module Int (
	module Data.Int

        -- SUP: deprecated in the new FFI, subsumed by fromIntegral
	, intToInt8      -- :: Int     -> Int8
	, intToInt16     -- :: Int     -> Int16
	, intToInt32     -- :: Int     -> Int32
	, intToInt64     -- :: Int     -> Int64

        , integerToInt8  -- :: Integer -> Int8
        , integerToInt16 -- :: Integer -> Int16
        , integerToInt32 -- :: Integer -> Int32
        , integerToInt64 -- :: Integer -> Int64

	, int8ToInt      -- :: Int8    -> Int
        , int8ToInteger  -- :: Int8    -> Integer
        , int8ToInt16    -- :: Int8    -> Int16
        , int8ToInt32    -- :: Int8    -> Int32
        , int8ToInt64    -- :: Int8    -> Int64

	, int16ToInt     -- :: Int16   -> Int
        , int16ToInteger -- :: Int16   -> Integer
        , int16ToInt8    -- :: Int16   -> Int8
        , int16ToInt32   -- :: Int16   -> Int32
        , int16ToInt64   -- :: Int16   -> Int64

	, int32ToInt     -- :: Int32   -> Int
        , int32ToInteger -- :: Int32   -> Integer
        , int32ToInt8    -- :: Int32   -> Int8
        , int32ToInt16   -- :: Int32   -> Int16
        , int32ToInt64   -- :: Int32   -> Int64

	, int64ToInt     -- :: Int64   -> Int
        , int64ToInteger -- :: Int64   -> Integer
        , int64ToInt8    -- :: Int64   -> Int8
        , int64ToInt16   -- :: Int64   -> Int16
        , int64ToInt32   -- :: Int64   -> Int32

	-- The "official" place to get these from is Addr, importing
	-- them from Int is a non-standard thing to do.
        -- SUP: deprecated in the new FFI, subsumed by the Storable class
	, indexInt8OffAddr
	, indexInt16OffAddr
	, indexInt32OffAddr
	, indexInt64OffAddr
	
	, readInt8OffAddr
	, readInt16OffAddr
	, readInt32OffAddr
	, readInt64OffAddr
	
	, writeInt8OffAddr
	, writeInt16OffAddr
	, writeInt32OffAddr
	, writeInt64OffAddr
	
        -- SUP: deprecated in the new FFI, subsumed by the Storable class
	, sizeofInt8
	, sizeofInt16
	, sizeofInt32
	, sizeofInt64
	
	-- The non-standard fromInt and toInt functions
	, fromInt, toInt

	-- non-standard, GHC specific
	, intToWord
  ) where

import Data.Int
import Data.Word
import Addr

{-# DEPRECATED fromInt "use fromIntegral instead" #-}
fromInt :: Num a => Int -> a
fromInt = fromIntegral

{-# DEPRECATED toInt "use fromIntegral instead" #-}
toInt :: Integral a => a -> Int
toInt = fromIntegral

{-# DEPRECATED intToInt8      "use fromIntegral instead" #-}
{-# DEPRECATED intToInt16     "use fromIntegral instead" #-}
{-# DEPRECATED intToInt32     "use fromIntegral instead" #-}
{-# DEPRECATED intToInt64     "use fromIntegral instead" #-}

{-# DEPRECATED integerToInt8  "use fromIntegral instead" #-}
{-# DEPRECATED integerToInt16 "use fromIntegral instead" #-}
{-# DEPRECATED integerToInt32 "use fromIntegral instead" #-}
{-# DEPRECATED integerToInt64 "use fromIntegral instead" #-}

{-# DEPRECATED int8ToInt      "use fromIntegral instead" #-}
{-# DEPRECATED int8ToInteger  "use fromIntegral instead" #-}
{-# DEPRECATED int8ToInt16    "use fromIntegral instead" #-}
{-# DEPRECATED int8ToInt32    "use fromIntegral instead" #-}
{-# DEPRECATED int8ToInt64    "use fromIntegral instead" #-}

{-# DEPRECATED int16ToInt     "use fromIntegral instead" #-}
{-# DEPRECATED int16ToInteger "use fromIntegral instead" #-}
{-# DEPRECATED int16ToInt8    "use fromIntegral instead" #-}
{-# DEPRECATED int16ToInt32   "use fromIntegral instead" #-}
{-# DEPRECATED int16ToInt64   "use fromIntegral instead" #-}

{-# DEPRECATED int32ToInt     "use fromIntegral instead" #-}
{-# DEPRECATED int32ToInteger "use fromIntegral instead" #-}
{-# DEPRECATED int32ToInt8    "use fromIntegral instead" #-}
{-# DEPRECATED int32ToInt16   "use fromIntegral instead" #-}
{-# DEPRECATED int32ToInt64   "use fromIntegral instead" #-}

{-# DEPRECATED int64ToInt     "use fromIntegral instead" #-}
{-# DEPRECATED int64ToInteger "use fromIntegral instead" #-}
{-# DEPRECATED int64ToInt8    "use fromIntegral instead" #-}
{-# DEPRECATED int64ToInt16   "use fromIntegral instead" #-}
{-# DEPRECATED int64ToInt32   "use fromIntegral instead" #-}

intToInt8      :: Int     -> Int8
intToInt16     :: Int     -> Int16
intToInt32     :: Int     -> Int32
intToInt64     :: Int     -> Int64

integerToInt8  :: Integer -> Int8
integerToInt16 :: Integer -> Int16
integerToInt32 :: Integer -> Int32
integerToInt64 :: Integer -> Int64

int8ToInt      :: Int8    -> Int
int8ToInteger  :: Int8    -> Integer
int8ToInt16    :: Int8    -> Int16
int8ToInt32    :: Int8    -> Int32
int8ToInt64    :: Int8    -> Int64

int16ToInt     :: Int16   -> Int
int16ToInteger :: Int16   -> Integer
int16ToInt8    :: Int16   -> Int8
int16ToInt32   :: Int16   -> Int32
int16ToInt64   :: Int16   -> Int64

int32ToInt     :: Int32   -> Int
int32ToInteger :: Int32   -> Integer
int32ToInt8    :: Int32   -> Int8
int32ToInt16   :: Int32   -> Int16
int32ToInt64   :: Int32   -> Int64

int64ToInt     :: Int64   -> Int
int64ToInteger :: Int64   -> Integer
int64ToInt8    :: Int64   -> Int8
int64ToInt16   :: Int64   -> Int16
int64ToInt32   :: Int64   -> Int32

intToInt8      = fromIntegral
intToInt16     = fromIntegral
intToInt32     = fromIntegral
intToInt64     = fromIntegral

integerToInt8  = fromIntegral
integerToInt16 = fromIntegral
integerToInt32 = fromIntegral
integerToInt64 = fromIntegral

int8ToInt      = fromIntegral
int8ToInteger  = fromIntegral
int8ToInt16    = fromIntegral
int8ToInt32    = fromIntegral
int8ToInt64    = fromIntegral

int16ToInt     = fromIntegral
int16ToInteger = fromIntegral
int16ToInt8    = fromIntegral
int16ToInt32   = fromIntegral
int16ToInt64   = fromIntegral

int32ToInt     = fromIntegral
int32ToInteger = fromIntegral
int32ToInt8    = fromIntegral
int32ToInt16   = fromIntegral
int32ToInt64   = fromIntegral

int64ToInt     = fromIntegral
int64ToInteger = fromIntegral
int64ToInt8    = fromIntegral
int64ToInt16   = fromIntegral
int64ToInt32   = fromIntegral

{-# DEPRECATED sizeofInt8 "use Storable.sizeOf instead" #-}
sizeofInt8 :: Word32
sizeofInt8 = 1

{-# DEPRECATED sizeofInt16 "use Storable.sizeOf instead" #-}
sizeofInt16 :: Word32
sizeofInt16 = 2

{-# DEPRECATED sizeofInt32 "use Storable.sizeOf instead" #-}
sizeofInt32 :: Word32
sizeofInt32 = 4

{-# DEPRECATED sizeofInt64 "use Storable.sizeOf instead" #-}
sizeofInt64 :: Word32
sizeofInt64 = 8
