{-# OPTIONS -#include "Win32Aux.h" #-}
{-# OPTIONS -#include <windows.h> #-}
{-# OPTIONS -#include "errors.h" #-}
{-# OPTIONS -#include "win32debug.h" #-}
{-# OPTIONS -#include "finalizers.h" #-}
{-# OPTIONS -#include "dumpBMP.h" #-}
{-# OPTIONS -#include "Win32Bitmap_stub_ffi.h" #-}
module Win32Bitmap where

import StdDIS
import Win32Types
import GDITypes


----------------------------------------------------------------
-- Resources
----------------------------------------------------------------

-- Yoiks - name clash
-- %dis bitmap x = addr ({LPTSTR} x)
-- 
-- type Bitmap = LPCTSTR
-- 
-- intToBitmap :: Int -> Bitmap
-- intToBitmap i = makeIntResource (toWord i)
-- 
-- %fun LoadBitmap :: MbHINSTANCE -> Bitmap -> IO HBITMAP
-- %fail { res1 == 0 } { ErrorString("LoadBitmap") }
--  
-- %const Bitmap  
-- % [ OBM_CLOSE        = { MAKEINTRESOURCE(OBM_CLOSE)       }
-- % , OBM_UPARROW      = { MAKEINTRESOURCE(OBM_UPARROW)     }
-- % , OBM_DNARROW      = { MAKEINTRESOURCE(OBM_DNARROW)     }
-- % , OBM_RGARROW      = { MAKEINTRESOURCE(OBM_RGARROW)     }
-- % , OBM_LFARROW      = { MAKEINTRESOURCE(OBM_LFARROW)     }
-- % , OBM_REDUCE       = { MAKEINTRESOURCE(OBM_REDUCE)      }
-- % , OBM_ZOOM         = { MAKEINTRESOURCE(OBM_ZOOM)        }
-- % , OBM_RESTORE      = { MAKEINTRESOURCE(OBM_RESTORE)     }
-- % , OBM_REDUCED      = { MAKEINTRESOURCE(OBM_REDUCED)     }
-- % , OBM_ZOOMD        = { MAKEINTRESOURCE(OBM_ZOOMD)       }
-- % , OBM_RESTORED     = { MAKEINTRESOURCE(OBM_RESTORED)    }
-- % , OBM_UPARROWD     = { MAKEINTRESOURCE(OBM_UPARROWD)    }
-- % , OBM_DNARROWD     = { MAKEINTRESOURCE(OBM_DNARROWD)    }
-- % , OBM_RGARROWD     = { MAKEINTRESOURCE(OBM_RGARROWD)    }
-- % , OBM_LFARROWD     = { MAKEINTRESOURCE(OBM_LFARROWD)    }
-- % , OBM_MNARROW      = { MAKEINTRESOURCE(OBM_MNARROW)     }
-- % , OBM_COMBO        = { MAKEINTRESOURCE(OBM_COMBO)       }
-- % , OBM_UPARROWI     = { MAKEINTRESOURCE(OBM_UPARROWI)    }
-- % , OBM_DNARROWI     = { MAKEINTRESOURCE(OBM_DNARROWI)    }
-- % , OBM_RGARROWI     = { MAKEINTRESOURCE(OBM_RGARROWI)    }
-- % , OBM_LFARROWI     = { MAKEINTRESOURCE(OBM_LFARROWI)    }
-- % , OBM_OLD_CLOSE    = { MAKEINTRESOURCE(OBM_OLD_CLOSE)   }   
-- % , OBM_SIZE         = { MAKEINTRESOURCE(OBM_SIZE)        }
-- % , OBM_OLD_UPARROW  = { MAKEINTRESOURCE(OBM_OLD_UPARROW) }   
-- % , OBM_OLD_DNARROW  = { MAKEINTRESOURCE(OBM_OLD_DNARROW) }   
-- % , OBM_OLD_RGARROW  = { MAKEINTRESOURCE(OBM_OLD_RGARROW) }   
-- % , OBM_OLD_LFARROW  = { MAKEINTRESOURCE(OBM_OLD_LFARROW) }   
-- % , OBM_BTSIZE       = { MAKEINTRESOURCE(OBM_BTSIZE)      }
-- % , OBM_CHECK        = { MAKEINTRESOURCE(OBM_CHECK)       }
-- % , OBM_CHECKBOXES   = { MAKEINTRESOURCE(OBM_CHECKBOXES)  }   
-- % , OBM_BTNCORNERS   = { MAKEINTRESOURCE(OBM_BTNCORNERS)  }   
-- % , OBM_OLD_REDUCE   = { MAKEINTRESOURCE(OBM_OLD_REDUCE)  }   
-- % , OBM_OLD_ZOOM     = { MAKEINTRESOURCE(OBM_OLD_ZOOM)    }
-- % , OBM_OLD_RESTORE  = { MAKEINTRESOURCE(OBM_OLD_RESTORE) }   
-- % ]

----------------------------------------------------------------
-- Raster Ops
----------------------------------------------------------------


type RasterOp3 = Word32
type RasterOp4 = Word32

sRCCOPY :: RasterOp3
sRCCOPY =
  unsafePerformIO(
    prim_sRCCOPY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sRCCOPY" unsafe prim_sRCCOPY :: IO (Word32)
sRCPAINT :: RasterOp3
sRCPAINT =
  unsafePerformIO(
    prim_sRCPAINT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sRCPAINT" unsafe prim_sRCPAINT :: IO (Word32)
sRCAND :: RasterOp3
sRCAND =
  unsafePerformIO(
    prim_sRCAND
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sRCAND" unsafe prim_sRCAND :: IO (Word32)
sRCINVERT :: RasterOp3
sRCINVERT =
  unsafePerformIO(
    prim_sRCINVERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sRCINVERT" unsafe prim_sRCINVERT :: IO (Word32)
sRCERASE :: RasterOp3
sRCERASE =
  unsafePerformIO(
    prim_sRCERASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sRCERASE" unsafe prim_sRCERASE :: IO (Word32)
nOTSRCCOPY :: RasterOp3
nOTSRCCOPY =
  unsafePerformIO(
    prim_nOTSRCCOPY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_nOTSRCCOPY" unsafe prim_nOTSRCCOPY :: IO (Word32)
nOTSRCERASE :: RasterOp3
nOTSRCERASE =
  unsafePerformIO(
    prim_nOTSRCERASE
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_nOTSRCERASE" unsafe prim_nOTSRCERASE :: IO (Word32)
mERGECOPY :: RasterOp3
mERGECOPY =
  unsafePerformIO(
    prim_mERGECOPY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mERGECOPY" unsafe prim_mERGECOPY :: IO (Word32)
mERGEPAINT :: RasterOp3
mERGEPAINT =
  unsafePerformIO(
    prim_mERGEPAINT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mERGEPAINT" unsafe prim_mERGEPAINT :: IO (Word32)
pATCOPY :: RasterOp3
pATCOPY =
  unsafePerformIO(
    prim_pATCOPY
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pATCOPY" unsafe prim_pATCOPY :: IO (Word32)
pATPAINT :: RasterOp3
pATPAINT =
  unsafePerformIO(
    prim_pATPAINT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pATPAINT" unsafe prim_pATPAINT :: IO (Word32)
pATINVERT :: RasterOp3
pATINVERT =
  unsafePerformIO(
    prim_pATINVERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_pATINVERT" unsafe prim_pATINVERT :: IO (Word32)
dSTINVERT :: RasterOp3
dSTINVERT =
  unsafePerformIO(
    prim_dSTINVERT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dSTINVERT" unsafe prim_dSTINVERT :: IO (Word32)
bLACKNESS :: RasterOp3
bLACKNESS =
  unsafePerformIO(
    prim_bLACKNESS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_bLACKNESS" unsafe prim_bLACKNESS :: IO (Word32)
wHITENESS :: RasterOp3
wHITENESS =
  unsafePerformIO(
    prim_wHITENESS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_wHITENESS" unsafe prim_wHITENESS :: IO (Word32)

mAKEROP4 :: RasterOp3 -> RasterOp3 -> RasterOp4
mAKEROP4 arg1 arg2 =
  unsafePerformIO(
    prim_mAKEROP4 arg1 arg2
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_mAKEROP4" unsafe prim_mAKEROP4 :: Word32 -> Word32 -> IO (Word32)

----------------------------------------------------------------
-- BITMAP
----------------------------------------------------------------

type BITMAP =
  ( LONG    -- bmType
  , LONG    -- bmWidth
  , LONG    -- bmHeight
  , LONG    -- bmWidthBytes
  , WORD    -- bmPlanes   
  , WORD    -- bmBitsPixel
  , LPVOID  -- bmBits
  )


type LPBITMAP = Addr

setBITMAP :: LPBITMAP -> BITMAP -> IO ()
setBITMAP arg1 gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4,gc_arg6,gc_arg8,gc_arg10,gc_arg12,gc_arg14) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  case ( int32ToInt  gc_arg6) of { gc_arg7 ->
  case ( int32ToInt  gc_arg8) of { gc_arg9 ->
  case ( word16ToWord32  gc_arg10) of { gc_arg11 ->
  case ( word16ToWord32  gc_arg12) of { gc_arg13 ->
  prim_setBITMAP arg1 gc_arg3 gc_arg5 gc_arg7 gc_arg9 gc_arg11 gc_arg13 gc_arg14}}}}}}}
foreign import  ccall "prim_setBITMAP" unsafe prim_setBITMAP :: Addr -> Int -> Int -> Int -> Int -> Word32 -> Word32 -> Addr -> IO ()

marshall_bITMAP_ :: BITMAP -> IO LPBITMAP
marshall_bITMAP_ bmp = do
  lpbmp <- malloc sizeofBITMAP
  setBITMAP lpbmp bmp
  return lpbmp

----------------------------------------------------------------
-- Misc
----------------------------------------------------------------

deleteBitmap :: HBITMAP -> IO ()
deleteBitmap arg1 =
  prim_deleteBitmap arg1
  >>= \ gc_result ->
  access_prim_deleteBitmap_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_deleteBitmap_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (()))
foreign import  ccall "prim_deleteBitmap" unsafe prim_deleteBitmap :: Addr -> IO (Addr)
foreign import ccall "access_prim_deleteBitmap_gc_failed" unsafe access_prim_deleteBitmap_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_deleteBitmap_gc_failstring" unsafe access_prim_deleteBitmap_gc_failstring :: Addr -> IO (Addr)

createCompatibleBitmap :: HDC -> Int32 -> Int32 -> IO HBITMAP
createCompatibleBitmap arg1 gc_arg1 gc_arg2 =
  case ( int32ToInt  gc_arg1) of { arg2 ->
  case ( int32ToInt  gc_arg2) of { arg3 ->
  prim_createCompatibleBitmap arg1 arg2 arg3
  >>= \ gc_result ->
  access_prim_createCompatibleBitmap_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createCompatibleBitmap_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createCompatibleBitmap_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}}
foreign import  ccall "prim_createCompatibleBitmap" unsafe prim_createCompatibleBitmap :: Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_createCompatibleBitmap_res1" unsafe access_prim_createCompatibleBitmap_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createCompatibleBitmap_gc_failed" unsafe access_prim_createCompatibleBitmap_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createCompatibleBitmap_gc_failstring" unsafe access_prim_createCompatibleBitmap_gc_failstring :: Addr -> IO (Addr)

createBitmap :: INT -> INT -> UINT -> UINT -> MbLPVOID -> IO HBITMAP
createBitmap gc_arg1 gc_arg2 arg3 arg4 arg5 =
  case ( int32ToInt  gc_arg1) of { arg1 ->
  case ( int32ToInt  gc_arg2) of { arg2 ->
  (case arg5 of {
      Nothing -> (return (nullAddr));
      (Just arg5) -> (return ((arg5)))
   }) >>= \ (arg5) ->
  prim_createBitmap arg1 arg2 arg3 arg4 arg5
  >>= \ gc_result ->
  access_prim_createBitmap_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createBitmap_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createBitmap_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))}}
foreign import  ccall "prim_createBitmap" unsafe prim_createBitmap :: Int -> Int -> Word32 -> Word32 -> Addr -> IO (Addr)
foreign import ccall "access_prim_createBitmap_res1" unsafe access_prim_createBitmap_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createBitmap_gc_failed" unsafe access_prim_createBitmap_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createBitmap_gc_failstring" unsafe access_prim_createBitmap_gc_failstring :: Addr -> IO (Addr)

createBitmapIndirect :: LPBITMAP -> IO HBITMAP
createBitmapIndirect arg1 =
  prim_createBitmapIndirect arg1
  >>= \ gc_result ->
  access_prim_createBitmapIndirect_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createBitmapIndirect_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createBitmapIndirect_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createBitmapIndirect" unsafe prim_createBitmapIndirect :: Addr -> IO (Addr)
foreign import ccall "access_prim_createBitmapIndirect_res1" unsafe access_prim_createBitmapIndirect_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createBitmapIndirect_gc_failed" unsafe access_prim_createBitmapIndirect_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createBitmapIndirect_gc_failstring" unsafe access_prim_createBitmapIndirect_gc_failstring :: Addr -> IO (Addr)

createDIBPatternBrushPt :: LPVOID -> ColorFormat -> IO HBRUSH
createDIBPatternBrushPt arg1 arg2 =
  prim_createDIBPatternBrushPt arg1 arg2
  >>= \ gc_result ->
  access_prim_createDIBPatternBrushPt_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createDIBPatternBrushPt_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createDIBPatternBrushPt_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createDIBPatternBrushPt" unsafe prim_createDIBPatternBrushPt :: Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_createDIBPatternBrushPt_res1" unsafe access_prim_createDIBPatternBrushPt_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createDIBPatternBrushPt_gc_failed" unsafe access_prim_createDIBPatternBrushPt_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createDIBPatternBrushPt_gc_failstring" unsafe access_prim_createDIBPatternBrushPt_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- Querying
----------------------------------------------------------------

getBitmapDimensionEx :: HBITMAP -> IO SIZE
getBitmapDimensionEx h =
  prim_getBitmapDimensionEx h
  >>= \ gc_result ->
  access_prim_getBitmapDimensionEx_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getBitmapDimensionEx_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_getBitmapDimensionEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getBitmapDimensionEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       (return ((gc_res1,gc_res3)))
foreign import  ccall "prim_getBitmapDimensionEx" unsafe prim_getBitmapDimensionEx :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBitmapDimensionEx_gc_res2" unsafe access_prim_getBitmapDimensionEx_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapDimensionEx_gc_res4" unsafe access_prim_getBitmapDimensionEx_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapDimensionEx_gc_failed" unsafe access_prim_getBitmapDimensionEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapDimensionEx_gc_failstring" unsafe access_prim_getBitmapDimensionEx_gc_failstring :: Addr -> IO (Addr)

setBitmapDimensionEx :: HBITMAP -> SIZE -> IO SIZE
setBitmapDimensionEx h gc_arg1 =
  case gc_arg1 of { (gc_arg2,gc_arg4) ->
  case ( int32ToInt  gc_arg2) of { gc_arg3 ->
  case ( int32ToInt  gc_arg4) of { gc_arg5 ->
  prim_setBitmapDimensionEx h gc_arg3 gc_arg5
  >>= \ gc_result ->
  access_prim_setBitmapDimensionEx_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_setBitmapDimensionEx_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_setBitmapDimensionEx_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setBitmapDimensionEx_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       (return ((gc_res1,gc_res3)))}}}
foreign import  ccall "prim_setBitmapDimensionEx" unsafe prim_setBitmapDimensionEx :: Addr -> Int -> Int -> IO (Addr)
foreign import ccall "access_prim_setBitmapDimensionEx_gc_res2" unsafe access_prim_setBitmapDimensionEx_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_setBitmapDimensionEx_gc_res4" unsafe access_prim_setBitmapDimensionEx_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_setBitmapDimensionEx_gc_failed" unsafe access_prim_setBitmapDimensionEx_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setBitmapDimensionEx_gc_failstring" unsafe access_prim_setBitmapDimensionEx_gc_failstring :: Addr -> IO (Addr)

getBitmapInfo :: HBITMAP -> IO BITMAP
getBitmapInfo x =
  prim_getBitmapInfo x
  >>= \ gc_result ->
  access_prim_getBitmapInfo_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getBitmapInfo_gc_res4 (gc_result :: Addr) >>= \ gc_res4 ->
  access_prim_getBitmapInfo_gc_res6 (gc_result :: Addr) >>= \ gc_res6 ->
  access_prim_getBitmapInfo_gc_res8 (gc_result :: Addr) >>= \ gc_res8 ->
  access_prim_getBitmapInfo_gc_res10 (gc_result :: Addr) >>= \ gc_res10 ->
  access_prim_getBitmapInfo_gc_res12 (gc_result :: Addr) >>= \ gc_res12 ->
  access_prim_getBitmapInfo_gc_res13 (gc_result :: Addr) >>= \ gc_res13 ->
  access_prim_getBitmapInfo_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getBitmapInfo_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (gc_res2)) in
       let gc_res3 = ( intToInt32  (gc_res4)) in
       let gc_res5 = ( intToInt32  (gc_res6)) in
       let gc_res7 = ( intToInt32  (gc_res8)) in
       let gc_res9 = ( word32ToWord16  (gc_res10)) in
       let gc_res11 = ( word32ToWord16  (gc_res12)) in
       (return ((gc_res1,gc_res3,gc_res5,gc_res7,gc_res9,gc_res11,gc_res13)))
foreign import  ccall "prim_getBitmapInfo" unsafe prim_getBitmapInfo :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBitmapInfo_gc_res2" unsafe access_prim_getBitmapInfo_gc_res2 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapInfo_gc_res4" unsafe access_prim_getBitmapInfo_gc_res4 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapInfo_gc_res6" unsafe access_prim_getBitmapInfo_gc_res6 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapInfo_gc_res8" unsafe access_prim_getBitmapInfo_gc_res8 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapInfo_gc_res10" unsafe access_prim_getBitmapInfo_gc_res10 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBitmapInfo_gc_res12" unsafe access_prim_getBitmapInfo_gc_res12 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBitmapInfo_gc_res13" unsafe access_prim_getBitmapInfo_gc_res13 :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBitmapInfo_gc_failed" unsafe access_prim_getBitmapInfo_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getBitmapInfo_gc_failstring" unsafe access_prim_getBitmapInfo_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
--
----------------------------------------------------------------

type BitmapCompression = WORD

bI_RGB :: BitmapCompression
bI_RGB =
  unsafePerformIO(
    prim_bI_RGB
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bI_RGB" unsafe prim_bI_RGB :: IO (Word32)
bI_RLE8 :: BitmapCompression
bI_RLE8 =
  unsafePerformIO(
    prim_bI_RLE8
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bI_RLE8" unsafe prim_bI_RLE8 :: IO (Word32)
bI_RLE4 :: BitmapCompression
bI_RLE4 =
  unsafePerformIO(
    prim_bI_RLE4
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bI_RLE4" unsafe prim_bI_RLE4 :: IO (Word32)
bI_BITFIELDS :: BitmapCompression
bI_BITFIELDS =
  unsafePerformIO(
    prim_bI_BITFIELDS
    >>= \  res1  ->
    let gc_res1 = ( word32ToWord16  (res1)) in
    (return (gc_res1)))
foreign import  ccall "prim_bI_BITFIELDS" unsafe prim_bI_BITFIELDS :: IO (Word32)

type ColorFormat = DWORD

dIB_PAL_COLORS :: ColorFormat
dIB_PAL_COLORS =
  unsafePerformIO(
    prim_dIB_PAL_COLORS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dIB_PAL_COLORS" unsafe prim_dIB_PAL_COLORS :: IO (Word32)
dIB_RGB_COLORS :: ColorFormat
dIB_RGB_COLORS =
  unsafePerformIO(
    prim_dIB_RGB_COLORS
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_dIB_RGB_COLORS" unsafe prim_dIB_RGB_COLORS :: IO (Word32)

----------------------------------------------------------------
-- BITMAPINFO
----------------------------------------------------------------

type LPBITMAPINFO = Addr

----------------------------------------------------------------
-- BITMAPINFOHEADER
----------------------------------------------------------------

type BITMAPINFOHEADER =
 ( DWORD              -- biSize      -- sizeof(BITMAPINFOHEADER)
 , LONG               -- biWidth
 , LONG               -- biHeight
 , WORD               -- biPlanes
 , WORD               -- biBitCount  -- 1, 4, 8, 16, 24 or 32
 , BitmapCompression  -- biCompression
 , DWORD              -- biSizeImage
 , LONG               -- biXPelsPerMeter
 , LONG               -- biYPelsPerMeter
 , Maybe DWORD        -- biClrUsed
 , Maybe DWORD        -- biClrImportant
 )

type LPBITMAPINFOHEADER   = Addr

getBITMAPINFOHEADER_ :: LPBITMAPINFOHEADER -> IO BITMAPINFOHEADER
getBITMAPINFOHEADER_ arg1 =
  prim_getBITMAPINFOHEADER_ arg1
  >>= \ gc_result ->
  access_prim_getBITMAPINFOHEADER__gc_res1 (gc_result :: Addr) >>= \ gc_res1 ->
  access_prim_getBITMAPINFOHEADER__gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_getBITMAPINFOHEADER__gc_res5 (gc_result :: Addr) >>= \ gc_res5 ->
  access_prim_getBITMAPINFOHEADER__gc_res7 (gc_result :: Addr) >>= \ gc_res7 ->
  access_prim_getBITMAPINFOHEADER__gc_res9 (gc_result :: Addr) >>= \ gc_res9 ->
  access_prim_getBITMAPINFOHEADER__gc_res11 (gc_result :: Addr) >>= \ gc_res11 ->
  access_prim_getBITMAPINFOHEADER__gc_res12 (gc_result :: Addr) >>= \ gc_res12 ->
  access_prim_getBITMAPINFOHEADER__gc_res14 (gc_result :: Addr) >>= \ gc_res14 ->
  access_prim_getBITMAPINFOHEADER__gc_res16 (gc_result :: Addr) >>= \ gc_res16 ->
  access_prim_getBITMAPINFOHEADER__gc_res18 (gc_result :: Addr) >>= \ gc_res18 ->
  access_prim_getBITMAPINFOHEADER__gc_res20 (gc_result :: Addr) >>= \ gc_res20 ->
  let gc_res2 = ( intToInt32  (gc_res3)) in
  let gc_res4 = ( intToInt32  (gc_res5)) in
  let gc_res6 = ( word32ToWord16  (gc_res7)) in
  let gc_res8 = ( word32ToWord16  (gc_res9)) in
  let gc_res10 = ( word32ToWord16  (gc_res11)) in
  let gc_res13 = ( intToInt32  (gc_res14)) in
  let gc_res15 = ( intToInt32  (gc_res16)) in
  (if 0 == (gc_res18)
   then return Nothing
   else (return ((Just gc_res18)))) >>= \ gc_res17 ->
  (if 0 == (gc_res20)
   then return Nothing
   else (return ((Just gc_res20)))) >>= \ gc_res19 ->
  (return ((gc_res1,gc_res2,gc_res4,gc_res6,gc_res8,gc_res10,gc_res12,gc_res13,gc_res15,gc_res17,gc_res19)))
foreign import  ccall "prim_getBITMAPINFOHEADER_" unsafe prim_getBITMAPINFOHEADER_ :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res1" unsafe access_prim_getBITMAPINFOHEADER__gc_res1 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res3" unsafe access_prim_getBITMAPINFOHEADER__gc_res3 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res5" unsafe access_prim_getBITMAPINFOHEADER__gc_res5 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res7" unsafe access_prim_getBITMAPINFOHEADER__gc_res7 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res9" unsafe access_prim_getBITMAPINFOHEADER__gc_res9 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res11" unsafe access_prim_getBITMAPINFOHEADER__gc_res11 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res12" unsafe access_prim_getBITMAPINFOHEADER__gc_res12 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res14" unsafe access_prim_getBITMAPINFOHEADER__gc_res14 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res16" unsafe access_prim_getBITMAPINFOHEADER__gc_res16 :: Addr -> IO (Int)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res18" unsafe access_prim_getBITMAPINFOHEADER__gc_res18 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPINFOHEADER__gc_res20" unsafe access_prim_getBITMAPINFOHEADER__gc_res20 :: Addr -> IO (Word32)


----------------------------------------------------------------
-- BITMAPFILEHEADER
----------------------------------------------------------------

type BITMAPFILEHEADER =
 ( WORD   -- bfType      -- "BM" == 0x4d42
 , DWORD  -- bfSize      -- number of bytes in file
 , WORD   -- bfReserved1 -- == 0
 , WORD   -- bfReserved2 -- == 0
 , DWORD  -- bfOffBits   -- == (char*) bits - (char*) filehdr
 )

type LPBITMAPFILEHEADER = Addr

getBITMAPFILEHEADER :: LPBITMAPFILEHEADER -> IO BITMAPFILEHEADER
getBITMAPFILEHEADER arg1 =
  prim_getBITMAPFILEHEADER arg1
  >>= \ gc_result ->
  access_prim_getBITMAPFILEHEADER_gc_res2 (gc_result :: Addr) >>= \ gc_res2 ->
  access_prim_getBITMAPFILEHEADER_gc_res3 (gc_result :: Addr) >>= \ gc_res3 ->
  access_prim_getBITMAPFILEHEADER_gc_res5 (gc_result :: Addr) >>= \ gc_res5 ->
  access_prim_getBITMAPFILEHEADER_gc_res7 (gc_result :: Addr) >>= \ gc_res7 ->
  access_prim_getBITMAPFILEHEADER_gc_res8 (gc_result :: Addr) >>= \ gc_res8 ->
  let gc_res1 = ( word32ToWord16  (gc_res2)) in
  let gc_res4 = ( word32ToWord16  (gc_res5)) in
  let gc_res6 = ( word32ToWord16  (gc_res7)) in
  (return ((gc_res1,gc_res3,gc_res4,gc_res6,gc_res8)))
foreign import  ccall "prim_getBITMAPFILEHEADER" unsafe prim_getBITMAPFILEHEADER :: Addr -> IO (Addr)
foreign import ccall "access_prim_getBITMAPFILEHEADER_gc_res2" unsafe access_prim_getBITMAPFILEHEADER_gc_res2 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPFILEHEADER_gc_res3" unsafe access_prim_getBITMAPFILEHEADER_gc_res3 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPFILEHEADER_gc_res5" unsafe access_prim_getBITMAPFILEHEADER_gc_res5 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPFILEHEADER_gc_res7" unsafe access_prim_getBITMAPFILEHEADER_gc_res7 :: Addr -> IO (Word32)
foreign import ccall "access_prim_getBITMAPFILEHEADER_gc_res8" unsafe access_prim_getBITMAPFILEHEADER_gc_res8 :: Addr -> IO (Word32)

sizeofBITMAP :: Word32
sizeofBITMAP =
  unsafePerformIO(
    prim_sizeofBITMAP
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sizeofBITMAP" unsafe prim_sizeofBITMAP :: IO (Word32)
sizeofBITMAPINFO :: Word32
sizeofBITMAPINFO =
  unsafePerformIO(
    prim_sizeofBITMAPINFO
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sizeofBITMAPINFO" unsafe prim_sizeofBITMAPINFO :: IO (Word32)
sizeofBITMAPINFOHEADER :: Word32
sizeofBITMAPINFOHEADER =
  unsafePerformIO(
    prim_sizeofBITMAPINFOHEADER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sizeofBITMAPINFOHEADER" unsafe prim_sizeofBITMAPINFOHEADER :: IO (Word32)
sizeofBITMAPFILEHEADER :: Word32
sizeofBITMAPFILEHEADER =
  unsafePerformIO(
    prim_sizeofBITMAPFILEHEADER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sizeofBITMAPFILEHEADER" unsafe prim_sizeofBITMAPFILEHEADER :: IO (Word32)
sizeofLPBITMAPFILEHEADER :: Word32
sizeofLPBITMAPFILEHEADER =
  unsafePerformIO(
    prim_sizeofLPBITMAPFILEHEADER
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_sizeofLPBITMAPFILEHEADER" unsafe prim_sizeofLPBITMAPFILEHEADER :: IO (Word32)

----------------------------------------------------------------
-- CreateBMPFile
----------------------------------------------------------------

-- A (large) helper function - courtesy of Microsoft

-- Includes "dumpBMP.c" for non-ghc backends.

createBMPFile :: String -> HBITMAP -> HDC -> IO ()
createBMPFile gc_arg1 arg2 arg3 =
  (marshall_string_ gc_arg1) >>= \ (arg1) ->
  prim_createBMPFile arg1 arg2 arg3
foreign import  ccall "prim_createBMPFile" unsafe prim_createBMPFile :: Addr -> Addr -> Addr -> IO ()

----------------------------------------------------------------
-- Device Independent Bitmaps
----------------------------------------------------------------

cBM_INIT :: DWORD
cBM_INIT =
  unsafePerformIO(
    prim_cBM_INIT
    >>= \  res1  ->
    (return (res1)))
foreign import  ccall "prim_cBM_INIT" unsafe prim_cBM_INIT :: IO (Word32)

getDIBits :: HDC -> HBITMAP -> INT -> INT -> MbLPVOID -> LPBITMAPINFO -> ColorFormat -> IO INT
getDIBits arg1 arg2 gc_arg1 gc_arg2 arg5 arg6 arg7 =
  case ( int32ToInt  gc_arg1) of { arg3 ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  (case arg5 of {
      Nothing -> (return (nullAddr));
      (Just arg5) -> (return ((arg5)))
   }) >>= \ (arg5) ->
  prim_getDIBits arg1 arg2 arg3 arg4 arg5 arg6 arg7
  >>= \ gc_result ->
  access_prim_getDIBits_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_getDIBits_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_getDIBits_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (res1)) in
       (return (gc_res1))}}
foreign import  ccall "prim_getDIBits" unsafe prim_getDIBits :: Addr -> Addr -> Int -> Int -> Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_getDIBits_res1" unsafe access_prim_getDIBits_res1 :: Addr -> IO (Int)
foreign import ccall "access_prim_getDIBits_gc_failed" unsafe access_prim_getDIBits_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_getDIBits_gc_failstring" unsafe access_prim_getDIBits_gc_failstring :: Addr -> IO (Addr)

setDIBits :: HDC -> HBITMAP -> INT -> INT -> LPVOID -> LPBITMAPINFO -> ColorFormat -> IO INT
setDIBits arg1 arg2 gc_arg1 gc_arg2 arg5 arg6 arg7 =
  case ( int32ToInt  gc_arg1) of { arg3 ->
  case ( int32ToInt  gc_arg2) of { arg4 ->
  prim_setDIBits arg1 arg2 arg3 arg4 arg5 arg6 arg7
  >>= \ gc_result ->
  access_prim_setDIBits_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_setDIBits_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_setDIBits_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else let gc_res1 = ( intToInt32  (res1)) in
       (return (gc_res1))}}
foreign import  ccall "prim_setDIBits" unsafe prim_setDIBits :: Addr -> Addr -> Int -> Int -> Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_setDIBits_res1" unsafe access_prim_setDIBits_res1 :: Addr -> IO (Int)
foreign import ccall "access_prim_setDIBits_gc_failed" unsafe access_prim_setDIBits_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_setDIBits_gc_failstring" unsafe access_prim_setDIBits_gc_failstring :: Addr -> IO (Addr)

createDIBitmap :: HDC -> LPBITMAPINFOHEADER -> DWORD -> LPVOID -> LPBITMAPINFO -> ColorFormat -> IO HBITMAP
createDIBitmap arg1 arg2 arg3 arg4 arg5 arg6 =
  prim_createDIBitmap arg1 arg2 arg3 arg4 arg5 arg6
  >>= \ gc_result ->
  access_prim_createDIBitmap_res1 (gc_result :: Addr) >>= \ res1 ->
  access_prim_createDIBitmap_gc_failed (gc_result :: Addr) >>= \ gc_failed ->
  access_prim_createDIBitmap_gc_failstring (gc_result :: Addr) >>= \ gc_failstring ->
  if ( gc_failed /= (0::Int))
  then unmarshall_string_ gc_failstring >>=  ioError  . userError
  else (return (res1))
foreign import  ccall "prim_createDIBitmap" unsafe prim_createDIBitmap :: Addr -> Addr -> Word32 -> Addr -> Addr -> Word32 -> IO (Addr)
foreign import ccall "access_prim_createDIBitmap_res1" unsafe access_prim_createDIBitmap_res1 :: Addr -> IO (Addr)
foreign import ccall "access_prim_createDIBitmap_gc_failed" unsafe access_prim_createDIBitmap_gc_failed :: Addr -> IO (Int)
foreign import ccall "access_prim_createDIBitmap_gc_failstring" unsafe access_prim_createDIBitmap_gc_failstring :: Addr -> IO (Addr)

----------------------------------------------------------------
-- End
----------------------------------------------------------------


