module StdWindowAttribute ( isValidWindowAttribute, isValidDialogAttribute
                          , isWindowActivate,   getWindowActivateFun
                          , isWindowClose,      getWindowCloseFun
                          , isWindowDeactivate, getWindowDeactivateFun
                          , isWindowId,         getWindowIdAtt
                          , isWindowInit,       getWindowInitFun
                          , isWindowViewSize,   getWindowViewSizeAtt
                          , module StdWindowDef
                          ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	StdWindowAttribute specifies which WindowAttributes are valid for Windows.
--	********************************************************************************


import StdWindowDef
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


isValidWindowAttribute :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isValidWindowAttribute att = isAllWindowsAttribute att || isWindowOnlyAttribute att

isValidDialogAttribute :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isValidDialogAttribute att = isAllWindowsAttribute att || isDialogOnlyAttribute att

isAllWindowsAttribute :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isAllWindowsAttribute (WindowActivate   _) = True
isAllWindowsAttribute (WindowClose      _) = True
isAllWindowsAttribute (WindowDeactivate _) = True
isAllWindowsAttribute (WindowId         _) = True
isAllWindowsAttribute (WindowInit       _) = True
isAllWindowsAttribute (WindowViewSize   _) = True
isAllWindowsAttribute _                    = False

isWindowOnlyAttribute :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowOnlyAttribute _ = False

isDialogOnlyAttribute :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isDialogOnlyAttribute _ = False


isWindowActivate :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowActivate (WindowActivate _) = True
isWindowActivate _                  = False

isWindowClose    :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowClose    (WindowClose _)    = True
isWindowClose    _                  = False

isWindowDeactivate :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowDeactivate (WindowDeactivate _) = True
isWindowDeactivate _                    = False

isWindowId       :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowId       (WindowId _)       = True
isWindowId       _                  = False

isWindowInit     :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowInit     (WindowInit _)     = True
isWindowInit     _                  = False

isWindowViewSize :: WindowAttribute IF_MVAR(,ls ps) -> Bool
isWindowViewSize (WindowViewSize _) = True
isWindowViewSize _                  = False


getWindowActivateFun :: WindowAttribute IF_MVAR(,ls ps) -> IF_MVAR(GUIFun (),GUIFun ls ps)
getWindowActivateFun (WindowActivate f) = f

getWindowCloseFun :: WindowAttribute IF_MVAR(,ls ps) -> IF_MVAR(GUIFun (),GUIFun ls ps)
getWindowCloseFun (WindowClose f) = f

getWindowDeactivateFun :: WindowAttribute IF_MVAR(,ls ps) -> IF_MVAR(GUIFun (),GUIFun ls ps)
getWindowDeactivateFun (WindowDeactivate f) = f

getWindowIdAtt :: WindowAttribute IF_MVAR(,ls ps) -> Id
getWindowIdAtt (WindowId id) = id

getWindowInitFun :: WindowAttribute IF_MVAR(,ls ps) -> IF_MVAR(GUIFun (),GUIFun ls ps)
getWindowInitFun (WindowInit init) = init

getWindowViewSizeAtt :: WindowAttribute IF_MVAR(,ls ps) -> Size
getWindowViewSizeAtt (WindowViewSize size) = size
