module Scheduler ( Context
                 , initContext
                 , handleEvents, {-chandleEvents,-} handleContextOSEvent --, handleOneEventForDevices
                 , addInteractiveProcess
                 , closeContext
                 , quitProcess
                 ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	Scheduler contains the process creation, termination, and handling functions.
--	********************************************************************************


import ClCrossCall_12 (osInitToolbox)	-- Should actually be in a Os... module, but not Ostoolbox
import CleanStdFunc
import CleanStdList
import CleanStdMisc
import Commondef
import Id
import IOstate
import Osevent
import StdProcessDef
import Roundrobin
import World
#include "preprocess.h"
         -- Compile with -cpp; set MVAR=1 for MVAR version


{-	Context is now defined at IOstate.
type	Context IF_MVAR(,ps)
	= PSt IF_MVAR(,ps)
-}

schedulerFatalError :: String -> String -> x
schedulerFatalError rule message
	= dumpFatalError rule "Scheduler" message


--	Access functions on RuntimeState:

rsIsClosed :: RuntimeState -> Bool
rsIsClosed Closed = True
rsIsClosed _      = False


--	Access functions on PSt:

#if MVAR
appPIO :: IdFun IOSt -> IdFun PSt
appPIO f = f

accPIO :: St IOSt x -> St PSt x
accPIO f = f
#else
appPIO :: IdFun (IOSt ps) -> IdFun (PSt ps)
appPIO f pState@(PSt {io=ioState})
	= let ioState1 = f ioState
	  in  pState {io=ioState1}

accPIO :: St (IOSt ps) x -> St (PSt ps) x
accPIO f pState@(PSt {io=ioState})
	= let (x,ioState1)= f ioState
	  in  (x,pState {io=ioState1})
#endif


--	Starting an interactive process.

initContext :: [ProcessAttribute IF_MVAR(,ps)] -> ProcessInit IF_MVAR(,ps -> ps) -> DocumentInterface -> IO (Maybe Context)
initContext pAtts initIO IF_MVAR(,ps) xDI
	= do {
		initOK <- osInitToolbox;							-- initialise toolbox
		if   initOK									-- toolbox correctly initialised
		then do {
			w <- loadWorld;
			storeWorld w;
			context  <- initialContext w;						-- initialise context
			context1 <- createInitialProcess pAtts initIO IF_MVAR(,ps) xDI context;	-- fork the initial interactive process
			return (Just context1)
		     }
		else return Nothing
	  }


--	Handling events until termination of all interactive processes.

handleEvents :: Context -> IO Context
handleEvents context
	= osHandleEvents		-- previous arguments:
		terminate		-- (accPIO ioStClosed)
		getosevents		-- (accPIO ioStGetEvents)
		setosevents		-- (\(es,cs)->appPIO (ioStSetEvents es) cs)
		{-getsleeptime-}	-- {-contextGetSleepTime-}
		handleContextOSEvent	-- handleContextOSEvent
		context			-- context;
	where
		terminate :: Context -> IO (Bool,Context)
		terminate context
			= do {
				iocontext <- takeMVar context;
				let (empty,iocontext1) = ioContextEmptyProcessEventHandlers iocontext
				in  putMVar context iocontext1 >> return (empty,context)
			  }
		
		getosevents :: Context -> IO (OSEvents,Context)
		getosevents context
			= do {
				iocontext <- takeMVar context;
				let (osevents,iocontext1) = ioContextGetEvents iocontext
				in  putMVar context iocontext1 >> return (osevents,context);
			  }
		
		setosevents :: (OSEvents,Context) -> IO Context
		setosevents (osevents,context)
			= do {
				iocontext <- takeMVar context;
				putMVar context (ioContextSetEvents osevents iocontext) >> return context
			  }


--	Closing a final context. 

closeContext :: Context -> IO ()
closeContext context
	= do {
		iocontext <- readMVar context;
		if   fst (ioContextEmptyProcessEventHandlers iocontext)
		then storeWorld 42
		else schedulerFatalError "closeContext" "not a final Context"
	  }


--	Handling events while condition holds.
{- not used
chandleEvents :: St IF_MVAR(Context,(Context ps)) Bool -> Context IF_MVAR(,ps) -> IO IF_MVAR(Context,(Context ps))
chandleEvents cond context
	= osHandleEvents (terminate cond)
	                 (accPIO ioStGetEvents)
	                 (\(es,cs)->appPIO (ioStSetEvents es) cs)
	                 {-contextGetSleepTime-}
	                 handleContextOSEvent
	                 context
	where
	--	terminate :: Context IF_MVAR(,ps) -> (Bool,Context IF_MVAR(,ps))
		terminate :: St IF_MVAR(Context,(Context ps)) Bool -> St IF_MVAR(Context,(Context ps)) Bool
		terminate cond context
			= let (continue,context1) = cond context
			  in  (not continue,context1)
-}

handleContextOSEvent :: SchedulerEvent -> Context -> IO ([Int],Context)
handleContextOSEvent schedulerEvent context
	= do {
		iocontext <- takeMVar context;
		let (processfilters,iocontext1) = ioContextGetProcessEventHandlers iocontext
		in
		do {
			putMVar context iocontext1;
			(schedulerEvent1,context1) <- letProcessesFilterEvent processfilters schedulerEvent context;
			let replyToOS = case schedulerEvent1 of
						(ScheduleOSEvent _ reply) -> reply
						_                         -> []
			in  return (replyToOS,context1)
		}
	  }
	where
		letProcessesFilterEvent :: [ProcessEventHandler] -> SchedulerEvent -> Context -> IO (SchedulerEvent,Context)
		letProcessesFilterEvent (peh : pehs) schedulerEvent context
			= do {
				(ok,maybeDeviceEvent,schedulerEvent1) <- filterfun schedulerEvent;
				if   not ok
				then letProcessesFilterEvent pehs schedulerEvent1 context
				else if   isNothing maybeDeviceEvent
				     then return (schedulerEvent1,context)
				     else 
				     do {
				          writeDeviceEvent de (fromJust maybeDeviceEvent);
				          return (schedulerEvent1,context)
				     }
			  }
			where
				filterfun = pehEventFilter  peh
				de        = pehDeviceEvents peh
		letProcessesFilterEvent _ schedulerEvent context
			= return (schedulerEvent,context)


{- not used
handleOneEventForDevices :: SchedulerEvent -> PSt IF_MVAR(,ps) -> IO (Bool,SchedulerEvent,PSt IF_MVAR(,ps))
handleOneEventForDevices schedulerEvent pState
	= let (deviceFunctions,pState1) = accPIO ioStGetDeviceFunctions pState
	      ioFunctions               = [(dDevice df,dEvent df,dDoIO df) | df<-deviceFunctions]
	  in  handleEventForDevices ioFunctions False schedulerEvent pState1
-}

{-	Creation of an interactive process:
	createInitialProcess should be applied for the first process;
	addInteractiveProcess should be applied for every other process creation.
-}
createInitialProcess :: [ProcessAttribute IF_MVAR(,ps)] -> ProcessInit IF_MVAR(,ps -> ps) -> DocumentInterface -> Context -> IO Context
createInitialProcess pAtts initIO IF_MVAR(,ps) xDI context
	= do {
		de        <- newDeviceEvents;
		iocontext <- takeMVar context;
		let (ioId,iocontext1) = ioContextNewMaxIONr iocontext
		in
		do {
			newIOSt   <- emptyIOSt ioId xDI pAtts initIO context de;
			let processEventHandler = ProcessEventHandler
			                              { pehId           = ioId
			                              , pehEventFilter  = processEventFilter newIOSt
			                              , pehDeviceEvents = de
			                              }
			    iocontext2          = ioContextSetProcessEventHandler processEventHandler iocontext1
#if MVAR
			    pState              = newIOSt
#else
			    pState              = PSt {ls=ps,io=newIOSt}
#endif
			in
			do {
				putMVar context iocontext2;
				threadId <- forkIO (ioProcess de pState);		-- Spawn the interactive process (it blocks immediately on channel)
				writeDeviceEvent de (ProcessDevice,ProcessInitialise);	-- Make sure the interactive process gets started
				return context
			}
		}
	  }

#if MVAR
addInteractiveProcess :: [ProcessAttribute] -> ProcessInit -> DocumentInterface -> GUI ()
addInteractiveProcess pAtts initIO xDI
#else
addInteractiveProcess :: [ProcessAttribute ps'] -> ProcessInit ps' -> ps' -> DocumentInterface -> GUI ps ()
addInteractiveProcess pAtts initIO ps' xDI
#endif
	= do {
		ioId      <- ioStNewMaxIONr;
		de        <- liftIO newDeviceEvents;
		context   <- accIOEnv ioStGetContext;
		newIOSt   <- liftIO (emptyIOSt ioId xDI pAtts initIO context de);
		iocontext <- liftIO (takeMVar context);
		let processEventHandler = ProcessEventHandler
		                              { pehId           = ioId
		                              , pehEventFilter  = processEventFilter newIOSt
		                              , pehDeviceEvents = de
		                              }
		    iocontext1          = ioContextSetProcessEventHandler processEventHandler iocontext
#if MVAR
		    pState              = newIOSt
#else
		    pState              = PSt {ls=ps',io=newIOSt}
#endif
		in
		do {
			liftIO (putMVar context iocontext1);
			threadId <- liftIO (forkIO (ioProcess de pState));		-- Spawn the interactive process (it blocks immediately on channel)
			liftIO (writeDeviceEvent de (ProcessDevice,ProcessInitialise));	-- Make sure the interactive process gets started
		}
	  }


{-	An ioProcess handles events coming in on its (Chan DeviceEvent) until termination (closeProcess).
-}
ioProcess :: DeviceEvents -> PSt IF_MVAR(,ps) -> IO ()
ioProcess de pState
	| closed
		= return ()
	| otherwise
		= do {
			(device,deviceEvent) <- readDeviceEvent de;
			pState2              <- handleEventForProcess device deviceEvent pState1;
			reregisterProcessEventHandler IF_MVAR(pState2,(io pState2));
			freeDeviceEvent de;
			ioProcess de pState2
		  }
	where
		(closed,pState1) = accPIO ioStClosed pState
		
#if MVAR
		handleEventForProcess :: Device -> DeviceEvent -> IOSt -> IO IOSt
		handleEventForProcess device schedulerEvent ioState
			= do {
				(_,ioState2)   <- fromGUI initIO ioState1;
				let (closed,ioState3) = ioStClosed ioState2
				in  if   closed
				    then return ioState3
				    else let (deviceFunctions,ioState4) = ioStGetDeviceFunctions ioState3
				             (found,df)                 = cselect (\df -> dDevice df == device) undef deviceFunctions
				         in  
				         if   not found
				         then schedulerFatalError "ioProcess" "could not find Device to handle DeviceEvent"
				         else fromGUI (dDoIO df schedulerEvent) ioState4 >>= (\(_,ioState5) -> return ioState5)
			  }
			where
				(initIO,ioState1) = ioStGetInitIO ioState
#else
		handleEventForProcess :: Device -> DeviceEvent -> PSt ps -> IO (PSt ps)
		handleEventForProcess device schedulerEvent (PSt {ls=ps,io=ioState})
			= do {
				(ps1,ioState2) <- fromGUI (initIO ps) ioState1;
				let (closed,ioState3) = ioStClosed ioState2
				in  if   closed
				    then return (PSt {ls=ps1,io=ioState3})
				    else let (deviceFunctions,ioState4) = ioStGetDeviceFunctions ioState3
				             (found,df)                 = cselect (\df -> dDevice df == device) undef deviceFunctions
				         in  
				         if   not found
				         then schedulerFatalError "ioProcess" "could not find Device to handle DeviceEvent"
				         else do {
				                  (ps2,ioState5) <- fromGUI (dDoIO df schedulerEvent ps1) ioState4;
				                  return (PSt {ls=ps2,io=ioState5})
				              }
			  }
			where
				(initIO,ioState1) = ioStGetInitIO ioState
#endif
		reregisterProcessEventHandler :: IOSt IF_MVAR(,ps) -> IO ()
		reregisterProcessEventHandler ioState
			| closed
				= return ()
			| otherwise
				= do {
					iocontext <- takeMVar context;
					let (maybePEH,iocontext1) = ioContextRemoveProcessEventHandler ioid iocontext
					in  case maybePEH of
						Nothing  -> schedulerFatalError "ioProcess" "could not find ProcessEventHandler in Context"
						Just peh -> putMVar context (ioContextSetProcessEventHandler (peh {pehEventFilter=processEventFilter ioState3}) iocontext1)
				  }
			where
				(closed, ioState1) = ioStClosed  ioState
				(ioid,   ioState2) = ioStGetIOId ioState1
				(context,ioState3) = ioStGetContext ioState2


{-	processEventFilter passes the current Device dEvent DeviceFunctions to the
	argument SchedulerEvent to determine if this event should be handled by this
	process.
-}
processEventFilter :: IOSt IF_MVAR(,ps) -> SchedulerEvent -> IO (Bool,Maybe DeviceEventInfo,SchedulerEvent)
processEventFilter ioState schedulerEvent
	| closed
		= return (False,Nothing,schedulerEvent)
	| otherwise
		= filterEventForDevices eventFunctions False schedulerEvent ioState2
	where
		(closed,         ioState1) = ioStClosed ioState
		(deviceFunctions,ioState2) = ioStGetDeviceFunctions ioState1
		eventFunctions             = [(dDevice df,dEvent df) | df <- deviceFunctions]

		filterEventForDevices :: [(Device,EventFunction IF_MVAR(,ps))] -> Bool -> SchedulerEvent -> IOSt IF_MVAR(,ps)
		                      -> IO (Bool,Maybe DeviceEventInfo,SchedulerEvent)
		filterEventForDevices ((device,mapDeviceEvent):mapDeviceEvents) eventDone schedulerEvent ioState
			| eventDone
				= return (eventDone,Nothing,schedulerEvent)
			| otherwise
				= do {
					(forThisDevice,okDeviceEvent,schedulerEvent1) <- mapDeviceEvent ioState schedulerEvent;
					if   not forThisDevice
					then filterEventForDevices mapDeviceEvents eventDone schedulerEvent1 ioState
					else return ( forThisDevice
					            , case okDeviceEvent of
					                   Just deviceEvent -> Just (device,deviceEvent)
					                   nothing          -> Nothing
					            , schedulerEvent1
					            )
				  }
		filterEventForDevices _ eventDone schedulerEvent _
			= return (eventDone,Nothing,schedulerEvent)


{-	Quit this interactive process.
	Quitting a process involves the following:
	- Set the RuntimeState to Closed (quitProcess is the only function that does this)
	- Close all devices
	- Remove the process from the Context
-}
quitProcess :: IF_MVAR(GUI (),ps -> GUI ps ps)
quitProcess IF_MVAR(,ps)
	= do {
		rs <- accIOEnv ioStGetRuntimeState;
		if   rsIsClosed rs
		then IF_MVAR(return (),return ps)
		else do {
		             deviceFunctions <- accIOEnv ioStGetDeviceFunctions;
#if MVAR
		             sequence [dClose df | df<-deviceFunctions];
#else
		             ps1 <- seqListM [dClose df | df<-deviceFunctions] ps;
#endif
		             appIOEnv (ioStSetRuntimeState Closed);
		             
		             -- This part is new: remove the process from the context
		             ioId              <- accIOEnv ioStGetIOId;
		             myPEH             <- ioStRemoveProcessEventHandler ioId;
		             if   isNothing myPEH	-- This condition should not occur
		             then schedulerFatalError "quitProcess" "could not remove ProcessEventHandler from Context"
		             else return IF_MVAR((),ps1)
		        }
	     }
#if MVAR
#else
	where
		seqListM :: [ps -> GUI ps ps] -> ps -> GUI ps ps
		seqListM (m:ms) ps
			= m ps >>= (\ps -> seqListM ms ps)
		seqListM _ ps
			= return ps
#endif
