module PictCCall_12 ( PIC, HDC, Pt, RGBcolor, Fnt
                    , iWhitePattern, iLtGreyPattern, iGreyPattern, iDkGreyPattern, iBlackPattern
                    , iModeNotBic, iModeNotXor, iModeNotOr, iModeNotCopy, iModeBic, iModeXor, iModeOr, iModeCopy
                    , iStrikeOut, iUnderline, iItalic, iBold
                    , alternate, winding
                    , winCreateScreenHDC, winDestroyScreenHDC
                    , winGetStringWidth, winGetCharWidth
                    , winGetPicFontInfo, winGetFontInfo, winSetFontStyle, winSetFontSize, winSetFontName, winSetFont
                    , winPrintResizedBitmap, winDrawBitmap, winDrawResizedBitmap, winCreateBitmap
                    , winInvertPolygon, winErasePolygon, winFillPolygon, winDrawPolygon, winAddPolygonPoint, 
                    , winStartPolygon, winEndPolygon, winAllocPolyShape, winSetPolyPoint, winFreePolyShape
                    , winInvertWedge, winEraseWedge, winFillWedge, winDrawWedge
                    , winInvertCircle, winEraseCircle, winFillCircle, winDrawCircle
                    , winInvertOval, winEraseOval, winFillOval, winDrawOval
                    , winInvertRoundRectangle, winEraseRoundRectangle, winFillRoundRectangle, winDrawRoundRectangle
                    , winScrollRectangle, winCopyRectangle, winCopyRectangleTo, winMoveRectangle, winMoveRectangleTo
                    , winInvertRectangle, winEraseRectangle, winFillRectangle, winDrawRectangle
                    , winDrawChar, winDrawString
                    , winDrawCCurve, winDrawCLine, winDrawCPoint, winDrawCurve, winDrawLine, winDrawPoint
                    , winLinePen, winLinePenTo
                    , winMovePen, winMovePenTo, winGetPenPos
                    , winSetPenSize, winSetPattern, winSetMode, winSetBackColor, winSetPenColor
                    , winClipPicture, winClipRgnPicture, winSetClipRgnPicture, winGetClipRgnPicture
                    , winDeleteObject
                    , winDonePicture, winInitPicture
                    ) where


--	********************************************************************************
--	Clean to Haskell Standard Object I/O library, version 1.2
--	
--	PictCCall_12 contains all C calls related to drawing.
--	********************************************************************************


import Ostoolbox
import Ostypes(Rect(..))
import RgnCCall_12
import Cutil_12


type	PIC
	= HDC
type	HDC
	= Int
type	Pt
	= ( Int
	  , Int
	  )
type	RGBcolor
	= ( Int
	  , Int
	  , Int
	  )
type	Fnt
	= ( String
	  , Int
	  , Int
	  )


iWhitePattern, iLtGreyPattern, iGreyPattern, iDkGreyPattern, iBlackPattern :: Int
iWhitePattern	= 4
iLtGreyPattern	= 3
iGreyPattern	= 2
iDkGreyPattern	= 1
iBlackPattern	= 0

iModeNotBic, iModeNotXor, iModeNotOr, iModeNotCopy, iModeBic, iModeXor, iModeOr, iModeCopy :: Int
iModeNotBic	= 7
iModeNotXor	= 6
iModeNotOr	= 5
iModeNotCopy	= 4
iModeBic	= 3
iModeXor	= 2
iModeOr		= 1
iModeCopy	= 0

iStrikeOut, iUnderline, iItalic, iBold :: Int
iStrikeOut	= 8
iUnderline	= 4
iItalic		= 2
iBold		= 1

--	Constants for drawing polygons.
alternate, winding :: Int
alternate	= 1
winding		= 2


return_fst (a,_) = return a

--	Win(Create/Destroy)ScreenHDC added to temporarily create a HDC of a screen.
--		Never use these values for a window or control.
winCreateScreenHDC :: IO PIC
winCreateScreenHDC
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCreateScreenHDC osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCreateScreenHDC" cWinCreateScreenHDC :: Int -> Addr -> Addr -> IO ()

winDestroyScreenHDC :: PIC -> IO ()
winDestroyScreenHDC a1
	= cWinDestroyScreenHDC a1 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinDestroyScreenHDC" cWinDestroyScreenHDC :: PIC -> Int -> IO Int

winGetStringWidth :: String -> Fnt -> Int -> HDC -> IO Int
winGetStringWidth a1 (a2,a3,a4) a5 a6
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		s2 <- createCLEAN_STRING a2;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinGetStringWidth s1 s2 a3 a4 a5 a6 osNewToolbox o1 o2;
		-- Read/free:
		mapM_ freeCLEAN_STRING [s1,s2];
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinGetStringWidth" cWinGetStringWidth :: Addr -> Addr -> Int -> Int -> Int -> HDC -> Int -> Addr -> Addr -> IO ()

winGetCharWidth :: Char -> Fnt -> Int -> HDC -> IO Int
winGetCharWidth a1 (a2,a3,a4) a5 a6
	= do {
		-- Marshal arguments:
		s2 <- createCLEAN_STRING a2;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinGetCharWidth (fromEnum a1) s2 a3 a4 a5 a6 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s2;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1;
	  }
foreign import stdcall "cpicture_121" "WinGetCharWidth" cWinGetCharWidth :: Int -> Addr -> Int -> Int -> Int -> HDC -> Int -> Addr -> Addr -> IO ()

winGetPicFontInfo :: PIC -> IO (Int,Int,Int,Int,PIC)
winGetPicFontInfo a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		o5 <- malloc 4;
		o6 <- malloc 4;
		-- Call C:
		cWinGetPicFontInfo a1 osNewToolbox o1 o2 o3 o4 o5 o6;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- fpeek o5;
		r6 <- free o6;
		return (r1,r2,r3,r4,r5)
	  }
foreign import stdcall "cpicture_121" "WinGetPicFontInfo" cWinGetPicFontInfo :: PIC -> Int -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()

winGetFontInfo :: Fnt -> Int -> HDC -> IO (Int,Int,Int,Int)
winGetFontInfo (a1,a2,a3) a4 a5
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		o5 <- malloc 4;
		-- Call C:
		cWinGetFontInfo s1 a2 a3 a4 a5 osNewToolbox o1 o2 o3 o4 o5;
		-- Read/free:
		freeCLEAN_STRING s1;
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- free o5;
		return (r1,r2,r3,r4)
	  }
foreign import stdcall "cpicture_121" "WinGetFontInfo" cWinGetFontInfo :: Addr -> Int -> Int -> Int -> HDC -> Int -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()

winSetFontStyle :: Int -> PIC -> IO PIC
winSetFontStyle a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetFontStyle a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetFontStyle" cWinSetFontStyle :: Int -> PIC -> Int -> Addr -> Addr -> IO ()

winSetFontSize :: Int -> PIC -> IO PIC
winSetFontSize a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetFontSize a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetFontSize" cWinSetFontSize :: Int -> PIC -> Int -> Addr -> Addr -> IO ()

winSetFontName :: String -> PIC -> IO PIC
winSetFontName a1 a2
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetFontName s1 a2 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s1;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetFontName" cWinSetFontName :: Addr -> PIC -> Int -> Addr -> Addr -> IO ()

winSetFont :: Fnt -> PIC -> IO PIC
winSetFont (a1,a2,a3) a4
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetFont s1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s1;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetFont" cWinSetFont :: Addr -> Int -> Int -> PIC -> Int -> Addr -> Addr -> IO ()

winPrintResizedBitmap :: (Int,Int) -> (Int,Int) -> (Int,Int) -> String -> PIC -> IO PIC
winPrintResizedBitmap (a1,a2) (a3,a4) (a5,a6) a7 a8
	= do {
		-- Marshal arguments:
		s7 <- createCLEAN_STRING a7;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinPrintResizedBitmap a1 a2 a3 a4 a5 a6 s7 a8 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s7;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinPrintResizedBitmap" cWinPrintResizedBitmap :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Addr -> Addr -> IO ()

--	Routines to DRAW bitmaps.
winDrawBitmap :: (Int,Int) -> (Int,Int) -> Int -> PIC -> IO PIC
winDrawBitmap (a1,a2) (a3,a4) a5 a6
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawBitmap a1 a2 a3 a4 a5 a6 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawBitmap" cWinDrawBitmap :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawResizedBitmap :: (Int,Int) -> (Int,Int) -> (Int,Int) -> Int -> PIC -> IO PIC
winDrawResizedBitmap (a1,a2) (a3,a4) (a5,a6) a7 a8
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawResizedBitmap a1 a2 a3 a4 a5 a6 a7 a8 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawResizedBitmap" cWinDrawResizedBitmap :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winCreateBitmap :: Int -> String -> HDC -> IO Int
winCreateBitmap a1 a2 a3
	= do {
		-- Marshal arguments:
		s2 <- createCLEAN_STRING a2;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCreateBitmap a1 s2 a3 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s2;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCreateBitmap" cWinCreateBitmap :: Int -> Addr -> HDC -> Int -> Addr -> Addr -> IO ()

winInvertPolygon :: PIC -> IO PIC
winInvertPolygon a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertPolygon a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertPolygon" cWinInvertPolygon :: Int -> Int -> Addr -> Addr -> IO ()

winErasePolygon :: PIC -> IO PIC
winErasePolygon a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinErasePolygon a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinErasePolygon" cWinErasePolygon :: Int -> Int -> Addr -> Addr -> IO ()

winFillPolygon :: PIC -> IO PIC
winFillPolygon a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillPolygon a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillPolygon" cWinFillPolygon :: Int -> Int -> Addr -> Addr -> IO ()

winDrawPolygon :: PIC -> IO PIC
winDrawPolygon a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawPolygon a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawPolygon" cWinDrawPolygon :: Int -> Int -> Addr -> Addr -> IO ()

winAddPolygonPoint :: Pt -> IO ()
winAddPolygonPoint (a1,a2)
	= cWinAddPolygonPoint a1 a2 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinAddPolygonPoint" cWinAddPolygonPoint :: Int -> Int -> Int -> IO Int

winStartPolygon :: Int -> IO ()
winStartPolygon a1
	= cWinStartPolygon a1 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinStartPolygon" cWinStartPolygon :: Int -> Int -> IO Int

winEndPolygon :: IO ()
winEndPolygon
	= cWinEndPolygon osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinEndPolygon" cWinEndPolygon :: Int -> IO Int


{-	Operations to create, modify, and destroy polygon shapes.
-}
winAllocPolyShape :: Int -> IO Int
winAllocPolyShape a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinAllocPolyShape a1 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinAllocPolyShape" cWinAllocPolyShape :: Int -> Int -> Addr -> Addr -> IO ()

winSetPolyPoint :: Int -> Int -> Int -> Int -> IO ()
winSetPolyPoint a1 a2 a3 a4
	= cWinSetPolyPoint a1 a2 a3 a4 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinSetPolyPoint" cWinSetPolyPoint :: Int -> Int -> Int -> Int -> Int -> IO Int

winFreePolyShape :: Int -> IO ()
winFreePolyShape a1
	= cWinFreePolyShape a1 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinFreePolyShape" cWinFreePolyShape :: Int -> Int -> IO Int


winInvertWedge :: Rect -> Pt -> Pt -> PIC -> IO PIC
winInvertWedge (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) a9
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertWedge a1 a2 a3 a4 a5 a6 a7 a8 a9 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertWedge" cWinInvertWedge :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winEraseWedge :: Rect -> Pt -> Pt -> PIC -> IO PIC
winEraseWedge (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) a9
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinEraseWedge a1 a2 a3 a4 a5 a6 a7 a8 a9 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinEraseWedge" cWinEraseWedge :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winFillWedge :: Rect -> Pt -> Pt -> PIC -> IO PIC
winFillWedge (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) a9
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillWedge a1 a2 a3 a4 a5 a6 a7 a8 a9 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillWedge" cWinFillWedge :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawWedge :: Rect -> Pt -> Pt -> PIC -> IO PIC
winDrawWedge (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) a9
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawWedge a1 a2 a3 a4 a5 a6 a7 a8 a9 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawWedge" cWinDrawWedge :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winInvertCircle :: Pt -> Int -> PIC -> IO PIC
winInvertCircle (a1,a2) a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertCircle a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertCircle" cWinInvertCircle :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winEraseCircle :: Pt -> Int -> PIC -> IO PIC
winEraseCircle (a1,a2) a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinEraseCircle a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinEraseCircle" cWinEraseCircle :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winFillCircle :: Pt -> Int -> PIC -> IO PIC
winFillCircle (a1,a2) a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillCircle a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillCircle" cWinFillCircle :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawCircle :: Pt -> Int -> PIC -> IO PIC
winDrawCircle (a1,a2) a3 a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawCircle a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawCircle" cWinDrawCircle :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winInvertOval :: Rect -> PIC -> IO PIC
winInvertOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertOval a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertOval" cWinInvertOval :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winEraseOval :: Rect -> PIC -> IO PIC
winEraseOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinEraseOval a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinEraseOval" cWinEraseOval :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winFillOval :: Rect -> PIC -> IO PIC
winFillOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillOval a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillOval" cWinFillOval :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawOval :: Rect -> PIC -> IO PIC
winDrawOval (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawOval a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawOval" cWinDrawOval :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winInvertRoundRectangle :: Rect -> Int -> Int -> PIC -> IO PIC
winInvertRoundRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5 a6 a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertRoundRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertRoundRectangle" cWinInvertRoundRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winEraseRoundRectangle :: Rect -> Int -> Int -> PIC -> IO PIC
winEraseRoundRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5 a6 a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinEraseRoundRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinEraseRoundRectangle" cWinEraseRoundRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winFillRoundRectangle :: Rect -> Int -> Int -> PIC -> IO PIC
winFillRoundRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5 a6 a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillRoundRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillRoundRectangle" cWinFillRoundRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawRoundRectangle :: Rect -> Int -> Int -> PIC -> IO PIC
winDrawRoundRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5 a6 a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawRoundRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawRoundRectangle" cWinDrawRoundRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winScrollRectangle :: Rect -> Pt -> PIC -> IO (Rect,PIC)
winScrollRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		o5 <- malloc 4;
		o6 <- malloc 4;
		-- Call C:
		cWinScrollRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2 o3 o4 o5 o6;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- fpeek o5;
		r6 <- free o6;
		return (Rect {rleft=r1,rtop=r2,rright=r3,rbottom=r4},r5)
	  }
foreign import stdcall "cpicture_121" "WinScrollRectangle" cWinScrollRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()

winCopyRectangle :: Rect -> Pt -> PIC -> IO PIC
winCopyRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCopyRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCopyRectangle" cWinCopyRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winCopyRectangleTo :: Rect -> Pt -> PIC -> IO PIC
winCopyRectangleTo (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinCopyRectangleTo a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinCopyRectangleTo" cWinCopyRectangleTo :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winMoveRectangle :: Rect -> Pt -> PIC -> IO PIC
winMoveRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinMoveRectangle a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinMoveRectangle" cWinMoveRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winMoveRectangleTo :: Rect -> Pt -> PIC -> IO PIC
winMoveRectangleTo (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) a7
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinMoveRectangleTo a1 a2 a3 a4 a5 a6 a7 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinMoveRectangleTo" cWinMoveRectangleTo :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winInvertRectangle :: Rect -> PIC -> IO PIC
winInvertRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInvertRectangle a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInvertRectangle" cWinInvertRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winEraseRectangle :: Rect -> PIC -> IO PIC
winEraseRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinEraseRectangle a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinEraseRectangle" cWinEraseRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winFillRectangle :: Rect -> PIC -> IO PIC
winFillRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinFillRectangle a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinFillRectangle" cWinFillRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawRectangle :: Rect -> PIC -> IO PIC
winDrawRectangle (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawRectangle a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawRectangle" cWinDrawRectangle :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawChar :: Int -> PIC -> IO PIC
winDrawChar a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawChar a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawChar" cWinDrawChar :: Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawString :: String -> PIC -> IO PIC
winDrawString a1 a2
	= do {
		-- Marshal arguments:
		s1 <- createCLEAN_STRING a1;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawString s1 a2 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s1;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawString" cWinDrawString :: Addr -> Int -> Int -> Addr -> Addr -> IO ()

winDrawCCurve :: Rect -> Pt -> Pt -> RGBcolor -> PIC -> IO PIC
winDrawCCurve (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) (a9,a10,a11) a12
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawCCurve a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 a11 a12 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawCCurve" cWinDrawCCurve :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawCLine :: Pt -> Pt -> RGBcolor -> PIC -> IO PIC
winDrawCLine (a1,a2) (a3,a4) (a5,a6,a7) a8
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawCLine a1 a2 a3 a4 a5 a6 a7 a8 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawCLine" cWinDrawCLine :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawCPoint :: Pt -> RGBcolor -> PIC -> IO PIC
winDrawCPoint (a1,a2) (a3,a4,a5) a6
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawCPoint a1 a2 a3 a4 a5 a6 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawCPoint" cWinDrawCPoint :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawCurve :: Rect -> Pt -> Pt -> PIC -> IO PIC
winDrawCurve (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) (a5,a6) (a7,a8) a9
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawCurve a1 a2 a3 a4 a5 a6 a7 a8 a9 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawCurve" cWinDrawCurve :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawLine :: Pt -> Pt -> PIC -> IO PIC
winDrawLine (a1,a2) (a3,a4) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawLine a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawLine" cWinDrawLine :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winDrawPoint :: Pt -> PIC -> IO PIC
winDrawPoint (a1,a2) a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinDrawPoint a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinDrawPoint" cWinDrawPoint :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winLinePen :: Pt -> PIC -> IO PIC
winLinePen (a1,a2) a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinLinePen a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinLinePen" cWinLinePen :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winLinePenTo :: Pt -> PIC -> IO PIC
winLinePenTo (a1,a2) a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinLinePenTo a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinLinePenTo" cWinLinePenTo :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winMovePen :: Pt -> PIC -> IO PIC
winMovePen (a1,a2) a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinMovePen a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinMovePen" cWinMovePen :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winMovePenTo :: Pt -> PIC -> IO PIC
winMovePenTo (a1,a2) a3
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinMovePenTo a1 a2 a3 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinMovePenTo" cWinMovePenTo :: Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winGetPenPos :: PIC -> IO (Int,Int,HDC)
winGetPenPos a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		-- Call C:
		cWinGetPenPos a1 osNewToolbox o1 o2 o3 o4;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- free o4;
		return (r1,r2,r3)
	  }
foreign import stdcall "cpicture_121" "WinGetPenPos" cWinGetPenPos :: Int -> Int -> Addr -> Addr -> Addr -> Addr -> IO ()

winSetPenSize :: Int -> PIC -> IO PIC
winSetPenSize a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetPenSize a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetPenSize" cWinSetPenSize :: Int -> Int -> Int -> Addr -> Addr -> IO ()

winSetPattern :: Int -> PIC -> IO PIC
winSetPattern a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetPattern a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetPattern" cWinSetPattern :: Int -> Int -> Int -> Addr -> Addr -> IO ()

winSetMode ::  Int -> PIC -> IO PIC
winSetMode a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetMode a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetMode" cWinSetMode :: Int -> Int -> Int -> Addr -> Addr -> IO ()

winSetBackColor :: RGBcolor -> PIC -> IO PIC
winSetBackColor (a1,a2,a3) a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetBackColor a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetBackColor" cWinSetBackColor :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winSetPenColor :: RGBcolor -> PIC -> IO PIC
winSetPenColor (a1,a2,a3) a4
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetPenColor a1 a2 a3 a4 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetPenColor" cWinSetPenColor :: Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

winClipPicture :: Rect -> PIC -> IO PIC
winClipPicture (Rect {rleft=a1,rtop=a2,rright=a3,rbottom=a4}) a5
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinClipPicture a1 a2 a3 a4 a5 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinClipPicture" cWinClipPicture :: Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()

--	Operation to set the clipping region.
winClipRgnPicture :: HRGN -> PIC -> IO PIC
winClipRgnPicture a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinClipRgnPicture a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinClipRgnPicture" cWinClipRgnPicture :: Int -> Int -> Int -> Addr -> Addr -> IO ()

--	Operation to set the complete clipping region.
winSetClipRgnPicture :: HRGN -> PIC -> IO PIC
winSetClipRgnPicture a1 a2
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinSetClipRgnPicture a1 a2 osNewToolbox o1 o2;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinSetClipRgnPicture" cWinSetClipRgnPicture :: Int -> Int -> Int -> Addr -> Addr -> IO ()

--	Operation to retrieve the current clipping region.
winGetClipRgnPicture :: PIC -> IO (HRGN,PIC)
winGetClipRgnPicture a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		-- Call C:
		cWinGetClipRgnPicture a1 osNewToolbox o1 o2 o3;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- free o3;
		return (r1,r2)
	  }
foreign import stdcall "cpicture_121" "WinGetClipRgnPicture" cWinGetClipRgnPicture :: Int -> Int -> Addr -> Addr -> Addr -> IO ()

winDeleteObject :: Int -> IO ()
winDeleteObject a1
	= cWinDeleteObject a1 osNewToolbox >> return ()
foreign import stdcall "cpicture_121" "WinDeleteObject" cWinDeleteObject :: Int -> Int -> IO Int

winDonePicture :: PIC -> IO (Int,Int,RGBcolor,RGBcolor,Pt,Fnt,PIC)
winDonePicture a1
	= do {
		-- Marshal arguments:
		o1 <- malloc 4;
		o2 <- malloc 4;
		o3 <- malloc 4;
		o4 <- malloc 4;
		o5 <- malloc 4;
		o6 <- malloc 4;
		o7 <- malloc 4;
		o8 <- malloc 4;
		o9 <- malloc 4;
		o10 <- malloc 4;
		o11 <- malloc 4;
		o12 <- malloc 4;
		o13 <- malloc 4;
		o14 <- malloc 4;
		o15 <- malloc 4;
		-- Call C:
		cWinDonePicture a1 osNewToolbox o1 o2 o3 o4 o5 o6 o7 o8 o9 o10 o11 o12 o13 o14 o15;
		-- Read/free:
		r1 <- fpeek o1;
		r2 <- fpeek o2;
		r3 <- fpeek o3;
		r4 <- fpeek o4;
		r5 <- fpeek o5;
		r6 <- fpeek o6;
		r7 <- fpeek o7;
		r8 <- fpeek o8;
		r9 <- fpeek o9;
		r10 <- fpeek o10;
		clstr11 <- peek o11;			-- dereference *CLEAN_STRING
		s11 <- readCLEAN_STRING clstr11;	-- read CLEAN_STRING
		freeCLEAN_STRING o11;
		r12 <- fpeek o12;
		r13 <- fpeek o13;
		r14 <- fpeek o14;
		r15 <- free o15;
		return (r1,r2,(r3,r4,r5),(r6,r7,r8),(r9,r10),(s11,r12,r13),r14)
	  }
foreign import stdcall "cpicture_121" "WinDonePicture" cWinDonePicture :: Int -> Int -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> Addr -> IO ()

winInitPicture :: Int -> Int -> RGBcolor -> RGBcolor -> Pt -> Fnt -> Pt -> PIC -> IO PIC
winInitPicture a1 a2 (a3,a4,a5) (a6,a7,a8) (a9,a10) (a11,a12,a13) (a14,a15) a16
	= do {
		-- Marshal arguments:
		s11 <- createCLEAN_STRING a11;
		o1 <- malloc 4;
		o2 <- malloc 4;
		-- Call C:
		cWinInitPicture a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 s11 a12 a13 a14 a15 a16 osNewToolbox o1 o2;
		-- Read/free:
		freeCLEAN_STRING s11;
		r1 <- fpeek o1;
		r2 <- free o2;
		return r1
	  }
foreign import stdcall "cpicture_121" "WinInitPicture" cWinInitPicture :: Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Int -> Int -> Int -> Int -> Int -> Int -> Addr -> Addr -> IO ()
