# -----------------------------------------------------------------------------
# $Id: target.mk,v 1.34 2001/08/16 22:54:24 sof Exp $
#
# hslibs/target.mk
#

# We need to set TOP to be the TOP that the next level up expects!
# The TOP variable is reset after the inclusion of the fptools
# boilerplate, so we stash TOP away first:
HSLIBS_TOP := $(TOP)
TOP:=$(TOP)/..

# -----------------------------------------------------------------------------
# Makefiles in the subdirectories should set the following variables:
# 
#   PACKAGE		the (short) name of the top-level library category 
#			we're building.  eg. lang, net, text etc.
#
#   PACKAGE_DEPS  	other library categories that this category depends on.
#
#   IS_CBITS_LIB        YES if the current library is a cbits library
#
#   SRCS_FROM_SUBDIRS	pull out *.hs and *.lhs sources from these subdirectories
#			under the current directory.
#
#   NOT_FOR_GHC		exclude source files from certain compilers.
#   NOT_FOR_NHC
#   NOT_FOR_HBC
#   NOT_FOR_HUGS
#
#   NOT_FOR_ANYONE	always exclude certain files

# -----------------------------------------------------------------------------

# Automatically recurse into cbits subdir
ifneq "$(wildcard cbits)" ""
SUBDIRS += cbits
endif

# Filter source file list depending on which compiler we're using

ifeq "$(HsLibsFor)" "ghc"
EXCLUDED_SRCS = $(NOT_FOR_GHC)
HC = $(GHC_INPLACE)
MKDEPENDHS = $(HC)
endif

ifeq "$(HsLibsFor)" "hugs"
EXCLUDED_SRCS = $(NOT_FOR_HUGS)
MKDEPENDHS = $(GHC)
endif

ifeq "$(HsLibsFor)" "nhc"
EXCLUDED_SRCS = $(NOT_FOR_NHC)
HC = $(NHC)
MKDEPENDHS = $(GHC)
endif

ifeq "$(HsLibsFor)" "hbc"
EXCLUDED_SRCS = $(NOT_FOR_HBC)
HC = $(HBC)
MKDEPENDHS = $(GHC)
endif

ifneq "$(NOT_FOR_ANYONE)" ""
EXCLUDED_SRCS = $(NOT_FOR_ANYONE)
endif

# -----------------------------------------------------------------------------
# Building libraries for GHC

ifeq "$(HsLibsFor)" "ghc"

SRC_HAPPY_OPTS += -g

ifneq "$(PACKAGE)" ""

SRCS += $(wildcard $(patsubst %, %/*hs, $(SRCS_FROM_SUBDIRS)))
SRC_HC_OPTS += $(patsubst %, -i%, $(SRCS_FROM_SUBDIRS))

MAGIC_HSCPP_OPTS=-DBEGIN_FOR_GHC='-}' -DEND_FOR_GHC='{-' -DBEGIN_FOR_HUGS='{-' -DEND_FOR_HUGS='-}'
SRC_MKDEPENDHS_OPTS += -optdep-w $(MAGIC_HSCPP_OPTS)

SRC_HC_OPTS += $(GhcLibHcOpts)
ifeq "$(StripObjs)" "YES"
SRC_HC_OPTS += -strip-objs
endif

# to find the HsFoo.h files, the include path list must be extended
SRC_CC_OPTS += $(patsubst %, -I$(TOP)/%/cbits, $(PACKAGE_DEPS))
SRC_HC_OPTS += $(patsubst %, -I$(TOP)/%/cbits, $(PACKAGE_DEPS))

SRC_HSC2HS_OPTS += -I$(GHC_IO_INCLUDE_DIR)
SRC_CC_OPTS     += -I$(GHC_IO_INCLUDE_DIR) -I$(GHC_INCLUDE_DIR)

# Installation; need to install .hi files as well as libraries
#
# The interface files are put inside the $(libdir), since they
# might (potentially) be platform specific..
#
# override is used here because for binary distributions, datadir is
# set on the command line. sigh.
#

override datadir:=$(libdir)/imports/$(PACKAGE)
INSTALL_LIBS  += $(LIBRARY)
INSTALL_DATAS += $(HS_IFACES)

ifeq "$(DLLized)" "YES"
INSTALL_PROGS += $(DLL_NAME)
INSTALL_LIBS  += $(patsubst %.a, %_imp.a, $(LIBRARY))
endif

endif # PACKAGE /= ""

endif # HsLibsFor = ghc

# -----------------------------------------------------------------------------
# Building libraries for Hugs

# we CPP all the haskell sources and pop them in a mirror hierarchy
# under hugs-srcs/.

ifeq "$(HsLibsFor)" "hugs"

HUGS_SRC_DIR = hugs-srcs
HUGS_SRC_DIRS = $(HUGS_SRC_DIR) $(patsubst %, $(HUGS_SRC_DIR)/%, $(SRCS_FROM_SUBDIRS))

SRCS += $(wildcard $(patsubst %, %/*hs, $(SRCS_FROM_SUBDIRS)))
HUGS_SRCS = $(patsubst %, $(HUGS_SRC_DIR)/%, $(SRCS))

all :: $(HUGS_SRC_DIRS) $(HUGS_SRCS)

$(HUGS_SRC_DIRS) ::
	$(MKDIRHIER) $@

HUGS_DEFINES = -D__HUGS__

$(HUGS_SRC_DIR)/%.hs : %.hs
	$(CPP) $(RAWCPP_FLAGS) $(HUGS_DEFINES) -o $(HUGS_SRC_DIR)/$*.hs - < $<

$(HUGS_SRC_DIR)/%.lhs : %.lhs
	$(CPP) $(RAWCPP_FLAGS) $(HUGS_DEFINES) -o $(HUGS_SRC_DIR)/$*.lhs - < $<

INSTALL_DATAS = $(HUGS_SRCS)

endif

# -----------------------------------------------------------------------------

include $(TOP)/mk/target.mk

# Reset TOP
TOP:=$(HSLIBS_TOP)
