{-
   Double.hs (adapted from double.c which is (c) Silicon Graphics, Inc)
   This file is part of HOpenGL - a binding of OpenGL and GLUT for Haskell.
   Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

   This is a simple double buffered program.
   Pressing the left mouse button rotates the rectangle.
   Pressing the middle mouse button stops the rotation.
-}

import IOExts   ( IORef, newIORef, readIORef, modifyIORef )

import GL
import GLUT

display :: IORef GLfloat -> DisplayAction
display spin = do
   clear [ColorBufferBit]
   pushMatrix
   s <- readIORef spin
   rotate s (Vector3 0 0 1)
   color (Color3 1.0 1.0 (1.0 ::GLfloat))
   rect (Vertex2 (-25) (-25)) (Vertex2 25 (25 :: GLfloat))
   popMatrix
   swapBuffers

spinDisplay :: IORef GLfloat -> IdleAction
spinDisplay spin = do
   modifyIORef spin (\s1 -> let s2 = s1 + 2.0
                            in if s2 > 360.0 then s2 - 360.0 else s2)
   postRedisplay

myInit :: IO ()
myInit = do
   clearColor (Color4 0.0 0.0 0.0 0.0)
   shadeModel Smooth

reshape :: ReshapeAction
reshape screenSize = do
   viewport (Viewport (WindowPosition 0 0) screenSize)
   matrixMode Projection
   loadIdentity
   ortho (-50.0) 50.0 (-50.0) 50.0 (-1.0) 1.0
   matrixMode Modelview
   loadIdentity

mouse :: IORef GLfloat -> MouseAction
mouse spin LeftButton Down _ = idleFunc (Just (spinDisplay spin))
mouse _    _          Down _ = idleFunc Nothing
mouse _    _          _    _ = return ()

--  Request double buffer display mode.
--  Register mouse input callback functions

main :: IO ()
main = do
   (progName, _args) <- GLUT.init Nothing
   spin <- newIORef 0.0
   createWindow progName (display spin) [ GLUT.Double, GLUT.Rgb ]
                (Just (WindowPosition 100 100))
                (Just (WindowSize     250 250))
   myInit
   reshapeFunc (Just reshape)
   mouseFunc (Just (mouse spin))
   mainLoop
