{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2001  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-}

module GLU_Constants where

import GL_BasicTypes    (GLenum)

default (GLenum)

-- Normal vectors --------------------------------------------------------------
glu_SMOOTH                   = 0x100000
glu_FLAT                     = 0x100001
glu_NONE                     = 0x100002

-- Quadric draw styles ---------------------------------------------------------
glu_POINT                    = 0x100010
glu_LINE                     = 0x100011
glu_FILL                     = 0x100012
glu_SILHOUETTE               = 0x100013

-- Quadric orientation ---------------------------------------------------------
glu_OUTSIDE                  = 0x100020
glu_INSIDE                   = 0x100021

-- Tessellator -----------------------------------------------------------------
glu_TESS_BEGIN               = 0x100100
glu_TESS_VERTEX              = 0x100101
glu_TESS_END                 = 0x100102
glu_TESS_ERROR               = 0x100103
glu_TESS_EDGE_FLAG           = 0x100104
glu_TESS_COMBINE             = 0x100105
                          
glu_TESS_BEGIN_DATA          = 0x100106
glu_TESS_VERTEX_DATA         = 0x100107
glu_TESS_END_DATA            = 0x100108
glu_TESS_ERROR_DATA          = 0x100109
glu_TESS_EDGE_FLAG_DATA      = 0x100110
glu_TESS_COMBINE_DATA        = 0x100111

-- Winding rules ---------------------------------------------------------------
glu_TESS_WINDING_ODD         = 0x100130
glu_TESS_WINDING_NONZERO     = 0x100131
glu_TESS_WINDING_POSITIVE    = 0x100132
glu_TESS_WINDING_NEGATIVE    = 0x100133
glu_TESS_WINDING_ABS_GEQ_TWO = 0x100134

-- Tessellation properties -----------------------------------------------------
glu_TESS_WINDING_RULE        = 0x100140
glu_TESS_BOUNDARY_ONLY       = 0x100141
glu_TESS_TOLERANCE           = 0x100142

-- Tessellation errors ---------------------------------------------------------
glu_TESS_ERROR1              = 0x100151
glu_TESS_ERROR2              = 0x100152
glu_TESS_ERROR3              = 0x100153
glu_TESS_ERROR4              = 0x100154
glu_TESS_ERROR5              = 0x100155
glu_TESS_ERROR6              = 0x100156
glu_TESS_ERROR7              = 0x100157
glu_TESS_ERROR8              = 0x100158

-- NURBS -----------------------------------------------------------------------
glu_AUTO_LOAD_MATRIX         = 0x100200
glu_CULLING                  = 0x100201
glu_PARAMETRIC_TOLERANCE     = 0x100202
glu_SAMPLING_TOLERANCE       = 0x100203
glu_DISPLAY_MODE             = 0x100204
glu_SAMPLING_METHOD          = 0x100205
glu_U_STEP                   = 0x100206
glu_V_STEP                   = 0x100207

glu_PATH_LENGTH              = 0x100215
glu_PARAMETRIC_ERROR         = 0x100216
glu_DOMAIN_DISTANCE          = 0x100217

glu_MAP1_TRIM_2              = 0x100210
glu_MAP1_TRIM_3              = 0x100211

glu_OUTLINE_POLYGON          = 0x100240
glu_OUTLINE_PATCH            = 0x100241

glu_NURBS_ERROR1             = 0x100251
glu_NURBS_ERROR2             = 0x100252
glu_NURBS_ERROR3             = 0x100253
glu_NURBS_ERROR4             = 0x100254
glu_NURBS_ERROR5             = 0x100255
glu_NURBS_ERROR6             = 0x100256
glu_NURBS_ERROR7             = 0x100257
glu_NURBS_ERROR8             = 0x100258
glu_NURBS_ERROR9             = 0x100259
glu_NURBS_ERROR10            = 0x100260
glu_NURBS_ERROR11            = 0x100261
glu_NURBS_ERROR12            = 0x100262
glu_NURBS_ERROR13            = 0x100263
glu_NURBS_ERROR14            = 0x100264
glu_NURBS_ERROR15            = 0x100265
glu_NURBS_ERROR16            = 0x100266
glu_NURBS_ERROR17            = 0x100267
glu_NURBS_ERROR18            = 0x100268
glu_NURBS_ERROR19            = 0x100269
glu_NURBS_ERROR20            = 0x100270
glu_NURBS_ERROR21            = 0x100271
glu_NURBS_ERROR22            = 0x100272
glu_NURBS_ERROR23            = 0x100273
glu_NURBS_ERROR24            = 0x100274
glu_NURBS_ERROR25            = 0x100275
glu_NURBS_ERROR26            = 0x100276
glu_NURBS_ERROR27            = 0x100277
glu_NURBS_ERROR28            = 0x100278
glu_NURBS_ERROR29            = 0x100279
glu_NURBS_ERROR30            = 0x100280
glu_NURBS_ERROR31            = 0x100281
glu_NURBS_ERROR32            = 0x100282
glu_NURBS_ERROR33            = 0x100283
glu_NURBS_ERROR34            = 0x100284
glu_NURBS_ERROR35            = 0x100285
glu_NURBS_ERROR36            = 0x100286
glu_NURBS_ERROR37            = 0x100287

-- Errors ----------------------------------------------------------------------
glu_INVALID_ENUM             = 0x100900
glu_INVALID_VALUE            = 0x100901
glu_OUT_OF_MEMORY            = 0x100902
glu_INCOMPATIBLE_GL_VERSION  = 0x100903

-- New in GLU 1.1 --------------------------------------------------------------
glu_VERSION                  = 0x100800
glu_EXTENSIONS               = 0x100801

-- GLU 1.0 tessellation - obsolete! --------------------------------------------

-- Mouse buttons ---------------------------------------------------------------
glu_CW                       = 0x100120
glu_CCW                      = 0x100121
glu_INTERIOR                 = 0x100122
glu_EXTERIOR                 = 0x100123
glu_UNKNOWN                  = 0x100124

-- Tessellator -----------------------------------------------------------------
glu_BEGIN                    = glu_TESS_BEGIN
glu_VERTEX                   = glu_TESS_VERTEX
glu_END                      = glu_TESS_END
glu_ERROR                    = glu_TESS_ERROR
glu_EDGE_FLAG                = glu_TESS_EDGE_FLAG
