{-
HOpenGL - a binding of OpenGL and GLUT for Haskell.
Copyright (C) 2000  Sven Panne <Sven.Panne@BetaResearch.de>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library (COPYING.LIB); if not, write to the Free
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

This module corresponds to chapter 11 (Geometric Object Rendering) of the
GLUT3 API docs.
-}

module GLUT_Objects (
   wireSphere, solidSphere, wireCone, solidCone, wireCube, solidCube,
   wireTorus, solidTorus, wireDodecahedron, solidDodecahedron,
   wireTeapot, solidTeapot, wireOctahedron, solidOctahedron,
   wireTetrahedron, solidTetrahedron, wireIcosahedron, solidIcosahedron
) where

import GL_BasicTypes    (GLint, GLdouble)

foreign import "glutWireSphere"        unsafe wireSphere        :: GLdouble -> GLint -> GLint -> IO ()
foreign import "glutSolidSphere"       unsafe solidSphere       :: GLdouble -> GLint -> GLint -> IO ()
foreign import "glutWireCone"          unsafe wireCone          :: GLdouble -> GLdouble -> GLint -> GLint -> IO ()
foreign import "glutSolidCone"         unsafe solidCone         :: GLdouble -> GLdouble -> GLint -> GLint -> IO ()
foreign import "glutWireCube"          unsafe wireCube          :: GLdouble -> IO ()
foreign import "glutSolidCube"         unsafe solidCube         :: GLdouble -> IO ()
foreign import "glutWireTorus"         unsafe wireTorus         :: GLdouble -> GLdouble -> GLint -> GLint -> IO ()
foreign import "glutSolidTorus"        unsafe solidTorus        :: GLdouble -> GLdouble -> GLint -> GLint -> IO ()
foreign import "glutWireDodecahedron"  unsafe wireDodecahedron  :: IO ()
foreign import "glutSolidDodecahedron" unsafe solidDodecahedron :: IO ()
foreign import "glutWireTeapot"        unsafe wireTeapot        :: GLdouble -> IO ()
foreign import "glutSolidTeapot"       unsafe solidTeapot       :: GLdouble -> IO ()
foreign import "glutWireOctahedron"    unsafe wireOctahedron    :: IO ()
foreign import "glutSolidOctahedron"   unsafe solidOctahedron   :: IO ()
foreign import "glutWireTetrahedron"   unsafe wireTetrahedron   :: IO ()
foreign import "glutSolidTetrahedron"  unsafe solidTetrahedron  :: IO ()
foreign import "glutWireIcosahedron"   unsafe wireIcosahedron   :: IO ()
foreign import "glutSolidIcosahedron"  unsafe solidIcosahedron  :: IO ()
