
# Look for a way to send a print job (either lpr or lp)
AC_DEFUN(AC_FIND_SPOOLER,
[dnl
AC_PATH_PROG(SPOOLER, "lpr")
if test -z "$SPOOLER" ; then
  AC_PATH_PROG(SPOOLER, "lp")
fi
if test -z "$SPOOLER" ; then
  AC_MSG_ERROR(Cannot determine your print spooling system)
fi

if test `basename $SPOOLER` = lpr ; then
  AC_DEFINE_UNQUOTED(PRINTER_SPOOLER, "$SPOOLER -P")
else
  AC_DEFINE_UNQUOTED(PRINTER_SPOOLER, "$SPOOLER -d")
fi
])


# Check whether the bool type is known to the compiler
AC_DEFUN(AC_CHECK_BOOL,
[dnl
AC_CACHE_CHECK([for bool type],
  ac_cv_bool,
  [AC_LANG_SAVE
   AC_LANG_CPLUSPLUS
   AC_TRY_COMPILE([#include<stdio.h>], [bool a;],
                  ac_cv_bool=yes, ac_cv_bool=no)
   AC_LANG_RESTORE
])
if test $ac_cv_bool = no; then
  AC_DEFINE(bool, int)
fi
])
