/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  scanner.inl - G::Scanner inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GScanner*
GFC::G::Scanner::g_scanner() const
{
	return scanner_;
}

inline GFC::G::Scanner::operator GScanner* () const
{
	return this ? scanner_ : 0;
}

inline GTokenType
GFC::G::Scanner::token() const
{
	return g_scanner_cur_token(scanner_);
}

inline GTokenValue
GFC::G::Scanner::value() const
{
	return g_scanner_cur_value(scanner_);
}

inline unsigned int
GFC::G::Scanner::line() const
{
	return g_scanner_cur_line(scanner_);
}

inline unsigned int
GFC::G::Scanner::position() const
{
	return g_scanner_cur_position(scanner_);
}

inline bool
GFC::G::Scanner::eof() const
{
	return g_scanner_eof(scanner_) != 0;
}

inline GTokenType
GFC::G::Scanner::next_token() const
{
	return scanner_->next_token;
}

inline GTokenValue
GFC::G::Scanner::next_value() const
{
	return scanner_->next_value;
}

inline unsigned int
GFC::G::Scanner::next_line() const
{
	return scanner_->next_line;
}

inline unsigned int
GFC::G::Scanner::next_position() const
{
	return scanner_->next_position;
}

inline GTokenType
GFC::G::Scanner::get_next_token() const
{
	return g_scanner_get_next_token(scanner_);
}

inline GTokenType
GFC::G::Scanner::peek_next_token() const
{
	return g_scanner_peek_next_token(scanner_);
}

inline void
GFC::G::Scanner::input_file(int input_fd)
{
	g_scanner_input_file(scanner_, input_fd);
}

inline void
GFC::G::Scanner::sync_file_offset()
{
	g_scanner_sync_file_offset(scanner_);
}

inline void
GFC::G::Scanner::input_text(const char *text, unsigned int length)
{
	g_scanner_input_text(scanner_, text, length);
}

inline unsigned int
GFC::G::Scanner::set_scope(unsigned int scope_id)
{
	return g_scanner_set_scope(scanner_, scope_id);
}

inline void
GFC::G::Scanner::scope_add_symbol(unsigned int scope_id, const char *symbol, void *value)
{
	g_scanner_scope_add_symbol(scanner_, scope_id, symbol, value);
}

inline void
GFC::G::Scanner::scope_remove_symbol(unsigned int scope_id, const char *symbol)
{
	g_scanner_scope_remove_symbol(scanner_, scope_id, symbol);
}

inline void*
GFC::G::Scanner::scope_lookup_symbol(unsigned int scope_id, const char *symbol)
{
	return g_scanner_scope_lookup_symbol(scanner_, scope_id, symbol);
}

inline void*
GFC::G::Scanner::lookup_symbol(const char *symbol)
{
	return g_scanner_lookup_symbol(scanner_, symbol);
}

