#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>

#include "gfcc.h"

extern GtkWidget *notebook;
extern GtkWidget *cliplist;
extern struct _fwchain fwchain[];
extern gint maxchains;
extern gint modified;

extern struct _menu *service_tcp;
extern struct _menu *service_udp;
extern struct _menu *proto_name;

const struct _menu target_name[] = {
	{ 1, IP_FW_LABEL_ACCEPT, NULL },
	{ 1, IP_FW_LABEL_BLOCK, NULL },
	{ 1, IP_FW_LABEL_MASQUERADE, NULL },
	{ 1, IP_FW_LABEL_REJECT, NULL },
	{ 1, IP_FW_LABEL_RETURN, NULL },
	{ 1, IP_FW_LABEL_REDIRECT, NULL },
	{ 1, IP_FW_LABEL_NONE, NULL },
	{ 0, NULL, NULL },
};

const struct _menu tos_name[] = {
	{ 0x00, "0x00 - Not Set", NULL },
	{ 0x10, "0x10 - Minimum Delay", NULL },
	{ 0x08, "0x08 - Minimum Throughput", NULL },
	{ 0x04, "0x04 - Maximum Reliability", NULL },
	{ 0x02, "0x02 - Minimum Cost", NULL },
	{    0, NULL, NULL },
};

struct icmp_names {
	gchar *name;
	gchar *type;
	gchar *code_min, *code_max;
	int use_code_min_for_testing;
};
const struct icmp_names icmp_codes[] = {
	{ "Select icmp-type",		  "0",  "0",     "0", TRUE },
	{ "all",			  "0",  "0", "65535", TRUE },
	{ "echo-reply(pong)",		  "0",  "0", "65535", TRUE },
	{ "destination-unreachable",	  "3",  "0", "65535", FALSE },
	{ "  network-unreachable",	  "3",  "0",     "0", TRUE },
	{ "  host-unreachable",		  "3",  "1",     "1", TRUE },
	{ "  protocol-unreachable",	  "3",  "2",     "2", TRUE },
	{ "  port-unreachable",		  "3",  "3",     "3", TRUE },
	{ "  fragmentation-needed",	  "3",  "4",     "4", TRUE },
	{ "  source-route-failed",	  "3",  "5",     "5", TRUE },
	{ "  network-unknown",		  "3",  "6",     "6", TRUE },
	{ "  host-unknown",		  "3",  "7",     "7", TRUE },
	{ "  network-prohibited",	  "3",  "9",     "9", TRUE },
	{ "  host-prohibited",		  "3", "10",    "10", TRUE },
	{ "  TOS-network-unreachable",	  "3", "11",    "11", TRUE },
	{ "  TOS-host-unreachable",	  "3", "12",    "12", TRUE },
	{ "  communication-prohibited",	  "3", "13",    "13", TRUE },
	{ "  host-precedence-violation",  "3", "14",    "14", TRUE },
	{ "  precedence-cutoff",	  "3", "15",    "15", TRUE },
	{ "source-quench",		  "4",  "0", "65535", TRUE },
	{ "redirect",			  "5",  "0", "65535", FALSE },
	{ "  network-redirect",		  "5",  "0",     "0", TRUE },
	{ "  host-redirect",		  "5",  "1",     "1", TRUE },
	{ "  TOS-network-redirect",	  "5",  "2",     "2", TRUE },
	{ "  TOS-host-redirect",	  "5",  "3",     "3", TRUE },
	{ "echo-request(ping)",		  "8",  "0", "65535", TRUE },
	{ "router-advertisement",	  "9",  "0", "65535", TRUE },
	{ "router-solicitation",	 "10",  "0", "65535", TRUE },
	{ "time(ttl)-exceeded",		 "11",  "0", "65535", FALSE },
	{ "  ttl-zero-during-transit",	 "11",  "0",     "0", TRUE },
	{ "  ttl-zero-during-reassembly","11",  "1",     "1", TRUE },
	{ "parameter-problem",		 "12",  "0", "65535", FALSE },
	{ "  ip-header-bad",		 "12",  "0",     "0", TRUE },
	{ "  required-option-missing",	 "12",  "1",     "1", TRUE },
	{ "timestamp-request",		 "13",  "0", "65535", TRUE },
	{ "timestamp-reply",		 "14",  "0", "65535", TRUE },
	{ "address-mask-request",	 "17",  "0", "65535", TRUE },
	{ "address-mask-reply",		 "18",  "0", "65535", TRUE },
	{ NULL, NULL, NULL, NULL, FALSE },
};

struct _fwentry fwentry;

static void edit_win_destroy(GtkWidget *, gpointer);
static void port_win_destroy(GtkWidget *, gpointer);
static void set_protocol_value(GtkWidget *widget, gpointer data);
static void set_icmp_type(GtkWidget *widget, gpointer data);
static void set_rule_data(GtkWidget *widget, gpointer data);
static void set_tosxor_data(GtkWidget *widget, gpointer data);
static void put_rule_data(void);
static void syn_toggle(GtkWidget *w, gchar *);
static void fragment_toggle(GtkWidget *w, gchar *);
static void intf_toggle(GtkWidget *w, gpointer data);
static void protocol_toggle(GtkWidget *w, gpointer data);
static void port_toggle(GtkWidget *w, gchar *data);
static void address_toggle(GtkWidget *w, gchar *data);
static void toggle_port_button(GtkWidget *,gint,gint,GdkEventButton*,gboolean);
static void select_port_window(GtkWidget *, PortIdx);
static void select_port(GtkWidget *, PortIdx);
static gint select_port_event(GtkWidget *, GdkEvent *, PortIdx);
static void option_menu_proto(GtkWidget *, gint, gint);
static void option_menu_tosxor(GtkWidget *, gint, gint);
static void option_menu_rule(GtkWidget *, gint, gint);

static GtkWidget *redirect_label;
static GtkWidget *icmp_menu;
GtkWidget *edit_win = NULL;
GtkWidget *port_win = NULL;

guint8 tspace;
GdkPixmap *tpixmap;
GdkBitmap *tmask;

void popup_rule_edit(GtkWidget *widget, RuleAction action)
{
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	GtkWidget *vbox, *hbox, *hsep;
	GtkWidget *table, *bottom, *child;
	GtkWidget *label, *button;
	GtkWidget *submenu, *menu_item;
	gint i, index, map=0;
	const gchar *edit_label[] = {
		"Source:",
		"Destination:",
		"",
		"Protocol:",
		"Interface:",
		"Tos:",
		"Target:",
		NULL,
	};
	#include "Pics/expand.xpm"
	
	if(page < 0)
		return;
	fwentry.action = (gint)action;
	index = GTK_CLIST(fwchain[page].rulelist)->focus_row;
	
	if(edit_win)
		gtk_widget_destroy(edit_win);
	edit_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(edit_win, 450, 440);
	gtk_window_set_position(GTK_WINDOW(edit_win), GTK_WIN_POS_CENTER);
	gtk_signal_connect(GTK_OBJECT(edit_win), "destroy",
			GTK_SIGNAL_FUNC(edit_win_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(edit_win), "delete_event",
			GTK_SIGNAL_FUNC(edit_win_destroy), NULL);
	gtk_window_set_title(GTK_WINDOW(edit_win), "Edit Rule");
	gtk_container_set_border_width(GTK_CONTAINER(edit_win), 10);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_widget_show(vbox);
	gtk_container_add(GTK_CONTAINER(edit_win), vbox);
	
	table = gtk_table_new(14, 2, FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), table, TRUE, TRUE, 0);
	gtk_table_set_col_spacing(GTK_TABLE(table), 0, 8);
	gtk_widget_show(table);
	
	for(i=0; edit_label[i]; i++) {
		gtk_table_set_row_spacing(GTK_TABLE(table), i, 8);
		child = gtk_alignment_new(1,1,0,1);
		gtk_widget_show(child);
		gtk_table_attach_defaults(GTK_TABLE(table), child, 0,1,i,i+1);
		label = gtk_label_new(edit_label[i]);
		gtk_widget_show(label);
		gtk_container_add(GTK_CONTAINER(child), label);
	}
	/***********************************/
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	fwentry.invsrc = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(address_toggle), "SRC");
	fwentry.src = gfcc_entry_new(hbox, 0, 120, -1, NULL);
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
			GTK_SIGNAL_FUNC(select_host_window), fwentry.src);

	label = gfcc_label_new(hbox, " Port: ");
	fwentry.invspts = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(port_toggle), "SRC");
	fwentry.spts[0] = gfcc_entry_new(hbox, 0, 45, -1, "0");
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
		GTK_SIGNAL_FUNC(select_port_window), (PortIdx *)PORTSMIN);

	label = gfcc_label_new(hbox, "-");
	fwentry.spts[1] = gfcc_entry_new(hbox, 0, 45, -1, "65535");
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
			GTK_SIGNAL_FUNC(select_port_window),
			(PortIdx *)PORTSMAX);
	/**********************************/

	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	fwentry.invdst = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(address_toggle), "DST");
	fwentry.dst = gfcc_entry_new(hbox, 0, 120, -1, NULL);
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
		GTK_SIGNAL_FUNC(select_host_window), fwentry.dst);

	label = gfcc_label_new(hbox, " Port: ");
	fwentry.invdpts = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(port_toggle), "DST");
	fwentry.dpts[0] = gfcc_entry_new(hbox, 0, 45, -1, "0");
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
		GTK_SIGNAL_FUNC(select_port_window), (PortIdx *)PORTDMIN);

	label = gfcc_label_new(hbox, "-");
	fwentry.dpts[1] = gfcc_entry_new(hbox, 0, 45, -1, "65535");
	button = gfcc_pixmap_button_new(hbox, expand, 14, -1,
		GTK_SIGNAL_FUNC(select_port_window), (PortIdx *)PORTDMAX);
	/***********************************/

	hsep = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), hsep, 0,2,map,map+1);
	map++;
	gtk_widget_show(hsep);
	/*****************************************/
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	fwentry.invproto = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(protocol_toggle), NULL);
	option_menu_proto(hbox, page, index);

	icmp_menu = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(hbox), icmp_menu, FALSE, FALSE, 0);
	submenu = gtk_menu_new();
	for(i=0; icmp_codes[i].name; i++) {
		menu_item = append_submenu_item(
			submenu, GTK_SIGNAL_FUNC(set_icmp_type),
			icmp_codes[i].name);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(icmp_menu), submenu);
	if(!strcmp(fwentry.proto, "icmp"))
		gtk_widget_show(icmp_menu);
	/*****************************************/

	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	fwentry.invvia = gfcc_toggle_new(hbox,
				GTK_SIGNAL_FUNC(intf_toggle), NULL);
	fwentry.via = gfcc_entry_new(hbox, IFNAMSIZ-1, 100, -1, NULL);

	/**********************************/

	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	option_menu_tosxor(hbox, page, index);

	/**********************************/
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), hbox, 1,2,map,map+1);
	map++;
	gtk_widget_show(hbox);

	option_menu_rule(hbox, page, index);
	redirect_label = gfcc_label_new(hbox, " Port: ");
	gtk_widget_hide(redirect_label);
	fwentry.redirpt = gfcc_entry_new(hbox, 10, 45, -1, NULL);
	gtk_widget_hide(fwentry.redirpt);

	/*********************************/

	hsep = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(table), hsep, 0,2,map,map+1);
	map++;
	gtk_widget_show(hsep);
	
	/**********************************/
	
	bottom = gtk_table_new(7,2, FALSE);
	gtk_table_attach_defaults(GTK_TABLE(table), bottom, 1,2,map,map+1);
	map++;
	gtk_widget_show(bottom);
	
	fwentry.syn = gtk_check_button_new_with_label("SYN");
	gtk_table_attach(GTK_TABLE(bottom),
			fwentry.syn, 0,1,0,1,GTK_FILL,0,0,0);
	gtk_signal_connect(GTK_OBJECT(fwentry.syn), "toggled",
			GTK_SIGNAL_FUNC(syn_toggle), "0");
	gtk_widget_show(fwentry.syn);

	fwentry.invsyn = gtk_check_button_new_with_label("Inverse SYN");
	gtk_table_attach(GTK_TABLE(bottom),
			fwentry.invsyn, 1,2,0,1,GTK_FILL,0,0,0);
	gtk_signal_connect(GTK_OBJECT(fwentry.invsyn), "toggled",
			GTK_SIGNAL_FUNC(syn_toggle), "1");
	gtk_widget_show(fwentry.invsyn);

	fwentry.fragment = gtk_check_button_new_with_label("Fragment");
	gtk_table_attach(GTK_TABLE(bottom),
			fwentry.fragment, 0,1,1,2,GTK_FILL,0,0,0);
	gtk_signal_connect(GTK_OBJECT(fwentry.fragment), "toggled",
			GTK_SIGNAL_FUNC(fragment_toggle), "0");
	gtk_widget_show(fwentry.fragment);

	fwentry.invfragment =
		gtk_check_button_new_with_label("Inverse Fragment");
	gtk_table_attach(GTK_TABLE(bottom),
				fwentry.invfragment, 1,2,1,2,GTK_FILL,0,0,0);
	gtk_signal_connect(GTK_OBJECT(fwentry.invfragment), "toggled",
			GTK_SIGNAL_FUNC(fragment_toggle), "1");
	gtk_widget_show(fwentry.invfragment);
	
	/*********************************/
	gtk_table_set_row_spacing(GTK_TABLE(bottom), 2, 10);
	/*********************************/
	
	fwentry.fw_mark = gtk_check_button_new_with_label("Firewall mark");
	gtk_table_attach(GTK_TABLE(bottom),
			fwentry.fw_mark, 0,1,3,4,GTK_FILL,0,0,0);
	gtk_widget_show(fwentry.fw_mark);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach(GTK_TABLE(bottom), hbox, 1,2,3,4,GTK_FILL,0,0,0);
	gtk_widget_show(hbox);

	fwentry.fw_mark_val = gfcc_entry_new(hbox, 7, 60, -1, NULL);

	/*********************************/
	
	fwentry.fw_netlink=gtk_check_button_new_with_label("Firewall netlink");
	gtk_table_attach(GTK_TABLE(bottom),
				fwentry.fw_netlink, 0,1,4,5,GTK_FILL,0,0,0);
	gtk_widget_show(fwentry.fw_netlink);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_table_attach(GTK_TABLE(bottom), hbox, 1,2,4,5,GTK_FILL,0,0,0);
	gtk_widget_show(hbox);

	fwentry.fw_outputsize = gfcc_entry_new(hbox, 7, 60, -1, NULL);

	/********************************/
	gtk_table_set_row_spacing(GTK_TABLE(bottom), 5, 10);
	/*********************************/

	fwentry.log = gtk_check_button_new_with_label(
				"Kernel logging for this packet");
	gtk_table_attach(GTK_TABLE(bottom),
			fwentry.log, 0,2,6,7,GTK_FILL,0,0,0);
	gtk_widget_show(fwentry.log);

	/********************************/

	hsep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), hsep, TRUE, TRUE, 1);
	gtk_widget_show(hsep);
	
	/********************************/
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_box_pack_end(GTK_BOX(vbox), hbox, FALSE, TRUE, 1);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 7);
	gtk_widget_show(hbox);

	button = gtk_button_new_with_label("OK");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(check_input_value), (gpointer)&fwentry);
	gtk_widget_show(button);
	button = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(edit_win_destroy), NULL);
	gtk_widget_show(button);

	gtk_widget_show(edit_win);
	
	if(fwentry.action == EDIT)
		put_rule_data();
}

static void edit_win_destroy(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(edit_win);
	edit_win = NULL;
}

static void set_protocol_value(GtkWidget *widget, gpointer data)
{
	if(!strcmp(data, "all")) {
		if(GTK_TOGGLE_BUTTON(fwentry.invproto)->active) {
			gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invproto), FALSE);
		}
	}
	if(!strcmp(data, "icmp"))
		gtk_widget_show(icmp_menu);
	else
		gtk_widget_hide(icmp_menu);

	strcpy(fwentry.proto, data);
}

static void set_icmp_type(GtkWidget *widget, gpointer data)
{
	gint i;
	
	for(i=0; icmp_codes[i].name; i++) {
		if(!strcmp(data, icmp_codes[i].name))
			break;
	}
	if(!icmp_codes[i].name)
		return;
	if(!strcmp(icmp_codes[i].name, "Select icmp-type"))
		return;

	gtk_entry_set_text(GTK_ENTRY(fwentry.spts[0]), icmp_codes[i].type);
	if(!strcmp(icmp_codes[i].name, "all"))
		gtk_entry_set_text(GTK_ENTRY(fwentry.spts[1]), "65535");
	else
		gtk_entry_set_text(
			GTK_ENTRY(fwentry.spts[1]), icmp_codes[i].type);
	gtk_entry_set_text(GTK_ENTRY(fwentry.dpts[0]), icmp_codes[i].code_min);
	gtk_entry_set_text(GTK_ENTRY(fwentry.dpts[1]), icmp_codes[i].code_max);

	return;
}

static void set_rule_data(GtkWidget *widget, gpointer data)
{
	if(!strcmp(data, IP_FW_LABEL_REDIRECT)) {
		gtk_widget_show(redirect_label);
		gtk_widget_show(fwentry.redirpt);
	} else {
		gtk_widget_hide(redirect_label);
		gtk_widget_hide(fwentry.redirpt);
	}
	strcpy(fwentry.target, data);
}

static void set_tosxor_data(GtkWidget *widget, gpointer data)
{
	strcpy(fwentry.tosxor, data);
}

void popup_rule_copy(GtkWidget *widget, gchar *data)
{
	GList *selection;
	gint i, index, row;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *content[NUMCOLS];
	guint8	spacing[6];
	GdkPixmap *pixmap[6];
	GdkBitmap *mask[6];
	GtkCList *tlist;
	
	if(page < 0)
		return;
	tlist = GTK_CLIST(fwchain[page].rulelist);
	if((selection = tlist->selection) == NULL)
		return;

	while(selection) {
		index = GPOINTER_TO_INT(selection->data);
		for(i=0; i<6; i++)
			gtk_clist_get_pixtext(tlist, index, i, &content[i],
				&spacing[i], &pixmap[i], &mask[i]);
		for(; i<NUMCOLS; i++)
			gtk_clist_get_text(tlist, index, i, &content[i]);

		row = gtk_clist_append(GTK_CLIST(cliplist), content);
		for(i=0; i<6; i++) {
			gtk_clist_set_pixtext(GTK_CLIST(cliplist), row, i,
				content[i], spacing[i], pixmap[i], mask[i]);
		}

		selection = selection->next;
	}
	gtk_clist_unselect_all(tlist);
	
	modified = 1;
}

void popup_rule_paste(GtkWidget *widget, gchar *data)
{
	GList *selection;
	gint i, j, row;
	gint current;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *content[NUMCOLS];
	guint8	spacing[6];
	GdkPixmap *pixmap[6];
	GdkBitmap *mask[6];
	GtkCList *tlist;
	
	if(page < 0)
		return;
	tlist = GTK_CLIST(fwchain[page].rulelist);
	if((selection = tlist->selection) == NULL)
		current = FALSE;
	else
		current = GPOINTER_TO_INT(selection->data);

	for(i=0; i<GTK_CLIST(cliplist)->rows; i++) {
		for(j=0; j<6; j++)
			gtk_clist_get_pixtext(GTK_CLIST(cliplist), i, j,
				&content[j], &spacing[j], &pixmap[j], &mask[j]);
		for(; j<NUMCOLS; j++)
			gtk_clist_get_text(GTK_CLIST(cliplist),i,j,&content[j]);

		if(current) {
			row = gtk_clist_insert(tlist, current++, content);
		} else
			row = gtk_clist_append(tlist, content);

		for(j=0; j<6; j++) {
			gtk_clist_set_pixtext(tlist, row, j,
				content[j], spacing[j], pixmap[j], mask[j]);
		}
	}
	gtk_clist_clear(GTK_CLIST(cliplist));
}

void popup_rule_cut(GtkWidget *widget, gchar *data)
{
	GList *selection;
	gint i, index, row;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *content[NUMCOLS];
	guint8	spacing[6];
	GdkPixmap *pixmap[6];
	GdkBitmap *mask[6];
	GtkCList *tlist;
	
	if(page < 0)
		return;
	tlist = GTK_CLIST(fwchain[page].rulelist);
	if((selection = tlist->selection) == NULL)
		return;

	while(1) {
		index = GPOINTER_TO_INT(selection->data);
		for(i=0; i<6; i++)
			gtk_clist_get_pixtext(tlist, index, i, &content[i],
				&spacing[i], &pixmap[i], &mask[i]);
		for(; i<NUMCOLS; i++)
			gtk_clist_get_text(tlist, index, i, &content[i]);

		row = gtk_clist_append(GTK_CLIST(cliplist), content);
		for(i=0; i<6; i++) {
			gtk_clist_set_pixtext(GTK_CLIST(cliplist), row, i,
				content[i], spacing[i], pixmap[i], mask[i]);
		}

		if(!selection->next)
			break;
		selection = selection->next;
	}
	while(selection) {
		index = GPOINTER_TO_INT(selection->data);
		gtk_clist_remove(tlist, index);
		selection = selection->prev;
	}
	
	modified = 1;
}

void popup_rule_delete(GtkWidget *widget, gpointer action)
{
	GList *selection;
	gint index;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	
	if(page < 0)
		return;
	if((selection = GTK_CLIST(fwchain[page].rulelist)->selection) == NULL)
		return;
	
	while(selection->next)
		selection = selection->next;
	while(selection) {
		index = GPOINTER_TO_INT(selection->data);
		gtk_clist_remove(GTK_CLIST(fwchain[page].rulelist), index);
		selection = selection->prev;
	}
	
	modified = 1;
}

void popup_rule_duplicate(GtkWidget *widget, gpointer action)
{
	GList *selection;
	gint index;
	gint i, row;
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *content[NUMCOLS];
	guint8	spacing[6];
	GdkPixmap *pixmap[6];
	GdkBitmap *mask[6];
	GtkCList *tlist;
	
	if(page < 0)
		return;
	if((selection = GTK_CLIST(fwchain[page].rulelist)->selection) == NULL)
		return;
	
	tlist = GTK_CLIST(fwchain[page].rulelist);
	index = GPOINTER_TO_INT(selection->data);
	for(i=0; i<6; i++)
		gtk_clist_get_pixtext(tlist, index, i, &content[i],
			&spacing[i], &pixmap[i], &mask[i]);
	for(; i<NUMCOLS; i++) {
		gtk_clist_get_text(tlist, index,i,&content[i]);
	}

	row = gtk_clist_insert(tlist, index, content);
	for(i=0; i<6; i++) {
		gtk_clist_set_pixtext(tlist, row, i,
			content[i], spacing[i], pixmap[i], mask[i]);
	}
	
	modified = 1;
}

static void syn_toggle(GtkWidget *w, gchar *data)
{
	if(GTK_TOGGLE_BUTTON(w)->active) {
		if(GTK_TOGGLE_BUTTON(fwentry.invproto)->active) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
			dialog_window("Inverse Protocol not Permitted", NULL);
			return;
		}
		if(strcmp(fwentry.proto, "tcp")) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
			dialog_window("Only allowed with TCP protocol", NULL);
			return;
		}
		if(*data == '0') {
			if(GTK_TOGGLE_BUTTON(fwentry.fragment)->active) {
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
				dialog_window(
					"Syn not allowed with Fragment", NULL);
			} else {
				gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(fwentry.invsyn),
					FALSE);
			}
		} else
			gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.syn), FALSE);
	}
}

static void fragment_toggle(GtkWidget *w, gchar *data)
{
	gchar *text;
	
	if(!GTK_TOGGLE_BUTTON(w)->active)
		return;
	text = gtk_entry_get_text(GTK_ENTRY(fwentry.spts[0]));
	if(*text && strcmp(text, "0"))
		goto ERROR;
	text = gtk_entry_get_text(GTK_ENTRY(fwentry.spts[1]));
	if(*text && strcmp(text, "65535"))
		goto ERROR;
	text = gtk_entry_get_text(GTK_ENTRY(fwentry.dpts[0]));
	if(*text && strcmp(text, "0"))
		goto ERROR;
	text = gtk_entry_get_text(GTK_ENTRY(fwentry.dpts[1]));
	if(*text && strcmp(text, "65535"))
		goto ERROR;
	
	
	if(*data == '0') {
		if(GTK_TOGGLE_BUTTON(fwentry.syn)->active) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
			dialog_window("Fragment not allowed with Syn", NULL);
		} else {
			gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invfragment), FALSE);
		}
	} else
		gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON(fwentry.fragment), FALSE);

	return;
ERROR:
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), FALSE);
	dialog_window("No ports allowed", NULL);
}

static void intf_toggle(GtkWidget *w, gpointer data)
{
	gchar *text;

	if(GTK_TOGGLE_BUTTON(w)->active) {
		text = gtk_entry_get_text(GTK_ENTRY(fwentry.via));
		if(!*text) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
			dialog_window("Via name is NULL", NULL);
		}
	}
}

static void protocol_toggle(GtkWidget *w, gpointer data)
{
	if(GTK_TOGGLE_BUTTON(w)->active) {
		if(!strcmp(fwentry.proto, "all")) {
			gtk_toggle_button_set_active(
					GTK_TOGGLE_BUTTON(w), FALSE);
			dialog_window("Specify the Protocol first", NULL);
		}
	}
}

static void port_toggle(GtkWidget *w, gchar *data)
{
	gchar *pmin, *pmax;
	
	if(!GTK_TOGGLE_BUTTON(w)->active)
		return;
	
	if(!strcmp(data, "SRC")) {
		pmin = gtk_entry_get_text(GTK_ENTRY(fwentry.spts[0]));
		pmax = gtk_entry_get_text(GTK_ENTRY(fwentry.spts[1]));
	} else {
		pmin = gtk_entry_get_text(GTK_ENTRY(fwentry.dpts[0]));
		pmax = gtk_entry_get_text(GTK_ENTRY(fwentry.dpts[1]));
	}
	
	if(*pmin == '0' && !strcmp(pmax, "65535")) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), FALSE);
		dialog_window("Port value must be specified", NULL);
	}
}

static void address_toggle(GtkWidget *w, gchar *data)
{
	gchar *text;
	
	if(!GTK_TOGGLE_BUTTON(w)->active)
		return;

	if(!strcmp(data, "SRC"))
		text = gtk_entry_get_text(GTK_ENTRY(fwentry.src));
	else
		text = gtk_entry_get_text(GTK_ENTRY(fwentry.dst));
	
	if(!strcmp(text, "0.0.0.0/0") ||
	   !strcmp(text, "Any")) {
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), FALSE);
		dialog_window("Address value must be specified", NULL);
	}
}

static void put_rule_data(void)
{
	gint page = gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook));
	gchar *text;
	gint index;
	GtkCList *tlist;
	__u16 fw_flg, fw_invflg;

	if(page < 0)
		return;
	tlist = GTK_CLIST(fwchain[page].rulelist);
	index = tlist->focus_row;

	gtk_clist_get_pixtext(tlist,index,0,&text, &tspace,&tpixmap,&tmask);
	gtk_entry_set_text(GTK_ENTRY(fwentry.src), text);

	gtk_clist_get_text(tlist, index, 9, &text);
	gtk_entry_set_text(GTK_ENTRY(fwentry.spts[0]), text);
	gtk_clist_get_text(tlist, index, 10, &text);
	gtk_entry_set_text(GTK_ENTRY(fwentry.spts[1]), text);

	gtk_clist_get_pixtext(tlist,index,2,&text, &tspace,&tpixmap,&tmask);
	gtk_entry_set_text(GTK_ENTRY(fwentry.dst), text);

	gtk_clist_get_text(tlist, index, 11, &text);
	gtk_entry_set_text(GTK_ENTRY(fwentry.dpts[0]), text);
	gtk_clist_get_text(tlist, index, 12, &text);
	gtk_entry_set_text(GTK_ENTRY(fwentry.dpts[1]), text);

	gtk_clist_get_pixtext(tlist,index,5,&text, &tspace,&tpixmap,&tmask);
	if(*text)
		gtk_entry_set_text(GTK_ENTRY(fwentry.via), text);
	
	gtk_clist_get_text(tlist, index, 13, &text);
	fw_flg = (__u16)atoi(text);
	
	gtk_clist_get_text(tlist,index,14,&text);
	fw_invflg = (__u16)atoi(text);
	
	if(fw_invflg & IP_FW_INV_SRCIP)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invsrc), TRUE);
	if(fw_invflg & IP_FW_INV_DSTIP)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invdst), TRUE);
	if(fw_invflg & IP_FW_INV_PROTO)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invproto), TRUE);
	if(fw_invflg & IP_FW_INV_SRCPT)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invspts), TRUE);
	if(fw_invflg & IP_FW_INV_DSTPT)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invdpts), TRUE);
	if(fw_invflg & IP_FW_INV_VIA)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invvia), TRUE);
	/*********************/
	if(fw_invflg & IP_FW_INV_SYN) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invsyn), TRUE);
	} else if(fw_flg & IP_FW_F_TCPSYN) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.syn), TRUE);
	}
	if(fw_invflg & IP_FW_INV_FRAG) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.invfragment), TRUE);
	} else if(fw_flg & IP_FW_F_FRAG) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.fragment), TRUE);
	}
	/*********************/
	
	gtk_clist_get_text(tlist, index, 6, &text);
	if(!strcmp(text, IP_FW_LABEL_REDIRECT)) {
		gtk_widget_show(redirect_label);
		gtk_widget_show(fwentry.redirpt);
	}
	gtk_clist_get_text(tlist, index, 15, &text);
	if(strcmp(text, "0"))
		gtk_entry_set_text(GTK_ENTRY(fwentry.redirpt), text);

	if(fw_flg & IP_FW_F_PRN)
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.log), TRUE);
	if(fw_flg & IP_FW_F_MARKABS) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.fw_mark), TRUE);
		gtk_clist_get_text(tlist, index, 16, &text);
		if(strcmp(text, "0"))
			gtk_entry_set_text(
				GTK_ENTRY(fwentry.fw_mark_val), text);
	}
	if(fw_flg & IP_FW_F_NETLINK) {
		gtk_toggle_button_set_active(
				GTK_TOGGLE_BUTTON(fwentry.fw_netlink), TRUE);
		gtk_clist_get_text(tlist, index, 17, &text);
		if(strcmp(text, "0"))
			gtk_entry_set_text(
				GTK_ENTRY(fwentry.fw_outputsize), text);
	}
}

GtkWidget *portlist = NULL;
GtkWidget *port_ok_button;

static void toggle_port_button(GtkWidget *widget, gint row, gint column,
		GdkEventButton *event, gboolean flag)
{
	gtk_widget_set_sensitive(port_ok_button, flag);
}

static void select_port_window(GtkWidget *widget, PortIdx idx)
{
	GtkWidget *vbox, *hbox;
	GtkWidget *scrolled_window;
	GtkWidget *button;
	gchar *content[1];
	struct _menu *tservice;
	
	if(!strcmp(fwentry.proto, "tcp"))
		tservice = service_tcp;
	else if(!strcmp(fwentry.proto, "udp"))
		tservice = service_udp;
	else {
		dialog_window("Only TCP or UDP protocol allowed\n", NULL);
		return;
	}

	if(port_win)
		gtk_widget_destroy(port_win);
	port_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_usize(port_win, 150, 300);
	gtk_window_set_position(GTK_WINDOW(port_win), GTK_WIN_POS_CENTER);
	gtk_window_set_title(GTK_WINDOW(port_win), "Select port");
	gtk_container_set_border_width(GTK_CONTAINER(port_win), 10);
	gtk_signal_connect(GTK_OBJECT(port_win), "destroy",
			GTK_SIGNAL_FUNC(port_win_destroy), NULL);
	gtk_signal_connect(GTK_OBJECT(port_win), "delete_event",
			GTK_SIGNAL_FUNC(port_win_destroy), NULL);
	
	vbox = gtk_vbox_new(FALSE, 1);
	gtk_container_add(GTK_CONTAINER(port_win), vbox);
	gtk_widget_show(vbox);

	scrolled_window = gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(scrolled_window, -1, -1);
	gtk_scrolled_window_set_policy(
			GTK_SCROLLED_WINDOW(scrolled_window),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(vbox), scrolled_window);
	gtk_widget_show(scrolled_window);

	portlist = gtk_clist_new(1);
	gtk_container_add(GTK_CONTAINER(scrolled_window), portlist);
	gtk_signal_connect(GTK_OBJECT(portlist), "event",
			GTK_SIGNAL_FUNC(select_port_event), (PortIdx *)idx);
	gtk_signal_connect(GTK_OBJECT(portlist), "select_row",
			GTK_SIGNAL_FUNC(toggle_port_button), (gpointer)TRUE);
	gtk_signal_connect(GTK_OBJECT(portlist), "unselect_row",
			GTK_SIGNAL_FUNC(toggle_port_button), (gpointer)FALSE);
	content[0] = "0";
	gtk_clist_append(GTK_CLIST(portlist), content);
	content[0] = "65535";
	gtk_clist_append(GTK_CLIST(portlist), content);
	for(; tservice; tservice = tservice->next) {
		content[0] = g_strdup(tservice->label);
		gtk_clist_append(GTK_CLIST(portlist), content);
		g_free(content[0]);
	}
	gtk_clist_sort(GTK_CLIST(portlist));
	gtk_widget_show(portlist);
	
	hbox = gtk_hbox_new(FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_widget_show(hbox);
	
	port_ok_button = gtk_button_new_with_label(" OK ");
	gtk_box_pack_start(GTK_BOX(hbox), port_ok_button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(port_ok_button), "clicked",
			GTK_SIGNAL_FUNC(select_port), (PortIdx *)idx);
	gtk_widget_show(port_ok_button);
	gtk_widget_set_sensitive(port_ok_button, FALSE);

	button = gtk_button_new_with_label("Cancel");
	gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, TRUE, 1);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(port_win_destroy), NULL);
	gtk_widget_show(button);

	gtk_widget_show(port_win);
}

static void port_win_destroy(GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(port_win);
	port_win = NULL;
}

static void select_port(GtkWidget *widget, PortIdx idx)
{
	gchar *text;
	GtkEntry *entry = NULL, *entry2=NULL;

	gtk_clist_get_text(GTK_CLIST(portlist),
			GTK_CLIST(portlist)->focus_row, 0, &text);
	switch(idx) {
	case PORTSMIN:
		entry = GTK_ENTRY(fwentry.spts[0]);
		entry2 = GTK_ENTRY(fwentry.spts[1]);
		break;
	case PORTSMAX:
		entry = GTK_ENTRY(fwentry.spts[1]);
		break;
	case PORTDMIN:
		entry = GTK_ENTRY(fwentry.dpts[0]);
		entry2 = GTK_ENTRY(fwentry.dpts[1]);
		break;
	case PORTDMAX:
		entry = GTK_ENTRY(fwentry.dpts[1]);
		break;
	default: break;
	}
	if(entry)
		gtk_entry_set_text(entry, text);
	if(entry2) {
		if(!strcmp(text, "0"))
			gtk_entry_set_text(entry2, "65535");
		else
			gtk_entry_set_text(entry2, text);
	}
	gtk_widget_destroy(port_win);
	port_win = NULL;
}

static gint select_port_event(GtkWidget *widget, GdkEvent *event, PortIdx idx)
{
	if(!event)
		return FALSE;

	switch(event->type) {
	case GDK_2BUTTON_PRESS:
		switch(event->button.button) {
		case 1:
			select_port(widget, idx);
			return TRUE;
		default: break;
		}
		break;
	default: break;
	}
	return FALSE;
}

static void option_menu_proto(GtkWidget *hbox, gint page, gint index)
{
	GtkWidget *option_menu, *submenu, *menu_item;
	struct _menu *tmp;
	gchar *text;

	option_menu = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);
	
	submenu = gtk_menu_new();
	
	if(proto_name)
		strcpy(fwentry.proto, proto_name->label);
	if(fwentry.action == EDIT) {
		gtk_clist_get_pixtext(GTK_CLIST(fwchain[page].rulelist),
			index, 4, &text, &tspace, &tpixmap, &tmask);
		strcpy(fwentry.proto, text);
		if(*text) {
			menu_item = append_submenu_item(submenu,
				GTK_SIGNAL_FUNC(set_protocol_value), text);
		}
	}
	for(tmp = proto_name; tmp; tmp = tmp->next) {
		if(fwentry.action == EDIT &&
		   !strcmp(fwentry.proto, tmp->label))
			continue;
		menu_item = append_submenu_item(
			submenu, GTK_SIGNAL_FUNC(set_protocol_value),
			tmp->label);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), submenu);
}

static void option_menu_tosxor(GtkWidget *hbox, gint page, gint index)
{
	GtkWidget *option_menu, *submenu, *menu_item;
	gchar *text;
	gint i;
	__u8 Tosxor;

	option_menu = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);
	
	submenu = gtk_menu_new();
	
	strcpy(fwentry.tosxor, tos_name[0].label);
	if(fwentry.action == EDIT) {
		gtk_clist_get_text(
			GTK_CLIST(fwchain[page].rulelist), index, 8, &text);
		Tosxor = (__u8)int_from_hex(text);
		tosxor_itos(fwentry.tosxor, Tosxor);
		menu_item = append_submenu_item(submenu,
			GTK_SIGNAL_FUNC(set_tosxor_data), fwentry.tosxor);
	}
	for(i=0; tos_name[i].label; i++) {
		if(fwentry.action == EDIT &&
		   !strcmp(fwentry.tosxor, tos_name[i].label))
			continue;
		menu_item = append_submenu_item(submenu,
			GTK_SIGNAL_FUNC(set_tosxor_data), tos_name[i].label);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), submenu);
}

static void option_menu_rule(GtkWidget *hbox, gint page, gint index)
{
	GtkWidget *option_menu, *submenu, *menu_item;
	gint i;
	gchar *text;

	option_menu = gtk_option_menu_new();
	gtk_box_pack_start(GTK_BOX(hbox), option_menu, FALSE, FALSE, 0);
	gtk_widget_show(option_menu);
	
	submenu = gtk_menu_new();
	strcpy(fwentry.target, target_name[0].label);
	if(fwentry.action == EDIT) {
		gtk_clist_get_text(GTK_CLIST(fwchain[page].rulelist),
				index, 6, &text);
		strcpy(fwentry.target, text);
		if(*text) {
			menu_item = append_submenu_item(submenu,
				GTK_SIGNAL_FUNC(set_rule_data), text);
		}
	}
	for(i=0; target_name[i].label; i++) {
		if(fwentry.action == EDIT &&
		   !strcmp(text, target_name[i].label))
			continue;
		if(!strcmp(target_name[i].label, IP_FW_LABEL_MASQUERADE) &&
			strcmp(fwchain[page].label, IP_FW_LABEL_FORWARD))
			continue;
		if(!strcmp(target_name[i].label, IP_FW_LABEL_REDIRECT) &&
			strcmp(fwchain[page].label, IP_FW_LABEL_INPUT))
			continue;
		menu_item = append_submenu_item(submenu,
			GTK_SIGNAL_FUNC(set_rule_data), target_name[i].label);
	}
	for(i=3; fwchain[i].label[0]; i++) {
		if(i == page)
			continue;
		if(fwentry.action == EDIT &&
		   !strcmp(text, fwchain[i].label))
			continue;
		menu_item = append_submenu_item(submenu,
			GTK_SIGNAL_FUNC(set_rule_data), fwchain[i].label);
	}
	gtk_option_menu_set_menu(GTK_OPTION_MENU(option_menu), submenu);
}
