.\" @(#)$RCSfile: gfal_set_ids.man,v $ $Revision: 1.4 $ $Date: 2009/04/16 15:42:49 $ CERN Remi Mollon
.\" Copyright (C) 2007 by CERN
.\" All rights reserved
.\"
.TH GFAL_SET_IDS 3 "$Date: 2009/04/16 15:42:49 $" GFAL "Library Functions"
.SH NAME
gfal_set_ids \- Sets the SRM file/request ids in the 'gfal_internal' object
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_set_ids (gfal_internal " gfal ,
.BI "int " nbfileids ,
.BI "int *" srm_fileids ,
.BI "int " srm_reqid ,
.BI "char *" srmv2_reqtoken ,
.BI "char *" errbuf ,
.BI "int " errbufsz );
.SH DESCRIPTION
.B gfal_set_ids
Sets the SRM file/request ids (or request token for SRMv2) in the
.B gfal_internal
object.

These values can be retrieve with the function 
.BR gfal_get_ids (3).

.TP
.I gfal
.B gfal_internal
object generated from user parameters.
.TP
.I srm_reqid
The request id returned by a SRMv1 SE.
.TP
.I srm_fileids
The table of file ids returned by a SRMv1 SE.
.TP
.I srmv2_reqtoken
The request token returned by a SRMv2 SE.
.TP
.I errbuf
allocated 
.B char *
pointer in which a detailed error message may be stored.
.TP
.I errbufsz
size allocated ofr the pointer 
.I errbuf

.SH RETURN VALUE
This routine returns 0 on a success, or -1 in case of error. In the latter case,
.B errno
is set appropriately. Moreover, you can get an error message from
.I errbuf
, if specified.
.SH ERRORS
.B errno
indicates the type of error, but for detailled error message, you have to look into
.IR errbuf .
.TP 1.3i
.B EINVAL
One or more parameter in 
.I req
have a wrong value.

.SH SEE ALSO
.BR gfal (3),
.BR gfal_request_new (3),
.BR gfal_internal_free (3),
.BR gfal_init (3),
.BR gfal_deletesurls (3),
.BR gfal_removedir (3),
.BR gfal_turlsfromsurls (3),
.BR gfal_ls (3),
.BR gfal_get (3),
.BR gfal_getstatus (3),
.BR gfal_prestage (3),
.BR gfal_prestagestatus (3),
.BR gfal_pin (3),
.BR gfal_release (3),
.BR gfal_abortrequest (3),
.BR gfal_abortfiles (3),
.BR gfal_set_xfer_done (3),
.BR gfal_set_xfer_running (3),
.BR gfal_get_ids (3),
.BR gfal_set_ids (3),
.BR gfal_get_results (3),
