/*
** 1998-09-30 -	Header file for the progress reporting module. Pretty simple.
*/

typedef enum { PGS_CANCEL, PGS_PROCEED } PgsRes;

#define	PFLG_COUNT_RECURSIVE	(1<<0)	/* Count # of items recursively? */
#define	PFLG_ITEM_VISIBLE	(1<<1)	/* Display progress for individual items? */
#define	PFLG_BYTE_VISIBLE	(1<<2)	/* Display total byte progress? */
#define	PFLG_BUSY_MODE		(1<<10)	/* Just indicate "busyness", no direct filesystem coupling. */

/* ----------------------------------------------------------------------------------------- */

/* Call this to set up an operation, which is assumed to consist of doing
** something to a bunch of items.
*/
void	pgs_progress_begin(MainInfo *min, const gchar *op_name, guint32 flags);

/* Use these three calls to report the progress of each item. */
void	pgs_progress_item_begin(MainInfo *min, const gchar *name, gsize size);
PgsRes	pgs_progress_item_update(MainInfo *min, gsize pos);
void	pgs_progress_item_end(MainInfo *min);

/* Call this when the operation as a whole is completed. */
void	pgs_progress_end(MainInfo *min);
