/****************************************************************************
** eh.h
**
** Michael S. Borella <mike@borella.net>
**
** Class definition generic error handler
**
*****************************************************************************/

#ifndef EH_H
#define EH_H

#include <string>

// types of dispositions
enum eh_disp_t
{
  EH_DISP_HALT,      // print msg then terminate
  EH_DISP_CONTINUE,  // print msg then continue where we left off
  EH_DISP_IGNORE,    // do nothing, just return
  EH_DISP_CALLBACK   // pass the msg to a callback function
};

#define EH_LOCATION __FILE__,__LINE__

//---------------------------------------------------------------------------
//
// class EH
//
//---------------------------------------------------------------------------

class EH
{
protected:
  static eh_disp_t _disposition;
  static void      (*_callback)(string);

  // determines what to do based on disposition
  void action(string, string, int);

public:
  // Constructor, destructor
  EH(string);
  EH(string, string, int); // for passing __FILE__ and __LINE__
  EH() {} // for inherited classes, we don't need to do anything
  ~EH(){}
  
  // disposition functions
  static eh_disp_t disposition()            { return _disposition; }
  static void      disposition(eh_disp_t d) { _disposition = d; }
  
  // callback function
  static void      callback(void (*f)(string)) { _callback = f; }
};

#endif


