/**********************************************************************
** This program is part of the kinetics library and is
**           copyright (C) 1995 Upinder S. Bhalla.
** It is made available under the terms of the
**           GNU Library General Public License. 
** See the file COPYRIGHT for the full notice.
**********************************************************************/
static char rcsid[] = "$Id: reac.c,v 1.4 2000/06/12 05:07:03 mhucka Exp $";
 
/*
** $Log: reac.c,v $
** Revision 1.4  2000/06/12 05:07:03  mhucka
** Removed nested comments; added NOTREACHED comments where appropriate.
**
** Revision 1.3  1998/07/21 19:49:11  dhb
** Fixed ANSI C isms.
**
 * Revision 1.2  1998/07/15 06:45:33  dhb
 * Upi update
 *
 * Revision 1.1  1997/07/24 17:49:40  dhb
 * Initial revision
 *
 * Revision 1.2  1994/08/05  19:24:43  bhalla
 * Minor changes due to conversion to using n rather than conc
 *
 * Revision 1.1  1994/06/13  22:55:39  bhalla
 * Initial revision
 * */

#include "kin_ext.h"

/*
** A reaction handling element. does the basic forward/backward
** rate const management, must be used in conjunction with pools.
** Can handle any number of substrate or product components, but
** the reaction is only a single stage
*/

#ifdef __STDC__
static int do_oldmsgmode(struct reac_type *reac);
static int check_msg_type(struct reac_type *reac, MsgIn *msg);
#else
static int do_oldmsgmode();
static int check_msg_type();
#endif


ReacFunc(reac,action)
register struct reac_type *reac;
Action		*action;
{
MsgIn	*msg;
double	substrate_prd;
double	product_prd;
double	dt;
double **data;
int j;

    if(debug > 1){
		ActionHeader("ReactionPool",reac,action);
    }

    SELECT_ACTION(action){
		case INIT:
			break;
    	case PROCESS:
				substrate_prd = reac->kf;
				product_prd = reac->kb;
				if (reac->oldmsgmode)
					return do_oldmsgmode(reac);

				data = reac->msgdata;
           		/* TYPE = SUBSTRATE. */
				for (j = 0; j < reac->msgcount[0]; j++, data++)
					substrate_prd *= **data;
           		/* TYPE = PRODUCT. */
				for (j = 0; j < reac->msgcount[1]; j++, data++)
					product_prd *= **data;

				reac->A = product_prd;
				reac->B = substrate_prd;
			break;
    	case RESET: {
				double *tempdata[200];
				data = tempdata;
				reac->msgcount[0] = reac->msgcount[1] = 0;
        		MSGLOOP(reac,msg) {
						case 0: /* TYPE = SUBSTRATE */
							*data++ = (double*)(MSGPTR(msg,0));
							reac->msgcount[0]++;
							break;
						default:
							check_msg_type(reac,msg);
						break;
				}
        		MSGLOOP(reac,msg) {
						case 1: /* TYPE = PRODUCT */
							*data++ = (double*)(MSGPTR(msg,0));
							reac->msgcount[1]++;
							break;
				}
				j = reac->msgcount[0] + reac->msgcount[1];
		        reac->msgdata = alloc_msgdata(j, tempdata);


        		MSGLOOP(reac,msg) {
						case 0:
							break;
						case 1:
							break;
						case 2:		/* TYPE = KF */
									/* msg 0 = kf */
							reac->kf = MSGVALUE(msg,0);
						break;
						case 3:		/* TYPE = KB */
									/* msg 0 = kb */
							reac->kb = MSGVALUE(msg,0);
						break;
        		}
			}
        	break;
    	case SET :
        	return(0); /* do the normal set */
		/* NOTREACHED */
			break;
		case CREATE:
			reac->oldmsgmode = 0;
			break;
	}
}

#ifdef __STDC__
static int do_oldmsgmode(struct reac_type *reac) {
#else
static int do_oldmsgmode(reac)
struct reac_type *reac;
{
#endif
	MsgIn	*msg;
	double	substrate_prd = reac->kf;
	double	product_prd = reac->kb;
   	MSGLOOP(reac,msg) {
   		case 0:		/* TYPE = SUBSTRATE. */
			/* msg 0 = # of sub. Used to be Co */
			substrate_prd *= MSGVALUE(msg,0);
   		break;
		case 1:		/* TYPE = PRODUCT */
				/* msg 0 = # of prd. Used to be Co */
			product_prd *= MSGVALUE(msg,0);
		break;
		case 2:		/* TYPE = KF */
					/* msg 0 = kf */
			reac->kf = MSGVALUE(msg,0);
		break;
		case 3:		/* TYPE = KB */
					/* msg 0 = kb */
			reac->kb = MSGVALUE(msg,0);
		break;
   	}
	reac->A = product_prd;
	reac->B = substrate_prd;
	return 1;
}

#ifdef __STDC__
static int check_msg_type(struct reac_type *reac, MsgIn *msg) { 
#else
static int check_msg_type(reac, msg)
struct reac_type *reac;
MsgIn *msg;
{ 
#endif
    if (MSGSLOT(msg)[0].func != DoubleMessageData) {
        Warning();
        /* Complain */
        printf("Message source for REAC msg to %s is not a double\n",
        Pathname(reac));
        printf("Reverting to slow old messaging\n");
        reac->oldmsgmode = 1;
    }
}

