static char rcsid[] = "$Id: concpool.c,v 1.2 1997/05/28 21:23:50 dhb Exp $";

/*
** $Log: concpool.c,v $
** Revision 1.2  1997/05/28 21:23:50  dhb
** Added RCS id and log headers
**
*/

/* Version EDS20k 95/09/27, Erik De Schutter, BBF-UIA 9/95-9/95 */

#include "conc_ext.h"
/* A 'well-mixed' concentration pool without diffusion.  Has better
**  controls over size/volume than Ca_concen and does not include
**  any equilibratrion mechanism */

ConcPool(pool,action)
register Cpool *pool;
Action		*action;
{
double		A,B;		/* integrate dC/dt= A - B*C */
double		Cj,Dfl,Dif,dt,r1,r2;
MsgIn		*msg;
double		savedata[2];
int			n0,n1;

    if(debug > 1){
	ActionHeader("concpool",pool,action);
    }

    SELECT_ACTION(action){
    case INIT:
	pool->prev_C = pool->C;
	break;

    case PROCESS:
	dt = Clockrate(pool);
	A = pool->leak;
	B = 0.0;
	/* Read the msgs.  */
	MSGLOOP(pool,msg){
	    case STOREINFLUX:	/* influx into store */
				/* 0 = flux */
			/* d[C]/dt = flux/Vol */
			A += MSGVALUE(msg,0)/pool->vol;
			break;
	    case STOREOUTFLUX:	/* outflux out store */
				/* 0 = flux */
			/* d[C]/dt = flux/Vol */
			A -= MSGVALUE(msg,0)/pool->vol;
			break;
	    case TAUPUMP:	/* interaction with tau pump having its own Ceq */
				/* 0 = kPump */
				/* 1 = Ceq */
			/* dC/dt = -kPump*(C-Ceq) */
			/* F = kPump */
			Dif = MSGVALUE(msg,0);
			A += Dif*MSGVALUE(msg,1);
			B += Dif;
			break;
	    case EQTAUPUMP:	/* interaction with tau pump having same Ceq */
				/* 0 = kPump */
			/* dC/dt = -kPump*(C-Ceq) */
			/* Dif = kPump */
			Dif = MSGVALUE(msg,0);
			A += Dif*pool->Ceq;
			B += Dif;
			break;
	}
	
	/* Integrate to get the net pool concentration */ 
	pool->C = IntegrateMethod(pool->object->method,pool,pool->C,A,B,dt,"C");
	break;

    case RESET:
	pool->prev_C = pool->C = pool->Ceq;
	/* no break! */

    case RECALC:
	if (pool->shape_mode==SHELL) {
		r1=pool->dia/2.0;
		r2=r1 - pool->thick;
		if (r2<0.0) r2=0.0;
		if (pool->len>0.0) {	/* cylindrical */
			pool->vol=(r1*r1-r2*r2)*pool->len*PI;
		} else {				/* spherical */
			pool->vol=4.0/3.0*(r1*r1*r1-r2*r2*r2)*PI;
		}
	} else if (pool->shape_mode==SLAB) {
		r1=pool->dia/2.0;
		pool->vol=r1*r1*pool->thick*PI;
	}
	if (pool->vol<UTINY){
			ErrorMessage("concpool", "Invalid vol.", pool);
	}
	break;

    case CHECK:
	/* minimum concentration */
	if(pool->Ceq < 0.0){
	    ErrorMessage("concpool", "Invalid Ceq.", pool);
	}
	/* diffusion constant */
	MSGLOOP(pool,msg){
	    case TAUPUMP:		/* pump */
			if((MSGVALUE(msg,0) <= 0.0)||(MSGVALUE(msg,1) < 0.0)){
				ErrorMessage("concpool","Incoming pump data invalid.",pool);
			}
			break;
	    case EQTAUPUMP:	/* pump */
			if (MSGVALUE(msg,0) <= 0.0){
				ErrorMessage("concpool","Incoming pump data invalid.",pool);
			}
			break;
	}
	/* check dimensions */
	/* length */
	if(pool->len < 0.0){
		ErrorMessage("concpool", "Invalid len.", pool);
	}
	if (pool->shape_mode<USERDEF) {
		/* thickness */
		if(pool->thick <= 0.0){
			ErrorMessage("concpool", "Invalid thick.", pool);
		}
		/* diameter */
		if(pool->dia <= 0.0){
			ErrorMessage("concpool", "Invalid dia.", pool);
		}
	} else {
		/* volume */
		if(pool->vol <= 0.0){
			ErrorMessage("concpool", "Invalid vol.", pool);
		}
	}
	break;

    case SAVE2:
	savedata[0] = pool->C;
	savedata[1] = pool->prev_C;
	/* action->data contains the file pointer */
	n0=2;
	fwrite(&n0,sizeof(int),1,(FILE*)action->data);
	fwrite(savedata,sizeof(double),n0,(FILE*)action->data);
	break;

    case RESTORE2:
	/* action->data contains the file pointer */
	fread(&n0,sizeof(int),1,(FILE*)action->data);
	if (n0!=2) ErrorMessage("concpool", "Invalid savedata length.",pool);
	fread(savedata,sizeof(double),2,(FILE*)action->data);
	pool->C = savedata[0];
	pool->prev_C = savedata[1];
	break;
    }
}
