static char rcsid[] = "$Id: hines_conn.c,v 1.1 1997/05/28 23:11:50 dhb Exp $";

/* Version EDS21d 97/01/28, Erik De Schutter, BBF-UIA 6/94-1/97 */

/*
** $Log: hines_conn.c,v $
** Revision 1.1  1997/05/28 23:11:50  dhb
** Initial revision
**
*/

#include "hines_ext.h"

/* Contains routines that setup and execute interaction with the newconn
** objects. */
/* Not the most efficient way of handling things, as events are still
** send from the original spikegen to the original synchan instead of 
** hsolve to hsolve.
*/

/* execute Spikegen event */
h_dospike_event(hsolve)
	Hsolve  *hsolve;
{
	Element *spike;
	MsgOut  *mo;

	spike=hsolve->spikegen;
	MSGOUTLOOP(spike,mo) {
		CallEventAction(spike, mo);
	}
}

/* synapse fires: call synchan element, get weight and update counter */
/* this code is very inefficient! Should improve when synchan gets
*  completely incorporated */
h_dosynchan(hsolve,stabindex,cindex)
	Hsolve  *hsolve;
	int	stabindex,cindex;
{
	Action  *action;
	Element	*child;
	S2chan	*s2chan;
	int		nop,nchip;
	SynapticEventPtr next_event;

	child=hsolve->children[cindex];
	action = GetAction("HPROCESS");
	CallElement(child,action,0);
	nchip=hsolve->childchips[cindex];
	nop=hsolve->childops[cindex];
	if (hsolve->ops[nop+1]==SYN3_OP) nchip++;	/* skip frequency */
	s2chan=(S2chan *)child;
	hsolve->chip[nchip]+=s2chan->activation*hsolve->stablist[stabindex+3];
	next_event=s2chan->PendingSynapticEvents;
	if (next_event) {
		hsolve->ops[nop+2]=next_event->time;
	} else {
		hsolve->ops[nop+2]=-1;	/* no next firing time */
	}
}

/* implements event transmission to hines solvers */
int h_eventaction(src,dst,index,time)

Element *src,*dst;
int	index;
int	time;

{
    Action  action;

	action.name = "HSEVENT";
	action.type = HSEVENT;
	action.data = (char *)src;
	action.argc = index;
	action.argv = (char**) &time;

	return CallActionFunc(dst, &action);
} 

