/*
Copyright (C) 2001 by Brock Robert Reynolds 

brock@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#ifndef _RDF_H
#define _RDF_H

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "gdis.h"

#define MAX_RDF_POINTS 500
#define MIN_RDF_POINTS 50

#define COUNT_CLOSEST_SECONDARY 0
#define COUNT_ALL_SECONDARY 1

#define CALCULATE_RDF 0
#define CALCULATE_PAIRS 1

#define RDF_ALL_ATOMS 0
#define RDF_TWO_ELEMENTS 1
#define RDF_SELECTED_ATOMS 2

#define OUTPUT_ASCII 0
#define OUTPUT_GRACE 1

#define ELEMENT_MAX 120

/* Atom coordinates data pak... */
struct rdf_coords_pak
{
  gdouble x;
  gdouble y;
  gdouble z;
};

/* Frame data pak... */
struct rdf_frame_pak
{
  gint atom_count[2];
  struct rdf_coords_pak *firstatom;
  struct rdf_coords_pak *secondatom;
};

/* RDF data pak... */
struct rdf_pak
{
  gint frames_count;
  gint frame_atoms[2];
  gint atom_element[2];
  gint atom_total[2];
  struct rdf_frame_pak *frame;
};

/* Interface functions... */
void create_rdfwindow(void);
void on_atom1select_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_atom2select_toggled (GtkToggleButton *togglebutton, gpointer user_data);
void on_atom3select_toggled (GtkToggleButton *togglebutton, gpointer user_data);

/* Queing system interface function... */
void init_rdf_task(void);

/* Main process loop */
void exec_rdf_task(gpointer *ptr);

/* Memory allocation / deallocation / scrubbing functions... */
struct rdf_pak *rdf_init(gint num_frames);
gint rdf_cleanup(struct rdf_pak *rdf);
gint rdf_add_frame(struct rdf_pak *rdf, gint frames_total);
gint rdf_add_coords(struct rdf_frame_pak *frame, gint atom);

/* Data sorting / retrieval functions... */
gint rdf_frame_atoms(struct model_pak *model, gint atom_select, gint atom_element);
gint get_rdf_data(struct rdf_pak *rdf, struct model_pak *model, gint atom_select);

/* Calculation functions... */
gint distances_atoms(struct rdf_pak *rdf, struct model_pak *model, gint *distances, gint hist_points, gdouble scale, gint count_method);
gint distances_elements(struct rdf_pak *rdf, struct model_pak *model, gint *distances, gint hist_points, gdouble scale, gint count_method);
gint smooth_data(gdouble *plotdata, gint hist_points);

#endif
