#include "config.h"
#ifdef GTK_GL
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <gdk/gdk.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <gtkgl/gtkglarea.h>

#include "gdis.h"

/* externals */
extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

/* convert from gdis pixel offset to OpenGL cartesian Angs */
/* FIXME - replace this hack using gluUnProject */
#define PIX2ANG 0.03

/* NEW - all rendering parameters are handled by the same dialog */
/* as serves the povray rendering */

/*******************/
/* configure event */
/*******************/
gint gl_configure_event(GtkWidget *w, GdkEventConfigure *event)
{
gint i;
struct model_pak *data;

/* perspective change? */
if (gtk_gl_area_make_current(GTK_GL_AREA(w)))
  {
  glViewport(0,0, w->allocation.width, w->allocation.height);
  glClearColor(0,0,0,1); 
  }
else
  {
  printf("configure_event() error: failed to make current.\n");
  return(FALSE);
  }

/* update coords */
for (i=0 ; i<sysenv.num_displayed ; i++)
  {
  data = model_ptr(sysenv.displayed[i], RECALL);
  if (data)
    init_objs(REDO_COORDS, data);
  }

/* redraw screen frames & models */
opengl_draw(w);

return TRUE;
}

/*****************/
/* expose event */
/****************/
gint gl_expose_event(GtkWidget *w, GdkEventExpose *event)
{
/* swap backbuffer to front */
gtk_gl_area_swapbuffers(GTK_GL_AREA(w));

return TRUE;
}

/*******************************************/
/* set opengl RGB colour for gdis RGB data */
/*******************************************/
void set_gl_colour(gint *rgb)
{
gfloat col[3];

col[0] = (gfloat) *rgb;
col[1] = (gfloat) *(rgb+1);
col[2] = (gfloat) *(rgb+2);
VEC3MUL(col, 1.0/65535.0);
glColor3f(col[0], col[1], col[2]);
}

/******************************************/
/* draw a cylinder between points v1 & v2 */
/******************************************/
void draw_cylinder(gfloat *v1, gfloat *v2, gfloat rad, gint segments)
{
gint i;
gfloat theta, st, ct;
gfloat v[3], v12[3], p[3], q[3];

/* vector from v2 to v1 */
ARR3SET(v12, v1);
ARR3SUB(v12, v2);

/* create vectors p and q, co-planar with the cylinder's cross-sectional disk */
ARR3SET(p, v12);
if (v12[0] == 0.0 && v12[2] == 0.0)
  v12[0] += 1.0;
else
  v12[2] += 1.0;
crossprod(q, p, v12);
crossprod(p, v12, q);
normalize(p, 3);
normalize(q, 3);

/* build the cylinder from rectangular segments */
glBegin(GL_QUAD_STRIP);
for (i=0 ; i<=segments ; i++) 
  {
/* sweep out a circle */
  theta = (gfloat) i * 2.0 * PI / (gfloat) segments;
  st = tbl_sin(theta);
  ct = tbl_cos(theta);
/* construct normal */
  v12[0] = ct * p[0] + st * q[0];
  v12[1] = ct * p[1] + st * q[1];
  v12[2] = ct * p[2] + st * q[2];
  normalize(v12, 3);
/* point on disk 1 */
  ARR3SET(v, v2);
  v[0] += rad*v12[0];
  v[1] += rad*v12[1];
  v[2] += rad*v12[2];
  glNormal3fv(v12);
  glVertex3fv(v);

/* point on disk 2 */
  ARR3SET(v, v1);
  v[0] += rad*v12[0];
  v[1] += rad*v12[1];
  v[2] += rad*v12[2];
  glNormal3fv(v12);
  glVertex3fv(v);
  }
glEnd();
}

/********************/
/* printing routine */
/********************/
/* NB: assumes we're viewing in Ortho2D mode */
void gl_print(gint x, gint y, gchar *str)
{
gint i, n;

n = strlen(str);

/* the use of 3 coords allows us to put text above everything else */
glRasterPos3i(x,y,1); 

for (i=0 ; i<n ; i++)
  glutBitmapCharacter(GLUT_BITMAP_HELVETICA_12, *str++);
}


/********************************/
/* OpenGL atom location routine */
/********************************/
#define DEBUG_GL_SEEK_ATOM 1
GLint viewport[4];
GLdouble mvmatrix[16], projmatrix[16];
/* NB: should always return -1 if no atom was found */
/* TODO - return a list (may be more than one atom?) */
gint gl_seek_atom(gint x, gint y, struct model_pak *data)
{
gint i;
GLint realy;
GLdouble wx, wy, wz;
gfloat dx, dy, d2;

if (!gtk_gl_area_make_current(GTK_GL_AREA(sysenv.glarea))) 
  return(-1);


realy = viewport[3] - y - 1;
gluUnProject(x, realy, 0.0, mvmatrix, projmatrix, viewport, &wx, &wy, &wz);

printf("World coords: %f %f %f\n", wx, wy, wz);

for (i=data->num_atoms ; i-- ;)
  {
printf("%s : %f %f \n", (data->atoms+i)->label, (data->atoms+i)->rx, (data->atoms+i)->ry);
  dx = (data->atoms+i)->rx - wx;
  dy = (data->atoms+i)->ry - wy;
  d2 = dx*dx + dy*dy;
  if (d2 < 0.01)
    return(i);
  }

return(-1);
}

/*****************************/
/* the model drawing routine */
/*****************************/
#define DEBUG_OPENGL_DRAW 0
void opengl_draw(GtkWidget *glarea)
{
gint a, b, c, i, j, k, l, n, bc;
gint px1, py1, px2, py2, cpk_flag, flag;
gfloat r, rad;
gfloat v1[3], v2[3], v3[3], x[3], y[3], z[3], norm[3];
gfloat mat[9];
gfloat cam[3] = {0.0, -1.0, 0.0};
gfloat upv[3] = {0.0, 0.0, 1.0};
float light0[4] = { 1.0, -1.0, -1.0, 0.0 };
float light1[4] = { 0.0,  1.0,  1.0, 0.0 };
/* why does this cause an inc in brightness for periodic img creation */
/* because we have more atoms reflecting light -> brighter image */
/* TODO - scale the light vectors with the number of periodic images/atoms */
float specular[4] = { 0.50, 0.50, 0.50, 0.0 };
float diffuse[4] = { 0.50, 0.50, 0.50, 0.0 };
float amb[4] = { 0.1, 0.1, 0.1, 1.0 };
float gl_colour[4];
gchar *mode_label, facet_label[10];
struct model_pak *data=NULL;
struct plane_pak *plane;
GSList *bond, *plist;
GLUquadricObj *quad=NULL;

/* is there anything to draw on? */
if (!gtk_gl_area_make_current(GTK_GL_AREA(glarea))) 
  {
  printf("opengl_draw() failed to make glarea current.\n");
  return;
  }

#ifdef TIMER
start_timer("opengl_draw");
#endif

/* init */
if (!quad)
  quad = gluNewQuadric();

glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

/* only draw the active model */
data = model_ptr(sysenv.active, RECALL);
if (!data)
  {
  gtk_gl_area_swapbuffers(GTK_GL_AREA(glarea));
  return;
  }

/* subwindow width/height? (+ translation offset 4 each) */
r = RMAX_FUDGE * data->rmax;

/* viewing */
glMatrixMode(GL_MODELVIEW);
glLoadIdentity();
/* get the model axes transformation matrix */
init_rotmat(mat);
/* transform camera position & up vector */
vecmat(mat, cam);
vecmat(mat, upv);

/* NEW - scaling affects placement to avoid near/far clipping */
/* move camera back */
cam[2] = -(sysenv.render.vp_dist+1.0*data->scale)*r;

gluLookAt(cam[0],cam[1],cam[2],0.0,0.0,0.0,upv[0],upv[1],upv[2]);

/* projection */
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
/* perspective proj */
/* NEW - scaling affects projection to avoid near/far clipping */
glFrustum(-r,r,-r,r,sysenv.render.vp_dist*r,(sysenv.render.vp_dist+2.0*data->scale)*r);





glGetIntegerv(GL_VIEWPORT, viewport);
glGetDoublev(GL_MODELVIEW_MATRIX, mvmatrix);
glGetDoublev(GL_PROJECTION_MATRIX, projmatrix);







/* NEW - light properties */
VEC3SET(amb, sysenv.render.ambience 
           , sysenv.render.ambience 
           , sysenv.render.ambience);
VEC3SET(diffuse, sysenv.render.diffuse 
               , sysenv.render.diffuse 
               , sysenv.render.diffuse);
/* FIXME - this component doesn't seem to do a lot (fault of the material?) */
VEC3SET(specular, sysenv.render.specular 
                , sysenv.render.specular 
                , sysenv.render.specular);

/* DIRECTIONAL lighting - translation shouldn't darken a model */
glLightfv(GL_LIGHT0, GL_POSITION, light0);
glLightfv(GL_LIGHT1, GL_POSITION, light1);
/* low values for these gives 'expected' gdis colour */
glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
glLightfv(GL_LIGHT0, GL_AMBIENT, amb);
glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);
glLightfv(GL_LIGHT1, GL_SPECULAR, specular);
glLightfv(GL_LIGHT1, GL_AMBIENT, amb);

/* NEW - set default, a previous morphology draw may have changed this */
glFrontFace(GL_CCW);

glEnable(GL_LIGHTING);
glEnable(GL_LIGHT0);
glEnable(GL_DEPTH_TEST);
glEnable(GL_CULL_FACE);
glShadeModel(GL_SMOOTH);
/* setup colour-only change for spheres */
glEnable(GL_COLOR_MATERIAL);
/*
glColorMaterial(GL_FRONT, GL_AMBIENT);
glColor3f(0.2,0.2,0.2);
*/
glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
glPolygonMode(GL_FRONT, GL_FILL);
/* display lists for improved performance */
switch(sysenv.render.type)
  {
/* display list for CPK (ie sphere for each unique vdw rad) */
  case CPK:
    construct_unique(data);
    for (i=0 ; i<data->num_unique ; i++)
      {
      rad = sysenv.render.cpk_scale * data->scale 
            * elements[*(data->unique+i)].vdw;
      glNewList(*(data->unique+i), GL_COMPILE);
      gluSphere(quad, rad, 15, 15);
      glEndList();
      }
    break;
/* display list for ball & stick */
  case BALL_STICK:
    glNewList(BALL_STICK, GL_COMPILE);
      gluSphere(quad, data->scale * sysenv.render.ball_rad, 15, 15);
    glEndList();
    break;
  }

/* loop over atoms */
for (n=data->num_atoms ; n-- ; )
  {
/* deleted/hidden */
  if ((data->atoms+n)->status & (DELETED | HIDDEN))
    continue;

  cpk_flag=0;
  switch (sysenv.render.type)
    {
/* B&S & CPK use the same drawing code, but a different sphere radius */
    case BALL_STICK:
      cpk_flag= -1;
    case CPK:
      cpk_flag++;
/* get pixel coordinates */
      VEC3SET(v1, (data->atoms+n)->rx, (data->atoms+n)->ry, (data->atoms+n)->rz);
/* translate */
      VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
/*
      VEC3MUL(v1, data->scale/r);
*/
      VEC3MUL(v1, data->scale);

/* colour */
      if ((data->atoms+n)->status & (SQUARE_HL | SELECT_HL))
        {
        VEC3SET(gl_colour, 1.0, 1.0, 0.0);
        gl_colour[3] = 1.0;
        }
      else
        {
        ARR3SET(gl_colour, (data->atoms+n)->colour);
        VEC3MUL(gl_colour, 1.0/65535.0);
        gl_colour[3] = 1.0;
        }
      glColor3fv(gl_colour);
/* save & translate to location */
      glPushMatrix();

/* FIXME - why are these negative signs necessary??? */
      glTranslatef(v1[0],-v1[1],-v1[2]);

/* set appropriate radius */
      if (cpk_flag)
        {
        glCallList((data->atoms+n)->atom_code);
        }
      else
        {
        glCallList(BALL_STICK);
        }
      glPopMatrix();
      break;
    }
  }

/*******************/
/* loop over bonds */
/*******************/
/* setup for bond drawing */
glLineWidth(0.1);
switch(sysenv.render.type)
  {
  case STICK:
    glDisable(GL_COLOR_MATERIAL);
    glDisable(GL_LIGHTING);
    glLineWidth(sysenv.render.line_thickness);
  case BALL_STICK:
    bc=0;
/* only draw is stick - TODO - also B&S */
    bond = data->bonds; 
    while(bond != NULL)
      {
      bc++;
/* the two atoms */
      i = ((struct bond_pak *) bond->data)->atom1;
      j = ((struct bond_pak *) bond->data)->atom2;
/* deleted/hidden */
      if ((data->atoms+i)->status & DELETED)
        continue;
      if ((data->atoms+j)->status & DELETED)
        continue;
/* get pixel coordinates */
      VEC3SET(v1, (data->atoms+i)->rx, (data->atoms+i)->ry, (data->atoms+i)->rz);
      VEC3SET(v2, (data->atoms+j)->rx, (data->atoms+j)->ry, (data->atoms+j)->rz);
/* bond midpoint */
      ARR3SET(v3, v1);
      ARR3ADD(v3, v2);
      VEC3MUL(v3, 0.5);
/* translation via offset */
      VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
      VEC2ADD(v2, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
      VEC2ADD(v3, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
/* scale */
      VEC3MUL(v1, data->scale);
      VEC3MUL(v2, data->scale);
      VEC3MUL(v3, data->scale);
/* half */
    if (!((data->atoms+i)->status & HIDDEN))
      {
      set_gl_colour((data->atoms+i)->colour);
      if (sysenv.render.type == STICK)
        {
        glBegin(GL_LINE_LOOP);
        glVertex3fv(v1);
        glVertex3fv(v3);
        glEnd();
        }
      else
        draw_cylinder(v1, v3, data->scale*sysenv.render.stick_rad, 9);
      }
/* half */
    if (!((data->atoms+j)->status & HIDDEN))
      {
      set_gl_colour((data->atoms+j)->colour);
      if (sysenv.render.type == STICK)
        {
        glBegin(GL_LINE_LOOP);
        glVertex3fv(v2);
        glVertex3fv(v3);
        glEnd();
        }
      else
        draw_cylinder(v3, v2, data->scale*sysenv.render.stick_rad, 9);
      }
/* next bond */
    bond = g_slist_next(bond);
    }
  default:
/* CPK - no bonds */
    break;
  }

/* back to lit stuff */
glEnable(GL_LIGHTING);
glEnable(GL_COLOR_MATERIAL);

/* morphology drawing */
glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
glColor3fv(sysenv.render.morph_colour);
/*
glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
glDisable(GL_CULL_FACE);
glDisable(GL_LIGHTING);
glLineWidth(2.0);
*/

if (data->num_vertices)
  {
  plist = data->planes;
  while (plist != NULL)
    {
    plane = (struct plane_pak *) plist->data;
    if (plane->present && plane->visible)
      {
#if DEBUG_OPENGL_DRAW
printf("Drawing: %f %f %f ", plane->m[0], plane->m[1], plane->m[2]);
#endif

/* surface normal */
      ARR3SET(norm, plane->norm);
      vecmat(data->rotmat, norm);
      normalize(norm, 3);
/* get first vertex */
      c = a = *(plane->points+0);
      v1[0] = (data->vertices+a)->rx;
      v1[1] = (data->vertices+a)->ry;
      v1[2] = (data->vertices+a)->rz;
      VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
      VEC3MUL(v1, data->scale);
/* get next adj */
      b = c;
      for (i=0 ; i<(data->vertices+a)->num_adj ; i++)
        for (j=0 ; j<plane->num_points ; j++)
          if (*((data->vertices+a)->adj+i) == *(plane->points+j))
            {
            b = *(plane->points+j);
            goto init_next;
            }
printf("Error: (init) bad adjacency list.\n");
init_next:;
      v2[0] = (data->vertices+b)->rx;
      v2[1] = (data->vertices+b)->ry;
      v2[2] = (data->vertices+b)->rz;
      VEC2ADD(v2, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
      VEC3MUL(v2, data->scale);

/* use adjacency list to traverse the face */
      flag=0;
      for (;;)
        {
/* get next adj that was not the previous */
        for (i=0 ; i<(data->vertices+b)->num_adj ; i++)
          for (j=0 ; j<plane->num_points ; j++)
            if (*((data->vertices+b)->adj+i) == *(plane->points+j) &&
                                                *(plane->points+j) != a)
              {
/* new becomes old */
              a = b; 
/* get a new new */
              b = *(plane->points+j);
              goto found_next;
              }
printf("Error: bad adjacency list.\n");
break;
found_next:;
        if (b == c)
           break;

        v3[0] = (data->vertices+b)->rx;
        v3[1] = (data->vertices+b)->ry;
        v3[2] = (data->vertices+b)->rz;
        VEC2ADD(v3, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
        VEC3MUL(v3, data->scale);

        if (flag)
          {
/* plot current */
          glNormal3fv(norm);
          glVertex3fv(v3);
          ARR3ADD(v1, v3);
          flag++;
          }
        else
          {
/* cross product to get vertex adjacency direction */
          ARR3SET(x, v2);
          ARR3SUB(x, v1);
          ARR3SET(y, v3);
          ARR3SUB(y, v1);
          crossprod(z, x, y);
/* set normal sense accordingly */
          if (via(z, v2, 3) > PI/2.0)
            glFrontFace(GL_CW);
          else
            glFrontFace(GL_CCW);
/* only now do we start the drawing loop */
/* NB: this MUST go after the glFrontFace calls */
          glBegin(GL_POLYGON);
/* wire frame draw */
/*
glDisable(GL_LIGHTING);
glLineWidth(2.0);
glBegin(GL_LINE_LOOP);
*/
/* plot first three */
          glNormal3fv(norm);
          glVertex3fv(v1);
          glNormal3fv(norm);
          glVertex3fv(v2);
          glNormal3fv(norm);
          glVertex3fv(v3);
/* sum, for later midpoint computation */
          ARR3ADD(v1, v2);
          ARR3ADD(v1, v3);
          flag+=3;
          }
        }
#if DEBUG_OPENGL_DRAW
printf(" # vertices: %d\n", flag);
#endif
      glEnd();

/* label */
      if (data->morph_label)
        {
        VEC3MUL(v1, 1.0/(gfloat) flag);
/* TODO - facet labelling */




        }
      }
    plist = g_slist_next(plist);
    }
  }

/* 2D molecular surface */
if (data->csurf_on)
  {
  glEnable(GL_LIGHT1);
/* ensure the underside is correctly lit */
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE);
/* disable - so the back of the surface still shows up */
  glDisable(GL_CULL_FACE);

/* NEW cope with lattice matrix with reflections */
  if (det(data->latmat) < 0.0)
    glFrontFace(GL_CW);

  glDisable(GL_LINE_SMOOTH);
  glDisable(GL_POINT_SMOOTH);
  glDisable(GL_BLEND);

/* set back face colour once for all the triangles */
  glColorMaterial(GL_BACK, GL_DIFFUSE);
  glColor3f(0.2,0.2,0.7);

/* setup for front face colour changing */
  glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);

/* filled surface, or wire frame? */
  if (sysenv.render.wire_csurf)
    {
    glLineWidth(sysenv.render.line_thickness);
    glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
    }
  else
    glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

/* periodic image loops */
  for (a=-data->image_limit[0] ; a<data->image_limit[1] ; a++)
    {
    for (b=-data->image_limit[2] ; b<data->image_limit[3] ; b++)
      {
      for (c=-data->image_limit[4] ; c<data->image_limit[5] ; c++)
        {
        if (!data->periodic)
          if (a || b || c)
            continue;
/* form the translation vector */
        ARR3SET(&mat[0], &data->piv_real[0]);
        ARR3SET(&mat[3], &data->piv_real[3]);
        ARR3SET(&mat[6], &data->piv_real[6]);
        VEC3SET(v3, a, b, c);
        vecmat(mat,v3);
/* grid loop */
        for (j=0 ; j<data->csurf.grid-1 ; j++)
          {
          glBegin(GL_TRIANGLE_STRIP);
          for (i=0 ; i<data->csurf.grid ; i++)
            {
/* Point 1 */
/* NB: the order of point 1 & 2 indicates the front facing orientation */
/* convenience index */
            n = (j)*data->csurf.grid+i;
/* get atom touched (if any) */
            k = *(data->csurf.touch+n); 
/* set colour according to atom touched */
            if (k < 0)
              {
              if (sysenv.depth < 16)
                glColor3f(1.0,1.0,0.0);  /* YELLOW */
              else
                glColor3f(1.0,0.0,1.0);  /* PURPLE */
              }
            else
              set_gl_colour(elements[*(data->csurf.code+n)].colour);
/* don't draw true holes */
            if (k == HOLE)
              glColor3f(0.0,0.0,0.0);
/* surface normal */
            v2[0] = *(data->csurf.n[0]+n);
            v2[1] = *(data->csurf.n[1]+n);
            v2[2] = *(data->csurf.n[2]+n);
            glNormal3fv(v2);
/* triangle vertex */
            v1[0] = *(data->csurf.rx+n);
            v1[1] = *(data->csurf.ry+n);
            v1[2] = *(data->csurf.rz+n);
            ARR3ADD(v1,v3);
            VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
            VEC3MUL(v1, data->scale);
            glVertex3fv(v1);
/* Point 2 */
/* NB: the order of point 1 & 2 indicates the front facing orientation */
/* convenience index */
            n = (j+1)*data->csurf.grid+i;
/* get atom touched (if any) */
            k = *(data->csurf.touch+n); 
/* set colour according to atom touched */
            if (k < 0)
              {
              if (sysenv.depth < 16)
                glColor3f(1.0,1.0,0.0);  /* YELLOW */
              else
                glColor3f(1.0,0.0,1.0);  /* PURPLE */
              }
            else
              set_gl_colour(elements[*(data->csurf.code+n)].colour);
/* don't draw true holes */
            if (k == HOLE)
              glColor3f(0.0,0.0,0.0);
/* surface normal */
            v2[0] = *(data->csurf.n[0]+n);
            v2[1] = *(data->csurf.n[1]+n);
            v2[2] = *(data->csurf.n[2]+n);
            glNormal3fv(v2);
/* triangle vertex */
            v1[0] = *(data->csurf.rx+n);
            v1[1] = *(data->csurf.ry+n);
            v1[2] = *(data->csurf.rz+n);
            ARR3ADD(v1,v3);
            VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
            VEC3MUL(v1, data->scale);
            glVertex3fv(v1);
            }
          glEnd();
          }
        }
      }
    }

/* done surface */
  glLightModeli(GL_LIGHT_MODEL_TWO_SIDE, GL_FALSE);
  glDisable(GL_COLOR_MATERIAL);
  glDisable(GL_LIGHTING);
  glEnable(GL_CULL_FACE);

/* revert */
  if (det(data->latmat) < 0.0)
    glFrontFace(GL_CCW);
  }

/* plain line drawing */
/* init */
glEnable(GL_LINE_SMOOTH);
glEnable(GL_POINT_SMOOTH);
glEnable(GL_BLEND);
glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
glDisable(GL_COLOR_MATERIAL);
glDisable(GL_LIGHTING);
glLineWidth(sysenv.render.line_thickness);
/* loop over isolated atoms */
if (sysenv.render.type == STICK)
  {
  for (n=data->num_atoms ; n-- ; )
    {
    if ((data->atoms+n)->atom_bonds)
      continue;
/* deleted/hidden */
    if ((data->atoms+n)->status & (DELETED | HIDDEN))
      continue;
/* get pixel coordinates */
    VEC3SET(v1, (data->atoms+n)->rx, (data->atoms+n)->ry, (data->atoms+n)->rz);
    VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
    VEC3MUL(v1, data->scale);
    set_gl_colour((data->atoms+n)->colour);
/* cross - vertic'l part */
    glBegin(GL_LINE_LOOP);
/* offset units here are effectively angstroms */
    glVertex3f(v1[0], v1[1]-5*PIX2ANG, v1[2]);
    glVertex3f(v1[0], v1[1]+5*PIX2ANG, v1[2]);
    glEnd();
/* cross - horiz'l part */
    glBegin(GL_LINE_LOOP);
/* offset units here are effectively angstroms */
    glVertex3f(v1[0]-5*PIX2ANG, v1[1], v1[2]);
    glVertex3f(v1[0]+5*PIX2ANG, v1[1], v1[2]);
    glEnd();
    }
  }

/* AXES */
if (data->axes_on)
  {
/* TODO */
  }

/* CELL */
if (data->cell_on)
  {
  glLineWidth(sysenv.render.frame_thickness);
  glColor3f(1.0, 1.0, 1.0);
/* draw the opposite ends of the frame */
  for(k=8 ; k-- ; )
    {
/* part 1 */
    i = 2*(k/2) + 1;
    j = 4*(k/4);
/* retrieve coordinates */
    ARR3SET(v2, data->cell[i].rx);
    ARR3SET(v1, data->cell[j].rx);
    ARR3SET(v3, data->cell[j+2].rx);
/* xlat */
    VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
    VEC2ADD(v2, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
    VEC2ADD(v3, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
/* scale */
    VEC3MUL(v1, data->scale);
    VEC3MUL(v2, data->scale);
    VEC3MUL(v3, data->scale);
/* draw */
    glBegin(GL_LINE_STRIP);
    glVertex3fv(v1);
    glVertex3fv(v2);
    glVertex3fv(v3);
    glEnd();
    }
/* draw the sides of the frame */
  for (k=4 ; k-- ; )
    {
    l = k+4;
/* retrieve coordinates */
    ARR3SET(v1, data->cell[k].rx);
    ARR3SET(v2, data->cell[l].rx);
    VEC2ADD(v1, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
    VEC2ADD(v2, data->offset[0]*PIX2ANG, data->offset[1]*PIX2ANG);
    VEC3MUL(v1, data->scale);
    VEC3MUL(v2, data->scale);
/* draw */
    glBegin(GL_LINE_STRIP);
    glVertex3fv(v1);
    glVertex3fv(v2);
    glEnd();
    }
  }

/* NEW - all the 2D stuff here eg mouse related lines & text stuff */
/* project so that the raster position corresponds to the screen (ie pixel) coords */
glMatrixMode(GL_PROJECTION);
glLoadIdentity();
gluOrtho2D(0.0, sysenv.width, 0.0, sysenv.height);
glMatrixMode(GL_MODELVIEW);
glLoadIdentity();

glColor3f(1.0, 1.0, 0.0);
if (data->box_on)
  {
/* new box selection style */
  px1 = data->box_select[0].px;
  py1 = sysenv.height - data->box_select[0].py;
  px2 = data->box_select[1].px;
  py2 = sysenv.height - data->box_select[1].py;
/* draw box */
  glBegin(GL_LINE_LOOP);
  glVertex3f(px1, py1, 1);
  glVertex3f(px1, py2, 1);
  glVertex3f(px2, py2, 1);
  glVertex3f(px2, py1, 1);
  glEnd();
  }

glColor3f(1.0, 1.0, 1.0);
if (data->num_vertices)
  {
/* draw facet labels */
/* TODO - make this more efficient */
  plist = data->planes;
  while (plist != NULL)
    {
    plane = (struct plane_pak *) plist->data;
    if (plane->present && plane->visible && data->morph_label)
      {
      g_snprintf(facet_label,7,"%2d%2d%2d",abs(plane->index[0])
                                          ,abs(plane->index[1])
                                          ,abs(plane->index[2]));
      a = sysenv.width/2.0 + plane->px + data->offset[0];
      b = sysenv.height/2.0 - plane->py - data->offset[1];
      gl_print(a, b, facet_label);

/* messy */
      if (plane->index[0] < 0)
        {
        glBegin(GL_LINE_LOOP);
        glVertex3f(a+3, b+11, 1);
        glVertex3f(a+10, b+11, 1);
        glEnd();
        }
      if (plane->index[1] < 0)
        {
        glBegin(GL_LINE_LOOP);
        glVertex3f(a+14, b+11, 1);
        glVertex3f(a+21, b+11, 1);
        glEnd();
        }
      if (plane->index[2] < 0)
        {
        glBegin(GL_LINE_LOOP);
        glVertex3f(a+25, b+11, 1);
        glVertex3f(a+32, b+11, 1);
        glEnd();
        }

      }
    plist = g_slist_next(plist);
    }
  }


/* MODE */
switch(data->mode)
  {
  case FREE:
      mode_label = g_strdup("normal");
      break;
    case ATOM_ADD:
      mode_label = g_strdup("add atoms");
      break;
    case ATOM_MOVE:
      mode_label = g_strdup("move atoms");
      break;
    case ATOM_DELETE:
      mode_label = g_strdup("delete atoms");
      break;
    case ATOM_CHANGE_TYPE:
      mode_label = g_strdup("change atom type");
      break;
    case BOND_SINGLE:
      mode_label = g_strdup("single bonds");
      break;
    case BOND_DOUBLE:
      mode_label = g_strdup("double bonds");
      break;
    case BOND_TRIPLE:
      mode_label = g_strdup("triple bonds");
      break;
    case MOL_MOVE:
      mode_label = g_strdup("move mol");
      break;
    case MOL_DELETE:
      mode_label = g_strdup("delete mols");
      break;
    case BOND_INFO:
      mode_label = g_strdup("bonds");
      break;
    case DIST_INFO:
      mode_label = g_strdup("distances");
      break;
    case ANGLE_INFO:
      mode_label = g_strdup("angles");
      break;
    case DIHEDRAL_INFO:
      mode_label = g_strdup("dihedral angles");
      break;
    case ALTER_SELECT:
      mode_label = g_strdup("alter selection");
      break;
    case REGION_LITE:
      mode_label = g_strdup("region lighting");
      break;
    default:
      mode_label = g_strdup("undefined");
      break;
  }
/* TODO - how to auto determine position??? */
gl_print(sysenv.width - 8 * strlen(mode_label), 20, mode_label);
g_free(mode_label);


/* FLUSH THE DRAWING AREA */
gtk_gl_area_swapbuffers(GTK_GL_AREA(glarea));

/* clean up */
/*
gluDeleteQuadric(quad);
*/

#ifdef TIMER
stop_timer("opengl_draw");
#endif
}

/*********************************************/
/* find & update an OpenGL image (if exists) */
/*********************************************/
void redraw_opengl(struct model_pak *data)
{
gint i;

for (i=0 ; i<MAX_DIALOGS ; i++)
  {
/* skip? */
  if (!sysenv.dialog[i].active)
    continue;
  if (sysenv.dialog[i].model != data->number)
    continue;
/* refresh OpenGL image */
  if (sysenv.dialog[i].type == OPENGL)
    opengl_draw(sysenv.dialog[i].data);
  }
}
#endif /* GTK_GL */
