/*
Copyright (C) 2000 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gdis.h"

void about(void)
{
gint doc;
GtkWidget *helpwin, *notebook, *hbox, *vbox, *frame, *label, *button;
GString *buff, *title;

/* create a dialog */
helpwin = gtk_dialog_new();
gtk_window_set_policy(GTK_WINDOW(helpwin), FALSE, TRUE, FALSE);
gtk_window_set_title(GTK_WINDOW (helpwin), "About");
gtk_window_set_position(GTK_WINDOW(helpwin), GTK_WIN_POS_CENTER);

hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(helpwin)->vbox), hbox, TRUE, TRUE, 10);

/* notebook display */
notebook = gtk_notebook_new();
gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_TOP);
gtk_container_add (GTK_CONTAINER (hbox), notebook);

/* data strings */
buff = g_string_new(NULL);
title = g_string_new(NULL);

/* fill out the pages in the notebook */
for (doc=0 ; doc<LAST ; doc++)
  {
  switch(doc)
    {
    case DISMOL:
      g_string_assign(title,"GDIS");
      g_string_sprintf(buff,"GDIS version %s.%d\n\n",VERSION,PATCH);
      g_string_append(buff,"A molecular and crystal display interface\n\n");
      g_string_append(buff,"(c) 2000 by Sean Fleming\n\n");
      g_string_append(buff,"sean@power.curtin.edu.au\n\n");
      g_string_append(buff,"http://gdis.seul.org\n\n");
      g_string_append(buff,"Thanks very much to the guys at www.seul.org!\n\n");
      g_string_append(buff,"Additional thanks to:\n\n");
      g_string_append(buff,"Steef Boerrigter (sxmboer@sci.kun.nl),\n");
      g_string_append(buff,"Keith Refson (keith.refson@earth.ox.ac.uk),\n");
      g_string_append(buff,"Andrew Rohl (andrew@power.curtin.edu.au),\n");
      g_string_append(buff,"and Julian Gale (j.gale@ic.ac.uk).\n\n");
      g_string_append(buff,"for their suggestions and assistance in finding/fixing bugs.\n");
      break;
    case SGINFO:
      g_string_assign(title,"SgInfo");
      g_string_sprintf(buff,"Space Group information lookup.\n\n");
      g_string_append(buff,"(c) 1994-96 by Ralf W. Grosse-Kunstleve.\n\n");
      g_string_append(buff,"rwgk@laplace.csb.yale.edu\n\n");
      g_string_append(buff,"Modified by Sean Fleming for inclusion in GDIS.\n");
      break;
    case SYMMETRY:
      g_string_assign(title,"Symmetry");
      g_string_sprintf(buff,"Brute force symmetry analyzer\n\n");
      g_string_append(buff,"(c) 1996 Sergei Pachkovsky\n\n");
      g_string_append(buff,"patchkov@chem.ucalgary.ca\n\n");
      g_string_append(buff,"http://www.cobalt.chem.ucalgary.ca/ps/\n\n");
      g_string_append(buff,"Modified by Sean Fleming for inclusion in GDIS.");
      break;
    case CDD:
      g_string_assign(title,"CDD");
      g_string_sprintf(buff,"CDD uses the double description method to compute\n");
      g_string_append(buff,"the vertices and extreme rays of a polyhedron.\n");
      g_string_append(buff,"It is utilized in calculating crystal habits.\n\n");
      g_string_append(buff,"(c) 1997 by Komei Fukuda\n\n");
      g_string_append(buff,"fukuda@ifor.math.ethz.ch\n\n");
      g_string_append(buff,"http://www.ifor.math.ethz.ch/~fukuda/cdd_home/cdd.html\n\n");

      g_string_append(buff,"Modified by Sean Fleming for inclusion in GDIS.\n");
      break;
    case GPERIODIC:
      g_string_assign(title,"GPeriodic");
      g_string_sprintf(buff,"Shows the periodic table of elements.\n\n");
      g_string_append(buff,"(c) 1999 by Kyle R. Burton\n\n");
      g_string_append(buff,"mortis@voicenet.com\n\n");
      g_string_append(buff,"http://www.voicenet.com/~mortis\n http://gperiodic.seul.org\n\n");
      g_string_append(buff,"Contributing authors:\n");
      g_string_append(buff,"a.w.peters@ieee.org,\n");
      g_string_append(buff,"khazuada@univ-littoral.fr,\n");
      g_string_append(buff,"mrivera@cable.net.co,\n");
      g_string_append(buff,"chris@koeln.ccc.de,\n");
      g_string_append(buff,"lalo@linuxcenter.com.br\n");
      g_string_append(buff,"koen_kooi@hotmail.com\n\n");
      g_string_append(buff,"Modified by Sean Fleming for inclusion in GDIS.");
      break; 
    case POVRAY:
      g_string_assign(title,"POVRay");
      g_string_sprintf(buff,"The Persistence Of Vision Raytracer\n\n");
      g_string_append(buff,"http://www.povray.org\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to POVRay.\n\n");
      g_string_append(buff,"A working version of POVRay must be installed\n");
      g_string_append(buff,"on your system in order to render molecules.\n");
      break;
    case GULP:
      g_string_assign(title,"GULP");
      g_string_sprintf(buff,"The General Utility Lattice Program\n\n");
      g_string_append(buff,"(c) Julian Gale\n\n");
      g_string_append(buff,"j.gale@ic.ac.uk\n\n");
      g_string_append(buff,"http://www.ch.ic.ac.uk/gale/Research/gulp.html\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to GULP.\n\n");
      g_string_append(buff,"A working version of GULP must be installed on\n");
      g_string_append(buff,"your system in order to run energy calculations.\n");
      break; 
    case BABEL:
      g_string_assign(title,"Babel");
      g_string_sprintf(buff,"A coordinate file interconversion program\n\n");
      g_string_append(buff,"(c) 1992-1996 Pat Walters and Matt Stahl\n\n");
      g_string_append(buff,"babel@mercury.aichem.arizona.edu\n\n");
      g_string_append(buff,"http://smog.com/chem/babel/\n\n");
      g_string_append(buff,"GDIS acts only as a GUI to Babel.\n\n");
      g_string_append(buff,"A working version of Babel must be installed on\n");
      g_string_append(buff,"your system in order to load certain filetypes.\n");
      break;
/* empty page */
    default:
      continue;
    }
/* frame each page */
  frame = gtk_frame_new (title->str);
  gtk_container_set_border_width (GTK_CONTAINER (frame), 10);
/* put in a vbox to get a border around the text */
  vbox = gtk_vbox_new(TRUE,0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  gtk_container_set_border_width (GTK_CONTAINER(GTK_BOX(vbox)), 10);
/* add the title & text */
  label = gtk_label_new (buff->str);
  gtk_container_add(GTK_CONTAINER(GTK_BOX(vbox)), label);
  label = gtk_label_new (title->str);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);
  }

/* starting page - GDIS, of course */
gtk_notebook_set_page (GTK_NOTEBOOK(notebook), 0);

/* terminating button */
hbox = gtk_hbox_new(FALSE,0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(helpwin)->action_area), hbox,
                                                     FALSE, TRUE, 0);
button = gtk_button_new_with_label ("  Close  ");
gtk_box_pack_start(GTK_BOX(hbox), button, TRUE, FALSE, 0);
gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                          GTK_SIGNAL_FUNC(gtk_widget_destroy),
                          GTK_OBJECT(helpwin));

/* show the dialog */
gtk_widget_show_all(helpwin);

/* done */
g_string_free(buff, TRUE);
g_string_free(title, TRUE);
}

