/*
Copyright (C) 2000 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#define PATCH 0
#define MAX_TOKENS 100
#define MAX_ELEM_TOKENS 7
#define MAX_PATH_ITEMS 50
#define MAX_DISPLAYED 9
#define MAX_MODELS 14
/* NB: allowing sof's require making this unrealistically large */
#define MAX_BONDS 16
#define MAX_MOL_SIZE 100
#define MAX_POTENTIALS 50
#define MAX_MODEL_DIALOGS 10
#define MAX_DIALOGS 15
#define ELEM_LABEL_SIZE 7
#define LABEL_SIZE 7
#define TAIL_SIZE 80
#define DEFAULT_NA 30
#define DEFAULT_NL 10
#define DEFAULT_SS 10
#define MAX_SHELL_DIST 0.5
#define BOND_FUDGE 0.1
#define RMAX_FUDGE 1.1
#define RMAX_SCALE 1.1
#define ROTATE_SCALE 1.0
#define PIX2SCALE 0.01
#define MESH_POINTS_MIN 2
#define MESH_POINTS_MAX 20
#define MESH_SPACE_MIN 0.1
#define MESH_SPACE_MAX 10.0
/* 1st is roughly (no accounting for latmat) in Angs */
#define POSITION_TOLERANCE 0.01
#define FRACTION_TOLERANCE 0.000001

/* maths */
#define PI 3.1415927654
#define R2A 57.295779513
#define AU2ANG 0.529

/* location of data file - TODO - IMPROVE ie rc file/scan etc */
#define RCFILE ".gdisrc"
#define LIBRARY "gdis.lib"
#define LOG_FILE "gdismol.log"
#define FONT "-misc-fixed-medium-r-*-*-*-120-*-*-*-*-iso8859-1"

/* graphics window defs */
#define START_WIDTH 640
#define START_HEIGHT 600
#define MIN_WIDTH 550
#define MIN_HEIGHT 500
/* use GTKGL_ as GL_ are often reserved by OpenGL */
#define GTKGL_DIM 600
#define GTKGL_LINE_WIDTH 1.5
/* spacing */
#define PANEL_SPACING 4
/* sub windows */
#define W_BORDER 5
#define H_BORDER 5
/* camera placement for POVray */
#define FRAMEZ 2000
/* angle drawing */
#define MIN_ARC_RAD 15

/* parsing */
#define FILELEN 150
#define LINELEN  300
#define ITEMLEN  50

/* non-contact molecular surface types */
#define REENTRANT -1
#define HOLE -2
#define VALLEY -3

/* convenience macros */
#define SPIN_FVAL gtk_spin_button_get_value_as_float
#define SPIN_IVAL gtk_spin_button_get_value_as_int

/* dim 2 */
#define ARR2SET(vec, a) {*vec = *a ; *(vec+1) = *(a+1);}
#define ARR2ADD(vec, a) {*vec += *a ; *(vec+1) += *(a+1);}
#define VEC2ADD(vec, a, b) {*vec += a ; *(vec+1) += b;}

/* dim 3 */
#define VEC3MUL(vec,m) {*vec *= m ; *(vec+1) *= m ; *(vec+2) *= m;}
#define VEC2MUL(vec,m) {*vec *= m ; *(vec+1) *= m;}
#define VEC3MAGSQ(vec) (*vec * *vec + *(vec+1) * *(vec+1) + \
                        *(vec+2) * *(vec+2))
#define VEC3MAG(vec) sqrt(VEC3MAGSQ(vec))

#define VEC3SET(a,x,y,z) {*a = x; *(a+1) = y; *(a+2) = z;}
#define ARR3SET(a,b) {*a = *b; *(a+1) = *(b+1); *(a+2) = *(b+2);}
#define ARR3ADD(a,b) {*a += *b; *(a+1) += *(b+1); *(a+2) += *(b+2);}
#define ARR3SUB(a,b) {*a -= *b; *(a+1) -= *(b+1); *(a+2) -= *(b+2);}
#define ARR3MUL(a,b) {*a *= *b; *(a+1) *= *(b+1); *(a+2) *= *(b+2);}

#define P3VEC(s,v) (printf("%s (%f, %f, %f)\n",s,*v,*(v+1),*(v+2)))

#define P3MAT(s,m) {printf("%s\n|%f, %f, %f|\n|%f, %f, %f|\n|%f, %f, %f|\n",\
s,*m,*(m+1),*(m+2),*(m+3),*(m+4),*(m+5),*(m+6),*(m+7),*(m+8));}


#define SUBLINE(pix,gc,sub,x1,y1,x2,y2) (gdk_draw_line(pix, gc, \
x1+sysenv.subcenx[sub], y1+sysenv.subceny[sub], \
x2+sysenv.subcenx[sub], y2+sysenv.subceny[sub]))

#define SUBTEXT(pix,gc,sub,x1,y1,text) (gdk_draw_text(pix, sysenv.dfont, gc, \
x1+sysenv.subcenx[sub], y1+sysenv.subceny[sub], \
text, strlen(text)))

#define SUBARC(pix,gc,sub,x,y,w,h,a1,a2) (gdk_draw_arc(pix, gc, FALSE,\
x+sysenv.subcenx[sub], y+sysenv.subceny[sub], w, h, a1, a2))

#define FSUBARC(pix,gc,sub,x,y,w,h,a1,a2) (gdk_draw_arc(pix, gc, TRUE,\
x+sysenv.subcenx[sub], y+sysenv.subceny[sub], w, h, a1, a2))

/* file parsing keyword/option stuff */
enum 
{
E_SINGLE, E_OPTIMIZE, FREE_ENERGY, MD, CONP, CONV, MOLE, MOLMEC, MOLQ, NOBUILD,
NAME, CELL, CART, FRAC, S_FRAC, SURFACE_CELL, SURFACE_VECTORS, LATTICE_VECTORS,
SPACE, ORIGIN, ELEMENT, SPECIES, MAXCYC, ENERGY, TOTAL_ENERGY, SBULK_ENERGY,
HARMONIC, MORSE, BUCKINGHAM, LENNARD, THREE, FOUR, TORSION, OUTOFPLANE,
SPRING, SWITCH_MINIMISER, TEMPERATURE, ENSEMBLE, SHRINK, ZSISA, COMPARE, 
TITLE, END, GULP_OBSERVABLES, TEMP_FILE, DUMP_FILE, LIB_FILE, OUTPUT,
SUPER_CELL, NVE, NVT, NPT, BFGS_OPT, RFO_OPT, CONJ_OPT, D_HKL,
NO_ESURF, NO_EATT,
CIF_DATA_START, CIF_DATABASE_CODE, CIF_CHEMICAL_NAME, CIF_MINERAL_NAME,
CIF_CELL_A, CIF_CELL_B, CIF_CELL_C, CIF_CELL_ALPHA, CIF_CELL_BETA,
CIF_CELL_GAMMA, CIF_SPACE_NAME, CIF_SPACE_NUM, CIF_FRAC_DATA
};

/* misc specifiers */
enum {ALL, SINGLE, DOUBLE, TRIPLE};
enum {APPEND, INSERT, REPLACE};
enum {LOW, MEDIUM, HIGH};
enum {CARTESIAN, OTHER};
enum {PLANE_XY, PLANE_YZ, PLANE_XZ};
enum {CHECK, CONDENSE};
enum {EXEC_PATH};
enum {INVERSION, PLANE, PAXIS, IAXIS};

/* task modes */
enum {QUEUED, RUNNING, SUSPENDED};

/* surface types */
enum {SOLSURF, MOLSURF};

/* some colour names */
enum {BLACK, WHITE, RED, GREEN, BLUE, YELLOW, GOLD, ORANGE,
      SEA_GREEN, AQUAMARINE, NAVY_BLUE, LIGHT_TAN, LEMON, PURPLE};

/* data type specifiers */
enum {MODEL, ATOM, BOND, UBOND, MOL, SHELL, 
      GEOM, DIST, ANGLE, DIHEDRAL, SELECT};

/* init_objs() call modes */
enum 
{
INIT_COORDS, CENT_COORDS, REDO_COORDS,
MESH_ON, MESH_OFF, BOX_ON, BOX_OFF,
REFRESH_LITE, REFRESH_COLOUR, SOF_COLOUR
};

/* main operation modes */
enum {FREE, XLAT, ROTATE, PITCH, ROLL, QUIT,
      ALTER_SELECT, REGION_LITE,
      ATOM_ADD, ATOM_MOVE, ATOM_DELETE, ATOM_CHANGE_TYPE,
      BOND_SINGLE, BOND_DOUBLE, BOND_TRIPLE,
      MOL_MOVE, MOL_DELETE,
      BOND_INFO, DIST_INFO, ANGLE_INFO, DIHEDRAL_INFO};

/* crystal lattice types */
enum {XS_UNKNOWN, XS_TRICLINIC, XS_MONOCLINIC, XS_ORTHOROMBIC,
      XS_TETRAGONAL, XS_TRIGONAL, XS_HEXAGONAL, XS_CUBIC};

/* unit cell facets */
enum {A_LO, A_HI, B_LO, B_HI, C_LO, C_HI};

/* morphology types */
enum {LENGTH, DHKL, EATT, ESURF};

/* general update call modes */
enum {INITIAL, REFRESH, RESTORE, CREATE};

/* switch_view() call modes */
enum {SPLIT_NONE, SPLIT_VERT, SPLIT_HORZ, SPLIT_BOTH, PREV_MODEL, NEXT_MODEL};

/* view actions */
enum {ROTATION, UPDATE_X, UPDATE_Y, UPDATE_Z};


/* NEW - atom status flags */
/* TODO - to avoid problems get rid of NORMAL */
#define NORMAL 0
#define DELETED 2
#define HIDDEN 4
#define SQUARE_HL 8
#define SELECT_HL 16

/* model display features */
enum 
{
PLANE_LABELS, ASYM_TOGGLE,
ATOM_LABELS, FRAME, MESH, SHELLS, AXES_TYPE, 
PBC_CONFINE_ATOMS, PBC_CONFINE_MOLS, UNFRAGMENT_MOLS
};

/* creator grid */
enum {MESH_POINTS, MESH_SPACING};

/* marvin region types */
enum {REGION1A, REGION2A, REGION1B, REGION2B, NONE};

/* selection modes */
enum {CLEAN, START, UPDATE, STOP, ASSIGN, RECALL, RELEASE};

/* widget & file/package types */
enum 
{
DISMOL, SGINFO, SYMMETRY, CDD, GPERIODIC, POVRAY, GENSURF,
ANIM, SURF, DISPLAY, COLOUR, GEOMETRY, TASKMAN,
FILE_LOAD, FILE_SAVE, FILE_SAVE_AS,
/* the next line have to be in order for the pulldown menu to work properly */
NODATA, DATA, BABEL, BIOSYM, CIF, GULP, MARVIN, MORPH, XTL, XYZ,
NONBABEL, CSSR, FDAT, GAMOUT, MOPAC_OUT, PDB,
MDI, CREATOR, MVNOUT, GULPOUT, GULP_TRJ, OPENGL, OPENGL_OPTIONS, RDF,
LAST
};

/* surface creation - parameter specifiers */
enum 
{
MILLER_H, MILLER_K, MILLER_L, SHIFT, REGION1, REGION2, BASE_MODEL,
GRID, OFFSET, PROBE, SURF_ACCURACY,
RANK_FACES, CALC_SHIFTS, CONV_REGIONS, GENERATE
};

/* rendering consts */
#define BALL_SIZE 0.27
#define AMBIENCE_MAX 0.025
#define TRIPLE_SCALE 0.65
#define DOUBLE_SCALE 0.8
#define POVRAY_FONT "timrom.ttf"
/* convert from gdis pixel offset to OpenGL cartesian Angs */
#define PIX2ANG 0.03

/* unified render (povray & openGL) */
enum 
{
STICK, BALL_STICK, CPK,
LINE_WIDTH, BALL_RADIUS, STICK_RADIUS, CPK_SCALE, FRAME_RADIUS, WIDTH, HEIGHT,
LIGHT_AMBIENT, LIGHT_DIFFUSE, LIGHT_SPECULAR,
BACKGROUND, ANTIALIAS, SHADOWLESS, DRAW_AXES,
ANIMATE, ANIMATE_TYPE, ANIM_GIF, ANIM_MPEG, ANIM_NAME, ANIM_FRAME, DELAY,
MORPH_COLOUR, MORPH_STYLE, MORPH_FINISH, REF_INDEX, TRANSMIT,
CLIP_EQN_A, CLIP_EQN_B, CLIP_EQN_C, CLIP_EQN_D, VP_DIST,
ELEMENT_COLOUR
};

/*****************/
/* MAIN INCLUDES */
/*****************/
#include <glib.h>
#include <gtk/gtk.h>
#include "pak.h"

#if GTK_EXTRA
#include <gtkextra/gtksheet.h>
#endif

