/*
Copyright (C) 2000 by Sean David Fleming

sean@power.curtin.edu.au

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

The GNU GPL can also be found at http://www.gnu.org
*/

#include "config.h"
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef __sun
#include <sys/dirent.h>
#else
#include <sys/dir.h>
#endif

#include "gdis.h"

#define DEBUG_MORE 0
#define MAX_KEYS 15

/* main structures */
extern struct sysenv_pak sysenv;
extern struct elem_pak elements[];

/* TODO - load (adapt from load_data) */

/**********************/
/* Save in XTL format */
/**********************/
gint write_xtl(gchar *filename, struct model_pak *data)
{
gint i;
FILE *fp;

/* checks */
g_return_val_if_fail(data->fractional == TRUE, 1);

/* open the file */
fp = fopen(filename,"w");
if (!fp)
  {
  show_text("Error, bad filename!");
  return(1);
  }
show_text("Saving file in XTL format!");

/* header */
fprintf(fp,"TITLE %s\n",data->basename);
fprintf(fp,"DIMENSION %d\n",data->periodic);
fprintf(fp,"CELL\n");
if (data->periodic == 3)
  fprintf(fp,"%f  %f  %f  %f  %f  %f\n",data->pbc[0],data->pbc[1],data->pbc[2],
          180.0*data->pbc[3]/PI, 180.0*data->pbc[4]/PI, 180.0*data->pbc[5]/PI);
else
  fprintf(fp,"%f  %f  %f\n",data->pbc[0],data->pbc[1], 180.0*data->pbc[5]/PI);

fprintf(fp,"SYMMETRY NUMBER %d\n", data->sginfo.spacenum);
if (data->sginfo.cellchoice)
  fprintf(fp,"SYMMETRY QUALIFIER ORIGIN_%d\n", data->sginfo.cellchoice);
/* coords */
fprintf(fp,"ATOMS\n");
fprintf(fp,"NAME       X          Y          Z     CHARGE   TEMP    OCCUP   SCAT\n");
for (i=0 ; i<data->num_atoms ; i++)
  {
  if ((data->atoms+i)->primary)
    {
    fprintf(fp,"%4s %10.5f %10.5f %10.5f  0.0000  0.0000  1.0000   C 0+\n",
            (data->atoms+i)->label, (data->atoms+i)->x, 
            (data->atoms+i)->y, (data->atoms+i)->z);
    }
  }
fprintf(fp,"EOF\n");

/* done */
fclose(fp);
return(0);
}

