from ConfigWidget import ConfigWidget

import gtk

class ConfigURI(ConfigWidget):

    def __init__(self, attrs, getter, setter):

        def open_filedialog(self, on_ok, entry):
            def fd_hide(src, fselector): fselector.destroy()
            d = gtk.FileSelection()
            d.show()
            d.ok_button.connect("clicked", on_ok, d, entry)
            d.cancel_button.connect("clicked", fd_hide, d)

        def on_ok(src, fselector, entry):
            fname = fselector.get_filename()
            entry.set_text(fname)
            fselector.destroy()


        ConfigWidget.__init__(self, attrs, getter, setter)
        label = attrs.get("label", "")

        lbl = gtk.Label(label)
        lbl.show()
        align = gtk.Alignment(0.0, 0.0, 0.0, 0.0)
        align.show()
        align.add(lbl)

        hbox = gtk.HBox()
        hbox.show()
        entry = gtk.Entry()
        entry.show()
        hbox.pack_start(entry, True, True, 0)

        btn = gtk.Button(stock = gtk.STOCK_OPEN)
        btn.show()
        hbox.pack_end(btn, True, True, 4)

        btn.connect("clicked", open_filedialog, on_ok, entry)

        value = self._get_config()
        entry.set_text(value)
        entry.connect("focus-out-event", self.__on_change)

        #self.__tooltips.set_tip(entry, help)
        #self.__tooltips.set_tip(btn, help)

        # we need an EventBox for being able to display tooltips
        ebox = gtk.EventBox()
        ebox.show()
        ebox.add(hbox)

        self.__widgets = (align, ebox)


    def get_widgets(self): return self.__widgets


    def __on_change(self, src, event):

        value = src.get_text()
        value = value.replace("\"", "\\\"")
        self._set_config("\"" + value + "\"")
