from libdesklets.controls import Control, Interface, Permission
import xml.sax, RSSreader, thread, threading, re, os, dircache


class INewsGrab(Interface):
	get_icon	= Permission.READWRITE
	set_url		= Permission.WRITE
	set_browser	= Permission.WRITE
	launch		= Permission.WRITE
	interval	= Permission.WRITE
	get_items	= Permission.READ
	refresh		= Permission.READ
	status		= Permission.READ


class NewsGrab(Control, INewsGrab):

	def __init__(self):
		self._parser	= xml.sax.make_parser()
		self._handler	= RSSreader.NewsHandler()
		self._browser	= "firefox"
		self._url		= ""
		self._icon		= ""
		self._interval	= 30 * 60 * 1000
		self._updated	= 0
		self._refresh	= 0
		self._status	= 0
		self._logos		= ["slashdot", "tomshardware", "anandtech"]
		Control.__init__(self)
		self._add_timer(500, self.__start)

	
	def __set_url(self, value):		self._url = value
	def __set_browser(self, value):	self._browser = value
	def __set_interval(self, value):self._interval = value
	def __get_items(self):			return self._handler.item
	def __get_refresh(self):		return self._refresh
	def __get_status(self):			return self._status


	def __start(self):
		self._updated = 0
		self._refresh = 0
		self._status = 1
		self._update("status")
		thread.start_new_thread(self.__read_xml, ())
		self._add_timer(1000, self.__wait)

	
	def __wait(self):
		if self._updated == 0:
			return 1
		elif self._updated == 1:
			self._refresh = 1
			self._update("refresh")
			self._status = 0
			self._update("status")
			self._add_timer(self._interval, self.__start)
		return 0
	
		
	def __read_xml(self):
		self._handler.item = []
		self._parser.setContentHandler(self._handler)

		try:
			self._parser.parse(self._url)
		except:
			print "NewsGrab\nBad XML data, but will continue...\n"
			pass

		self._updated = 1


	def __launch(self, value):
		p = re.compile('&')
		url = p.sub('\&', value, 0)
		threading.Thread(target = os.system, args = ("nice -n 0 %s %s" % (self._browser, url),)).start()
		
		
	def __get_icon(self):
		for i in self._logos:
			m = re.search(i, self._url)
			if m:
				return i
			
		return "none"


	# Interface
	get_icon	= property(fget = __get_icon,
							doc = "Set provider icon")
	set_url		= property(fset = __set_url,
							doc = "Set the URL of where to grab the RSS from")
	set_browser	= property(fset = __set_browser,
							doc = "Set the default browser")
	launch		= property(fset = __launch,
							doc = "Launch the URL within a browser")
	interval	= property(fset = __set_interval,
							doc = "Set time between reading news")
	get_items	= property(__get_items,
							doc = "Get the news items array")
	refresh		= property(__get_refresh,
							doc = "Display refresh trigger")
	status		= property(__get_status,
							doc = "Status")


def get_class(): return NewsGrab

