#line 2 "lexer.c"

#line 4 "lexer.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    /* Note: We specifically omit the test for yy_rule_can_match_eol because it requires
     *       access to the local variable yy_act. Since yyless() is a macro, it would break
     *       existing scanners that call yyless() from OUTSIDE yylex. 
     *       One obvious solution it to make yy_act a global. I tried that, and saw
     *       a 5% performance hit in a non-yylineno scanner, because yy_act is
     *       normally declared as a register variable-- so it is not worth it.
     */
    #define  YY_LESS_LINENO(n) \
            do { \
                int yyl;\
                for ( yyl = n; yyl < yyleng; ++yyl )\
                    if ( yytext[yyl] == '\n' )\
                        --yylineno;\
            }while(0)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 18
#define YY_END_OF_BUFFER 19
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[73] =
    {   0,
        0,    0,    0,    0,    0,    0,   19,   18,   16,    1,
        1,   16,   12,   16,   12,   12,    4,    4,    4,   12,
       12,   12,    2,    2,   10,   11,   17,   17,   17,    1,
        0,   13,    0,    0,    0,   12,    3,   14,    3,    4,
        4,    0,    8,    0,    6,    8,    0,    8,    2,    2,
        2,   15,   13,    9,    0,    0,    3,    0,    0,    3,
        7,    5,    0,    0,    3,    0,    0,    3,    3,    0,
        3,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    1,    1,    6,    7,    8,
        9,   10,   11,   12,   13,   14,   15,   16,   17,   17,
       17,   17,   17,   17,   17,   18,   18,   19,   20,   21,
       22,   23,    1,    1,   24,   25,   25,   24,   26,   24,
       27,   28,   27,   27,   27,   27,   27,   27,   29,   27,
       27,   27,   27,   27,   27,   27,   27,   30,   27,   27,
       31,   32,   33,   34,    1,    1,   24,   25,   25,   24,

       24,   24,   27,   28,   27,   27,   27,   27,   27,   27,
       29,   27,   27,   27,   27,   27,   27,   27,   27,   30,
       27,   27,   35,   36,   37,   38,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[39] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    2,    2,    2,    1,    1,
        1,    1,    1,    2,    2,    2,    3,    4,    3,    3,
        1,    1,    1,    1,    1,    1,    1,    1
    } ;

static yyconst flex_int16_t yy_base[80] =
    {   0,
        0,    0,    0,    0,   29,   30,  122,  207,  207,   39,
       44,   39,  207,   84,   34,  105,   58,   24,   39,   89,
       35,   88,   73,    0,  207,  207,  207,   81,   82,   57,
       45,  207,   61,   73,   78,  207,   88,  207,   91,    0,
        0,   45,   42,  107,  207,   45,    0,  207,    0,    0,
        0,  207,   81,  207,   62,  123,  111,  131,  134,  108,
       50,    0,  138,  140,  143,  151,  154,  157,  160,  163,
      166,  207,  184,  188,  192,  196,  199,  202,   61
    } ;

static yyconst flex_int16_t yy_def[80] =
    {   0,
       73,   73,   72,    3,   74,   74,   72,   72,   72,   72,
       72,   75,   72,   76,   72,   72,   72,   17,   18,   72,
       72,   72,   72,   77,   72,   72,   72,   72,   72,   72,
       75,   72,   75,   72,   72,   72,   72,   72,   72,   18,
       19,   78,   78,   72,   72,   72,   79,   72,   23,   77,
       77,   72,   75,   72,   72,   72,   72,   72,   72,   44,
       72,   79,   72,   72,   72,   72,   72,   72,   72,   72,
       72,    0,   72,   72,   72,   72,   72,   72,   72
    } ;

static yyconst flex_int16_t yy_nxt[246] =
    {   0,
        9,   10,   11,   12,   13,   13,   14,   13,   13,   13,
       13,   13,   13,   15,   16,   17,   18,   19,   20,   13,
       21,   13,   22,   23,   23,   23,   24,   24,   24,   24,
       25,    9,   26,   13,   13,   13,   13,   13,   28,   28,
       30,   30,   32,   29,   29,   30,   30,   36,   32,   37,
       37,   37,   48,   72,   41,   41,   36,   36,   30,   30,
       61,   61,   62,   42,   53,   61,   61,   72,   54,   45,
       33,   39,   45,   40,   40,   41,   33,   63,   63,   54,
       34,   42,   43,   44,   32,   45,   46,   47,   49,   49,
       49,   38,   33,   55,   55,   52,   49,   49,   49,   50,

       51,   50,   50,   37,   37,   37,   57,   57,   57,   36,
       36,   34,   33,   56,   38,   35,   58,   59,   72,   59,
       72,   72,   60,   60,   60,   72,   57,   57,   57,   72,
       42,   42,   42,   64,   45,   64,   66,   72,   65,   65,
       65,   67,   72,   67,   54,   72,   68,   68,   68,   69,
       69,   69,   72,   34,   34,   65,   65,   65,   65,   65,
       65,   70,   72,   70,   72,   72,   71,   71,   71,   68,
       68,   68,   68,   68,   68,   69,   69,   69,   71,   71,
       71,   71,   71,   71,    8,    8,    8,    8,   27,   27,
       27,   27,   31,   31,   31,   31,   34,   34,   34,   34,

       50,   50,   50,   42,   72,   42,    7,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72
    } ;

static yyconst flex_int16_t yy_chk[246] =
    {   0,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    5,    6,
       10,   10,   12,    5,    6,   11,   11,   15,   31,   15,
       15,   15,   18,   18,   19,   19,   21,   21,   30,   30,
       46,   46,   79,   19,   33,   61,   61,   19,   55,   43,
       12,   17,   42,   17,   17,   17,   31,   55,   55,   34,
       35,   17,   17,   17,   53,   17,   17,   17,   23,   23,
       23,   29,   33,   35,   35,   28,   23,   23,   23,   23,

       23,   23,   23,   37,   37,   37,   39,   39,   39,   22,
       20,   35,   53,   37,   16,   14,   39,   44,   60,   44,
       60,    7,   44,   44,   44,    0,   57,   57,   57,    0,
       44,   44,   44,   56,   44,   56,   57,    0,   56,   56,
       56,   58,    0,   58,   63,    0,   58,   58,   58,   59,
       59,   59,    0,   63,   63,   64,   64,   64,   65,   65,
       65,   66,    0,   66,    0,    0,   66,   66,   66,   67,
       67,   67,   68,   68,   68,   69,   69,   69,   70,   70,
       70,   71,   71,   71,   73,   73,   73,   73,   74,   74,
       74,   74,   75,   75,   75,   75,   76,   76,   76,   76,

       77,   77,   77,   78,    0,   78,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72,   72,   72,   72,   72,   72,
       72,   72,   72,   72,   72
    } ;

/* Table of booleans, true if rule could match eol. */
static yyconst flex_int32_t yy_rule_can_match_eol[19] =
    {   0,
1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0,     };

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "lexer.l"
/*************************************************************
Copyright (C) 1990, 1991, 1993 Andy C. Hung, all rights reserved.
PUBLIC DOMAIN LICENSE: Stanford University Portable Video Research
Group. If you use this software, you agree to the following: This
program package is purely experimental, and is licensed "as is".
Permission is granted to use, modify, and distribute this program
without charge for any purpose, provided this license/ disclaimer
notice appears in the copies.  No warranty or maintenance is given,
either expressed or implied.  In no event shall the author(s) be
liable to you or a third party for any special, incidental,
consequential, or other damages, arising out of the use or inability
to use the program for any purpose (or the loss of data), even if we
have been advised of such possibilities.  Any public reference or
advertisement of this source code should refer to it as the Portable
Video Research Group (PVRG) code, and not by any author(s) (or
Stanford University) name.
*************************************************************/
#line 20 "lexer.l"

/*LABEL lexer.c */

/*
 * flex command was run this way:
 * 
 *  $ lex -olexer.c lexer.l
 */

/* We do not care of interactive mode */
#define YY_NEVER_INTERACTIVE 1
#define YY_NO_UNPUT 1

/* Do not include unistd.h in generated source. */
#define YY_NO_UNISTD_H

/* Skip declaring this function.  It is a macro.  */
#define YY_SKIP_YYWRAP

/* Redefine the yywrap so that we don't have
   to worry about lex library */

# define yywrap() (1)

static char *ReservedWords[] = {   /* Token names */
"COMPONENT",
"SCAN",
"QUANTIZATION",
"DCSPEC",
"ACCUSTOM",
"DCCUSTOM",
"PRINTSCAN",
"PRINTFRAME",
"PRINTIMAGE",
"OPENSCAN",
"ACSPEC",
"WRITESCAN",
"WRITEFRAME",
"WRITESOI",
"WRITEQUANTIZATION",
"WRITERESYNC",
"WRITEHUFFMAN",
"FREQUENCY",
"ACSEND",
"DCSEND",
"QSEND",
"STREAMNAME",
"IMAGEHEIGHT",
"IMAGEWIDTH",
"RESYNC",
"BUFFER",
"OPENSTREAM",
"CLOSESTREAM",
"FRAMEHEIGHT",
"FRAMEWIDTH",
"CLOSESCAN",
"WRITEEOI",
"ECHO",
"WRITESPECIAL",
"WRITEDIRECT",
"LUMINANCEDEFAULT",
"CHROMINANCEDEFAULT",
"ENABLE",
"SCANDNL",
"WRITEDNL",
"AUTO",
"EMPTY",
""};

#define R_COMPONENT 1           /* Token values mapped to token names */
#define R_SCAN 2
#define R_QUANTIZATION 3
#define R_DCSPEC 4
#define R_ACCUSTOM 5
#define R_DCCUSTOM 6
#define R_PRINTSCAN 7
#define R_PRINTFRAME 8
#define R_PRINTIMAGE 9
#define R_OPENSCAN 10
#define R_ACSPEC 11
#define R_WRITESCAN 12
#define R_WRITEFRAME 13
#define R_WRITESOI 14
#define R_WRITEQUANTIZATION 15
#define R_WRITERESYNC 16
#define R_WRITEHUFFMAN 17
#define R_FREQUENCY 18
#define R_ACSEND 19
#define R_DCSEND 20
#define R_QSEND 21
#define R_STREAMNAME 22
#define R_IMAGEHEIGHT 23
#define R_IMAGEWIDTH 24
#define R_RESYNC 25
#define R_BUFFER 26
#define R_OPENSTREAM 27
#define R_CLOSESTREAM 28
#define R_FRAMEHEIGHT 29
#define R_FRAMEWIDTH 30
#define R_CLOSESCAN 31
#define R_WRITEEOI 32
#define R_ECHO 33
#define R_WRITESPECIAL 34
#define R_WRITEDIRECT 35
#define R_LUMINANCEDEFAULT 36
#define R_CHROMINANCEDEFAULT 37
#define R_ENABLE 38
#define R_SCANDNL 39
#define R_WRITEDNL 40
#define R_AUTO 41
#define R_EMPTY 42

#define R_INTEGER 1000      /* Special TYPES for tokens */
#define R_LBRACKET 1001
#define R_RBRACKET 1002
#define R_ID 1003
#define R_STRING 1004

int CommentDepth = 0;  /* depth of comment nesting */
int yyint=0;           /* Return value for integers */
int LexDebug=0;        /* Status of lex debugging */

#define PRIME 211
#define EOS '\0'

#define MakeStructure(S) (S *) malloc(sizeof(S))
#define InsertLink(link,list){\
if(!list){list=link;}else{link->next=list;list=link;}}

#define LINK struct link_def
struct id {         /* Default id structure */
  char *name;       /* Key */
  int tokentype;    /* Token type */
  int count;        /* Count of # references */
};

LINK {              /* A link for the hash buckets */
struct id *lid;     /* Current id */
LINK *next;         /* Pointer to next id */
};

/*PUBLIC*/

extern void initparser();
extern void parser();

static int hashpjw();
static LINK * MakeLink();
static struct id * enter();
static int getint();
static char * getstr();

/*PRIVATE*/

/*NOPROTO*/


#line 723 "lexer.c"

#define INITIAL 0
#define NORMAL 1
#define COMMENT 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

    static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 200 "lexer.l"


#line 881 "lexer.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 73 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 207 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

		if ( yy_act != YY_END_OF_BUFFER && yy_rule_can_match_eol[yy_act] )
			{
			int yyl;
			for ( yyl = 0; yyl < yyleng; ++yyl )
				if ( yytext[yyl] == '\n' )
					   
    yylineno++;
;
			}

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 202 "lexer.l"
{}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 204 "lexer.l"
{struct id *temp; temp = enter(0,yytext,yyleng); 
		 if (LexDebug)
		   {
		     printf("%s : %s (%d)\n",
			    yytext,
			    ((temp->tokentype) ? "RESERVED" : "IDENTIFIER"),
			    temp->count);
		   }
		 if (temp->tokentype)
		   {
		     return(temp->tokentype);
		   }
		 else
		   {
		     return(R_ID);
		   }
	       }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 221 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "REAL");
			   }
		       }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 226 "lexer.l"
{if (LexDebug)
			   {             
			     printf("%s : %s\n", yytext, "INTEGER");
			   }
			 yyint = atoi(yytext);
			 return(R_INTEGER);}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 232 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "(HEX)INTEGER");
			   }
			 yyint = strtol(yytext+2,NULL,16);
			 return(R_INTEGER);}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 238 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "(HEX)INTEGER");
			   }
			 yyint = strtol(yytext,NULL,16);
			 return(R_INTEGER);}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 244 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "(OCT)INTEGER");
			   }
			 yyint = strtol(yytext+2,NULL,8);
			 return(R_INTEGER);}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 250 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "(OCT)INTEGER");
			   }
			 yyint = strtol(yytext,NULL,8);
			 return(R_INTEGER);}
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 256 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "(CHAR)INTEGER");
			   }
			 if (yyleng>4)
			   {
			     yyint = strtol(yytext+2,NULL,8);
			   }
			 else
			   {
			     if (*(yytext+1)=='\\')
			       {
				 switch(*(yytext+2))
				   {
				   case '0':
				     yyint=0;
				     break;
				   case 'b':
				     yyint = 0x8;
				     break;
				   case 'i':
				     yyint = 0x9;
				     break;
				   case 'n':
				     yyint = 0xa;
				     break;
				   case 'v':
				     yyint = 0xb;
				     break;
				   case 'f':
				     yyint = 0xc;
				     break;
				   case 'r':
				     yyint = 0xd;
				     break;
				   default:
				     yyint=(*yytext+2);
				     break;
				   }
			       }
			     else
			       {
				 yyint = *(yytext+1);
			       }
			   }
			 return(R_INTEGER);}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 302 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "LBRACKET");
			   }
			 return(R_LBRACKET);}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 307 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "RBRACKET");
			   }
			 return(R_RBRACKET);}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 312 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "OPERATOR");
			   }
		       }
	YY_BREAK
case 13:
/* rule 13 can match eol */
YY_RULE_SETUP
#line 317 "lexer.l"
{if (LexDebug)
			   {
			     printf("%s : %s\n", yytext, "STRING");
			   }
			 return(R_STRING);}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 323 "lexer.l"
{CommentDepth++; BEGIN COMMENT;}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 325 "lexer.l"
{CommentDepth--;if(!CommentDepth) BEGIN NORMAL;}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 327 "lexer.l"
{
		  	    /* None of the above rules applicable, so
			       it's a bad symbol. */
                              printf("Bad input char '%c' on line %d\n",
  	  	  	  	    yytext[0],
  	  	  	  	    yylineno);
  	  	  	}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 335 "lexer.l"
{} /*Everything's AOK */
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 337 "lexer.l"
ECHO;
	YY_BREAK
#line 1180 "lexer.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(NORMAL):
case YY_STATE_EOF(COMMENT):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 73 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 73 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 72);

	return yy_is_jam ? 0 : yy_current_state;
}

    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

	/* undo effects of setting up yytext */
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

    if ( c == '\n' ){
        --yylineno;
    }

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	if ( c == '\n' )
		   
    yylineno++;
;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    /* We do not touch yylineno unless the option is enabled. */
    yylineno =  1;
    
    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 337 "lexer.l"



/*PROTO*/
LINK *HashTable[PRIME];  /* My little hash table */

/*START*/

/*BFUNC

initparser() is used to place the Reserved Words into the hash table.
It must be called before the parser command is called.

EFUNC*/

void initparser()
{
  char i,**sptr;
  BEGIN NORMAL;

  for(i=1,sptr=ReservedWords;**sptr!='\0';i++,sptr++) 
    {     /* Add Reserved Words */
      enter(i,*sptr,strlen(*sptr));        /* Put reserved words in */
    }                                      /* hash table */
}

#undef BEGIN
#undef MakeStructure
#include "globals.h"
#include "stream.h"
#include "tables.h"

extern FRAME *CFrame;
extern IMAGE *CImage;
extern SCAN *CScan;
extern int ErrorValue;

/*BFUNC

hashpjw() returns a hash value for a string input.

EFUNC*/

static int hashpjw(s)
     char *s;
{
  BEGIN("hashpjw")
  char *p;
  unsigned int g, h;
  h=0;

  for(p=s;*p!=EOS;p++)       /* Taken from Aho Sethi Ullman Compilers book. */
    {
      h = (h << 4) + *p;
      if ((g = h&0xf0000000))
	{
	  h = h ^(g >> 24);
	  h = h ^ g;
	}
    }
  return(h % PRIME);
}

/*BFUNC

MakeLink() is used to construct a link object. The link
is used for the hash table construct.

EFUNC*/


static LINK *MakeLink(tokentype,str,len)
     int tokentype;
     char *str;
     int len;
{
  BEGIN("MakeLink")
  LINK *temp;
  
  if (!(temp = MakeStructure(LINK)))            /* Make link */
    {
      WHEREAMI();
      printf("Cannot make a LINK.\n");
      exit(ERROR_MEMORY);
    }
  if (!(temp->lid = MakeStructure(struct id)))  /* Make id */
    {
      printf("Cannot make an id.\n");
      exit(ERROR_MEMORY);
    }
  temp->next = NULL;                            /* Set fields */
  if (!(temp->lid->name =(char *)calloc(len+1,sizeof(char))))
    {
      printf("Cannot make a string space for the link.\n");
      exit(ERROR_MEMORY);
    }
  strcpy(temp->lid->name,str);                 /* Copy key */
  temp->lid->tokentype = tokentype;
  temp->lid->count = 1; 
  return(temp);
}

/*BFUNC

enter() is used to enter a Reserved Word or ID into the hash table.

EFUNC*/

static struct id *enter(tokentype,str,len)
     int tokentype;
     char *str;
     int len;
{
  BEGIN("enter")
  int hashnum;
  LINK *temp,*current;
  char *ptr;

  for(ptr=str;*ptr!='\0';ptr++)          /* All capitals is fine */
    {
      if ((*ptr>='a') && (*ptr<='z'))
	{
	  *ptr = *ptr - ('a'-'A');
	}
    }
  hashnum = hashpjw(str);                /* Check if in hash table */
  for(temp=NULL,current=HashTable[hashnum];
      current!= NULL;
      current=current->next)
    {
      if (strcmp(str,current->lid->name) == 0)
	{
	  temp=current;
	  break;
	}
    }
  if (temp)                          /* Yes, found ID then return */
    {
      temp->lid->count++;
      return(temp->lid);
    }
  else                              /* Else make our own ID and return that*/
    {
      temp = MakeLink(tokentype,str,len);
      InsertLink(temp,HashTable[hashnum]);
      return(temp->lid);
    }
}

/*BFUNC

getint() takes an integer from the input.

EFUNC*/

static int getint()
{
  BEGIN("getint")
  int type;
  if ((type=yylex())!=R_INTEGER)
    {
      printf("Bad input, not integer, '%s' on line %d\n",
	     yytext,
	     yylineno);
      return(0);
    }
  return(yyint);
}

/*BFUNC

getstr() gets a string from the input. It copies the string to
temporary storage before it returns the pointer.

EFUNC*/

static char *getstr()
{
  BEGIN("getstr")
  char *tmp,*ptr,*bptr;
  int i,accum,flag;
  if (yylex() != R_STRING)                      /* Check if string */
    {
      printf("String expected.\n");
      if (!(tmp=(char *) malloc(sizeof(char))))
	{
	  WHEREAMI();
	  printf("Cannot allocate for null string.\n");
	  exit(ERROR_MEMORY);
	}
      *tmp='\0';
      return(tmp);
    }
  if (!(tmp=(char *)calloc(strlen(yytext)+1,sizeof(char)))) /* Make space */
    {
      WHEREAMI();
      printf("Cannot allocate %d string space.\n",yyleng);
      exit(ERROR_MEMORY);
    }
  for(bptr=yytext+1,ptr=tmp;*bptr!='"';bptr++,ptr++)   /* Copy to string */
    {
      if (*bptr=='\\')
	{
	  bptr++;
	  for(flag=0,accum=0,i=0;i<3;i++)  /* Octal character lookahead */
	    {
	      if ((*bptr>='0')&&(*bptr<='7'))
		{
		  accum = (accum<<3)+(*bptr-'0');
		  bptr++;
		  flag=1;
		}
	      else
		{
		  break;
		}
	    }
	  if (flag)
	    {
	      bptr--;
	      *ptr=accum;
	    }
	  else                           /* Do conversions, if necessary */
	    {
	      switch(*(bptr))
		{
		case '0':
		  *ptr = 0;
		  break;
		case 'b':
		  *ptr = 0x8;
		  break;
		case 'i':
		  *ptr = 0x9;
		  break;
		case 'n':
		  *ptr = 0xa;
		  break;
		case 'v':
		  *ptr = 0xb;
		  break;
		case 'f':
		  *ptr = 0xc;
		  break;
		case 'r':
		  *ptr = 0xd;
		  break;
		default:
		  *ptr=(*bptr);
		}
	    }
	}
      else
	{
	  *ptr = (*bptr);
	}
    }
  *ptr='\0';
  return(tmp);
}

/*BFUNC

parser() handles all of the parsing required for the Command
Interpreter.  It is basically a while statement with a very large case
statement for every input. The Command Interpreter is essentially
driven by the keywords. All unmatched values such as integers,
strings, and brackets, are ignored.

EFUNC*/

#define ARRAYBEGIN if (ntoken==R_LBRACKET)\
	    {\
	      arrayflag=1;\
	      ntoken=yylex();\
	    }\
	  if (ntoken!=R_INTEGER)\
	    {\
	      WHEREAMI();\
	      printf("Expected integer.\n");\
	      break;\
	    }\
	  while(1)\
	    {

#define ARRAYEND  if (arrayflag)\
		{\
		  if ((ntoken=yylex())==R_RBRACKET) break;\
		  else if (ntoken!=R_INTEGER)\
		    {\
		      WHEREAMI();\
		      printf("Expected integer or right bracket.\n");\
		      break;\
		    }\
		}\
	      else break;\
	      }

void parser()
{
  BEGIN("parser")
  int i,dest,value,token,ntoken,arrayflag;
  int accum;
  int Start,End;
  int *ptr,*ptr2;

  while((token=yylex()))        /* The code handling is simple enough. */
    {                         /* just read the code and documentation */
      ErrorValue=0;           /* book... */
      arrayflag=0;
      switch(token)
	{
	case R_ECHO:
	  printf("%s\n",getstr());
	  break;
	case R_PRINTIMAGE:
	  PrintImage();
	  break;
	case R_PRINTFRAME:
	  PrintFrame();
	  break;
	case R_PRINTSCAN:
	  PrintScan();
	  break;
	case R_COMPONENT:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_COMPONENTS-1,"Bad component reference");
	  if (ErrorValue) break;
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  CFrame->ComponentFileName[dest] = getstr();
	  value=getint();
	  InBounds(value,0,MAXIMUM_HORIZONTAL_FREQUENCY,
		   "Bad horizontal frequency");
	  if (ErrorValue) break;
	  CFrame->hf[dest]=value;
	  value=getint();
	  InBounds(value,0,MAXIMUM_VERTICAL_FREQUENCY,
		   "Bad vertical frequency");
	  if (ErrorValue) break;
	  CFrame->vf[dest]=value;
	  value=getint();
	  InBounds(value,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CFrame->tq[dest]=value;
	  CFrame->cn[CFrame->GlobalNumberComponents++]=dest;/*Know to use it*/
	  if (yylex()!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected right bracket.\n");
	      break;
	    }
	  ARRAYEND;
	  break;
	case R_SCAN:
	  CScan->NumberComponents=0;
	  ntoken=yylex();
	  ARRAYBEGIN;
	  if (CScan->NumberComponents>=MAXIMUM_SOURCES)
	    {
	      WHEREAMI();
	      printf("Exceeded number of sources per scan.\n");
	      break;
	    }
	  InBounds(yyint,0,MAXIMUM_COMPONENTS-1,"Bad component reference");
	  if (ErrorValue) break;
	  for(i=0;i<CFrame->GlobalNumberComponents;i++)  /* Check there */
            if (CFrame->cn[i]==yyint) break;
	  if (i==CFrame->GlobalNumberComponents)
	    {
	      WHEREAMI();
	      printf("Scan index not defined in frame yet.\n");
	      break;
	    }
	  CScan->ci[CScan->NumberComponents] = yyint;
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  value=getint();
	  InBounds(value,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CScan->td[CScan->NumberComponents]=value;
	  value=getint();
	  InBounds(value,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CScan->ta[CScan->NumberComponents]=value;
	  CScan->NumberComponents++;
	  if (yylex()!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected right bracket.\n");
	      break;
	    }
	  ARRAYEND;
	  break;
	case R_QUANTIZATION:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_DEVICES-1,
		   "Bad quantization reference.");
	  if (ErrorValue) break;
	  ntoken=yylex();
	  if (ntoken==R_LUMINANCEDEFAULT)
	    {
	      CImage->QuantizationMatrices[dest]=LuminanceQuantization;
	      break;
	    }
	  else if (ntoken==R_CHROMINANCEDEFAULT)
	    {
	      CImage->QuantizationMatrices[dest]=ChrominanceQuantization;
	      break;
	    }
	  else if (ntoken!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  CImage->NumberQuantizationMatrices =
	    MAX(CImage->NumberQuantizationMatrices,(dest+1));
	  if (!(ptr=(int *)calloc(64,sizeof(int))))
	    {
	      WHEREAMI();
	      printf("Cannot allocate quantization matrix.\n");
	      exit(ERROR_MEMORY);
	    }
	  CImage->NumberQuantizationMatrices =
	    MAX(CImage->NumberQuantizationMatrices,(dest+1));
	  CImage->QuantizationMatrices[dest]=ptr;
	  for(i=0;i<64;i++)
	    {
	      ptr[i]=16;
	    }
	  for(i=0;i<65;i++,ptr++) /* One additional to force r-bracket */
	    {
	      if ((ntoken=yylex())!=R_INTEGER) break;
	      InBounds(yyint,1,65535,"Integer out of bounds");
	      if (ErrorValue) yyint=16;
	      *ptr = yyint;
	    }
	  if (ntoken!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected integer or right bracket.\n");
	      break;
	    }
	  ARRAYEND;
	  break;
	case R_ACSEND:
	  ntoken=yylex();
	  if (ntoken==R_EMPTY)
	    {
	      CScan->NumberACTablesSend = 0;
	      break;
	    }
	  ARRAYBEGIN;
	  if (CScan->NumberACTablesSend>=MAXIMUM_DEVICES)
	    {
	      WHEREAMI();
	      printf("AC Huffman queue full.\n");
	      break;
	    }
	  InBounds(yyint,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CScan->sa[CScan->NumberACTablesSend++] = yyint;
	  ARRAYEND;
	  break;
	case R_DCSEND:
	  ntoken=yylex();
	  if (ntoken==R_EMPTY)
	    {
	      CScan->NumberDCTablesSend = 0;
	      break;
	    }
	  ARRAYBEGIN;
	  if (CScan->NumberDCTablesSend>=MAXIMUM_DEVICES)
	    {
	      WHEREAMI();
	      printf("DC Huffman queue full.\n");
	      break;
	    }
	  InBounds(yyint,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CScan->sd[CScan->NumberDCTablesSend++] = yyint;
	  ARRAYEND;
	  break;
	case R_QSEND:
	  ntoken=yylex();
	  if (ntoken==R_EMPTY)
	    {
	      CScan->NumberQTablesSend = 0;
	      break;
	    }
	  ARRAYBEGIN;
	  if (CScan->NumberQTablesSend>=MAXIMUM_DEVICES)
	    {
	      WHEREAMI();
	      printf("Quantization queue full.\n");
	      break;
	    }
	  InBounds(yyint,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  CScan->sq[CScan->NumberQTablesSend++] = yyint;
	  ARRAYEND;
	  break;
	case R_STREAMNAME:
	  CImage->StreamFileName = getstr();
	  break;
	case R_IMAGEWIDTH:
	  value=getint();
	  InBounds(value,0,MAXIMUM_IMAGE_WIDTH,"Bad image width");
	  CFrame->GlobalWidth = value;
	  break;
	case R_IMAGEHEIGHT:
	  value=getint();
	  InBounds(value,0,MAXIMUM_IMAGE_HEIGHT,"Bad image height");
	  CFrame->GlobalHeight = value;
	  break;
	case R_SCANDNL:
	  ntoken=yylex();
	  switch(ntoken)
	    {
	    case R_AUTO:
	      CFrame->InsertDnl= -2;
	      break;
	    case R_ENABLE:
	      CFrame->InsertDnl= -1;
	      break;
	    case R_INTEGER:
	      CFrame->InsertDnl = yyint;
	      break;
	    default:
	      WHEREAMI();
	      printf("Expected integer.\n");
	      break;
	    }
	  break;
	case R_FRAMEWIDTH:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_COMPONENTS-1,"Bad component destination");
	  if (ErrorValue) break;
	  value=getint();
	  InBounds(value,0,MAXIMUM_IMAGE_WIDTH,"Bad frame width");
	  if (ErrorValue) break;
	  CFrame->Width[dest] = value;
	  ARRAYEND;
	  break;
	case R_FRAMEHEIGHT:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_COMPONENTS-1,"Bad component destination");
	  if (ErrorValue) break;
	  value=getint();
	  InBounds(value,0,MAXIMUM_IMAGE_HEIGHT,"Bad frame height");
	  if (ErrorValue) break;
	  CFrame->Height[dest] = value;
	  ARRAYEND;
	  break;
	case R_RESYNC:
	  value = getint();
	  InBounds(value,0,MAXIMUM_RESYNC_INTERVAL,"Bad resync interval");
	  if (ErrorValue) break;
	  CFrame->ResyncInterval = value;
	  break;
	case R_BUFFER:
	  value = getint();
	  InBounds(value,MINIMUM_BUFFERSIZE,
		   MAXIMUM_BUFFERSIZE,"Bad buffersize");
	  if (ErrorValue) break;
	  CFrame->BufferSize = value;
	  break;
	case R_OPENSCAN:
	  CheckValidity();
	  CheckBaseline();
	  ConfirmFileSize();
	  MakeIob(IOB_BLOCK,O_RDONLY,1);
	  break;
	case R_CLOSESCAN:
	  for(i=0;i<CScan->NumberComponents;i++)  /* Close all components */
	    {
	      InstallIob(i);
	      CloseIob();
	    }
	  break;
	case R_OPENSTREAM:
	  if (CImage->StreamFileName)
	    {
	      swopen(CImage->StreamFileName,0);  /* Index 0 open */
	    }
	  else
	    {
	      printf("StreamFileName: Null. Failed\n");
	    }
	  break;
	case R_CLOSESTREAM:
	  swclose();
	  break;
	case R_FREQUENCY:
	  JpegFrequencyScan();
	  break;
	case R_WRITESPECIAL:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  value = yyint;
	  swbytealign();
	  bputc(0xFF);  /* Marker */
	  bputc(value&0xff);
	  Start = swtell();
	  bputw(0);
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      End = swtell();
	      swseek(Start);
	      bputw((End-Start) >> 3);
	      swseek(End);
	      break;
	    }
	  while((ntoken=yylex())==R_INTEGER)
	    {
	      bputc(yyint&0xff);
	    }
	  if (ntoken!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected integer or right bracket.\n");
	      End = swtell();
	      swseek(Start);
	      bputw((End-Start) >> 3);
	      swseek(End);
	      break;
	    }
	  End = swtell();
	  swseek(Start);
	  bputw((End-Start) >> 3);
	  swseek(End);
	  ARRAYEND;
	  break;
	case R_WRITEDIRECT:
	  swbytealign();
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  while((ntoken=yylex())==R_INTEGER)
	    {
	      bputc(yyint&0xff);
	    }
	  if (ntoken!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected integer or right bracket.\n");
	      break;
	    }
	  break;
	case R_WRITESCAN:
	  JpegEncodeScan();
	  break;
	case R_WRITEFRAME:
	  MakeConsistentFrameSize();  /* Do it here when everything defined */
	  WriteSof();
	  break;
	case R_WRITESOI:
	  WriteSoi();
	  break;
	case R_WRITEEOI:
	  WriteEoi();
	  break;
	case R_WRITEQUANTIZATION:
	  WriteDqt();
	  break;
	case R_WRITERESYNC:
	  WriteDri();
	  break;
	case R_WRITEDNL:
	  WriteDnl();
	  break;
	case R_WRITEHUFFMAN:
	  WriteDht();
	  break;
	case R_ACCUSTOM:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  MakeXhuff();
	  MakeEhuff();
	  if (!(ptr=(int *)calloc(257,sizeof(int))))
	    {
	      WHEREAMI();
	      printf("Out of custom frequency space.\n");
	      exit(ERROR_MEMORY);
	    }
	  for(i=0;i<257;i++)
	    {
	      ptr[i]=0;
	    }
	  while((ntoken=yylex())==R_INTEGER)
	    {
	      InBounds(yyint,0,MAXIMUM_SOURCES-1,"Bad frequency reference");
	      if(ErrorValue) yyint=0;
	      AddFrequency(ptr,CScan->ACFrequency[yyint]);
	    }
	  if (ntoken!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected right bracket.\n");
	      break;
	    }
	  MakeHuffman(ptr);
	  SetACHuffman(dest);
	  CImage->NumberACTables = 
	    MAX(CImage->NumberACTables,(dest+1));
	  ARRAYEND;
	  break;
	case R_DCCUSTOM:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  if (yylex()!=R_LBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected left bracket.\n");
	      break;
	    }
	  MakeXhuff();
	  MakeEhuff();
	  if (!(ptr=(int *)calloc(257,sizeof(int))))
	    {
	      WHEREAMI();
	      printf("Out of custom frequency space.\n");
	      exit(ERROR_MEMORY);
	    }
	  for(i=0;i<257;i++)
	    {
	      ptr[i]=0;
	    }
	  while((ntoken=yylex())==R_INTEGER)
	    {
	      InBounds(yyint,0,MAXIMUM_SOURCES-1,"Bad frequency reference");
	      if(ErrorValue) yyint=0;
	      AddFrequency(ptr,CScan->DCFrequency[yyint]);
	    }
	  if (ntoken!=R_RBRACKET)
	    {
	      WHEREAMI();
	      printf("Expected right bracket.\n");
	      break;
	    }
	  MakeHuffman(ptr);
	  SetDCHuffman(dest);
	  CImage->NumberDCTables = 
	    MAX(CImage->NumberDCTables,(dest+1));
	  ARRAYEND;
	  break;
	case R_ACSPEC:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  MakeXhuff();
	  MakeEhuff();
	  if ((ntoken=yylex())==R_LBRACKET)
	    {
	      if (!(ptr=(int *)calloc(38,sizeof(int)))) /* Get bits */
		{
		  WHEREAMI();
		  printf("Out of custom bits space.\n");
		  exit(ERROR_MEMORY);
		}
	      for(i=0;i<32;i++)
		{
		  ptr[i]=0;
		}
	      for(accum=0,i=0;i<17;i++) /* First index is bitlength of 1. */
		{                 /* One additional to force r-bracket. */
		  ntoken=yylex();
		  if (ntoken==R_INTEGER)
		    {
		      accum+=yyint;
		      ptr[i]=yyint;
		    }
		  else break;
		}
	      if (ntoken!=R_RBRACKET)
		{
		  WHEREAMI();
		  printf("Expected integer or right bracket.\n");
		  break;
		}
	      if (yylex()!=R_LBRACKET)  /* Get values */
		{
		  WHEREAMI();
		  printf("Expected left bracket.\n");
		  break;
		}
	      if (!(ptr2=(int *)calloc(257,sizeof(int))))
		{
		  WHEREAMI();
		  printf("Out of custom Huffman value space.\n");
		  exit(ERROR_MEMORY);
		}
	      for(i=0;i<257;i++)
		{
		  ptr2[i]=0;
		}
	      for(i=0;i<257;i++) /* One additinal to force r-bracket */
		{
		  ntoken=yylex();
		  if (ntoken==R_INTEGER)
		    {
		      ptr2[i]=yyint;
		    }
		  else break;
		}
	      if (i!=accum)
		{
		  WHEREAMI();
		  printf("Number of bitlengths != number of values.");
		}
	      if (ntoken!=R_RBRACKET)
		{
		  WHEREAMI();
		  printf("Expected integer or right bracket.\n");
		  break;
		}
	      SpecifiedHuffman(ptr,ptr2);
	    }
	  else if (ntoken==R_CHROMINANCEDEFAULT)
	    {
	      SpecifiedHuffman(ChrominanceACBits,ChrominanceACValues);
	    }
	  else if (ntoken==R_LUMINANCEDEFAULT)
	    {
	      SpecifiedHuffman(LuminanceACBits,LuminanceACValues);
	    }
	  else
	    {
	      WHEREAMI();
	      printf("Expected left bracket or ACDEFAULT.\n");
	      break;
	    }
	  SetACHuffman(dest);
	  CImage->NumberACTables = 
	    MAX(CImage->NumberACTables,(dest+1));
	  ARRAYEND;
	  break;
	case R_DCSPEC:
	  ntoken=yylex();
	  ARRAYBEGIN;
	  dest = yyint;
	  InBounds(dest,0,MAXIMUM_DEVICES-1,"Bad device reference");
	  if (ErrorValue) break;
	  MakeXhuff();
	  MakeEhuff();
	  if ((ntoken=yylex())==R_LBRACKET)
	    {
	      if (!(ptr=(int *)calloc(38,sizeof(int)))) /* Get bits */
		{
		  WHEREAMI();
		  printf("Out of custom bits space.\n");
		  exit(ERROR_MEMORY);
		}
	      for(i=0;i<32;i++)
		{
		  ptr[i]=0;
		}
	      for(accum=0,i=0;i<17;i++) /* First index is bitlength of 1. */
		{                /* 0-16 to force right bracket. */
		  ntoken=yylex();
		  if (ntoken==R_INTEGER)
		    {
		      accum+=yyint;
		      ptr[i]=yyint;
		    }
		  else break;
		}
	      if (ntoken!=R_RBRACKET)
		{
		  WHEREAMI();
		  printf("Expected integer or right bracket.\n");
		  break;
		}
	      if (yylex()!=R_LBRACKET)  /* Get values */
		{
		  WHEREAMI();
		  printf("Expected left bracket.\n");
		  break;
		}
	      if (!(ptr2=(int *)calloc(257,sizeof(int))))
		{
		  WHEREAMI();
		  printf("Out of custom Huffman value space.\n");
		  exit(ERROR_MEMORY);
		}
	      for(i=0;i<257;i++)
		{
		  ptr2[i]=0;
		}
	      for(i=0;i<257;i++) /*One additional to force r-bracket.*/
		{
		  ntoken=yylex();
		  if (ntoken==R_INTEGER)
		    {
		      ptr2[i]=yyint;
		    }
		  else break;
		}
	      if (i!=accum)
		{
		  WHEREAMI();
		  printf("Number of bitlengths != number of values.");
		}
	      if (ntoken!=R_RBRACKET)
		{
		  WHEREAMI();
		  printf("Expected integer or right bracket.\n");
		  break;
		}
	      SpecifiedHuffman(ptr,ptr2);
	    }
	  else if (ntoken==R_CHROMINANCEDEFAULT)
	    {
	      SpecifiedHuffman(ChrominanceDCBits,ChrominanceDCValues);
	    }
	  else if (ntoken==R_LUMINANCEDEFAULT)
	    {
	      SpecifiedHuffman(LuminanceDCBits,LuminanceDCValues);
	    }
	  else
	    {
	      WHEREAMI();
	      printf("Expected left bracket or DCDEFAULT.\n");
	      break;
	    }
	  SetDCHuffman(dest);
	  CImage->NumberDCTables = 
	    MAX(CImage->NumberDCTables,(dest+1));
	  ARRAYEND;
	  break;
	}
    }
}

/*NOPROTO*/
/*END*/

