/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- December 1997
 */

// GetPassword.cpp : implementation file
//

#include "stdafx.h"

#ifdef WIN32
#	include "wincvs.h"
#endif /* WIN32 */

#ifdef qMacCvsPP
#	include <UModalDialogs.h>
#	include <LEditText.h>

#	include "MacCvsApp.h"
#endif /* qMacCvsPP */

#if qUnix
#	include "UCvsDialogs.h"
#endif

#include "GetPassword.h"
#include "CPStr.h"

#ifdef WIN32
#	ifdef _DEBUG
#	define new DEBUG_NEW
#	undef THIS_FILE
	static char THIS_FILE[] = __FILE__;
#	endif
#endif /* WIN32 */

#ifdef WIN32
/////////////////////////////////////////////////////////////////////////////
// GetPassword dialog


GetPassword::GetPassword(CWnd* pParent /*=NULL*/)
	: CDialog(GetPassword::IDD, pParent)
{
	//{{AFX_DATA_INIT(GetPassword)
	m_passwd = _T("");
	//}}AFX_DATA_INIT
}


void GetPassword::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(GetPassword)
	DDX_Text(pDX, IDC_PASSWD, m_passwd);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(GetPassword, CDialog)
	//{{AFX_MSG_MAP(GetPassword)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// GetPassword message handlers
#endif /* WIN32 */

#if qUnix
class UCvsGetPasswd : public UWidget
{
	UDECLARE_DYNAMIC(UCvsGetPasswd)
public:
	UCvsGetPasswd() : UWidget(::UEventGetWidID()) {}
	virtual ~UCvsGetPasswd() {}

	enum
	{
		kOK = EV_COMMAND_START,	// 0
		kCancel,				// 1
		kPasswd					// 2
	};

	virtual void DoDataExchange(bool fill);

	UStr m_passwd;

protected:
	ev_msg int OnOK(void);
	ev_msg int OnCancel(void);

	UDECLARE_MESSAGE_MAP()
};

UIMPLEMENT_DYNAMIC(UCvsGetPasswd, UWidget)

UBEGIN_MESSAGE_MAP(UCvsGetPasswd, UWidget)
	ON_UCOMMAND(UCvsGetPasswd::kOK, UCvsGetPasswd::OnOK)
	ON_UCOMMAND(UCvsGetPasswd::kCancel, UCvsGetPasswd::OnCancel)
UEND_MESSAGE_MAP()

int UCvsGetPasswd::OnOK(void)
{
	EndModal(true);
	return 0;
}

int UCvsGetPasswd::OnCancel(void)
{
	EndModal(false);
	return 0;
}

void UCvsGetPasswd::DoDataExchange(bool fill)
{
	if(fill)
	{
	}
	else
	{
		UEventSendMessage(GetWidID(), EV_GETTEXT, kPasswd, &m_passwd);
	}
}
#endif // qUnix

char *CompatGetPassword(void)
{
#ifdef WIN32
	static char passwd[255];
	GetPassword gp;
	if(gp.DoModal() == IDOK)
	{
		strcpy(passwd, gp.m_passwd);
		return passwd;
	}
	return "";
#endif /* WIN32 */
#ifdef qMacCvsPP
	StDialogHandler	theHandler(dlg_Passwd, CMacCvsApp::app);
	LWindow *theDialog = theHandler.GetDialog();
	ThrowIfNil_(theDialog);
	static CPStr thepasswd;
	
	LEditText *passwd = dynamic_cast<LEditText*>
		(theDialog->FindPaneByID(item_GetPasswd));
	theDialog->SetLatentSub(passwd);
	
	theDialog->Show();
	MessageT hitMessage;
	while (true)
	{		// Let DialogHandler process events
		hitMessage = theHandler.DoDialog();
		
		if (hitMessage == msg_OK || hitMessage == msg_Cancel)
			break;
	}
	theDialog->Hide();
	
	if(hitMessage == msg_OK)
	{		
		char buf[512];
		Size len;
		passwd->GetText(buf, 511, &len);
		thepasswd.set(buf, len);
		return len == 0 ? (char *)"" : (char *)thepasswd;
	}
	return "";
#endif /* qMacCvsPP */
#if qUnix
	static char passwd[255];
	void *wid = UCreate_PasswdDlg();

	UCvsGetPasswd *dlg = new UCvsGetPasswd();
	UEventSendMessage(dlg->GetWidID(), EV_INIT_WIDGET, kUMainWidget, wid);	

	if(dlg->DoModal())
	{
		strcpy(passwd, dlg->m_passwd);
	}
	else
		strcpy(passwd, "");

	delete dlg;
	return passwd;
#endif // qUnix
}
