package GCPlugins::GCfilms::GCMovieClubNL;

###################################################
#
#  Copyright 2005-2009 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;

use GCPlugins::GCfilms::GCfilmsCommon;
use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginMovieClubNL;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^product_info\.php\?products_id=/)
                {
                    my $url = $attr->{href} . "&language=nl"; 
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{itemIdx}++ if ($self->{itemIdx} < 0) || ($url ne $self->{itemsList}[$self->{itemIdx}]->{url});
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (($attr->{src} =~ /images\/\w*\.jpg/) && ($attr->{border} eq "0") && (!$self->{inside}->{a}))
                {
                    $self->{curInfo}->{image} = "http://www.movieclub.be/catalog/" . $attr->{src} if !$self->{curInfo}->{image};
                }
            }
            elsif ($tagname eq "span")
            {
                $self->{insideName} = 1 if $attr->{class} eq "titrepers";
            }
            elsif ($tagname eq "font")
            {
                $self->{insideOrig} = 1 if ($attr->{size} eq "1") && ($attr->{color} eq "");
                $self->{insideDateOrSynopsis} = 1 if ($attr->{size} eq "2") && ($attr->{color} eq "");
            }
            elsif ($tagname eq "a")
            {
                $self->{insideActors} = 1 if $attr->{href} =~ /^product_infolist\.php\?person_id=[0-9]*&language_id=[0-9]&choice=1$/;
                $self->{insideDirector} = 1 if $attr->{href} =~ /^product_infolist\.php\?person_id=[0-9]*&language_id=[0-9]&choice=2$/;
                if ($attr->{href} =~ /^\/catalog\/default\.php\?cPath=([0-9]*)_[0-9]*$/)
                {
                    $self->{insideNat} = 1 if $1 eq '1100';
                    $self->{insideGenre} = 1 unless $1 eq '1100';
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{itemsList}[$self->{itemIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;
            $origtext =~ s/\n//g if !$self->{insideSynopsis};

           	if ($self->{insideName})
           	{
          	  $self->{curInfo}->{title} = $origtext;
							$self->{insideName} = 0;
						}
           	elsif ($self->{insideDateOrSynopsis})
           	{
							if ($origtext =~ /^[0-9]{4}$/)
							{
          	  	$self->{curInfo}->{date} = $origtext;
							}
							else
							{
          	  	$self->{curInfo}->{synopsis} = $origtext if !$self->{curInfo}->{synopsis};
							}
							$self->{insideDateOrSynopsis} = 0;
						}
           	elsif ($self->{insideActors})
           	{
              $self->{curInfo}->{actors} .= ', ' . $origtext
                if ($self->{actorsCounter} < $GCPlugins::GCfilms::GCfilmsCommon::MAX_ACTORS);
              $self->{actorsCounter}++;
              $self->{curInfo}->{actors} =~ s/^, //;
							$self->{insideActors} = 0;
						}
           	elsif ($self->{insideDirector})
           	{
                $self->{curInfo}->{director} .= ', ' .  $origtext;
                $self->{curInfo}->{director} =~ s/^, //;
                $self->{insideDirector} = 0;
            }
           	elsif ($self->{insideNat})
           	{
                $self->{curInfo}->{country} = $origtext if !$self->{curInfo}->{country};
                $self->{insideNat} = 0;
            }
           	elsif ($self->{insideGenre})
           	{
           	    $self->{curInfo}->{genre} .= ',' if $self->{curInfo}->{genre};
                $self->{curInfo}->{genre} .= $origtext;
                $self->{insideGenre} = 0;
            }            
          	elsif ($self->{insideTime})
           	{
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
           	elsif ($self->{insideOrig})
           	{
                $self->{curInfo}->{original} = $1 if $origtext =~ /\((.*)\)$/;
                $self->{insideOrig} = 0;
            }
            elsif ($self->{inside}->{strong})
            {
                $self->{insideTime} = 1 if $origtext =~ /Duur \:/;
            }
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 0,
            director => 0,
            actors => 0,
        };

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        $html =~ s/<a href=product_info\.php\?products_id=[0-9]*>Fiche zien<\/a>//g;
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.movieclub.be/catalog/advanced_search.php?titre=title&textfield=$word&language=nl";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.movieclub.be/catalog/" . $url;
    }

    sub getName
    {
        return "MovieClub NL";
    }
    
    sub getAuthor
    {
        return 'MeV';
    }

    sub getLang
    {
        return 'NL';
    }

}

1;
