package GCPlugins::GCfilms::GCAmazonDE;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCfilms::GCfilmsCommon;

{
    package GCPlugins::GCfilms::GCPluginAmazonDE;

    use base qw(GCPlugins::GCfilms::GCfilmsPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

	    if ($self->{parsingEnded})
        {
            if ($self->{itemIdx} < 0)
            {
                $self->{itemIdx} = 0;
                $self->{itemsList}[0]->{url} = $self->{loadedUrl};
            }
            return;
        }

        if ($self->{parsingList})
        {
            if ($tagname eq 'input')
            {
                $self->{beginParsing} = 1
                    if $attr->{src} =~ /go-button-search/;
            }
            return if ! $self->{beginParsing};
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m|/dp/[A-Z0-9]*/sr=([0-3]-[0-9]*)/qid=[0-9]*|)
                {
                    return if $self->{alreadyRetrieved}->{$1};
                    $self->{alreadyRetrieved}->{$1} = 1;
                    my $url = $attr->{href}; 
                    $self->{isMovie} = 1;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (($attr->{src} =~ m%^http://.*?images[.-]amazon\.com/images/P/[-A-Za-z0-9_.,]*?ZZZZZZZ(.*?)\.(jpg|gif)%)
                 && (!$self->{curInfo}->{image}))
                {
                    $self->{curInfo}->{image} = $attr->{src};
                    $self->{curInfo}->{image} =~ s%(.*?/images/P/[0-9]*\.)(.*?)(_SC.ZZZZZZZ_(.*?)\.(jpg|gif))%$1$3%;
                    $self->{curInfo}->{image} =~ s/_PE[0-9]{2}_/_/;
                }
            }
            elsif ($tagname eq "b")
            {
            	$self->{insideNameAndDate} = 1 if $attr->{class} eq "sans";
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
        return if ($self->{parsingEnded});

        if ($self->{parsingList})
        {
            if (($self->{inside}->{title})
            && ($origtext !~ /Amazon.de.? DVD Search Results/)
            && ($origtext !~ /Amazon.de\s*DVD:/))
            {
                $self->{parsingEnded} = 1;
            }
            if (
                (($self->{inside}->{b})
                || ($self->{inside}->{span}))            
             && ($origtext =~ /Sortieren nach/))
            {
                $self->{beginParsing} = 1;
                return;
            }
            return if ! $self->{beginParsing};
            if ($self->{isMovie})
            {
                $self->{itemsList}[$self->{itemIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                return;
            }
            elsif ($self->{inside}->{actors})
            {
                $self->{itemsList}[$self->{itemIdx}]->{actors} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{actors};
            }
            elsif ($self->{inside}->{director})
            {
                $self->{itemsList}[$self->{itemIdx}]->{director} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{director};
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;

            if ($self->{insideNameAndDate})
            {
                $self->{curInfo}->{title} = $origtext;
                $self->{insideNameAndDate} = 0;
            }
            elsif ($self->{insideActors})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{actors} = $origtext;
                $self->{insideActors} = 0;
            }
            elsif ($self->{insideAge})
            {
                $origtext =~ m/([0-9]{1,2})/;
                $self->{curInfo}->{age} = $1;
                $self->{insideAge} = 0;
            }
            elsif ($self->{insideDirector})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/,.$//;
                $self->{curInfo}->{director} = $origtext;
                $self->{insideDirector} = 0;
            }
            elsif ($self->{insideTime})
            {
                $origtext =~ s/^\s//;
                $origtext =~ s/\n//g;
                $self->{curInfo}->{time} = $origtext;
                $self->{insideTime} = 0;
            }
            elsif ($self->{insideSynopsis})
            {
                $self->{curInfo}->{synopsis} = $origtext;
                $self->{insideSynopsis} = 0;
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideActors} = 1 if $origtext =~ /Darsteller:/;
				$self->{insideDirector} = 1 if $origtext =~ /Regisseur\(e\):/;
				$self->{insideAge} = 1 if $origtext =~ /FSK:/;
				$self->{insideTime} = 1 if $origtext =~ /Spieldauer:/;
    			$self->{insideSynopsis} = 1 if $origtext =~ /VideoWoche/;
			}        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{hasField} = {
            title => 1,
            date => 0,
            director => 0,
            actors => 1,
        };

        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        if ($self->{parsingList})
        {
            $html =~ s|^\s+von\s+([^<]*)|<actors>$1</actors>|gm;
        }
        else
        {
            $html =~ s/(<i>|<\/i>)//gim;
            $html =~ s/(<ul>|<\/ul>)/\n/gim;
            $html =~ s/<li>([^<])/- $1/gim;
            $html =~ s|([^>])</li>|$1\n|gim;
            $html =~ s|<br ?/?>|\n|gi;
            $html =~ s|<a href="/gp/imdb/[^"]*">(.*?)</a>|$1|gm;
            #"
            $html =~ s/<a href="\/exec\/obidos\/search-handle-url\/index=dvd-de&field-(?:actor|director|keywords)=[^\/]*\/[-0-9]*">([^<]*)<\/a>/$1/gm;
        }

        $self->{parsingEnded} = 0;
        $self->{alreadyRetrieved} = {};
        $self->{beginParsing} = 0;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.amazon.de/gp/search/?redirect=true&search-alias=dvd&keywords=$word";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.amazon.de' if !$url;
        return $url;
    }

    sub getName
    {
        return "Amazon (DE)";
    }
    
    sub getImageFile
    {
        return "amazon.png";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'DE';
    }

}

1;
