package GCPlugins::GCbooks::GCAmazonDE;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;

use GCPlugins::GCbooks::GCbooksCommon;

{
    package GCPlugins::GCbooks::GCPluginAmazonDE;

    use base qw(GCPlugins::GCbooks::GCbooksPluginsBase);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

	    if ($self->{parsingEnded})
        {
            if ($self->{itemIdx} < 0)
            {
                $self->{itemIdx} = 0;
                $self->{itemsList}[0]->{url} = $self->{loadedUrl};
            }
            return;
        }

        if ($self->{parsingList})
        {
            if ($tagname eq 'input')
            {
                $self->{beginParsing} = 1
                    if $attr->{src} =~ /go-button-search/;
            }
            return if ! $self->{beginParsing};
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ m|/dp/[A-Z0-9]*/sr=([0-3]-[0-9]*)/qid=[0-9]*|)
                {
                    return if $self->{alreadyRetrieved}->{$1};
                    $self->{alreadyRetrieved}->{$1} = 1;
                    my $url = $attr->{href}; 
                    $self->{isBook} = 1;
                    $self->{itemIdx}++;
                    $self->{itemsList}[$self->{itemIdx}]->{url} = $url;
                }
            }
        }
        else
        {
            if ($tagname eq "img")
            {
                if (($attr->{src} =~ m%^http://.*?images[.-]amazon\.com/images/P/[-A-Za-z0-9_.,]*?ZZZZZZZ(.*?)\.(jpg|gif)%)
                 && (!$self->{curInfo}->{cover}))
                {
                    $self->{curInfo}->{cover} = $attr->{src};
                    $self->{curInfo}->{cover} =~ s%(.*?/images/P/[0-9X]*\.)(.*?)(_SC.ZZZZZZZ_(.*?)\.(jpg|gif))%$1$3%;
                    $self->{curInfo}->{cover} =~ s/_PE[0-9]{2}_/_/;
                }
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;
        return if ($self->{parsingEnded});

        if ($self->{parsingList})
        {
            if (($self->{inside}->{title})
            && ($origtext !~ /Amazon.com.*? B.+?cher/)
            && ($origtext !~ /Amazon.de B.+?cher:/))
            {
                $self->{parsingEnded} = 1;
            }
            if (
                (($self->{inside}->{b})
                || ($self->{inside}->{span}))            
             && ($origtext =~ /Sortieren nach/))
            {
                $self->{beginParsing} = 1;
                return;
            }
            return if ! $self->{beginParsing};
            if ($self->{isBook})
            {
                return if length($origtext) < 2;
                $self->{itemsList}[$self->{itemIdx}]->{title} = $origtext;
                $self->{isBook} = 0;
                return;
            }
            elsif ($self->{inside}->{author})
            {
                $origtext =~ s/von //;
                $self->{itemsList}[$self->{itemIdx}]->{authors} = $origtext
                    if ! $self->{itemsList}[$self->{itemIdx}]->{authors};
            }
            elsif ($self->{inside}->{publication})
            {
                $self->{itemsList}[$self->{itemIdx}]->{publication} = $origtext;
            }
            elsif ($self->{inside}->{format})
            {
                $self->{itemsList}[$self->{itemIdx}]->{format} = $origtext;
            }
        }
       	else
        {
			$origtext =~ s/^\s*//;
            $origtext =~ s/\s*$//;
            if ($self->{inside}->{title})
            {
                $origtext =~ m/Amazon.de: (.*?): (B.+?cher|English Books): (.*)$/;
	            $self->{curInfo}->{title} = $1;
	            $self->{curInfo}->{authors} = $3;
            }
            elsif ($self->{insideDesc})
            {
                $self->{curInfo}->{description} = $origtext;
                $self->{insideDesc} = 0;
            }
            elsif ($self->{insidePublisher})
            {
                $origtext =~ /^\s*(.*?)\(([^(]*?)\)$/;
                $self->{curInfo}->{publication} = $2;
                my @array = split /;\s*/, $1;
                $self->{curInfo}->{publisher} = $array[0];
                $self->{curInfo}->{edition} = $array[1];
                $self->{insidePublisher} = 0;
                $self->{curInfo}->{publication} =~ s|([0-9]*)\.*\s*(.*)\.*\s+([0-9]*)|($1?$1.'/':'').($2?$self->{monthNumber}->{$2}.'/':'').$3|e;
            }
            elsif ($self->{insideLanguage})
            {
                $self->{curInfo}->{language} = $origtext;
                $self->{insideLanguage} = 0;
            }
            elsif ($self->{insideIsbn})
            {
                $self->{curInfo}->{isbn} = $origtext;
                $self->{insideIsbn} = 0;
            }
            elsif ($self->{insidePages})
            {
                $self->{curInfo}->{pages} = $origtext;
                $self->{insidePages} = 0;
            }
            elsif ($self->{inside}->{b})
            {
                $self->{insideDesc} = 1 if $origtext eq 'Kurzbeschreibung' 
                                        || $origtext eq 'Amazon.de'
                                        || $origtext eq 'Aus der Amazon.de-Redaktion';
                $self->{insidePublisher} = 1 if $origtext =~ /Verlag:/;
				$self->{insideLanguage} = 1 if $origtext =~ /Sprache:/;
				$self->{insideIsbn} = 1 if $origtext =~ /ISBN:/;
				if ($self->{insideDetails})
                {
                    $origtext =~ s/:$//;
                    $self->{curInfo}->{format} = $origtext;
                    $self->{insidePages} = 1;
                    $self->{insideDetails} = 0;
                }
				$self->{insideDetails} = 1 if $origtext eq 'Produktinformation';
            }        
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{monthNumber} = {
			'Jan' => '01',
            Januar => '01',
			'Feb' => '02', 
            Februar => '02',
			'Mär' => '03',
            'März' => '03',
			'Apr' => '04',
            'April' => '04',
            'Mai' => '05',
			'Jun' => '06',
            'Juni' => '06',
			'Jul' => '07',
            'Juli' => '07',
			'Aug' => '08',
            'August' => '08',
			'Sep' => '09',
            'September' => '09',
			'Okt' => '10',
            'Oktober' => '10',
			'Nov' => '11',
            'November' => '11',
			'Dez' => '12',
            'Dezember' => '12'

        };

        $self->{hasField} = {
            title => 1,
            authors => 1,
            publication => 1,
            format => 1,
            edition => 0,
        };

        $self->{isBook} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
		
		$html =~ s/&nbsp;/ /g;

        if ($self->{parsingList})
        {
            $html =~ s|^\s+von(.*)$|<author>$1</author>|gm;
            $html =~ s|<span class="bindingBlock">\(<span class="binding">(.*?)</span> - (.*?[0-9]{4})\)</span>|<format>$1</format><publication>$2</publication>|gsm;
        }
        else
        {
            $html =~ s/(<i>|<\/i>)//gim;
            $html =~ s/(<ul>|<\/ul>)/\n/gim;
            $html =~ s/<li>([^<])/- $1/gim;
            $html =~ s|([^>])</li>|$1\n|gm;
            $html =~ s|<br ?/?>|\n|gi;
            $self->{insideDesc} = 0;
            $self->{insidePublisher} = 0;
            $self->{insideLanguage} = 0;
            $self->{insideSerie} = 0;
            $self->{insidePages} = 0;
            $self->{insideIsbn} = 0;
#        print "$html\n";
        }
        
        $self->{parsingEnded} = 0;
        $self->{alreadyRetrieved} = {};
        $self->{beginParsing} = 0;
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.amazon.de/gp/search/?redirect=true&search-alias=books&keywords=$word";
    }
    
    sub getItemUrl
    {
		my ($self, $url) = @_;
		
        return 'http://www.amazon.de' if !$url;
        return $url;
    }

    sub getName
    {
        return "Amazon (DE)";
    }
    
    sub getImageFile
    {
        return "amazon.png";
    }
	
    sub getAuthor
    {
        return 'frenkx';
    }
    
    sub getLang
    {
        return 'DE';
    }

}

1;
