package GCImport::GCImportTarGz;

###################################################
#
#  Copyright 2005-2006 Tian
#
#  This file is part of GCstar.
#
#  GCstar is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCstar is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCstar; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use GCImport::GCImportBase;

{
    package GCImport::GCImporterTarGz;

    use base qw(GCImport::GCImportBaseClass);
 
    use File::Spec;

    use File::Temp qw/ tempfile tempdir /;
    use Cwd;
    use File::Copy;
    
    #use GCData;

    
    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        eval "use Compress::Zlib"; my $hasZlib = $@ ? 0 : 1;
        eval "use Archive::Tar"; my $hasTar = $@ ? 0 : 1;
        eval "use File::Path"; my $hasPath = $@ ? 0 : 1;

        $self->{errors} = '';
        $self->{errors} .= "Compress::Zlib\n" if (!$hasZlib);
        $self->{errors} .= "Archive::Tar\n" if (!$hasTar);
        $self->{errors} .= "File::Path\n" if (!$hasPath);

        return $self;
    }

    sub getName
    {
        return ".tar.gz";
    }
    
    sub getFilePatterns
    {
       return (['Tar gzip (.tar.gz)', '*.tar.gz']);
    }
    
    sub getModelName
    {
        my $self = shift;
        
        return $self->{extractedModel};
    }

    sub getOptions
    {
        my $self = shift;
        my @options;
        return \@options;
    }
    
    # Ignored for the moment
    sub wantsFieldsSelection
    {
        return 0;
    }
    sub getEndInfo
    {
        return "";
    }
    
    sub getItemsArray
    {
        my ($self, $file) = @_;
        
        my ($tarFh, $tarFilename) = tempfile();

        my $gz = gzopen($file, "rb");
        my $buffer;
        print $tarFh $buffer while $gz->gzread($buffer) > 0 ;
        close $tarFh;
        $gz->gzclose;
        
        my $tmpDir = tempdir();
        my $oldCwd = getcwd;
        chdir $tmpDir;
        my $tar = Archive::Tar->new($tarFilename);
        $tar->extract;
        my $listFile = './collection.gcs';
        
        my $loader = new GCItems($self->{options}->{parent});
        
        $loader->load($listFile, undef, undef, 1);
        $loader->{model} = $self->{options}->{parent}->{model};
        $self->{modelAlreadySet} = 1;
        $self->{extractedModel} = $loader->{model}->getName;

        #Copying pictures
        foreach (@{$loader->{itemArray}})
        {
            my $title = $_->{$loader->{model}->{commonFields}->{title}};
            foreach my $field(@{$loader->{model}->{fieldsImage}})
            {
                (my $suffix = $_->{$field}) =~ s/.*?(\.[^.]*)$/$1/;
                my $imageFile = $self->{options}->{parent}->getUniqueImageFileName($suffix, $title);
                copy($_->{$field}, $imageFile)
                        if $_->{$field};
                $_->{$field} = $imageFile;
            }
        }

        chdir $oldCwd;
        File::Path::rmtree($tmpDir);
        unlink $tarFilename;
        
        return $loader->{itemArray};
    }
}

1;
