/*
** Copyright (C) 03 Jan 2001 Jonas Munsin <jmunsin@iki.fi>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <gtk/gtk.h>

#include "common_gtk.h"
#include "vector_commands.h"
#include "extra_options.h"
#include "mainwindow.h"
#include "globals.h"

static GList *cdrecord_list = NULL;
static GList *mkisofs_list = NULL;

/* start common functions */

static GList *add_extra_option(GtkWidget *combo, GList *list) {
	char *text;

	text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));

	if (strlen(text) == 0)
		return list;

	list = g_list_append(list, g_strdup(text));
	gtk_combo_set_popdown_strings(GTK_COMBO(combo), list);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry), "");
	return list;
}

static GList *del_option(GtkWidget *combo, GList *list) {
	char *text;
	int i, l;
	GList *tmp;

	text = gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
	if ((strlen(text) == 0) || (list == NULL))
		return list;

	l = g_list_length(list);
	tmp = list;
	for(i = 0; i < l; i++) {
		if (strcmp(tmp->data, text) == 0) {
			list = g_list_remove(list, tmp->data);
			g_free(tmp->data);
			l--;
			break;
		}
		tmp = tmp->next;
	}

	if (list == NULL) {
		list = g_list_append(list, g_strdup(""));
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), list);
		g_free(list->data);
		list = NULL;
	} else
		gtk_combo_set_popdown_strings(GTK_COMBO(combo), list);

	return list;
}

static GtkWidget *add_combo(GtkWidget *hbox, char *tt) {
	GtkWidget *combo;
	combo = gtk_combo_new();
	gtk_widget_show(combo);
	gtk_tooltips_set_tip(tooltips, GTK_COMBO(combo)->entry, tt, NULL);
	return combo;
}

/* end common functions */

/* callbacks */

static void add_extra_burn(GtkWidget *entry, gpointer combo) {
	cdrecord_list = add_extra_option(GTK_WIDGET(combo), cdrecord_list);
}

static void del_extra_burn_clicked(GtkWidget *button, gpointer combo) {
	cdrecord_list = del_option(GTK_WIDGET(combo), cdrecord_list);
}

static void add_extra_mkisofs(GtkWidget *entry, gpointer combo) {
	mkisofs_list = add_extra_option(GTK_WIDGET(combo), mkisofs_list);
}

static void del_extra_mkisofs_clicked(GtkWidget *button, gpointer combo) {
	mkisofs_list = del_option(GTK_WIDGET(combo), mkisofs_list);
}

/* end callbacks */

void create_extra_burn(GtkWidget *hbox) {
	GtkWidget *combo, *label;
	GtkWidget *del;

	del = gtk_button_new_with_label(_("Del"));
	gtk_tooltips_set_tip(tooltips, del, _("Remove selected option"), NULL);
	gtk_widget_show(del);
	gtk_box_pack_end(GTK_BOX(hbox), del, FALSE, FALSE, 0);

	combo = add_combo(hbox, _("Additional flags to cdrecord Here you can specify "
				"custom flags to cdrecord not available directly through "
				"gcombust. Write a flag in the text entry, and press return "
				"to add it. Due to implementation details and lack of time "
				"on gcombust author's part, it is possible that "
				"you have to specify flags containing spaces as seperate "
				"entries."));
	gtk_box_pack_end(GTK_BOX(hbox), combo, FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry), "activate",
			GTK_SIGNAL_FUNC(add_extra_burn), combo);
	gtk_signal_connect(GTK_OBJECT(del), "clicked",
			GTK_SIGNAL_FUNC(del_extra_burn_clicked), combo);

	label = gtk_label_new(_("Custom cdrecord options:"));
	gtk_widget_show(label);
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
}

void create_extra_mkisofs(GtkWidget *frame) {
	GtkWidget *hbox;
	GtkWidget *combo;
	GtkWidget *del;

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(frame), hbox);

	combo = add_combo(hbox, _("Additional flags to mkisofs. Here you can specify "
				"custom flags to mkisofs not available directly through "
				"gcombust. Write a flag in the text entry, and press return "
				"to add it. Due to implementation details and lack of time "
				"on gcombust author's part, it is likely that "
				"you have to specify flags containing spaces as seperate "
				"entries. For example, to add the flag \"-jcharset cp866\", "
				"first add -jcharset, then cp866."));
	gtk_box_pack_start(GTK_BOX(hbox), combo, FALSE, FALSE, 0);

	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry), "activate",
			GTK_SIGNAL_FUNC(add_extra_mkisofs), combo);

	del = gtk_button_new_with_label(_("Del"));
	gtk_tooltips_set_tip(tooltips, del, _("Remove selected option"), NULL);
	gtk_widget_show(del);
	gtk_box_pack_start(GTK_BOX(hbox), del, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(del), "clicked",
			GTK_SIGNAL_FUNC(del_extra_mkisofs_clicked), combo);
}

/* cmd_v functions */

static void add_item_to_cmd(gpointer data, gpointer cmd) {
	add_option_to_cmd(cmd, data);
}

void add_extra_burn_options(cmd_v *cmd) {
	g_list_foreach(cdrecord_list, add_item_to_cmd, cmd);
}

void add_extra_mkisofs_options(cmd_v *cmd) {
	g_list_foreach(mkisofs_list, add_item_to_cmd, cmd);
}

