/*
  GNOME Comics Organizer
  Copyright (C) 1999-2001 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <glade/glade.h>

#include "comiclist.h"
#include "functions.h"

extern GladeXML *xml;
extern GString *GLADE_FILE;
extern GList *ComicList;

extern gchar *current_filename;
extern gboolean file_changed;

extern gchar *MainWindowKey;
extern gchar *ComicListKey;
extern gchar *ComicToAddKey;
extern gchar *ComicToAddToKey;
extern gchar *ComicToEditKey;
extern gchar *IssueToEditKey;

extern GCompareFunc TComicCompare;

extern GList *publisher_history;
extern GList *type_history;
extern GList *group_history;

void on_Add_Comic_OK_Button_clicked (GtkButton *button, gpointer user_data)
{
  GString *GSTemp;

  TComic *ComicToAdd, *ComicToEdit;
  GtkWidget *add_comic_window, *CTitle_Entry, *Gnome_CPublisher_Entry, *Gnome_CType_Entry,
    *Gnome_CGroup_Entry, *Comment_Entry, *Volume_Entry;
  GladeXML *temp_xml = user_data;

  add_comic_window = glade_xml_get_widget (temp_xml, "add_comic_window");
  CTitle_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Title_Entry");
  Gnome_CPublisher_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Publisher_Combo-entry");
  Gnome_CType_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Type_Combo-entry");
  Gnome_CGroup_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Group_Combo-entry");
  Comment_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Comment_Entry");
  Volume_Entry = glade_xml_get_widget (temp_xml, "Add_Comic_Comic_Volume_Spinbutton");

  ComicToEdit = gtk_object_get_data (GTK_OBJECT (add_comic_window), ComicToEditKey);
  if (ComicToEdit!=NULL) ComicToAdd = ComicToEdit;
  else ComicToAdd = Init_Comic();

  g_string_assign(ComicToAdd->CTitle,
		  gtk_entry_get_text(GTK_ENTRY (CTitle_Entry)));
  g_string_assign(ComicToAdd->CPublisher,
		  gtk_entry_get_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CPublisher_Entry)))));
  g_string_assign(ComicToAdd->CType,
		  gtk_entry_get_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CType_Entry)))));
  g_string_assign(ComicToAdd->CGroup,
		  gtk_entry_get_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CGroup_Entry)))));
  g_string_assign(ComicToAdd->Comment,
		  gtk_entry_get_text(GTK_ENTRY (Comment_Entry)));
  g_string_sprintf(ComicToAdd->CVolume, "%i", gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (Volume_Entry)));

  GSTemp = g_string_new (ComicToAdd->CPublisher->str);
  publisher_history = g_list_insert_str_sorted_unique (publisher_history, GSTemp);
  GSTemp = g_string_new (ComicToAdd->CType->str);
  type_history = g_list_insert_str_sorted_unique (type_history, GSTemp);
  GSTemp = g_string_new (ComicToAdd->CGroup->str);
  group_history = g_list_insert_str_sorted_unique (group_history, GSTemp);

  if (ComicToEdit!=NULL) ComicList = g_list_sort(ComicList, TComicCompare);
  else ComicList = g_list_insert_sorted(ComicList, ComicToAdd, TComicCompare);

  file_changed = TRUE;

  /* refresh the screen */
  refresh_comics_list(add_comic_window);

  /* select the title we just added/edited */
  if (ComicToEdit) exp_set_selected_title(add_comic_window, ComicToEdit);
  else exp_set_selected_title(add_comic_window, ComicToAdd);

  gtk_widget_destroy(add_comic_window);
}

void on_Add_Comic_Cancel_Button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *add_comic_window;
  GladeXML *temp_xml = user_data;

  add_comic_window = glade_xml_get_widget(temp_xml, "add_comic_window");
  gtk_widget_destroy(add_comic_window);
}


gboolean on_add_comic_window_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
  GtkWidget *add_comic_window;
  GladeXML *temp_xml = user_data;

  add_comic_window = glade_xml_get_widget(temp_xml, "add_comic_window");
  gtk_widget_destroy(add_comic_window);

  return FALSE;
}

void on_add_comic_window_show (GtkWidget *widget, gpointer user_data)
{
  TComic *ComicToEdit;
  GtkWidget *add_comic_window, *CTitle_Entry, *Gnome_CPublisher_Entry, *Gnome_CType_Entry,
    *Gnome_CGroup_Entry, *Comment_Entry, *Volume_Entry;
  GladeXML *temp_xml = user_data;

  add_comic_window = glade_xml_get_widget(temp_xml, "add_comic_window");

  CTitle_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Title_Entry");
  Gnome_CPublisher_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Publisher_Combo-entry");
  Gnome_CType_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Type_Combo-entry");
  Gnome_CGroup_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Group_Combo-entry");
  Comment_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Comment_Entry");
  Volume_Entry = glade_xml_get_widget(temp_xml, "Add_Comic_Comic_Volume_Spinbutton");

  gnome_entry_set_history (GNOME_ENTRY (Gnome_CPublisher_Entry), publisher_history);
  gnome_entry_set_history (GNOME_ENTRY (Gnome_CType_Entry), type_history);
  gnome_entry_set_history (GNOME_ENTRY (Gnome_CGroup_Entry), group_history);

  ComicToEdit = gtk_object_get_data (GTK_OBJECT (add_comic_window), ComicToEditKey);
  if (ComicToEdit!=NULL)
    {
      gtk_entry_set_text(GTK_ENTRY (CTitle_Entry), 
			 ComicToEdit->CTitle->str);
      gtk_entry_set_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CPublisher_Entry))), 
			 ComicToEdit->CPublisher->str);
      gtk_entry_set_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CType_Entry))), 
			 ComicToEdit->CType->str);
      gtk_entry_set_text(GTK_ENTRY (gnome_entry_gtk_entry(GNOME_ENTRY (Gnome_CGroup_Entry))), 
			 ComicToEdit->CGroup->str);
      gtk_entry_set_text(GTK_ENTRY (Comment_Entry), 
			 ComicToEdit->Comment->str);
      gtk_spin_button_set_value(GTK_SPIN_BUTTON (Volume_Entry), atof(ComicToEdit->CVolume->str));
    }
}

GtkWidget *new_title_activate(GtkWidget *generic, gchar *title, gboolean show)
{
  GtkWindow *main_window, *add_comic_window = NULL;
  GladeXML *temp_xml;

  /* Create Window */
  temp_xml = glade_xml_new (GLADE_FILE->str, "add_comic_window");
  add_comic_window = (GtkWindow *) glade_xml_get_widget (temp_xml, "add_comic_window");

  /* FIXME - make a small function to do the signal connecting */
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "Add_Comic_OK_Button")), "clicked",
			   GTK_SIGNAL_FUNC(on_Add_Comic_OK_Button_clicked), NULL,
			   GTK_OBJECT(temp_xml), (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(glade_xml_get_widget (temp_xml, "Add_Comic_Cancel_Button")), "clicked",
			   GTK_SIGNAL_FUNC(on_Add_Comic_Cancel_Button_clicked), NULL,
			   GTK_OBJECT(temp_xml), (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(add_comic_window), "delete_event",
			   GTK_SIGNAL_FUNC(on_add_comic_window_delete_event), NULL,
			   GTK_OBJECT(temp_xml), (GtkDestroyNotify)gtk_object_unref,
			   FALSE, FALSE);
  gtk_signal_connect_full (GTK_OBJECT(add_comic_window), "show",
			   GTK_SIGNAL_FUNC(on_add_comic_window_show), NULL,
			   GTK_OBJECT(temp_xml), NULL,
			   FALSE, FALSE);

  /* set main window as transient, so we can grab it later for refreshes */
  main_window = (GtkWindow *) glade_xml_get_widget (xml, "main_window");
  gtk_window_set_transient_for(add_comic_window, main_window);

  /* we can perform these actions on behalf of the caller, or let the caller
   * finish the details up.
   */
  if (title) gtk_window_set_title (add_comic_window, title);
  if (show) gtk_widget_show(GTK_WIDGET(add_comic_window));

  return GTK_WIDGET(add_comic_window);
}

void edit_title_activate(GtkWidget *generic)
{
  GtkWidget *add_comic_window, *comics_tree;
  GList *SelectedItem, *TempComicGList;
  TComic *ComicToEdit;

  comics_tree = glade_xml_get_widget (xml, "comics_tree");
  SelectedItem = GTK_TREE_SELECTION (comics_tree);

  if (SelectedItem != NULL) 
    { 
      TempComicGList = gtk_object_get_data (GTK_OBJECT (SelectedItem->data), ComicListKey);
      
      ComicToEdit = TempComicGList->data;

      if (ComicToEdit->IsLink == FALSE)
	{
	  add_comic_window = new_title_activate(generic, "Edit Comic", FALSE);
	  gtk_object_set_data (GTK_OBJECT (add_comic_window), ComicToEditKey, ComicToEdit);
          gtk_widget_show(add_comic_window);
	}
      else
	{
	  /* FIXME - Edit file link */
	}
    }
}
