/*
  GNOME Comics Organizer
  Copyright (C) 1999-2000 Maxximum Software
   
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ctype.h>
#include <stdlib.h>
#include <glib.h>
#include "fileops.h"
#include "functions.h"
#include "comiclist.h"

const gchar *CO19Ident     = "CO19_File";
const gchar *GCO_0_1_Ident = "GCO_0_1__";
const gchar *GCO_0_3_Ident = "GCO_0_3__";

GList *LoadCO19(GList *ComicList, FILE *fp)
{
  int c;
  TComic *TempComic;
  TIssue *TempIssue;
  GString * TempString;

  while((c=getc(fp))!=EOF)
    {
      ungetc(c, fp);
      TempComic = Init_Comic();

      while((c=getc(fp))!='\x00')
	{
	  TempComic->CTitle = g_string_append_c(TempComic->CTitle, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CPublisher = g_string_append_c(TempComic->CPublisher, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CType = g_string_append_c(TempComic->CType, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CVolume = g_string_append_c(TempComic->CVolume, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CGroup = g_string_append_c(TempComic->CGroup, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->Comment = g_string_append_c(TempComic->Comment, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->LinkFile = g_string_append_c(TempComic->LinkFile, c);
	}
      TempComic->IsLink = (TempComic->LinkFile->len>0);

      /* Now load the Issues */
      while((c=getc(fp))!='\x00')
	{
	  ungetc(c,fp);

	  TempIssue = Init_Issue();

  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->IssueNo = g_string_append_c(TempIssue->IssueNo, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Writer = g_list_append(TempIssue->Writer, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Penciller = g_list_append(TempIssue->Penciller, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Inker = g_list_append(TempIssue->Inker, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Title = g_list_append(TempIssue->Title, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Location = g_string_append_c(TempIssue->Location, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Price = g_string_append_c(TempIssue->Price, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->CurrentPrice = g_string_append_c(TempIssue->CurrentPrice, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Image = g_string_append_c(TempIssue->Image, c);
  	    } 

	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  if (strcmp(TempString->str, "Poor (P)")==0)
	    TempIssue->Condition = 0;
	  if (strcmp(TempString->str, "Fair (FR)")==0)
	    TempIssue->Condition = 1;
	  if (strcmp(TempString->str, "Good (G)")==0) 
	    TempIssue->Condition = 2;
	  if (strcmp(TempString->str, "Very Good (VG)")==0)
	    TempIssue->Condition = 3;
	  if (strcmp(TempString->str, "Fine (F)")==0)
	    TempIssue->Condition = 4;
	  if (strcmp(TempString->str, "Fine-Very Fine (VFV)")==0)
	    TempIssue->Condition = 5;
	  if (strcmp(TempString->str, "Very Fine (VF)")==0)
	    TempIssue->Condition = 6;
	  if (strcmp(TempString->str, "Near Mint (NM)")==0)
	    TempIssue->Condition = 7;
	  if (strcmp(TempString->str, "Mint (M)")==0)
	    TempIssue->Condition = 8;


  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Comment = g_string_append_c(TempIssue->Comment, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      /*
	      TempIssue->Date = g_string_append_c(TempIssue->Date, c);
	      */

	      /* FIXME - doesn't import dates... */
  	    } 

	  /* Now the TIssue structure is filled - then insert into list */
	  TempComic->IssueNumbers = g_list_insert_sorted(TempComic->IssueNumbers, TempIssue,
							 CompareTIssue_IssueNo);
	}
      
      /* Now the TComic structure is filled - then insert into list */
      ComicList = g_list_insert_sorted(ComicList, TempComic, CompareTComic_Title);
    }

  return ComicList;
}

GList *LoadGCO_0_1(GList *ComicList, FILE *fp)
{
  /* Read largest used UID and set it using SetUID() */
  /* Read ComicList (remember to read the UIDs of the individual Comics and Issues, etc.) */
  int c;
  guint32 LargestUID;
  TComic *TempComic;
  TIssue *TempIssue;
  GString * TempString;

  TempString = g_string_new(NULL);
  while((c=getc(fp))!='\x00')
    {
      TempString = g_string_append_c(TempString, c);
    }
  LargestUID = atof(TempString->str);
  g_string_free(TempString, TRUE);

  while((c=getc(fp))!=EOF)
    {
      ungetc(c, fp);
      TempComic = Init_Comic();

      while((c=getc(fp))!='\x00')
	{
	  TempComic->CTitle = g_string_append_c(TempComic->CTitle, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CPublisher = g_string_append_c(TempComic->CPublisher, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CType = g_string_append_c(TempComic->CType, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CVolume = g_string_append_c(TempComic->CVolume, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CGroup = g_string_append_c(TempComic->CGroup, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->Comment = g_string_append_c(TempComic->Comment, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->LinkFile = g_string_append_c(TempComic->LinkFile, c);
	}
      TempComic->IsLink = (TempComic->LinkFile->len>0);
      TempString = g_string_new(NULL);
      while((c=getc(fp))!='\x00')
	{
	  TempString = g_string_append_c(TempString, c);
	}
      TempComic->UID = atof(TempString->str);
      g_string_free(TempString, TRUE);

      /* Now load the Issues */
      while((c=getc(fp))!='\x00')
	{
	  ungetc(c,fp);
	  TempIssue = Init_Issue();

  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->IssueNo = g_string_append_c(TempIssue->IssueNo, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Writer = g_list_append(TempIssue->Writer, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Penciller = g_list_append(TempIssue->Penciller, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Inker = g_list_append(TempIssue->Inker, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Title = g_list_append(TempIssue->Title, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Location = g_string_append_c(TempIssue->Location, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Price = g_string_append_c(TempIssue->Price, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->CurrentPrice = g_string_append_c(TempIssue->CurrentPrice, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Image = g_string_append_c(TempIssue->Image, c);
  	    } 
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->Condition = atof(TempString->str);
	  g_string_free(TempString, TRUE);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Comment = g_string_append_c(TempIssue->Comment, c);
  	    } 
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->Date = atof(TempString->str);
	  g_string_free(TempString, TRUE);
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->UID = atof(TempString->str);
	  g_string_free(TempString, TRUE);

	  /* Now the TIssue structure is filled - then insert into list */
	  TempComic->IssueNumbers = g_list_insert_sorted(TempComic->IssueNumbers, TempIssue,
							 CompareTIssue_IssueNo);
	}
      /* Now the TComic structure is filled - then insert into list */
      ComicList = g_list_insert_sorted(ComicList, TempComic, CompareTComic_Title);
    }

  SetUID(LargestUID);
  return ComicList;
}

GList *LoadGCO_0_3(GList *ComicList, FILE *fp)
{
  /* Read largest used UID and set it using SetUID() */
  /* Read ComicList (remember to read the UIDs of the individual Comics and Issues, etc.) */
  int c;
  guint32 LargestUID;
  TComic *TempComic;
  TIssue *TempIssue;
  GString * TempString;

  TempString = g_string_new(NULL);
  while((c=getc(fp))!='\x00')
    {
      TempString = g_string_append_c(TempString, c);
    }
  LargestUID = atof(TempString->str);
  g_string_free(TempString, TRUE);

  while((c=getc(fp))!=EOF)
    {
      ungetc(c, fp);
      TempComic = Init_Comic();

      while((c=getc(fp))!='\x00')
	{
	  TempComic->CTitle = g_string_append_c(TempComic->CTitle, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CPublisher = g_string_append_c(TempComic->CPublisher, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CType = g_string_append_c(TempComic->CType, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CVolume = g_string_append_c(TempComic->CVolume, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->CGroup = g_string_append_c(TempComic->CGroup, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->Comment = g_string_append_c(TempComic->Comment, c);
	}
      while((c=getc(fp))!='\x00')
	{
	  TempComic->LinkFile = g_string_append_c(TempComic->LinkFile, c);
	}
      TempComic->IsLink = (TempComic->LinkFile->len>0);
      TempString = g_string_new(NULL);
      while((c=getc(fp))!='\x00')
	{
	  TempString = g_string_append_c(TempString, c);
	}
      TempComic->UID = atof(TempString->str);
      g_string_free(TempString, TRUE);

      /* Now load the Issues */
      while((c=getc(fp))!='\x00')
	{
	  ungetc(c,fp);
	  TempIssue = Init_Issue();

  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->IssueNo = g_string_append_c(TempIssue->IssueNo, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Writer = g_list_append(TempIssue->Writer, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Penciller = g_list_append(TempIssue->Penciller, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Inker = g_list_append(TempIssue->Inker, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      ungetc(c,fp);
	      TempString = g_string_new(NULL);

	      while((c=getc(fp))!='\x02')
		{
		  TempString = g_string_append_c(TempString, c);
		}
	      TempIssue->Title = g_list_append(TempIssue->Title, TempString);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Location = g_string_append_c(TempIssue->Location, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Price = g_string_append_c(TempIssue->Price, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->CurrentPrice = g_string_append_c(TempIssue->CurrentPrice, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->PurchasePrice = g_string_append_c(TempIssue->PurchasePrice, c);
  	    } 
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Image = g_string_append_c(TempIssue->Image, c);
  	    } 
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->Condition = atof(TempString->str);
	  g_string_free(TempString, TRUE);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempIssue->Comment = g_string_append_c(TempIssue->Comment, c);
  	    } 
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->Date = atof(TempString->str);
	  g_string_free(TempString, TRUE);
	  TempString = g_string_new(NULL);
  	  while((c=getc(fp))!='\x01')
  	    { 
	      TempString = g_string_append_c(TempString, c);
  	    }
	  TempIssue->UID = atof(TempString->str);
	  g_string_free(TempString, TRUE);

	  /* Now the TIssue structure is filled - then insert into list */
	  TempComic->IssueNumbers = g_list_insert_sorted(TempComic->IssueNumbers, TempIssue,
							 CompareTIssue_IssueNo);
	}
      /* Now the TComic structure is filled - then insert into list */
      ComicList = g_list_insert_sorted(ComicList, TempComic, CompareTComic_Title);
    }

  SetUID(LargestUID);
  return ComicList;
}

GList *LoadFile(GList *ComicList, FILE *fp)
{
  switch (FileCheck(fp)) 
    {
    case CO19: 
      return LoadCO19(ComicList, fp);
      break;
    case GCO_0_1:
      return LoadGCO_0_1(ComicList, fp);
      break;
    case GCO_0_3:
      return LoadGCO_0_3(ComicList, fp);
      break;
    case NotCO: 
      g_print("File is not a recognized filetype...\n");
      return NULL;
    default:
      g_print("Something unexpected happened...\n");
      return NULL;
    }
}

void SaveFile(GList *ComicList, FILE *fp)
{
  /* Write GCO_0_3_Ident */
  /* Write largest used UID */
  /* Write ComicList (remember to save the UIDs of the individual Comics and Issues, etc.) */
  int i, j, k, l, m, n;
  TComic *TempComic;
  TIssue *TempIssue;
  GString * TempString;

  fputc('\x00', fp);
  fputs(GCO_0_3_Ident, fp);
  fputc('\x00', fp);
  fputs(itoa(GetUID()+1), fp); 
  fputc('\x00', fp);

  j = g_list_length(ComicList);
  for (i=0;i<j;i++)
    {
      /* Save the Comic info */
      TempComic = (g_list_nth(ComicList,i))->data;
      fputs(TempComic->CTitle->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->CPublisher->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->CType->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->CVolume->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->CGroup->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->Comment->str, fp);
      fputc('\x00', fp);
      fputs(TempComic->LinkFile->str, fp);
      fputc('\x00', fp);
      fputs(itoa(TempComic->UID), fp); 
      fputc('\x00', fp);

      /* Now save the Issues */
      k = g_list_length(TempComic->IssueNumbers);
      for (l=0;l<k;l++)
	{
	  TempIssue = (g_list_nth(TempComic->IssueNumbers,l))->data;
	  fputs(TempIssue->IssueNo->str, fp);
	  fputc('\x01', fp);

	  m = g_list_length(TempIssue->Writer);
	  for (n=0;n<m;n++)
	    {
	      TempString = (g_list_nth(TempIssue->Writer, n)->data);
	      fputs(TempString->str, fp);
	      fputc('\x02', fp);
	    }
	  fputc('\x01', fp);

	  m = g_list_length(TempIssue->Penciller);
	  for (n=0;n<m;n++)
	    {
	      TempString = (g_list_nth(TempIssue->Penciller, n)->data);
	      fputs(TempString->str, fp);
	      fputc('\x02', fp);
	    }
	  fputc('\x01', fp);

	  m = g_list_length(TempIssue->Inker);
	  for (n=0;n<m;n++)
	    {
	      TempString = (g_list_nth(TempIssue->Inker, n)->data);
	      fputs(TempString->str, fp);
	      fputc('\x02', fp);
	    }
	  fputc('\x01', fp);

	  m = g_list_length(TempIssue->Title);
	  for (n=0;n<m;n++)
	    {
	      TempString = (g_list_nth(TempIssue->Title, n)->data);
	      fputs(TempString->str, fp);
	      fputc('\x02', fp);
	    }
	  fputc('\x01', fp);

	  fputs(TempIssue->Location->str, fp);
	  fputc('\x01', fp);
	  fputs(TempIssue->Price->str, fp);
	  fputc('\x01', fp);
	  fputs(TempIssue->CurrentPrice->str, fp);
	  fputc('\x01', fp);
	  fputs(TempIssue->PurchasePrice->str, fp);
	  fputc('\x01', fp);
	  fputs(TempIssue->Image->str, fp);
	  fputc('\x01', fp);
	  fputs(itoa(TempIssue->Condition), fp);
	  fputc('\x01', fp);
	  fputs(TempIssue->Comment->str, fp);
	  fputc('\x01', fp);
	  fputs(itoa(TempIssue->Date), fp);
	  fputc('\x01', fp);
	  fputs(itoa(TempIssue->UID), fp);
	  fputc('\x01', fp);
	}
      fputc('\x00', fp);
    }
}


TFileType FileCheck(FILE *fp)
{
  gshort i;
  gchar c;
  GString *s;

  s = g_string_new(NULL);
  for(i=0;i<=10;i++)
    {
      if ((c=getc(fp))==EOF)
	g_print("Error...\n");
      if (c!=0) /* Idents are surrounded by #0's */
	s = g_string_append_c(s, c);
    }

  if (strcmp(s->str, CO19Ident)==0)
    return CO19;
  if (strcmp(s->str, GCO_0_1_Ident)==0)
    return GCO_0_1;
  if (strcmp(s->str, GCO_0_3_Ident)==0)
    return GCO_0_3;
  else
    return NotCO;
}

void ExportToASCIIFile(GList *clist, FILE *fp)
{
  TComic *TempComic;
  TIssue *TempIssue;
  guint32 i,j,k,l,m,n;
  GString *String;

  fprintf(fp, "%i comic title(s)\n\n\n\n", j=g_list_length(clist));
  for(i=0;i<j;i++)
    {
      TempComic = (g_list_nth(clist,i))->data;
      fprintf(fp, "%s", TempComic->CTitle->str);
      if(TempComic->IsLink)
	fprintf(fp, " (is a link to %s)\n", TempComic->LinkFile->str);
      else
	fprintf(fp, " (Vol. %s, %s, %s)\n", TempComic->CVolume->str,
		TempComic->CType->str, TempComic->CPublisher->str);
      fprintf(fp, "Comment: %s\n", TempComic->Comment->str);
      fprintf(fp, "Comic UID: %i\n", TempComic->UID);

      if(TempComic->IssueNumbers!=NULL)
	{
	  fprintf(fp, "%i issue(s)\n", l=g_list_length(TempComic->IssueNumbers));

	  for(k=0;k<l;k++)
	    {
	      TempIssue = (g_list_nth(TempComic->IssueNumbers,k))->data;

	      fprintf(fp, "  Issue #%s:\n",TempIssue->IssueNo->str);

	      fprintf(fp, "    Writer(s)\n");
	      n=g_list_length(TempIssue->Writer);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Writer, m)->data;
		  fprintf(fp, "      %s\n", String->str);
		}

	      fprintf(fp, "    Penciller(s)\n");
	      n=g_list_length(TempIssue->Penciller);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Penciller, m)->data;
		  fprintf(fp, "      %s\n", String->str);
		}

	      fprintf(fp, "    Inker(s)\n");
	      n=g_list_length(TempIssue->Inker);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Inker, m)->data;
		  fprintf(fp, "      %s\n", String->str);
		}

	      fprintf(fp, "    StoryTitle(s)\n");
	      n=g_list_length(TempIssue->Title);
	      for(m=0;m<n;m++)
		{ 
		  String = g_list_nth(TempIssue->Title, m)->data;
		  fprintf(fp, "      %s\n", String->str);
		}

	      fprintf(fp, "    Location: %s\n", TempIssue->Location->str);
	      fprintf(fp, "    CoverPrice: %s\n", TempIssue->Price->str);
	      fprintf(fp, "    Current Price: %s\n", TempIssue->CurrentPrice->str);
	      fprintf(fp, "    Purchase Price: %s\n", TempIssue->PurchasePrice->str);
	      fprintf(fp, "    Image: %s\n", TempIssue->Image->str);
	      fprintf(fp, "    Condition: ");

	      switch (TempIssue->Condition)
		{
		case Mint:
		    fprintf(fp, "Mint\n");
		    break;
		case NearMint:      
		  fprintf(fp, "NearMint\n");
		  break;
		case VeryFine: 
		  fprintf(fp, "VeryFine\n");
		  break;
		case FineVeryFine: 
		  fprintf(fp, "FineVeryFine\n");
		  break;
		case Fine: 
		  fprintf(fp, "Fine\n");
		  break;
		case VeryGood:  
		  fprintf(fp, "VeryGood\n");
		  break;
		case Good:  
		  fprintf(fp, "Good\n");
		  break;
		case Fair:  
		  fprintf(fp, "Fair\n");
		  break;
		case Poor: 
		  fprintf(fp, "Poor\n");
		  break;
		default: 
		  fprintf(fp, "Unknown\n");
		  break;
		}

	      fprintf(fp, "    Comment: %s\n", TempIssue->Comment->str);
	      fprintf(fp, "    Issue UID: %i\n", TempIssue->UID);
	    }
	}
      else
	{
	  fprintf(fp, "no issues\n");
	}
      fprintf(fp, "\n\n");
    }
}
