(in-package 'si)
;;; Autoloaders.


;;; DEFAUTOLOAD definitions. for lsp directory files normally loaded.
(if (fboundp 'abs) (push :numlib *features*))
;;hack to avoid interning all the :symbols if the files are loaded..
#-numlib
(progn
(autoload 'abs '|numlib|)
(autoload 'acos '|numlib|)
(autoload 'acosh '|numlib|)
(autoload 'adjust-array '|arraylib|)
(autoload 'apropos '|packlib|)
(autoload 'apropos-list '|packlib|)
(autoload 'array-dimensions '|arraylib|)
(autoload 'array-in-bounds-p '|arraylib|)
(autoload 'array-row-major-index '|arraylib|)
(autoload 'asin '|numlib|)
(autoload 'asinh  '|numlib|)
(autoload 'atanh '|numlib|)
(autoload 'best-array-element-type '|arraylib|)
(autoload 'bit '|arraylib|)
(autoload 'bit-and '|arraylib|)
(autoload 'bit-andc1 '|arraylib|)
(autoload 'bit-andc2 '|arraylib|)
(autoload 'bit-eqv '|arraylib|)
(autoload 'bit-ior '|arraylib|)
(autoload 'bit-nand '|arraylib|)
(autoload 'bit-nor '|arraylib|)
(autoload 'bit-not '|arraylib|)
(autoload 'bit-orc1 '|arraylib|)
(autoload 'bit-orc2 '|arraylib|)
(autoload 'bit-xor '|arraylib|)
(autoload 'byte '|numlib|)
(autoload 'byte-position '|numlib|)
(autoload 'byte-size '|numlib|)
(autoload 'cis '|numlib|)
(autoload 'coerce '|predlib|)
(autoload 'compile-file '|loadcmp|)
(autoload 'compile '|loadcmp|)
(autoload 'disassemble '|loadcmp|)
(autoload 'concatenate '|seq|)
(autoload 'cosh '|numlib|)
(autoload 'count '|seqlib|)
(autoload 'count-if '|seqlib|)
(autoload 'count-if-not '|seqlib|)
(autoload 'decode-universal-time '|mislib|)
(autoload 'delete '|seqlib|)
(autoload 'delete-duplicates '|seqlib|)
(autoload 'delete-if '|seqlib|)
(autoload 'delete-if-not  '|seqlib|)
(autoload 'deposit-field '|numlib|)
(autoload 'describe '|describe|)
(autoload 'dpb '|numlib|)
(autoload 'dribble '|iolib|)
(autoload 'encode-universal-time '|mislib|)
(autoload 'every '|seq|)
(autoload 'fceiling '|numlib|)
(autoload 'ffloor '|numlib|)
(autoload 'fill '|seqlib|)
(autoload 'find '|seqlib|)
(autoload 'find-all-symbols '|packlib|)
(autoload 'find-if '|seqlib|)
(autoload 'find-if-not '|seqlib|)
(autoload 'fround '|numlib|)
(autoload 'ftruncate '|numlib|)
#-unix (autoload 'get-decoded-time '|mislib|)
#+aosvs (autoload 'get-universal-time '|mislib|)
(autoload 'get-setf-method '|setf|)
(autoload 'get-setf-method-multiple-value '|setf|)
(autoload 'inspect '|describe|)
(autoload 'intersection '|listlib|)
(autoload 'isqrt '|numlib|)
(autoload 'ldb '|numlib|)
(autoload 'ldb-test '|numlib|)
(autoload 'logandc1 '|numlib|)
(autoload 'logandc2 '|numlib|)
(autoload 'lognand '|numlib|)
(autoload 'lognor '|numlib|)
(autoload 'lognot '|numlib|)
(autoload 'logorc1 '|numlib|)
(autoload 'logorc2 '|numlib|)
(autoload 'logtest '|numlib|)
(autoload 'make-array '|arraylib|)
(autoload 'make-sequence '|seq|)
(autoload 'map '|seq|)
(autoload 'mask-field '|numlib|)
(autoload 'merge '|seqlib|)
(autoload 'mismatch '|seqlib|)
(autoload 'nintersection '|listlib|)
(autoload 'notany '|seq|)
(autoload 'notevery '|seq|)
(autoload 'si::normalize-type ':predlib)
(autoload 'nset-difference '|listlib|)
(autoload 'nset-exclusive-or '|listlib|)
(autoload 'nsubstitute '|seqlib|)
(autoload 'nsubstitute-if '|seqlib|)
(autoload 'nsubstitute-if-not '|seqlib|)
(autoload 'nunion '|listlib|)
(autoload 'phase '|numlib|)
(autoload 'position '|seqlib|)
(autoload 'position-if '|seqlib|)
(autoload 'position-if-not '|seqlib|)
(autoload 'prin1-to-string '|iolib|)
(autoload 'princ-to-string '|iolib|)
(autoload 'rational '|numlib|)
(autoload 'rationalize '|numlib|)
(autoload 'read-from-string '|iolib|)
(autoload 'reduce '|seqlib|)
(autoload 'remove '|seqlib|)
(autoload 'remove-duplicates '|seqlib|)
(autoload 'remove-if '|seqlib|)
(autoload 'remove-if-not '|seqlib|)
(autoload 'replace '|seqlib|)
(autoload 'sbit '|arraylib|)
(autoload 'search '|seqlib|)
(autoload 'set-difference '|listlib|)
(autoload 'set-exclusive-or '|listlib|)
(autoload 'signum '|numlib|)
(autoload 'sinh '|numlib|)
(autoload 'some '|seq|)
(autoload 'sort '|seqlib|)
(autoload 'stable-sort '|seqlib|)
(autoload 'subsetp '|listlib|)
(autoload 'substitute '|seqlib|)
(autoload 'substitute-if '|seqlib|)
(autoload 'substitute-if-not '|seqlib|)
(autoload 'subtypep '|predlib|)
(autoload 'tanh '|numlib|)
(autoload 'typep '|predlib|)
(autoload 'union '|listlib|)
(autoload 'vector '|arraylib|)
(autoload 'vector-pop '|arraylib|)
(autoload 'vector-push '|arraylib|)
(autoload 'vector-extend '|arraylib|)
(autoload 'write-to-string '|iolib|)
(autoload 'y-or-n-p '|iolib|)
(autoload 'yes-or-no-p '|iolib|)


(set-dispatch-macro-character #\# #\a 'si::sharp-a-reader)
(set-dispatch-macro-character #\# #\A 'si::sharp-a-reader)
(autoload 'si::sharp-a-reader '"iolib")
(set-dispatch-macro-character #\# #\s 'si::sharp-s-reader)
(set-dispatch-macro-character #\# #\S 'si::sharp-s-reader)
(autoload 'si::sharp-s-reader '|iolib|)


;;; DEFAUTOLOADMACRO definitions.

(autoload-macro 'assert '|assert|)
(autoload-macro 'ccase '|assert|)
(autoload-macro 'check-type '|assert|)
(autoload-macro 'ctypecase '|assert|)
(autoload-macro 'decf '|setf|)
(autoload-macro 'define-modify-macro '|setf|)
(autoload-macro 'define-setf-method '|setf|)
(autoload-macro 'defsetf '|setf|)
(autoload-macro 'defstruct '|defstruct|)
(autoload-macro 'si::define-structure '|defstruct|)
(autoload-macro 'deftype '|predlib|)
(autoload-macro 'do-all-symbols '|packlib|)
(autoload-macro 'do-external-symbols '|packlib|)
(autoload-macro 'do-symbols '|packlib|)
(autoload-macro 'ecase '|assert|)
(autoload-macro 'etypecase '|assert|)
(autoload-macro 'incf '|setf|)
(autoload-macro 'pop '|setf|)
(autoload-macro 'push '|setf|)
(autoload-macro 'pushnew '|setf|)
(autoload-macro 'remf '|setf|)
(autoload-macro 'rotatef '|setf|)
(autoload-macro 'setf '|setf|)
(autoload-macro 'shiftf '|setf|)
(autoload-macro 'step '|trace|)
(autoload-macro 'time '|mislib|)
(autoload-macro 'trace '|trace|)
(autoload-macro 'typecase '|assert|)
(autoload-macro 'untrace '|trace|)
(autoload-macro 'with-input-from-string '|iolib|)
(autoload-macro 'with-open-file '|iolib|)
(autoload-macro 'with-open-stream '|iolib|)
(autoload-macro 'with-output-to-string '|iolib|)
)   ;;end autoloads of normally loaded files.j
(if (find-package "COMPILER") (push :compiler *features*))
#+compiler
(autoload 'compiler::emit-fn '|../cmpnew/gcl_collectfn|)
(autoload 'compiler::init-fn '|../cmpnew/gcl_collectfn|)
(autoload 'si::monstartup '"gprof")
(autoload  'si::set-up-profile '"profile")

(AUTOLOAD 'IDESCRIBE '|info|)
(AUTOLOAD 'INFO '|info|)
(AUTOLOAD 'LIST-MATCHES '|info|)
(AUTOLOAD 'get-match '|info|)
(AUTOLOAD 'print-node '|tinfo|)
(AUTOLOAD 'offer-choices '|tinfo|)
(AUTOLOAD 'tkconnect '|tkl|)




;; the sun has a broken ypbind business, if one wants to save.
;; So to stop users from invoking this
#+sun
(defun user-homedir-pathname ()
 (let* ((tem (si::getenv "HOME"))
	(l (- (length tem) 1)))
   (cond ((null tem) nil)
	 (t 
	  (or (and (>= l 0)
		   (eql (aref tem l) #\/))
	      (setq tem (concatenate 'string tem "/")))
	  (pathname tem)))))


