/*
 * GChangepass -- GTK+ Frontend to passwd
 * Copyright (C) 2005 Guilherme de Siqueira Pastore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>
#include <libintl.h>
#include <locale.h>
#include <stdlib.h>

#define _(x) gettext(x)

typedef struct {
  gchar *user;
  gchar *current_password;
  gchar *new_password;
} UserData;

typedef struct {
  gint uid;
  pid_t pid;
  gint master;
  gchar slave[255];
} Internals;
