------------------------------------------------------------------------------
--                                                                          --
--                            GCH COMPONENTS                                --
--                                                                          --
--                            G C H . I N I T                               --
--                                                                          --
--                                S p e c                                   --
--                                                                          --
--                                                                          --
--              Copyright (c) 1999, Vitali Sh.Kaufman.                      --
--                                                                          --
--  Gch is distributed as free software; that is with full sources          --
--  and in the hope that it will be useful, but WITHOUT ANY WARRANTY;       --
--  without even the implied warranty of MERCHANTABILITY or FITNESS         --
--  FOR A PARTICULAR PURPOSE. You can freely copy, modify and redistribute  --
--  this software, provided that full sources are available for the version --
--  being distribute (original and modified), and for a modified version,   --
--  any changes that you have made are clearly indicated.                   --
--                                                                          --
--  Gch was developed by Vitali Sh. Kaufman using a prototype               --
--  and consultations by Sergey I. Rybin.                                   --
------------------------------------------------------------------------------

--  This package defines subprograms needed for performing initialization
--  (including scanning arguments) and finalization actions

--  with GNAT.OS_Lib; use GNAT.OS_Lib;
with GNAT.Table;

package Gch.Init is

   Fatal_Error : exception;
   --  This is a "terminal" Gch exception, which should propagate into
   --  the top Gch driver and then it should be caught there with no
   --  additional diagnosis

   Gch_Not_Implemented_Error : exception;
   --  ??? for the development period only, should go away

   procedure Scan_Command_Line;
   --  Scans the command line arguments and sets the corresponding Gch
   --  options

   procedure Scan_Ini_File;
   --  Reads the file Gch.ini and sets the corresponding Gch options

   procedure Scan_Rule_Ini_File;
   --  Reads the file rules.ini and activates rule checks

   procedure Check_Settings;
   --   When all the settings are made, this procedure checks the
   --   compatibility of the settings.

--   procedure Initialize_Asis;
--   --  Initializes and opens an ASIS COntext

   procedure Clean_Up;
   --  Performs the final clean-up actions: deletes all what should be deleted;
   --  closes an ASIS Context etc ??? Do we need this???

   procedure Clean_Tree (Tree_Name : String_Access);
--  Deletts the tree file itself and the ALI file which was created along with the tree file



   --  Data structures to store source file names to process:

   type File_Id is new Positive;

   type Source_File_Record is record

      File_Name : String_Access;
      --  The name of the source file itself

      Checked_Successfully : Boolean;
      --  This flag indicates if all the rules have been successfully checked
      --  for a given source

   end record;

   package Source_File_Table is new GNAT.Table (
      Table_Component_Type => Source_File_Record,
      Table_Index_Type     => File_Id,

      Table_Low_Bound      =>  1,
      Table_Initial        => 10,
      Table_Increment      => 50);

   Sources : Source_File_Table.Table_Ptr renames
      Source_File_Table.Table;

   --------------------
   -- gcc options ???--
   --------------------

   Gcc : constant String := "gcc";
   --  The name of the command to call GNAT

   Create_Obj_Args  : Argument_List_Access;
   Create_Tree_Args : Argument_List_Access;
   --  Aggument lists for calling gcc to create on object and to create
   --  tree files respectively

   --  The data structure below is used to store the components of the
   --  Gch command line. This command line is just a gcc command line
   --  and it chould be passed to gcc to create the object for a source
   --  being compiled. A part of these arguments should be also used to call
   --  gcc to create a tree file for a given source.

   type Argument_Record is record
      Arg_String : String_Access;
      --  The argument itself

      Is_From_Path : Boolean;
      --  This flag indicates if this argument should be used when gcc is
      --  called to create a tree file (that is, if it is a part of a
      --  source search path)

   end record;

   package Argument_Table is new GNAT.Table (
      Table_Component_Type => Argument_Record,
      Table_Index_Type     => Positive,

      Table_Low_Bound      =>  1,
      Table_Initial        => 10,
      Table_Increment      => 50);

   Arguments : Argument_Table.Table_Ptr renames Argument_Table.Table;

   GCC_Tree_Args   : String_Access;
   --  All the arguments passed to gcc to create a tree

   GCC_Object_Args : String_Access;
   --  All the arguments passed to gcc to create an object file

end Gch.Init;