/* 
   gcardscheme - GNOME applet to control PCMCIA card schemes
   
   Copyright (C) 2000 Brian Bassett

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <errno.h>

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

extern void depopulate (GtkCList *list);

void
apply_schemes                          (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data)
{
    GtkWidget *wid = lookup_widget (GTK_WIDGET(gnomepropertybox), "list");
    depopulate (GTK_CLIST(wid));
}

void
add_remove_add                         (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dialog;
    GtkWidget *list;
    GtkWidget *entry;
    gint result;
    
    dialog = create_add_newname ();
    gnome_dialog_close_hides (GNOME_DIALOG(dialog), TRUE);
    result = gnome_dialog_run (GNOME_DIALOG(dialog));
    if (result == 0)
    {
	gchar *s;
	gchar *sa[] = { "", NULL };

	list = lookup_widget (GTK_WIDGET(user_data), "list");
	entry = lookup_widget (dialog, "entry");
	s = gtk_entry_get_text (GTK_ENTRY(entry));
	sa[0] = s;
	gtk_clist_append (GTK_CLIST(list), sa);
	gnome_property_box_changed (GNOME_PROPERTY_BOX(user_data));
    }
    gnome_dialog_close (GNOME_DIALOG(dialog));

    return;
}

int list_selected;

void
add_remove_remove                      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *list;
    
    if (list_selected == -1)
    {
	gnome_error_dialog (_("Cannot remove scheme, none selected."));
	return;
    }

    list = lookup_widget (GTK_WIDGET(user_data), "list");
    gtk_clist_remove (GTK_CLIST(list), list_selected);
    gnome_property_box_changed (GNOME_PROPERTY_BOX(user_data));
}

void
list_select                            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    list_selected = row;
}

void
list_unselect                          (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    list_selected = -1;
}

extern GtkWidget *choice;

void
select_ok                              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *select = GTK_WIDGET(user_data);

    if (list_selected != -1)
    {
	GtkWidget *list = lookup_widget (select, "list");
	GtkWidget *lbl;
	gchar *text;
	int result;
	gchar cmdline[256] = CARDCTL_HELPER " ";
	
	gtk_clist_get_text (GTK_CLIST(list), list_selected, 0, &text);

	/* Do the change */
	strcat (cmdline, text);
	result = system (cmdline);
	if (result != 0)
	{
	    g_print ("system(\"%s\") returned %d.\n", cmdline, result);
	    goto bail;
	}

	/* Update button */
	lbl = GTK_BIN(choice)->child;
	gtk_label_set_text (GTK_LABEL(lbl), text);
    }
    
bail:
    gnome_dialog_close (GNOME_DIALOG(select));
}

void
select_cancel                          (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *select = GTK_WIDGET(user_data);
    gnome_dialog_close (GNOME_DIALOG(select));
}

