/* Gnome BibTeX lyxconnect.C
 *    Copyright 1999 Alejandro Aguilar Sierra <asierra@servidor.unam.mx>
 * 
 *    This program is free software; you can redistribute it and'or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2, or (at your option)
 *    any later version.
 */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h> 
#include <gnome.h> 

//#include <sys/poll.h>

#include "gbib.h"
#include "lyxconnect.h"



LyXConnect::LyXConnect()
{
    lyx_listen = false;
    pipein = pipeout = -1;
    pipename = getenv("HOME");
    pipename += "/.lyxpipe";
    clientname = "gbib";
//    cerr << "Pipename " << pipename << "\n";
}


LyXConnect::~LyXConnect()
{
    closepipe();
}


void LyXConnect::connect()
{
    if (pipein!=-1) {
	cerr << "Pipes already opened, close them first\n";
	return;
    }
    char buf[100];
    string spipein  = pipename + ".in";
    string spipeout = pipename + ".out";
    
    pipein = open(spipein.c_str(), O_RDWR);
    pipeout = open(spipeout.c_str(), O_RDONLY|O_NONBLOCK);
    cerr << "Opened " << pipein << " " << pipeout << "\n";
    
    if (pipein<0 || pipeout<0) {
	perror("Couldn't open the pipes");
	pipein = pipeout = -1;
	return;
    }
    // greeting LyX
    sprintf(buf, "LYXSRV:%s:hello\n", clientname.c_str());
    write(pipein, buf, strlen(buf));
}



void LyXConnect::closepipe()
{
    	
    if (pipein>=0) {
	close(pipein);
    }    
   	      
    if (pipeout>=0) {
	if (lyx_listen) {
	    lyx_listen = false;
	    
	    char buf[200];
	    
	    // goodbye lyx
	    sprintf(buf, "LYXSRV:%s:bye\n", clientname.c_str());
	    write(pipeout, buf, strlen(buf));
	}
	close(pipeout);
	
	
//	fl_remove_io_callback(pipeout, FL_READ, io_cb);
    }     
    pipein = pipeout = -1; 
}


void LyXConnect::submit(char * command, const char * argument)
{
    string message = "LYXCMD:";
    
    message += clientname + ":" + command + ":" + argument + "\n";
    
    if (pipein>=0) {
	write(pipein, message.c_str(), message.size());

/*	
	struct pollfd gpoll[] = {
	    { pipeout, POLLIN, POLLIN }
	};
	
	poll(gpoll, 1, -1);
	int n;
	char s[255];
	
	do {
	    n = read(pipeout, &s[0], 200);
	    cerr << "Lyx says " << n << ": " << s << "|\n";
	} while (n > 0 && n < 100);
*/	
    } else
      cerr << "Pipe is not opened\n";
}

