# Copyright (C) 2004,2005 by Imendio AB
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

from gazpacho.loader import tags

DEFAULT_TYPE, OVERRIDE_TYPE, IGNORE_TYPE, LEGACY_TYPE = range(4)

def override(node, widget_class, method_name, property_class=None,
             adaptor_function=None):
    type_map = {
        'ignore' : IGNORE_TYPE,
        'default': DEFAULT_TYPE,
        'override' : OVERRIDE_TYPE,
        'legacy' : LEGACY_TYPE
        }

    func_name = node.getAttribute(tags.NAME)

    # Find out what object we should update
    if property_class:
        obj = property_class
    else:
        obj = widget_class

    func_type_name = node.getAttribute(tags.TYPE)
    try:
        func_type = type_map[func_type_name]
    except KeyError:
        print "Unknown function type [%s] for function [%s] in class [%s]" % \
              (func_type_name, func_name, obj.name)
        return

    if func_type == IGNORE_TYPE:
        # Ignore means no function
        func = None
    elif func_type == DEFAULT_TYPE:
        # Default is the same as not having a function at all
        return
    elif func_type == LEGACY_TYPE:
        func_value = node.getAttribute(tags.VALUE)
        func = widget_class.library.get_function(func_value)
    elif func_type == OVERRIDE_TYPE:
        if not obj.adaptor:
            print "Function [%s] in widget_class [%s] marked as override, but no adaptor class exists" % (func_name, obj.name)
            return

        if adaptor_function is None:
            adaptor_function = func_name.replace('-', '_')

        if not hasattr(obj.adaptor, adaptor_function):
            print "Function %s is not defined in adaptor class %s" % \
                  (adaptor_function, obj.adaptor.__class__)
            return
        
        func = getattr(obj.adaptor, adaptor_function)

    # Now update the function
    setattr(obj, method_name, Function(func_type, func))
    
class Function:
    def __init__(self, func_type, func = None):
        self.func_type = func_type
        self.func = func
        
    def __call__(self, *args, **kwargs):
        if self.func_type == IGNORE_TYPE:
            return
        elif self.func_type == LEGACY_TYPE:
            return self.func(*args, **kwargs)
        elif self.func_type == OVERRIDE_TYPE:
            return self.func(*args, **kwargs)
