# Copyright (C) 2004,2005 by SICEm S.L.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
from gazpacho.loader import tags

def list_new_from_node(xmlnode, pspec):
    result = []
    def_value = 0
    for child in xmlnode.childNodes:
        if child.nodeType == child.ELEMENT_NODE:
            name = child.getAttribute(tags.NAME)
            if not name:
                continue
            child_id = child.getAttribute(tags.ID)
            value = enum_from_string(child.getAttribute(child_id), pspec)
            # if enum_from_string is not able to find a value for this enum,
            # we will use as value the position of the item in the enum list
            if value == -1:
                value = def_value

            result.append({'name': name, 'id': child_id, 'value': value})
            def_value += 1

    return result

def list_new_from_spec(spec):
    result = []
    enum_class = spec.enum_class
    if enum_class is not None:
        for value, enum in enum_class.__enum_values__.items():
            name = enum.value_nick
            enum_id = enum.value_name
            result.append({'name': name, 'id': enum_id, 'value': value})
    return result

def enum_from_string(value_name, pspec):
    if not value_name or value_name == '-':
        return 0
    try:
        value = int(value_name)
    except ValueError:
        enum_class = pspec.enum_class
        if enum_class is not None:
            for value, enum in enum_class.__enum_values__.items():
                if value_name in (enum.value_name, enum.value_nick):
                    return value

    return 0

def enum_to_string(enum_value, pspec):
    enum_class = pspec.enum_class
    if enum_class is not None:
        for value, enum in enum_class.__enum_values__.items():
            if value == enum_value:
                return enum.value_nick
    return ""
    
def flags_from_string(value_name, pspec):
    if not value_name:
        return 0

    try:
        return int(value_name)
    except ValueError:
        pass
    
    value_names = [v.strip() for v in value_name.split('|')]

    flag_values = pspec.flags_class.__flags_values__
    new_value = 0
    for mask, flag in flag_values.items():
        if flag.value_names[0] in value_names \
           or flag.value_nicks[0] in value_names:
            new_value |= mask

    return new_value

def flags_to_string(flags_value, pspec):
    if flags_value == 0:
        return ""
    flags_names = []
    flags_values = pspec.flags_class.__flags_values__.items()
    for value, flag in flags_values:
        if (value & flags_value) != 0:
            for nick in flag.value_nicks:
                if nick not in flags_names:
                    flags_names.append(nick)
    flags_names.sort()
    return ' | '.join(flags_names)
