/**************************************************************************\
 gatos (General ATI TV and Overlay Software)

  Project Coordinated By Insomnia (Steaphan Greene)
  (insomnia@core.binghamton.edu)

  Copyright (C) 1999 Steaphan Greene, yvind Aabling, Octavian Purdila, 
	Vladimir Dergachev and Christian Lupien.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

\**************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#define LIMIT(x) (((x)<0)?0:((x)>255)?255:(x))

#define R1	p1[0]
#define W1	p1[1]

int main() {

  int fd0, fd1, y, cr, cb, r, g, b, h, v, i, j, res, n=0 ;
  unsigned char rgb[3], buf[256], name[13] ; struct stat st ;
  int p1[2] ; pid_t pid1 ;

  if ((fd0=open("/dev/null",O_WRONLY)) == -1) {
    perror("open(/dev/null) failed") ; exit(0) ; }

  while ( fread(buf,1,8,stdin) == 8 ) {

    while (1) {
      snprintf(name,sizeof(name),"tv%06d.jpg",++n) ;
      if (lstat(name,&st)) break ; }
    if ((fd1=open(name,O_WRONLY|O_CREAT|O_TRUNC)) == -1) {
      perror("open(outfile) failed") ; exit(0) ; }

    if (pipe(p1)) { perror("pipe() failed") ; exit(0) ; }

    if ((pid1=fork()) == -1) { perror("fork() failed") ; exit(0) ; }
    if (!pid1) {
      dup2(R1,0) ; dup2(fd1,1) ; dup2(fd0,2) ;
      close(R1) ; close(W1) ; close(fd0) ; close(fd1) ;
      execlp("cjpeg","cjpeg",NULL) ; exit(0) ; }

    close(R1) ; close(fd1) ;

    res = sscanf(buf,"%3d %3d\n",&h,&v) ;
    fprintf(stderr,"atitojpg: %dx%d image: %s\n",h,v,name) ;
    snprintf(buf,sizeof(buf),"P6\n%d %d\n255\n",h,v) ;
    write(W1,buf,strlen(buf)) ;

    for ( i=0 ; i<v ; i++ ) for ( j=0 ; j<h ; j+=2 ) {

	if (!fread(buf,4,1,stdin)) break ;
	cb = buf[1] - 128 ; cr = buf[3] - 128 ;

	y = buf[0] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	rgb[0] = LIMIT(r) ; rgb[1] = LIMIT(g) ; rgb[2] = LIMIT(b) ;
	write(W1,rgb,3) ;

	y = buf[2] - 16 ;
	r = ( 76284*y + 104595*cr             )>>16 ;
	g = ( 76284*y -  53281*cr -  25624*cb )>>16 ;
	b = ( 76284*y             + 132252*cb )>>16 ;
	rgb[0] = LIMIT(r) ; rgb[1] = LIMIT(g) ; rgb[2] = LIMIT(b) ;
	write(W1,rgb,3) ; }

    close(W1) ; waitpid(pid1,NULL,0) ; }

  return(0) ; }
