/* -*- C -*-                                        vim:set ts=4 sw=4:

 * FILE: "/home/life/projects/garchiver-0.4/src/load_imlib.c"
 * LAST MODIFICATION: "Sun, 17 Jun 2001 01:36:10 +0200 (life)"

 * (C) 2001 by Danie Roux <droux@tuks.co.za>
 *
 * $Id: load_imlib.c,v 1.2 2001/06/19 13:19:15 droux Exp $
 *
 * Short module that loads the imlib library into memory. This is needed
 * so that gtk themes can work as well as any other imlib call.
 *
 * RedHat doesn't need this module because they patched the Python source.
 *
 * Import this module before you import anything to do with gtk
 *
 */

#include <Python.h>
#include <dlfcn.h>

static PyMethodDef load_imlib_methods [] = {
      {NULL, NULL}
};

void
init_load_imlib ()
{

    if (!dlopen ("libgdk_imlib.so.1", RTLD_NOW | RTLD_GLOBAL))
        fprintf (stderr, "\n%s\n", dlerror());
    if (!dlopen ("libXi.so.6", RTLD_NOW | RTLD_GLOBAL))
        fprintf (stderr, "\n%s\n", dlerror());

    Py_InitModule ("_load_imlib", load_imlib_methods);
}
