/* -*- C -*-                                        vim:set ts=4 sw=4:

 * FILE: "/home/life/projects/garchiver-0.4/src/dir_listing.h"
 * LAST MODIFICATION: "Sat, 23 Jun 2001 15:37:22 +0200 (life)"

 * (C) 2001 by Danie Roux <droux@tuks.co.za>
 *
 * $Id: dir_listing.h,v 1.7 2001/06/25 12:49:05 droux Exp $
 *
 * Definition of the directory listing widget.
 *
 */

#ifndef __DIR_LISTING_H__
#define __DIR_LISTING_H__

#include <gnome.h>

#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtkctree.h>
#include <gtk/gtkscrolledwindow.h>

/* For all directory related stuff */
#include <dirent.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

/* TODO */
#include <pygtk/pygtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* C++ */

#define GTK_DIR_LISTING(obj) (GTK_CHECK_CAST (obj, gtk_dir_listing_get_type (), GtkDirListing))
#define GTK_DIR_LISTING_CLASS(klass) (GTK_CHECK_CLASS_CAST (klass, gtk_dir_listing_get_type (), GtkDirListingClass))
#define IS_DIR_LISTING(obj) (GTK_CHECK_TYPE (obj, gtk_dir_listing_get_type ()))
#define IS_VBOX_CLASS(klass) (GTK_CHECK_CLASS_TYPE (klass, gtk_dir_listing_get_type ())

typedef struct _GtkDirListing GtkDirListing;
typedef struct _GtkDirListingClass GtkDirListingClass;

struct _GtkDirListing
  {
    GtkVBox parent;

    GtkCTree *ctree;
    GtkWidget *popup;
    GtkAdjustment *adjustment;

    gboolean show_dotfiles;

    /* Node in tree currently selected */
    GtkCTreeNode *node_selected;
  };

struct _GtkDirListingClass
  {
    GtkVBoxClass parent_class;
    void (* dir_selected) (GtkDirListing *dl, gchar *path);
    void (* dir_final_selection) (GtkDirListing *dl, gchar *path);
  };

guint       gtk_dir_listing_get_type (void);
GtkWidget*  gtk_dir_listing_new (void);
GtkWidget*  gtk_dir_listing_new_with_dotfiles (gboolean show_dotfiles);

/* Changes this listing to the specified directory */
void gtk_dir_listing_cd (GtkDirListing *dl, const gchar *path);

/* Toggles whether to show dotfiles or not */
void gtk_dir_listing_show_dotfiles (GtkDirListing *dl, gboolean show);

#ifdef __cplusplus
}
#endif

#endif
/* vim:set tw=0: */
