/**
 * File:          $RCSfile: image_pyramid.h,v $
 * Module:        Construct multi-resolution image pyramid
 * Part of:       Gandalf Library
 *
 * Revision:      $Revision: 1.13 $
 * Last edited:   $Date: 2002/04/22 13:42:18 $
 * Author:        $Author: pm $
 * Copyright:     (c) 2000 Imagineer Software Limited
 */

/* This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _GAN_IMAGE_GL_PYRAMID_H
#define _GAN_IMAGE_GL_PYRAMID_H

#ifdef __cplusplus
extern "C" {
#endif

#include <gandalf/image/image_defs.h>

/**
 * \addtogroup ImagePackage
 * \{
 */

/**
 * \addtogroup ImagePyramid
 * \{
 */

/**
 * \brief Structure to hold image and mask at a single pyramid level.
 */
typedef struct Gan_ImagePyramid
{
   Gan_Image *img; /**< image represented at a single resolution level */
   Gan_Image *mask; /**< mask at this level defining which pixels are set */
} Gan_ImagePyramid;

/**
 * \brief Type of averaging used when combining four pixels into one.
 */
typedef enum Gan_ImagePyramidAverage
{
   GAN_AVERAGE_ALL,    /**< take average of all four pixels */
   GAN_AVERAGE_IN_MASK /**< take average only of pixels in the mask */
} Gan_ImagePyramidAverage;

Gan_Bool gan_image_pyramid_build ( Gan_Image *img, Gan_Image *mask,
                                   unsigned no_levels,
                                   Gan_ImagePyramidAverage average_type,
                                   unsigned no_neighbours,
                                   Gan_ImagePyramid **pyramid );
void gan_image_pyramid_free ( Gan_ImagePyramid *pyramid, unsigned no_levels,
                              Gan_Bool free_top_level );

/**
 * \}
 */

/**
 * \}
 */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef _GAN_IMAGE_GL_PYRAMID_H */
