
#line 3 "flex_parser.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int yyleng;

extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart (FILE *input_file  );
void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
void yy_delete_buffer (YY_BUFFER_STATE b  );
void yy_flush_buffer (YY_BUFFER_STATE b  );
void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

void *yyalloc (yy_size_t  );
void *yyrealloc (void *,yy_size_t  );
void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap() 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

extern int yylineno;

int yylineno = 1;

extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 42
#define YY_END_OF_BUFFER 43
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[138] =
    {   0,
       40,   40,   40,   40,   43,   41,   40,   40,   41,    9,
       41,   41,   13,   13,   19,   19,   19,   19,   19,   19,
       19,   41,   12,    1,   10,   41,    8,   41,   41,   41,
       41,   41,   41,   41,   41,   41,   40,    0,   35,    0,
       14,   13,   13,   13,   15,   18,   16,   17,    0,   39,
       19,   19,   19,   19,   19,   19,   19,   19,   19,   19,
       19,   19,    0,   38,   11,    2,    3,    0,    0,    5,
        0,    0,    0,    0,   13,   15,   18,   16,   17,   19,
       19,   19,   19,   19,   19,    0,   33,   19,   19,   19,
       19,    4,    7,    6,    0,   37,   19,   19,   19,    0,

       36,    0,   24,   19,    0,   34,    0,   20,   19,   19,
        0,   28,   19,    0,   25,   19,    0,   21,   19,    0,
       29,   19,    0,   26,    0,   22,    0,   32,    0,   30,
        0,   27,    0,   23,    0,   31,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    1,    1,    1,    5,    6,    1,    7,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       17,   17,   17,   17,   17,   18,   18,    1,    1,   19,
       20,   21,    1,    1,   22,   23,   24,   25,   23,   23,
       26,   26,   26,   26,   26,   26,   27,   28,   29,   30,
       26,   31,   26,   26,   26,   26,   26,   32,   26,   26,
        1,    1,    1,   33,    1,    1,   34,   35,   36,   37,

       23,   23,   38,   39,   40,   26,   26,   41,   42,   43,
       44,   45,   46,   47,   48,   49,   26,   26,   26,   50,
       26,   26,    1,   51,    1,   52,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[53] =
    {   0,
        1,    2,    2,    1,    1,    1,    2,    1,    1,    1,
        1,    1,    1,    1,    3,    3,    3,    3,    1,    1,
        1,    3,    3,    3,    3,    2,    2,    2,    2,    2,
        2,    2,    1,    3,    3,    3,    3,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        1,    1
    } ;

static yyconst flex_int16_t yy_base[141] =
    {   0,
        0,    0,   52,    0,  201,  474,  103,  105,  107,  474,
      100,  108,  116,  124,  141,  143,  150,  160,  162,  169,
      176,  178,  474,  474,  196,  178,  474,  169,  156,  153,
      146,  139,  118,  112,  107,  105,  156,  185,  474,  178,
      196,  205,  209,  217,  192,    0,  158,    0,  234,  474,
      236,  242,  244,  250,  252,  258,  260,  266,  268,  274,
      276,  282,  289,  474,  474,  474,  474,  122,  113,  474,
      105,   93,   91,   75,  282,  294,    0,  278,    0,  309,
      311,  317,  319,  325,  327,  333,  474,  335,  341,  343,
      349,  474,  474,  474,  351,  474,  361,  367,  369,  375,

      474,  382,  474,  384,  391,  474,  394,  474,  400,  402,
      408,  474,  410,  416,  474,  418,  424,  474,  426,  432,
      474,  434,  440,  474,  442,  474,  448,  474,  450,  474,
      456,  474,  458,  474,  464,  474,  474,  470,  117,  109
    } ;

static yyconst flex_int16_t yy_def[141] =
    {   0,
      137,    1,  137,    3,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  138,  138,  138,  138,  138,  138,
      138,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  139,  137,  140,  137,  137,
      138,  138,  138,  138,  138,  138,  138,  138,  138,  138,
      138,  138,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  139,  137,  140,  138,
      138,  138,  138,  138,  138,  137,  137,  138,  138,  138,
      138,  137,  137,  137,  137,  137,  138,  138,  138,  137,

      137,  137,  137,  138,  137,  137,  137,  137,  138,  138,
      137,  137,  138,  137,  137,  138,  137,  137,  138,  137,
      137,  138,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,    0,  137,  137,  137
    } ;

static yyconst flex_int16_t yy_nxt[527] =
    {   0,
        6,    7,    8,    9,    6,    6,   10,    6,    6,    6,
       11,   12,   11,    6,   13,   14,   14,   14,    6,    6,
        6,   15,   15,   16,   15,   15,   15,   15,   15,   15,
       15,   15,    6,   17,   15,   18,   15,   15,   15,   15,
       19,   15,   15,   15,   15,   15,   15,   20,   21,   15,
        6,   22,    6,    7,    8,   23,   24,   24,    6,   25,
       24,   24,    6,   24,    6,   24,    6,    6,    6,    6,
       26,   27,   28,   29,    6,    6,    6,    6,   30,    6,
       31,    6,    6,   32,   24,   33,    6,    6,    6,    6,
        6,    6,    6,   34,    6,   35,    6,    6,    6,    6,

        6,   36,   24,    6,   37,   37,   37,   37,   38,   38,
       40,   79,   40,   39,   41,   41,   41,   41,   40,   77,
       40,   94,   42,   42,   42,   42,   43,   93,   43,   92,
       44,   44,   44,   44,   43,   94,   43,   93,   44,   44,
       44,   44,   49,   49,   49,   49,   92,   50,   74,   50,
       45,   49,   49,   70,   46,   73,   50,   37,   37,   47,
       72,   49,   49,   49,   49,   48,   50,   71,   50,   52,
       49,   49,   78,   78,   78,   50,   70,   49,   49,   63,
       63,   69,   50,   68,   64,   53,   38,   38,   40,   67,
       40,   39,   41,   41,   41,   41,   66,   54,   55,   65,

      137,   56,   76,   57,   58,   59,   76,   76,   60,   62,
       41,   41,   41,   41,   61,   43,  137,   43,  137,   44,
       44,   44,   44,   75,   75,   75,   75,   43,  137,   43,
      137,   44,   44,   44,   44,   49,   49,   49,   49,  137,
       50,  137,   50,   49,   49,   49,   49,  137,   50,  137,
       50,   49,   49,   49,   49,  137,   50,  137,   50,   49,
       49,   49,   49,  137,   50,  137,   50,   86,   86,   49,
       49,   80,   87,  137,   50,   49,   49,   49,   49,  137,
       50,  137,   50,   49,   49,   83,  137,   81,   50,   82,
       63,   63,   78,   78,   78,   64,   75,   75,   75,   75,

      137,  137,   84,  137,   76,   88,  137,   85,   76,   76,
       95,   95,   49,   49,  137,   96,   89,   50,   49,   49,
       49,   49,   90,   50,   91,   50,  100,  100,  102,  102,
      137,  101,  137,  103,   86,   86,  105,  105,  137,   87,
      137,  106,  107,  107,   49,   49,  137,  108,  137,   50,
      111,  111,   95,   95,  137,  112,  137,   96,   97,   98,
      137,   99,  114,  114,  137,  104,  137,  115,  117,  117,
      120,  120,  137,  118,  137,  121,  100,  100,  137,  109,
      137,  101,  137,  102,  102,  123,  123,  113,  103,  137,
      124,  110,  105,  105,  137,  107,  107,  106,  137,  116,

      108,  125,  125,  127,  127,  119,  126,  122,  128,  111,
      111,  129,  129,  137,  112,  137,  130,  114,  114,  131,
      131,  137,  115,  137,  132,  117,  117,  133,  133,  137,
      118,  137,  134,  120,  120,  135,  135,  137,  121,  137,
      136,  123,  123,  125,  125,  137,  124,  137,  126,  127,
      127,  129,  129,  137,  128,  137,  130,  131,  131,  133,
      133,  137,  132,  137,  134,  135,  135,  137,  137,  137,
      136,   51,   51,    5,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,

      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137
    } ;

static yyconst flex_int16_t yy_chk[527] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    7,    7,    8,    8,    9,    9,
       11,  140,   11,    9,   11,   11,   11,   11,   12,  139,
       12,   74,   12,   12,   12,   12,   13,   73,   13,   72,
       13,   13,   13,   13,   14,   71,   14,   69,   14,   14,
       14,   14,   15,   15,   16,   16,   68,   15,   36,   16,
       13,   17,   17,   35,   13,   34,   17,   37,   37,   13,
       33,   18,   18,   19,   19,   13,   18,   32,   19,   16,
       20,   20,   47,   47,   47,   20,   31,   21,   21,   22,
       22,   30,   21,   29,   22,   17,   38,   38,   40,   28,
       40,   38,   40,   40,   40,   40,   26,   17,   17,   25,

        5,   18,   45,   18,   19,   19,   45,   45,   20,   21,
       41,   41,   41,   41,   20,   42,    0,   42,    0,   42,
       42,   42,   42,   43,   43,   43,   43,   44,    0,   44,
        0,   44,   44,   44,   44,   49,   49,   51,   51,    0,
       49,    0,   51,   52,   52,   53,   53,    0,   52,    0,
       53,   54,   54,   55,   55,    0,   54,    0,   55,   56,
       56,   57,   57,    0,   56,    0,   57,   58,   58,   59,
       59,   52,   58,    0,   59,   60,   60,   61,   61,    0,
       60,    0,   61,   62,   62,   55,    0,   53,   62,   54,
       63,   63,   78,   78,   78,   63,   75,   75,   75,   75,

        0,    0,   56,    0,   76,   59,    0,   57,   76,   76,
       80,   80,   81,   81,    0,   80,   60,   81,   82,   82,
       83,   83,   61,   82,   62,   83,   84,   84,   85,   85,
        0,   84,    0,   85,   86,   86,   88,   88,    0,   86,
        0,   88,   89,   89,   90,   90,    0,   89,    0,   90,
       91,   91,   95,   95,    0,   91,    0,   95,   81,   82,
        0,   83,   97,   97,    0,   85,    0,   97,   98,   98,
       99,   99,    0,   98,    0,   99,  100,  100,    0,   89,
        0,  100,    0,  102,  102,  104,  104,   91,  102,    0,
      104,   90,  105,  105,    0,  107,  107,  105,    0,   97,

      107,  109,  109,  110,  110,   98,  109,   99,  110,  111,
      111,  113,  113,    0,  111,    0,  113,  114,  114,  116,
      116,    0,  114,    0,  116,  117,  117,  119,  119,    0,
      117,    0,  119,  120,  120,  122,  122,    0,  120,    0,
      122,  123,  123,  125,  125,    0,  123,    0,  125,  127,
      127,  129,  129,    0,  127,    0,  129,  131,  131,  133,
      133,    0,  131,    0,  133,  135,  135,    0,    0,    0,
      135,  138,  138,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,

      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
      137,  137,  137,  137,  137,  137
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int yy_flex_debug;
int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "flex_parser.l"
/* TODO
* 
*/

#line 15 "flex_parser.l"
#include <stdlib.h>
#include <ctype.h>

#include "galculator.h"
#include "calc_basic.h"
#include "general_functions.h"
#include "math_functions.h"
#include "flex_parser.h"

static int flex_parser_identify_constant (char *string);
static int flex_parser_identify_user_function (char *string);
static void flex_parser_submit_token(char operation);
static void flex_parser_submit_func_token (double (*func)(double));

static GSList		*user_function_stack=NULL, *flex_buffer_stack=NULL;
static ALG_OBJECT	*alg_object_stack=NULL;
static s_cb_token 	parser_token;
static int 			bracket_counter=0;
#line 640 "flex_parser.c"

#define INITIAL 0
#define OP 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex (void);

#define YY_DECL int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 36 "flex_parser.l"

	/* 
	 * OPERATIONS.
	 */
#line 797 "flex_parser.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 138 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 137 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 40 "flex_parser.l"
flex_parser_submit_token(*yytext);
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 41 "flex_parser.l"
flex_parser_submit_token('<');
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 42 "flex_parser.l"
flex_parser_submit_token('>');
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 43 "flex_parser.l"
flex_parser_submit_token('&');
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 44 "flex_parser.l"
flex_parser_submit_token('|');
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 45 "flex_parser.l"
flex_parser_submit_token('x');
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 46 "flex_parser.l"
flex_parser_submit_token('m');
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 47 "flex_parser.l"
flex_parser_submit_token('='); return TRUE;
	YY_BREAK
/* 
	 * opening bracket - a bit different from an operation 
	 */
case 9:
YY_RULE_SETUP
#line 51 "flex_parser.l"
{
			parser_token.func = NULL;
			parser_token.operation = *yytext;
			gpointer *thisData = &(alg_object_stack->data);
			alg_add_token ((ALG_OBJECT **) thisData, parser_token);
			bracket_counter++;
		}
	YY_BREAK
/* 
	 * closing bracket - a bit different from an operation 
	 */
case 10:
YY_RULE_SETUP
#line 61 "flex_parser.l"
{
			parser_token.func = NULL;
			parser_token.operation = *yytext;
			/* closing bracket must be followed by operation,
			 * the value we want to feed with that operation
			 * is alg_add_token's return value
			 */
			gpointer *thisData = &(alg_object_stack->data);
			parser_token.number = alg_add_token ((ALG_OBJECT **) thisData, parser_token);
			bracket_counter--;
		}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 72 "flex_parser.l"
{
			parser_token.func = factorial;
			parser_token.operation = *yytext;
			/* closing bracket must be followed by operation,
			 * the value we want to feed with that operation
			 * is alg_add_token's return value
			 */
			gpointer *thisData = &(alg_object_stack->data);
			parser_token.number = alg_add_token ((ALG_OBJECT **) thisData, parser_token);
			bracket_counter--;
		}
	YY_BREAK
/* 
	 * FACTORIAL - only after a number, not after a bracket enclosed expression
	 */
case 12:
YY_RULE_SETUP
#line 87 "flex_parser.l"
parser_token.number = factorial(parser_token.number);
	YY_BREAK
/* 
	 * NUMBERS
	 */
case 13:
YY_RULE_SETUP
#line 92 "flex_parser.l"
parser_token.number = string2double (yytext, CS_DEC); BEGIN(OP);
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 93 "flex_parser.l"
parser_token.number = string2double (yytext, CS_DEC); BEGIN(OP);
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 94 "flex_parser.l"
yytext+=2*sizeof(char); parser_token.number = string2double (yytext, CS_BIN); BEGIN(OP);
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 95 "flex_parser.l"
yytext+=2*sizeof(char); parser_token.number = string2double (yytext, CS_OCT); BEGIN(OP);
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 96 "flex_parser.l"
yytext+=2*sizeof(char); parser_token.number = string2double (yytext, CS_HEX); BEGIN(OP);
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 97 "flex_parser.l"
yytext+=2*sizeof(char); parser_token.number = string2double (yytext, CS_HEX); BEGIN(OP);
	YY_BREAK
/* 
	 * CONSTANTS __maybe__ 
	 */
case 19:
YY_RULE_SETUP
#line 101 "flex_parser.l"
{
			if (flex_parser_identify_constant(yytext) == FALSE)  return FALSE;
			BEGIN(OP);
		}
	YY_BREAK
/* 
	 * FUNCTIONS
	 */
case 20:
/* rule 20 can match eol */
YY_RULE_SETUP
#line 108 "flex_parser.l"
flex_parser_submit_func_token (sin_wrapper);
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 109 "flex_parser.l"
flex_parser_submit_func_token (asin_wrapper);
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 110 "flex_parser.l"
flex_parser_submit_func_token (sinh);
	YY_BREAK
case 23:
/* rule 23 can match eol */
YY_RULE_SETUP
#line 111 "flex_parser.l"
flex_parser_submit_func_token (asinh);
	YY_BREAK
case 24:
/* rule 24 can match eol */
YY_RULE_SETUP
#line 112 "flex_parser.l"
flex_parser_submit_func_token (cos_wrapper);
	YY_BREAK
case 25:
/* rule 25 can match eol */
YY_RULE_SETUP
#line 113 "flex_parser.l"
flex_parser_submit_func_token (acos_wrapper);
	YY_BREAK
case 26:
/* rule 26 can match eol */
YY_RULE_SETUP
#line 114 "flex_parser.l"
flex_parser_submit_func_token (cosh);
	YY_BREAK
case 27:
/* rule 27 can match eol */
YY_RULE_SETUP
#line 115 "flex_parser.l"
flex_parser_submit_func_token (acosh);
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 116 "flex_parser.l"
flex_parser_submit_func_token (tan_wrapper);
	YY_BREAK
case 29:
/* rule 29 can match eol */
YY_RULE_SETUP
#line 117 "flex_parser.l"
flex_parser_submit_func_token (atan_wrapper);
	YY_BREAK
case 30:
/* rule 30 can match eol */
YY_RULE_SETUP
#line 118 "flex_parser.l"
flex_parser_submit_func_token (tanh);
	YY_BREAK
case 31:
/* rule 31 can match eol */
YY_RULE_SETUP
#line 119 "flex_parser.l"
flex_parser_submit_func_token (atanh);
	YY_BREAK
case 32:
/* rule 32 can match eol */
YY_RULE_SETUP
#line 120 "flex_parser.l"
flex_parser_submit_func_token (sqrt);
	YY_BREAK
case 33:
/* rule 33 can match eol */
YY_RULE_SETUP
#line 121 "flex_parser.l"
flex_parser_submit_func_token (log);
	YY_BREAK
case 34:
/* rule 34 can match eol */
YY_RULE_SETUP
#line 122 "flex_parser.l"
flex_parser_submit_func_token (log10);
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 123 "flex_parser.l"
flex_parser_submit_func_token (factorial);
	YY_BREAK
case 36:
/* rule 36 can match eol */
YY_RULE_SETUP
#line 124 "flex_parser.l"
flex_parser_submit_func_token (cmp);
	YY_BREAK
case 37:
/* rule 37 can match eol */
YY_RULE_SETUP
#line 125 "flex_parser.l"
flex_parser_submit_func_token (cmp);
	YY_BREAK
case 38:
/* rule 38 can match eol */
YY_RULE_SETUP
#line 126 "flex_parser.l"
flex_parser_submit_func_token (cmp);
	YY_BREAK
/* 
	 * USER DEFINED FUNCTIONS. __maybe__
	 */
case 39:
/* rule 39 can match eol */
YY_RULE_SETUP
#line 130 "flex_parser.l"
if (flex_parser_identify_user_function (yytext) == FALSE) return FALSE;
	YY_BREAK
/*
	 * ignore spaces
	 */
case 40:
/* rule 40 can match eol */
YY_RULE_SETUP
#line 134 "flex_parser.l"

	YY_BREAK
/*
	 * UNKNOWN
	 */
case 41:
YY_RULE_SETUP
#line 138 "flex_parser.l"
return FALSE;
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 140 "flex_parser.l"
ECHO;
	YY_BREAK
#line 1163 "flex_parser.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(OP):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), (size_t) num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 138 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 138 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 137);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (yyconst char * yystr )
{
    
	return yy_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) yyalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

int yyget_debug  (void)
{
        return yy_flex_debug;
}

void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = (FILE *) 0;
    yyout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 140 "flex_parser.l"



static double user_function_handler (double value)
{
	int			index;
	s_flex_parser_result	result;

	/* pop user function index from stack */
	index = GPOINTER_TO_INT (user_function_stack->data);
	user_function_stack = g_slist_delete_link (user_function_stack, user_function_stack);
	result = compute_user_function (user_function[index].expression, 
		user_function[index].variable, 
		get_display_number_string (value, CS_DEC));
	if (!result.error) return result.value;
	else yyterminate();
}

static int flex_parser_identify_user_function (char *string)
{	
	int 	counter;

	/* remove spaces and opening bracket */
	counter = strlen(string) - 2;
	while ((counter > 0) && isspace(string[counter])) counter--;
	string[counter + 1] = '\0';
	counter = 0;
	while (user_function[counter].name != NULL) {
		if (strcmp (user_function[counter].name, string) == 0) {
			user_function_stack = g_slist_prepend (
				user_function_stack, GINT_TO_POINTER (counter));
			flex_parser_submit_func_token(user_function_handler);
			return TRUE;
		}
		counter++;
	}
	return FALSE;
}

static int flex_parser_identify_constant (char *string)
{
	int 	counter = 0;
	
	while (constant[counter].name != NULL) {
		if (strcmp (constant[counter].name, string) == 0) {
			parser_token.number = string2double(constant[counter].value, CS_DEC);
			return TRUE;
		}
		counter++;
	}
	return FALSE;
}

static void flex_parser_submit_token (char operation)
{
	parser_token.operation = operation;
	gpointer *thisData = &(alg_object_stack->data);
	parser_token.number = alg_add_token ((ALG_OBJECT **) thisData, parser_token);
	BEGIN(INITIAL);
}

static void flex_parser_submit_func_token (double (*func)(double))
{
	parser_token.func = func;
	parser_token.operation = '(';
	gpointer *thisData = &(alg_object_stack->data);
	alg_add_token ((ALG_OBJECT **) thisData, parser_token);
	bracket_counter++;
}

s_flex_parser_result flex_parser (const char *string)
{
	int 			string_length, bracket_level;
	char			*my_string;
	static int 		recursion_counter = 0;
	s_flex_parser_result	return_result;
	
	recursion_counter++;
	if (recursion_counter > FLEX_PARSER_NR_RECURSIONS)
		fprintf (stderr, _("[%s] flex parser was called more than %i times. Do you \
know what you are doing? If not: %s\n"), PROG_NAME, FLEX_PARSER_NR_RECURSIONS, BUG_REPORT);
	/* create a '=' terminated copy of string */
	string_length = strlen(string);
	if (string[string_length-1] != '=') {
		my_string = (char *) malloc ((string_length + 2) * sizeof(char));
		strcpy(my_string, string);
		my_string[string_length] = '=';
		my_string[string_length + 1] = '\0';
	} else {
		my_string = (char *) malloc ((string_length+ 1) * sizeof(char));
		strcpy (my_string, string);
	}
	/* initialize */
	bracket_level = bracket_counter;
	alg_object_stack = g_slist_prepend (alg_object_stack, alg_init(0));
	/* the flex specific part. put current buffer on stack, create new one */
	flex_buffer_stack = g_slist_prepend (flex_buffer_stack, YY_CURRENT_BUFFER);
        yy_scan_string (my_string);
	BEGIN(INITIAL);
        return_result.error = !yylex();
	/* restore previous buffer state */
        yy_delete_buffer(YY_CURRENT_BUFFER);
	yy_switch_to_buffer (flex_buffer_stack->data);
	flex_buffer_stack = g_slist_delete_link (flex_buffer_stack, flex_buffer_stack);
	free (my_string);
	alg_free (alg_object_stack->data);
	alg_object_stack = g_slist_delete_link (alg_object_stack, alg_object_stack);
	/* after finishing a buffer we insert a number, so state is OP?!?!? */
	BEGIN(OP);
	/* process result */
	if (bracket_counter != bracket_level) {
		return_result.error = TRUE;
		bracket_counter = bracket_level;
	}		
	return_result.value = parser_token.number;
	recursion_counter--;
	return return_result;
}

