/**
 * @file meta-service.h Meta-Service API
 *
 * Copyright (C) 2004-2006 Christian Hammond.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA  02111-1307  USA
 */
#ifndef _GALAGOD_META_SERVICE_H_
#define _GALAGOD_META_SERVICE_H_

typedef struct _GalagodMetaService GalagodMetaService;

#include <libgalago/galago.h>
#include "account-list.h"

struct _GalagodMetaService
{
	GalagoService *service;

	GList *services;

	GalagodAccountList *account_list;
};

#define GALAGOD_META_SERVICE(service) \
	(g_object_get_data(G_OBJECT(service), "meta-service"))

GalagodMetaService *galagod_meta_service_new(const char *id, const char *name,
											 GalagoServiceFlags flags);
void galagod_meta_service_destroy(GalagodMetaService *meta_service);

GalagoService *galagod_meta_service_get_service(
	const GalagodMetaService *meta_service);

GList *galagod_meta_service_get_services(
	const GalagodMetaService *meta_service);

GalagodAccountList *galagod_meta_service_get_account_list(
	const GalagodMetaService *meta_service);

void galagod_meta_service_add_service(GalagodMetaService *meta_service,
									  GalagoService *service);
void galagod_meta_service_remove_service(GalagodMetaService *meta_service,
										 GalagoService *service);

#endif /* _GALAGOD_META_SERVICE_H_ */
