/*
 * tiers.h
 * Thomas Nemeth, le 22.02.2000
 *
 * HEADER
 * Gestion de la liste des donnes de gAcc, gestionnaire de comptes
 * banquaires personnels avec GTK+.
 *
 *   Copyright (C) 1999  Thomas Nemeth
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef _TIERS_H_
#define _TIERS_H_

#include "structs.h"


/* ------++++++======*** TIERS ******* 3RD PARTY ***======++++++----- */

/* Charge les dfinitions des tiers                                   */
/* Load tiers' definitions                                            */
void read_tiers_from_file ();

/* crit les dfinitions des tiers dans un fichier                    */
/* Write tiers' definitions in a file                                 */
void write_tiers_to_file ();

/* Ajoute une catgorie  la liste                                    */
/* Add a category to the list                                         */
void add_tiers (TIERS *tiers);

/* Enlve un tiers sans l'effacer                                     */
/* Remove a tiers without deleting it                                 */
void remove_tiers (TIERS *tiers);

/* Efface un tiers de la liste                                        */
/* Delete a tiers from the list                                       */
void del_tiers (TRS_ELT *element);

/* Rcupre un tiers par son numro (premier == 0) dans la liste      */
/* Get a tiers by its number (first == 0) in the list                 */
TRS_ELT *get_tiers (int trs_num);

/* Rcupre un tiers par son nom                                      */
/* Get a tiers by its name                                            */
TRS_ELT *get_tiers_with_name (const char *trs_name);

/* Rcupre un tiers par son numro rel                              */
/* Get a tiers by its real number                                     */
TRS_ELT *get_tiers_with_num (int trs_num);

/* Rcupre le prochain numro  affecter  un tiers                  */
/* Get the next number to affect a tiers                              */
int get_tiers_next_num ();

/* Renvoie le nom du tiers associe au numro                         */
/* Return the name of the tiers associated with the number            */
char *tiers_name (int trs_num);

/* Renvoie le numro du tiers associe au nom                         */
/* Return the number of the tiers associated with the name            */
int tiers_number (char *trs_name);

/* Libre la mmoire utilise par la liste des tiers                  */
/* Free the memory used by the tiers list                             */
void free_tiers ();

/* Oprations sur les tiers                                           */
/* Operations on tiers                                                */
TIERS *tiers_new ();
TIERS *get_tiers_from_line (const char *line);
char *create_line_from_tiers (TIERS *trs);
TRS_ELT *trs_list_elt_new ();
void trs_set_name (TIERS *trs, const char *name);
void trs_set_num  (TIERS *trs, int num);
void trs_set_flag (TIERS *trs, int is_in_file);

#endif

