/* MolcasLib.c */
/**********************************************************************************************************
Copyright (c) 2002-2007 Abdul-Rahman Allouche. All rights reserved

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
documentation files (the Gabedit), to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be included in all copies or substantial portions
  of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
************************************************************************************************************/

#include "../../Config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include "../Common/GabeditType.h"
#include "../Utils/Utils.h"
#include "../Utils/Constantes.h"
#include "../Molcas/MolcasLib.h"
/********************************************************************************/
void getMolcasBasisList(gchar* Symb, gchar* outfile, gchar* errfile)
{
	FILE* fout=FOpen(outfile,"w");  
	FILE* ferr=FOpen(errfile,"w");  
  
	gchar *filename = g_strdup_printf("%s%smolcasbasis",gabedit_directory(), G_DIR_SEPARATOR_S);

	FILE* fin = FOpen(filename,"r");
	
	gchar* t = g_malloc(BSIZE*sizeof(gchar));
	gchar* dump = g_malloc(BSIZE*sizeof(gchar));

#define NBASIS 400
	gchar* basisName[NBASIS];
	gchar* author[NBASIS];
	gchar* primitive[NBASIS];
	gchar* contraction[NBASIS];
	gchar* ecpType[NBASIS];

	gchar symb[6];
	gint nbas = 0;
	gint n = 0;
	gint j;

	for(j=0;j<NBASIS;j++)
	{
		basisName[j] = g_malloc(BSIZE*sizeof(gchar));
		author[j] = g_malloc(BSIZE*sizeof(gchar));
		primitive[j] = g_malloc(BSIZE*sizeof(gchar));
		contraction[j] = g_malloc(BSIZE*sizeof(gchar));
		ecpType[j] = g_malloc(BSIZE*sizeof(gchar));
	}

	if(!fin)
	{
		create_molcas_basis_file();
		fin = FOpen(filename,"r");
	}
	if(!fin)
	{
		fprintf(ferr,"Sorry the molcasbasis is corrupted.\nPlease reinstall gabedit\n");
		fclose(ferr);
		fclose(fout);
		
		g_free(t);
		g_free(dump);
		for(j=0;j<NBASIS;j++)
		{
			g_free(basisName[j]);
			g_free(author[j]);
			g_free(primitive[j]);
			g_free(contraction[j]);
			g_free(ecpType[j]);
		}
		return;
	}

	fgets(t,BSIZE,fin); /* number of atoms */
	while(!feof(fin))
	{
		if(!fgets(t,BSIZE,fin)) break;
		if(strstr(t,"Atom") && strstr(t,Symb) && sscanf(t,"%s %s",dump,symb)==2 && strcmp(Symb,symb) ==0 )
		{
			if(!fgets(t,BSIZE,fin)) break;
			sscanf(t,"%d",&nbas);
			for(j=0;j<nbas;j++)
			{
				if(!fgets(t,BSIZE,fin)) break;
			
				n = sscanf(t,"%s %s %s %s %s %s",symb, basisName[j], author[j], primitive[j], contraction[j], ecpType[j]);
				if(n<6) sprintf(ecpType[j],"UNK");
				if(n<5) sprintf(contraction[j],"UNK");
				if(n<4) sprintf(primitive[j],"UNK");
				if(n<3) sprintf(author[j],"UNK");
				if(n<2)
				{
					nbas = 0;
					break;
				}
			}
			break;
		}
	}
	if(nbas<1) 
		fprintf(ferr,"Sorry the molcasbasis is corrupted.\nPlease reinstall gabedit\n");
	else
	{
		for(j=0; j<nbas; j++)
		{
			fprintf(fout,"\t%s.",Symb);
			fprintf(fout,"%s.",basisName[j]);
			if(strstr(author[j],"UNK")) fprintf(fout,".");
			else fprintf(fout,"%s.",author[j]);
			if(strstr(primitive[j],"UNK")) fprintf(fout,".");
			else fprintf(fout,"%s.",primitive[j]);
			if(strstr(contraction[j],"UNK")) fprintf(fout,".");
			else fprintf(fout,"%s.",contraction[j]);
			if(strstr(ecpType[j],"UNK")) fprintf(fout,".");
			else fprintf(fout,"%s.",ecpType[j]);
			fprintf(fout,"\n");
		}
	}
	fclose(ferr);
	fclose(fin);
	fclose(fout);
	g_free(t);
	g_free(dump);
	for(j=0;j<NBASIS;j++)
	{
		g_free(basisName[j]);
		g_free(author[j]);
		g_free(primitive[j]);
		g_free(contraction[j]);
		g_free(ecpType[j]);
	}
}
/********************************************************************************/
gboolean create_molcas_basis_file()
{
        gchar *fileName =  g_strdup_printf("%s/molcasbasis",gabedit_directory());  
	FILE* file = fopen(fileName,"w");

	g_free(fileName);

	if(file==NULL)
	{
		return FALSE;
	}
	fprintf(file,"Natoms = 103\n");
	fprintf(file,"Atom  H\n");
	fprintf(file,"16\n");
	fprintf(file,"H Pol Sadlej 6s4p 3s2p UNK\n");
	fprintf(file,"H ano-l Widmark 8s4p3d 6s4p3d UNK\n");
	fprintf(file,"H ano-s Pierloot 7s3p 4s3p UNK\n");
	fprintf(file,"H 3-21G Binkley 3s 2s UNK\n");
	fprintf(file,"H 6-31G** UNK 4s1p 2s1p UNK\n");
	fprintf(file,"H STO-3G Hehre 3s 1s UNK\n");
	fprintf(file,"H 6-31G UNK 4s 2s UNK\n");
	fprintf(file,"H 6-31G* UNK 4s 2s UNK\n");
	fprintf(file,"H cc-pVTZ Dunning 5s2p1d 3s2p1d UNK\n");
	fprintf(file,"H cc-pVQZ Dunning 6s3p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"H cc-pVDZ Dunning 4s1p 2s1p UNK\n");
	fprintf(file,"H ANO-DK3 Tsuchiya 6s 1s UNK\n");
	fprintf(file,"H 4-31G Ditchfield 4s 2s UNK\n");
	fprintf(file,"H ano-rcc Widmark 8s4p3d1f 6s4p3d1f UNK\n");
	fprintf(file,"H aug-cc-pVDZ Dunning 5s2p 3s2p UNK\n");
	fprintf(file,"H aug-cc-pVTZ Dunning 6s3p2d 4s3p2d UNK\n");
	fprintf(file,"Atom  Li\n");
	fprintf(file,"20\n");
	fprintf(file,"Li Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"Li ano-l Widmark 14s9p4d3f 7s6p4d3f UNK\n");
	fprintf(file,"Li ano-s Pierloot 10s4p3d 6s4p3d UNK\n");
	fprintf(file,"Li 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"Li 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Li STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"Li 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"Li 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Li cc-pVTZ Dunning 11s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"Li cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"Li cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"Li ANO-DK3 Tsuchiya 12s 2s UNK\n");
	fprintf(file,"Li 4-31G Ditchfield 8s3p 3s2p UNK\n");
	fprintf(file,"Li ano-rcc Roos 14s9p4d3f1g 8s7p4d2f1g UNK\n");
	fprintf(file,"Li ECP Seijo 4s 1s 0e-AIMP-LiF\n");
	fprintf(file,"Li ECP Dolg 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Li ECP Seijo 0s 0s 0e-AIMP-LiF\n");
	fprintf(file,"Li ECP Barandiaran 5s1p 1s1p 1e-CG-AIMP\n");
	fprintf(file,"Li ECP Huzinaga 5s1p 1s1p 1e-NR-AIMP\n");
	fprintf(file,"Li ECP Stoll 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Atom  Na\n");
	fprintf(file,"31\n");
	fprintf(file,"Na Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"Na ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Na ano-s Pierloot 13s8p3d 6s5p3d UNK\n");
	fprintf(file,"Na 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Na 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Na STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Na 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Na 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Na cc-pVTZ Dunning 16s10p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"Na cc-pVQZ Dunning 19s12p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Na cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Na ANO-DK3 Tsuchiya 16s11p 3s1p UNK\n");
	fprintf(file,"Na ano-rcc Roos 17s12p5d4f 9s8p5d4f UNK\n");
	fprintf(file,"Na ECP Seijo 0s 0s 0e-AIMP-NaCl\n");
	fprintf(file,"Na ECP Barandiaran 7s6p 1s2p 7e-CG-AIMP\n");
	fprintf(file,"Na ECP Seijo 7s6p 1s2p 7e-NR-AIMP\n");
	fprintf(file,"Na ECP Barandiaran 6s3p 1s1p 0e-AIMP-K2NaGaF6\n");
	fprintf(file,"Na ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6\n");
	fprintf(file,"Na ECP Barandiaran 6s3p 1s1p 0e-AIMP-K2NaGaF6-60Kbar\n");
	fprintf(file,"Na ECP HW 3s3p 2s2p 1e-LANL2DZ\n");
	fprintf(file,"Na ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6-60Kbar\n");
	fprintf(file,"Na ECP Abdalla 7s4p 1s1p 0e-AIMP-Cs2NaYCl6\n");
	fprintf(file,"Na ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYCl6\n");
	fprintf(file,"Na ECP Abdalla 7s4p 1s2p 0e-AIMP-Cs2NaYBr6\n");
	fprintf(file,"Na ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYBr6\n");
	fprintf(file,"Na ECP Seijo 6s3p 1s1p 0e-AIMP-NaF\n");
	fprintf(file,"Na ECP Dolg 4s4p 2s2p 1e-SDF\n");
	fprintf(file,"Na ECP Seijo 0s 0s 0e-AIMP-NaF\n");
	fprintf(file,"Na ECP Seijo 6s3p 1s1p 0e-AIMP-NaCl\n");
	fprintf(file,"Na ECP Stoll 4s4p 2s2p 1e-SDF\n");
	fprintf(file,"Na ECP Hay-Wadt 3s3p 2s2p 1e-LANL2DZ\n");
	fprintf(file,"Atom  K\n");
	fprintf(file,"21\n");
	fprintf(file,"K Pol Sadlej 15s13p4d 9s7p2d UNK\n");
	fprintf(file,"K ano-s Pierloot 17s12p4d 7s6p4d UNK\n");
	fprintf(file,"K 6-31G** UNK 14s9p4d 5s3p4d UNK\n");
	fprintf(file,"K STO-3G Pietro 12s9p 4s3p UNK\n");
	fprintf(file,"K 6-31G UNK 22s16p 5s4p UNK\n");
	fprintf(file,"K 6-31G* UNK 14s9p4d 5s3p4d UNK\n");
	fprintf(file,"K ANO-DK3 Tsuchiya 20s15p 4s2p UNK\n");
	fprintf(file,"K ano-rcc Roos 21s16p5d4f 10s9p5d3f UNK\n");
	fprintf(file,"K ECP Seijo 0s 0s 0e-AIMP-KF\n");
	fprintf(file,"K ECP Barandiaran 9s7p 1s2p 7e-CG-AIMP\n");
	fprintf(file,"K ECP Seijo 9s7p 1s2p 7e-NR-AIMP\n");
	fprintf(file,"K ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6\n");
	fprintf(file,"K ECP HW 5s5p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"K ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6-60Kbar\n");
	fprintf(file,"K ECP Lopez-Moraza 0s 0s 0e-AIMP-KMgF3\n");
	fprintf(file,"K ECP Lopez-Moraza 0s 0s 0e-AIMP-KZnF3\n");
	fprintf(file,"K ECP Dolg 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"K ECP Lopez-Moraza 0s 0s 0e-AIMP-KCdF3\n");
	fprintf(file,"K ECP Seijo 10s7p 1s1p 0e-AIMP-KF\n");
	fprintf(file,"K ECP Stoll 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"K ECP Hay-Wadt 5s5p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"Atom  Rb\n");
	fprintf(file,"9\n");
	fprintf(file,"Rb Pol Sadlej 18s15p10d 11s9p4d UNK\n");
	fprintf(file,"Rb ANO-DK3 Tsuchiya 23s19p12d 5s3p1d UNK\n");
	fprintf(file,"Rb ano-rcc Roos 23s19p11d4f 10s10p5d4f UNK\n");
	fprintf(file,"Rb ECP HW 5s6p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"Rb ECP Dolg 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"Rb ECP Seijo 11s9p6d 1s2p1d 7e-NR-AIMP\n");
	fprintf(file,"Rb ECP Barandiaran 11s9p6d 1s2p1d 7e-CG-AIMP\n");
	fprintf(file,"Rb ECP Stoll 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"Rb ECP Hay-Wadt 5s6p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"Atom  Cs\n");
	fprintf(file,"12\n");
	fprintf(file,"Cs ANO-DK3 Tsuchiya 27s23p15d 6s4p2d UNK\n");
	fprintf(file,"Cs ano-rcc Roos 26s22p15d4f 12s10p8d4f UNK\n");
	fprintf(file,"Cs ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYCl6\n");
	fprintf(file,"Cs ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYBr6\n");
	fprintf(file,"Cs ECP Lopez-Moraza 0s 0s 0e-AIMP-CsCaF3\n");
	fprintf(file,"Cs ECP Casarrubios 0s 0s 0e-AIMP-Cs2GeF6\n");
	fprintf(file,"Cs ECP HW 5s6p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"Cs ECP Dolg 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"Cs ECP Barandiaran 13s11p8d 1s2p1d 7e-CG-AIMP\n");
	fprintf(file,"Cs ECP Seijo 13s11p8d 1s2p1d 7e-NR-AIMP\n");
	fprintf(file,"Cs ECP Stoll 7s6p 5s4p 9e-MWB\n");
	fprintf(file,"Cs ECP Hay-Wadt 5s6p 3s3p 9e-LANL2DZ\n");
	fprintf(file,"Atom  Fr\n");
	fprintf(file,"2\n");
	fprintf(file,"Fr ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d1f UNK\n");
	fprintf(file,"Fr ano-rcc Roos 28s25p17d12f 12s11p8d5f UNK\n");
	fprintf(file,"Atom  Be\n");
	fprintf(file,"18\n");
	fprintf(file,"Be Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"Be ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"Be ano-s Pierloot 10s4p3d 6s4p3d UNK\n");
	fprintf(file,"Be 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"Be 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Be STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"Be 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"Be 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Be cc-pVTZ Dunning 11s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"Be cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"Be cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"Be ANO-DK3 Tsuchiya 12s 2s UNK\n");
	fprintf(file,"Be 4-31G Ditchfield 8s3p 3s2p UNK\n");
	fprintf(file,"Be ano-rcc Roos 14s9p5d2f1g 9s8p5d2f1g UNK\n");
	fprintf(file,"Be ECP Huzinaga 5s1p 1s1p 2e-NR-AIMP\n");
	fprintf(file,"Be ECP Barandiaran 5s1p 1s1p 2e-CG-AIMP\n");
	fprintf(file,"Be ECP Dolg 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Be ECP Stoll 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Atom  Mg\n");
	fprintf(file,"24\n");
	fprintf(file,"Mg Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"Mg ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Mg ano-s Pierloot 13s8p3d 7s5p3d UNK\n");
	fprintf(file,"Mg 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Mg 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Mg STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Mg 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Mg 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Mg cc-pVTZ Dunning 15s10p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"Mg cc-pVQZ Dunning 16s12p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Mg cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Mg ANO-DK3 Tsuchiya 16s11p 3s1p UNK\n");
	fprintf(file,"Mg ano-rcc Roos 17s12p6d2f 9s8p6d2f UNK\n");
	fprintf(file,"Mg ECP Pascual 0s 0s 0e-AIMP-MgO\n");
	fprintf(file,"Mg ECP Pascual 0s 0s 0e-AIMP-MgO-0\n");
	fprintf(file,"Mg ECP Barandiaran 7s6p1d 1s2p1d 8e-CG-AIMP\n");
	fprintf(file,"Mg ECP Seijo 7s6p1d 1s2p1d 8e-NR-AIMP\n");
	fprintf(file,"Mg ECP Lopez-Moraza 7s4p 1s1p 0e-AIMP-KMgF3\n");
	fprintf(file,"Mg ECP Lopez-Moraza 0s 0s 0e-AIMP-KMgF3\n");
	fprintf(file,"Mg ECP Dolg 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Mg ECP Pascual 10s4p 1s1p 0e-AIMP-MgO\n");
	fprintf(file,"Mg ECP HW 3s3p 2s2p 2e-LANL2DZ\n");
	fprintf(file,"Mg ECP Stoll 4s4p 2s2p 2e-SDF\n");
	fprintf(file,"Mg ECP Hay-Wadt 3s3p 2s2p 2e-LANL2DZ\n");
	fprintf(file,"Atom  Ca\n");
	fprintf(file,"19\n");
	fprintf(file,"Ca Pol Sadlej 15s13p4d 9s7p2d UNK\n");
	fprintf(file,"Ca ano-s Pierloot 17s12p4d 7s7p4d UNK\n");
	fprintf(file,"Ca 6-31G** UNK 14s9p4d 5s3p4d UNK\n");
	fprintf(file,"Ca STO-3G Pietro 12s9p 4s3p UNK\n");
	fprintf(file,"Ca 6-31G UNK 22s16p 5s4p UNK\n");
	fprintf(file,"Ca 6-31G* UNK 14s9p4d 5s3p4d UNK\n");
	fprintf(file,"Ca ANO-DK3 Tsuchiya 20s15p 4s2p UNK\n");
	fprintf(file,"Ca ano-rcc Roos 20s16p6d2f 10s9p6d2f UNK\n");
	fprintf(file,"Ca ECP Seijo 9s7p5d 1s2p3d 8e-NR-AIMP\n");
	fprintf(file,"Ca ECP Lopez-Moraza 10s7p 1s1p 0e-AIMP-CsCaF3\n");
	fprintf(file,"Ca ECP HW 5s5p 3s3p 10e-LANL2DZ\n");
	fprintf(file,"Ca ECP Lopez-Moraza 0s 0s 0e-AIMP-CsCaF3\n");
	fprintf(file,"Ca ECP Pascual 13s7p 1s1p 0e-AIMP-CaO\n");
	fprintf(file,"Ca ECP Pascual 0s 0s 0e-AIMP-CaO\n");
	fprintf(file,"Ca ECP Dolg 6s6p5d 4s4p2d 10e-MWB\n");
	fprintf(file,"Ca ECP Pascual 0s 0s 0e-AIMP-CaF2\n");
	fprintf(file,"Ca ECP Barandiaran 9s7p5d 1s2p3d 8e-CG-AIMP\n");
	fprintf(file,"Ca ECP Stoll 6s6p5d 4s4p2d 10e-MWB\n");
	fprintf(file,"Ca ECP Hay-Wadt 5s5p 3s3p 10e-LANL2DZ\n");
	fprintf(file,"Atom  Sr\n");
	fprintf(file,"13\n");
	fprintf(file,"Sr Pol Sadlej 18s15p10d 11s9p4d UNK\n");
	fprintf(file,"Sr ANO-DK3 Tsuchiya 23s19p12d 5s3p1d UNK\n");
	fprintf(file,"Sr ano-rcc Roos 23s19p12d4f 11s10p7d4f UNK\n");
	fprintf(file,"Sr ECP Pascual 0s 0s 0e-AIMP-SrO\n");
	fprintf(file,"Sr ECP Pascual 0s 0s 0e-AIMP-SrO-QR\n");
	fprintf(file,"Sr ECP Pascual 0s 0s 0e-AIMP-SrF2\n");
	fprintf(file,"Sr ECP Barandiaran 11s9p6d 1s2p1d 8e-CG-AIMP\n");
	fprintf(file,"Sr ECP HW 5s6p 3s3p 10e-LAN2LDZ\n");
	fprintf(file,"Sr ECP Dolg 6s6p5d 4s4p2d 10e-MWB\n");
	fprintf(file,"Sr ECP Seijo 11s9p7d 1s2p1d 8e-NR-AIMP\n");
	fprintf(file,"Sr ECP Pascual 16s10p 1s1p 0e-AIMP-SrO\n");
	fprintf(file,"Sr ECP Stoll 6s6p5d 4s4p2d 10e-MWB\n");
	fprintf(file,"Sr ECP Hay-Wadt 5s6p 3s3p 10e-LAN2LDZ\n");
	fprintf(file,"Atom  Ba\n");
	fprintf(file,"9\n");
	fprintf(file,"Ba ANO-DK3 Tsuchiya 27s23p15d 6s4p2d UNK\n");
	fprintf(file,"Ba ano-rcc Roos 26s22p15d4f 12s10p8d4f UNK\n");
	fprintf(file,"Ba ECP Pascual 0s 0s 0e-AIMP-BaF2\n");
	fprintf(file,"Ba ECP HW 5s6p 3s3p 10e-LANL2DZ\n");
	fprintf(file,"Ba ECP Dolg 6s6p5d1f 4s4p2d1f 10e-MWB\n");
	fprintf(file,"Ba ECP Barandiaran 13s11p8d 1s2p1d 8e-CG-AIMP\n");
	fprintf(file,"Ba ECP Seijo 13s11p8d 1s2p1d 8e-NR-AIMP\n");
	fprintf(file,"Ba ECP Stoll 6s6p5d1f 4s4p2d1f 10e-MWB\n");
	fprintf(file,"Ba ECP Hay-Wadt 5s6p 3s3p 10e-LANL2DZ\n");
	fprintf(file,"Atom  Ra\n");
	fprintf(file,"2\n");
	fprintf(file,"Ra ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d1f UNK\n");
	fprintf(file,"Ra ano-rcc Roos 28s25p17d12f 12s11p8d5f UNK\n");
	fprintf(file,"Atom  Sc\n");
	fprintf(file,"11\n");
	fprintf(file,"Sc ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Sc ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"Sc 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Sc ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Sc ECP Seijo 9s6p6d 1s2p2d 9e-NR-AIMP\n");
	fprintf(file,"Sc ECP HW 5s5p5d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"Sc ECP Rakowitz 9s6p6d3f 5s4p4d1f 11e-NP-AIMP\n");
	fprintf(file,"Sc ECP Dolg 8s7p6d1f 6s5p3d1f 11e-MWB\n");
	fprintf(file,"Sc ECP Barandiaran 9s6p6d 1s2p2d 9e-CG-AIMP\n");
	fprintf(file,"Sc ECP Stoll 8s7p6d1f 6s5p3d1f 11e-MDF\n");
	fprintf(file,"Sc ECP Hay-Wadt 5s5p5d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"Atom  Y\n");
	fprintf(file,"11\n");
	fprintf(file,"Y Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Y ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Y ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYCl6\n");
	fprintf(file,"Y ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYBr6\n");
	fprintf(file,"Y ECP Rakowitz 11s8p7d3f 5s4p4d1f 11e-NP-AIMP\n");
	fprintf(file,"Y ECP Barandiaran 11s8p7d 1s2p2d 9e-CG-AIMP\n");
	fprintf(file,"Y ECP HW 5s6p4d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"Y ECP Dolg 8s7p6d 6s5p3d 11e-MWB\n");
	fprintf(file,"Y ECP Barandiaran 11s8p7d 1s2p2d 9e-NR-AIMP\n");
	fprintf(file,"Y ECP Stoll 8s7p6d 6s5p3d 11e-MWB\n");
	fprintf(file,"Y ECP Hay-Wadt 5s6p4d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"Atom  La\n");
	fprintf(file,"10\n");
	fprintf(file,"La ANO-DK3 Tsuchiya 27s23p15d 6s4p3d UNK\n");
	fprintf(file,"La ano-rcc Roos 24s21p15d5f3g 11s10p8d5f3g UNK\n");
	fprintf(file,"La ECP HW 5s6p3d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"La ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"La ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"La ECP Casarrubios 13s10p8d 1s2p2d 9e-CG-AIMP\n");
	fprintf(file,"La ECP Casarrubios 13s10p8d 1s2p2d 9e-NR-AIMP\n");
	fprintf(file,"La ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"La ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"La ECP Hay-Wadt 5s6p3d 3s3p2d 11e-LANL2DZ\n");
	fprintf(file,"Atom  Ac\n");
	fprintf(file,"5\n");
	fprintf(file,"Ac ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d1f UNK\n");
	fprintf(file,"Ac ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 29e-MWB\n");
	fprintf(file,"Ac ECP Dolg 12s11p10d8f 8s7p6d4f 29e-MWB\n");
	fprintf(file,"Ac ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 29e-MWB\n");
	fprintf(file,"Ac ECP Stoll 12s11p10d8f 8s7p6d4f 29e-MWB\n");
	fprintf(file,"Atom  Ti\n");
	fprintf(file,"11\n");
	fprintf(file,"Ti ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Ti ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"Ti 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Ti ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Ti ECP Seijo 9s6p6d 1s2p2d 10e-NR-AIMP\n");
	fprintf(file,"Ti ECP HW 5s5p5d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Ti ECP Rakowitz 9s6p6d3f 5s4p4d1f 12e-NP-AIMP\n");
	fprintf(file,"Ti ECP Dolg 8s7p6d1f 6s5p3d1f 12e-MDF\n");
	fprintf(file,"Ti ECP Barandiaran 9s6p6d 1s2p2d 10e-CG-AIMP\n");
	fprintf(file,"Ti ECP Stoll 8s7p6d1f 6s5p3d1f 12e-MDF\n");
	fprintf(file,"Ti ECP Hay-Wadt 5s5p5d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  Zr\n");
	fprintf(file,"9\n");
	fprintf(file,"Zr Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Zr ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Zr ECP Rakowitz 11s8p7d3f 5s4p4d1f 12e-NP-AIMP\n");
	fprintf(file,"Zr ECP Barandiaran 11s8p7d 1s2p2d 10e-CG-AIMP\n");
	fprintf(file,"Zr ECP HW 5s6p4d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Zr ECP Dolg 8s7p6d 6s5p3d 12e-MWB\n");
	fprintf(file,"Zr ECP Barandiaran 11s8p7d 1s2p2d 10e-NR-AIMP\n");
	fprintf(file,"Zr ECP Stoll 8s7p6d 6s5p3d 12e-MWB\n");
	fprintf(file,"Zr ECP Hay-Wadt 5s6p4d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  Hf\n");
	fprintf(file,"11\n");
	fprintf(file,"Hf Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Hf ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Hf ano-rcc Roos 24s21p15d11f4g 11s10p9d8f4g UNK\n");
	fprintf(file,"Hf ECP Rakowitz 13s10p9d1f 5s4p4d1f 12e-NP-AIMP\n");
	fprintf(file,"Hf ECP Casarrubios 13s10p9d5f 1s2p2d1f 10e-CG-AIMP\n");
	fprintf(file,"Hf ECP HW 5s6p3d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Hf ECP Dolg 8s7p6d 6s5p3d 12e-MWB\n");
	fprintf(file,"Hf ECP Casarrubios 13s10p9d5f 1s2p2d1f 10e-NR-AIMP\n");
	fprintf(file,"Hf ECP Rakowitz 13s10p9d6f 5s4p4d2f 12e-NP-AIMP\n");
	fprintf(file,"Hf ECP Stoll 8s7p6d 6s5p3d 12e-MWB\n");
	fprintf(file,"Hf ECP Hay-Wadt 5s6p3d 3s3p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  V\n");
	fprintf(file,"11\n");
	fprintf(file,"V ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"V ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"V 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"V ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"V ECP Seijo 9s6p6d 1s2p2d 11e-NR-AIMP\n");
	fprintf(file,"V ECP HW 5s5p5d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"V ECP Rakowitz 9s6p6d3f 5s4p4d1f 13e-NP-AIMP\n");
	fprintf(file,"V ECP Dolg 8s7p6d1f 6s5p3d1f 13e-MDF\n");
	fprintf(file,"V ECP Barandiaran 9s6p6d 1s2p2d 11e-CG-AIMP\n");
	fprintf(file,"V ECP Stoll 8s7p6d1f 6s5p3d1f 13e-MDF\n");
	fprintf(file,"V ECP Hay-Wadt 5s5p5d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"Atom  Nb\n");
	fprintf(file,"9\n");
	fprintf(file,"Nb Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Nb ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Nb ECP Rakowitz 11s8p7d3f 5s4p4d1f 13e-NP-AIMP\n");
	fprintf(file,"Nb ECP Barandiaran 11s8p7d 1s2p2d 11e-CG-AIMP\n");
	fprintf(file,"Nb ECP HW 5s6p4d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"Nb ECP Dolg 8s7p6d 6s5p3d 13e-MWB\n");
	fprintf(file,"Nb ECP Barandiaran 11s8p7d 1s2p2d 11e-NR-AIMP\n");
	fprintf(file,"Nb ECP Stoll 8s7p6d 6s5p3d 13e-MWB\n");
	fprintf(file,"Nb ECP Hay-Wadt 5s6p4d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"Atom  Ta\n");
	fprintf(file,"11\n");
	fprintf(file,"Ta Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Ta ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Ta ano-rcc Roos 24s21p15d11f4g 11s10p9d8f4g UNK\n");
	fprintf(file,"Ta ECP Rakowitz 13s10p9d1f 5s4p4d1f 13e-NP-AIMP\n");
	fprintf(file,"Ta ECP Casarrubios 13s10p9d5f 1s2p2d1f 11e-CG-AIMP\n");
	fprintf(file,"Ta ECP HW 5s6p3d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"Ta ECP Dolg 8s7p6d 6s5p3d 13e-MWB\n");
	fprintf(file,"Ta ECP Casarrubios 13s10p9d5f 1s2p2d1f 11e-NR-AIMP\n");
	fprintf(file,"Ta ECP Rakowitz 13s10p9d6f 5s4p4d2f 13e-NP-AIMP\n");
	fprintf(file,"Ta ECP Stoll 8s7p6d 6s5p3d 13e-MWB\n");
	fprintf(file,"Ta ECP Hay-Wadt 5s6p3d 3s3p2d 13e-LANL2DZ\n");
	fprintf(file,"Atom  Ce\n");
	fprintf(file,"7\n");
	fprintf(file,"Ce ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Ce ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Ce ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Ce ECP Diaz-Megias 14s10p9d8f 2s1p1d1f 12e-CG-AIMP\n");
	fprintf(file,"Ce ECP Tsuchiya 14s10p9d8f 2s1p1d1f 12e-DK3-AIMP\n");
	fprintf(file,"Ce ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Ce ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Th\n");
	fprintf(file,"9\n");
	fprintf(file,"Th Raf-r Wahlgren 24s19p14d11f 9s8p7d5f UNK\n");
	fprintf(file,"Th ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d1f UNK\n");
	fprintf(file,"Th ECP Dolg 12s11p7d8f 8s7p6d4f 30e-MWB\n");
	fprintf(file,"Th ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 30e-MWB\n");
	fprintf(file,"Th ECP Paulovic 14s10p11d9f 2s1p1d1f 12e-DK3-AIMP\n");
	fprintf(file,"Th ECP Paulovic 14s10p11d9f 2s1p2d1f 22e-DK3-AIMP\n");
	fprintf(file,"Th ECP Seijo 14s10p11d9f 2s1p1d1f 12e-CG-AIMP\n");
	fprintf(file,"Th ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 30e-MWB\n");
	fprintf(file,"Th ECP Stoll 12s11p7d8f 8s7p6d4f 30e-MWB\n");
	fprintf(file,"Atom  Cr\n");
	fprintf(file,"13\n");
	fprintf(file,"Cr ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Cr ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"Cr 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Cr ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Cr ano-rcc Roos 21s15p10d6f4g 10s10p8d6f4g UNK\n");
	fprintf(file,"Cr ECP HW 5s5p5d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"Cr ECP Rakowitz 9s6p6d3f 5s4p4d1f 14e-NP-AIMP\n");
	fprintf(file,"Cr ECP Dolg 8s7p6d 6s5p3d 14e-MDF\n");
	fprintf(file,"Cr ECP Barandiaran 9s6p6d 1s2p2d 12e-CG-AIMP\n");
	fprintf(file,"Cr ECP Seijo 9s6p6d 1s2p2d 12e-NR-AIMP\n");
	fprintf(file,"Cr ECP Stoll 8s7p6d1f 6s5p3d1f 14e-MDF\n");
	fprintf(file,"Cr ECP Stoll 8s7p6d 6s5p3d 14e-MDF\n");
	fprintf(file,"Cr ECP Hay-Wadt 5s5p5d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"Atom  Mo\n");
	fprintf(file,"9\n");
	fprintf(file,"Mo Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Mo ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Mo ECP Rakowitz 11s8p7d3f 5s4p4d1f 14e-NP-AIMP\n");
	fprintf(file,"Mo ECP Barandiaran 11s8p7d 1s2p2d 12e-CG-AIMP\n");
	fprintf(file,"Mo ECP HW 5s6p4d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"Mo ECP Dolg 8s7p6d 6s5p3d 14e-MWB\n");
	fprintf(file,"Mo ECP Barandiaran 11s8p7d 1s2p2d 12e-NR-AIMP\n");
	fprintf(file,"Mo ECP Stoll 8s7p6d 6s5p3d 14e-MWB\n");
	fprintf(file,"Mo ECP Hay-Wadt 5s6p4d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"Atom  W\n");
	fprintf(file,"11\n");
	fprintf(file,"W Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"W ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"W ano-rcc Roos 24s21p15d11f4g 11s10p9d8f4g UNK\n");
	fprintf(file,"W ECP Rakowitz 13s10p9d1f 5s4p4d1f 14e-NP-AIMP\n");
	fprintf(file,"W ECP Casarrubios 13s10p9d5f 1s2p2d1f 12e-CG-AIMP\n");
	fprintf(file,"W ECP HW 5s6p3d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"W ECP Dolg 8s7p6d 6s5p3d 14e-MWB\n");
	fprintf(file,"W ECP Casarrubios 13s10p9d5f 1s2p2d1f 12e-NR-AIMP\n");
	fprintf(file,"W ECP Rakowitz 13s10p9d6f 5s4p4d2f 14e-NP-AIMP\n");
	fprintf(file,"W ECP Stoll 8s7p6d 6s5p3d 14e-MWB\n");
	fprintf(file,"W ECP Hay-Wadt 5s6p3d 3s3p2d 14e-LANL2DZ\n");
	fprintf(file,"Atom  Pr\n");
	fprintf(file,"7\n");
	fprintf(file,"Pr ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Pr ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Pr ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Pr ECP Seijo 14s10p9d8f 2s1p1d1f 13e-CG-AIMP\n");
	fprintf(file,"Pr ECP Tsuchiya 14s10p9d8f 2s1p1d1f 13e-DK3-AIMP\n");
	fprintf(file,"Pr ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Pr ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Pa\n");
	fprintf(file,"8\n");
	fprintf(file,"Pa ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"Pa ECP Dolg 12s11p10d8f 8s7p6d4f 31e-MWB\n");
	fprintf(file,"Pa ECP Dolg 14s13p10d8f3g 6s6p5d4f3g 31e-MWB\n");
	fprintf(file,"Pa ECP Paulovic 14s10p11d9f 2s1p1d1f 13e-DK3-AIMP\n");
	fprintf(file,"Pa ECP Paulovic 14s10p12d9f 2s1p2d1f 23e-DK3-AIMP\n");
	fprintf(file,"Pa ECP Seijo 14s10p11d9f 2s1p1d1f 13e-CG-AIMP\n");
	fprintf(file,"Pa ECP Stoll 14s13p10d8f3g 6s6p5d4f3g 31e-MWB\n");
	fprintf(file,"Pa ECP Stoll 12s11p10d8f 8s7p6d4f 31e-MWB\n");
	fprintf(file,"Atom  Mn\n");
	fprintf(file,"12\n");
	fprintf(file,"Mn ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Mn ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"Mn 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Mn ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Mn ano-rcc Roos 21s15p10d6f4g 10s9p8d6f4g UNK\n");
	fprintf(file,"Mn ECP HW 5s5p5d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Mn ECP Rakowitz 9s6p6d3f 5s4p4d1f 15e-NP-AIMP\n");
	fprintf(file,"Mn ECP Dolg 8s7p6d1f 6s5p3d1f 15e-MDF\n");
	fprintf(file,"Mn ECP Barandiaran 9s6p6d 1s2p2d 13e-CG-AIMP\n");
	fprintf(file,"Mn ECP Seijo 9s6p6d 1s2p2d 13e-NR-AIMP\n");
	fprintf(file,"Mn ECP Stoll 8s7p6d1f 6s5p3d1f 15e-MDF\n");
	fprintf(file,"Mn ECP Hay-Wadt 5s5p5d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Atom  Tc\n");
	fprintf(file,"9\n");
	fprintf(file,"Tc Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Tc ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Tc ECP Rakowitz 11s8p7d3f 5s4p4d1f 15e-NP-AIMP\n");
	fprintf(file,"Tc ECP Barandiaran 11s8p7d 1s2p2d 13e-CG-AIMP\n");
	fprintf(file,"Tc ECP HW 5s6p4d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Tc ECP Dolg 8s7p6d 6s5p3d 15e-MWB\n");
	fprintf(file,"Tc ECP Barandiaran 11s8p7d 1s2p2d 13e-NR-AIMP\n");
	fprintf(file,"Tc ECP Stoll 8s7p6d 6s5p3d 15e-MWB\n");
	fprintf(file,"Tc ECP Hay-Wadt 5s6p4d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Atom  Re\n");
	fprintf(file,"11\n");
	fprintf(file,"Re Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Re ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Re ano-rcc Roos 24s21p15d11f4g 11s10p9d8f4g UNK\n");
	fprintf(file,"Re ECP Rakowitz 13s10p9d1f 5s4p4d1f 15e-NP-AIMP\n");
	fprintf(file,"Re ECP Casarrubios 13s10p9d5f 1s2p2d1f 13e-CG-AIMP\n");
	fprintf(file,"Re ECP HW 5s6p3d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Re ECP Dolg 8s7p6d 6s5p3d 15e-MWB\n");
	fprintf(file,"Re ECP Casarrubios 13s10p9d5f 1s2p2d1f 13e-NR-AIMP\n");
	fprintf(file,"Re ECP Rakowitz 13s10p9d6f 5s4p4d2f 15e-NP-AIMP\n");
	fprintf(file,"Re ECP Stoll 8s7p6d 6s5p3d 15e-MWB\n");
	fprintf(file,"Re ECP Hay-Wadt 5s6p3d 3s3p2d 15e-LANL2DZ\n");
	fprintf(file,"Atom  Nd\n");
	fprintf(file,"7\n");
	fprintf(file,"Nd ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Nd ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Nd ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Nd ECP Seijo 14s10p9d8f 2s1p1d1f 14e-CG-AIMP\n");
	fprintf(file,"Nd ECP Tsuchiya 14s10p9d8f 2s1p1d1f 14e-DK3-AIMP\n");
	fprintf(file,"Nd ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Nd ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  U\n");
	fprintf(file,"15\n");
	fprintf(file,"U Raf-r Wahlgren 24s19p14d11f 9s8p7d5f UNK\n");
	fprintf(file,"U ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"U ECP Dolg 12s11p10d8f 8s7p6d4f 32e-MWB\n");
	fprintf(file,"U ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 32e-MWB\n");
	fprintf(file,"U ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 32e-SOC\n");
	fprintf(file,"U ECP Dolg 12s11p10d8f 8s7p6d4f 32e-SOC\n");
	fprintf(file,"U ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 32e-MWB\n");
	fprintf(file,"U ECP Paulovic 14s10p11d9f 2s1p1d1f 14e-DK3-AIMP\n");
	fprintf(file,"U ECP Paulovic 14s10p12d9f 2s1p2d1f 24e-DK3-AIMP\n");
	fprintf(file,"U ECP Seijo 14s10p11d9f 2s1p1d1f 14e-CG-AIMP\n");
	fprintf(file,"U ECP Stoll 12s11p10d8f 8s7p6d4f 32e-SOC\n");
	fprintf(file,"U ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 32e-MWB\n");
	fprintf(file,"U ECP Stoll 12s11p10d8f 8s7p6d4f 32e-MWB\n");
	fprintf(file,"U ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 32e-MWB\n");
	fprintf(file,"U ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 32e-SOC\n");
	fprintf(file,"Atom  Fe\n");
	fprintf(file,"12\n");
	fprintf(file,"Fe ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Fe ano-s Pierloot 17s12p9d4f 8s7p7d4f UNK\n");
	fprintf(file,"Fe 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Fe ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Fe ano-rcc Roos 21s15p10d6f4g 10s9p8d6f4g UNK\n");
	fprintf(file,"Fe ECP HW 5s5p5d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Fe ECP Rakowitz 9s6p6d3f 5s4p4d1f 16e-NP-AIMP\n");
	fprintf(file,"Fe ECP Dolg 8s7p6d1f 6s5p3d1f 16-MDF\n");
	fprintf(file,"Fe ECP Barandiaran 9s6p6d 1s2p2d 14e-CG-AIMP\n");
	fprintf(file,"Fe ECP Seijo 9s6p6d 1s2p2d 14e-NR-AIMP\n");
	fprintf(file,"Fe ECP Stoll 8s7p6d1f 6s5p3d1f 16-MDF\n");
	fprintf(file,"Fe ECP Hay-Wadt 5s5p5d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Atom  Ru\n");
	fprintf(file,"9\n");
	fprintf(file,"Ru Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Ru ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Ru ECP Rakowitz 11s8p7d3f 5s4p4d1f 16e-NP-AIMP\n");
	fprintf(file,"Ru ECP Barandiaran 11s8p7d 1s2p2d 14e-CG-AIMP\n");
	fprintf(file,"Ru ECP HW 5s6p4d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Ru ECP Dolg 8s7p6d 6s5p3d 16e-MWB\n");
	fprintf(file,"Ru ECP Barandiaran 11s8p7d 1s2p2d 14e-NR-AIMP\n");
	fprintf(file,"Ru ECP Stoll 8s7p6d 6s5p3d 16e-MWB\n");
	fprintf(file,"Ru ECP Hay-Wadt 5s6p4d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Atom  Os\n");
	fprintf(file,"11\n");
	fprintf(file,"Os Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Os ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Os ano-rcc Roos 24s21p15d11f4g 11s10p9d8f4g UNK\n");
	fprintf(file,"Os ECP Rakowitz 13s10p9d1f 5s4p4d1f 16e-NP-AIMP\n");
	fprintf(file,"Os ECP Casarrubios 13s10p9d5f 1s2p2d1f 14e-CG-AIMP\n");
	fprintf(file,"Os ECP HW 5s6p3d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Os ECP Dolg 8s7p6d 6s5p3d 16e-MWB\n");
	fprintf(file,"Os ECP Casarrubios 13s10p9d5f 1s2p2d1f 14e-NR-AIMP\n");
	fprintf(file,"Os ECP Rakowitz 13s10p9d6f 5s4p4d2f 16e-NP-AIMP\n");
	fprintf(file,"Os ECP Stoll 8s7p6d 6s5p3d 16e-MWB\n");
	fprintf(file,"Os ECP Hay-Wadt 5s6p3d 3s3p2d 16e-LANL2DZ\n");
	fprintf(file,"Atom  Pm\n");
	fprintf(file,"7\n");
	fprintf(file,"Pm ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Pm ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Pm ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Pm ECP Seijo 14s10p9d8f 2s1p1d1f 15e-CG-AIMP\n");
	fprintf(file,"Pm ECP Tsuchiya 14s10p9d8f 2s1p1d1f 15e-DK3-AIMP\n");
	fprintf(file,"Pm ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Pm ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Np\n");
	fprintf(file,"15\n");
	fprintf(file,"Np ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"Np ECP Dolg 12s11p10d8f 8s7p6d4f 33e-MWB\n");
	fprintf(file,"Np ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 33e-MWB\n");
	fprintf(file,"Np ECP Dolg 12s11p10d8f 8s7p6d4f 33e-SOC\n");
	fprintf(file,"Np ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 33e-SOC\n");
	fprintf(file,"Np ECP Dolg 12s11p10d8f 8s7p6d4f 33e-MWB\n");
	fprintf(file,"Np ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 33e-MWB\n");
	fprintf(file,"Np ECP Paulovic 14s10p11d9f 2s1p1d1f 15e-DK3-AIMP\n");
	fprintf(file,"Np ECP Paulovic 14s10p12d9f 2s1p2d1f 25e-DK3-AIMP\n");
	fprintf(file,"Np ECP Seijo 14s10p11d9f 2s1p1d1f 15e-CG-AIMP\n");
	fprintf(file,"Np ECP Stoll 12s11p10d8f 8s7p6d4f 33e-SOC\n");
	fprintf(file,"Np ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 33e-SOC\n");
	fprintf(file,"Np ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 33e-MWB\n");
	fprintf(file,"Np ECP Stoll 12s11p10d8f 8s7p6d4f 33e-MWB\n");
	fprintf(file,"Np ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 33e-MWB\n");
	fprintf(file,"Atom  Co\n");
	fprintf(file,"12\n");
	fprintf(file,"Co ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Co ano-s Pierloot 17s12p9d4f 7s7p7d4f UNK\n");
	fprintf(file,"Co 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Co ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Co ano-rcc Roos 21s15p10d6f4g 10s9p8d6f4g UNK\n");
	fprintf(file,"Co ECP HW 5s5p5d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Co ECP Rakowitz 9s6p6d3f 5s4p4d1f 17e-NP-AIMP\n");
	fprintf(file,"Co ECP Dolg 8s7p6d1f 6s5p3d1f 17e-MDF\n");
	fprintf(file,"Co ECP Barandiaran 9s6p6d 1s2p2d 15e-CG-AIMP\n");
	fprintf(file,"Co ECP Seijo 9s6p6d 1s2p2d 15e-NR-AIMP\n");
	fprintf(file,"Co ECP Stoll 8s7p6d1f 6s5p3d1f 17e-MDF\n");
	fprintf(file,"Co ECP Hay-Wadt 5s5p5d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Atom  Rh\n");
	fprintf(file,"9\n");
	fprintf(file,"Rh Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Rh ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Rh ECP Rakowitz 11s8p7d3f 5s4p4d1f 17e-NP-AIMP\n");
	fprintf(file,"Rh ECP Barandiaran 11s8p7d 1s2p2d 15e-CG-AIMP\n");
	fprintf(file,"Rh ECP HW 5s6p4d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Rh ECP Dolg 8s7p6d 6s5p3d 17e-MWB\n");
	fprintf(file,"Rh ECP Barandiaran 11s8p7d 1s2p2d 15e-NR-AIMP\n");
	fprintf(file,"Rh ECP Stoll 8s7p6d 6s5p3d 17e-MWB\n");
	fprintf(file,"Rh ECP Hay-Wadt 5s6p4d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Atom  Ir\n");
	fprintf(file,"11\n");
	fprintf(file,"Ir Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Ir ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Ir ano-rcc Roos 24s21p15d11f4g 11s10p8d6f4g UNK\n");
	fprintf(file,"Ir ECP Rakowitz 13s10p9d1f 5s4p4d1f 17e-NP-AIMP\n");
	fprintf(file,"Ir ECP Casarrubios 13s10p9d5f 1s2p2d1f 15e-CG-AIMP\n");
	fprintf(file,"Ir ECP HW 5s6p3d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Ir ECP Dolg 8s7p6d 6s5p3d 17e-MWB\n");
	fprintf(file,"Ir ECP Casarrubios 13s10p9d5f 1s2p2d1f 15e-NR-AIMP\n");
	fprintf(file,"Ir ECP Rakowitz 13s10p9d6f 5s4p4d2f 17e-NP-AIMP\n");
	fprintf(file,"Ir ECP Stoll 8s7p6d 6s5p3d 17e-MWB\n");
	fprintf(file,"Ir ECP Hay-Wadt 5s6p3d 3s3p2d 17e-LANL2DZ\n");
	fprintf(file,"Atom  Sm\n");
	fprintf(file,"10\n");
	fprintf(file,"Sm ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Sm ano-rcc Roos 25s22p15d11f4g 12s11p8d7f4g UNK\n");
	fprintf(file,"Sm ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Sm ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Sm ECP Seijo 14s10p9d8f 2s1p1d1f 16e-CG-AIMP\n");
	fprintf(file,"Sm ECP Dolg 12s11p9d8f6g 5s5p4d4f3g 34e-MWB\n");
	fprintf(file,"Sm ECP Tsuchiya 14s10p9d8f 2s1p1d1f 16e-DK3-AIMP\n");
	fprintf(file,"Sm ECP Stoll 12s11p9d8f6g 5s5p4d4f3g 34e-MWB\n");
	fprintf(file,"Sm ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Sm ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Pu\n");
	fprintf(file,"12\n");
	fprintf(file,"Pu ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Pu ECP Dolg 12s11p10d8f 8s7p6d4f 34e-MWB\n");
	fprintf(file,"Pu ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 34e-MWB\n");
	fprintf(file,"Pu ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 34e-SOC\n");
	fprintf(file,"Pu ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 34e-MWB\n");
	fprintf(file,"Pu ECP Paulovic 14s10p11d9f 2s1p1d1f 16e-DK3-AIMP\n");
	fprintf(file,"Pu ECP Paulovic 14s10p12d9f 2s1p2d1f 26e-DK3-AIMP\n");
	fprintf(file,"Pu ECP Seijo 14s10p11d9f 2s1p1d1f 16e-CG-AIMP\n");
	fprintf(file,"Pu ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 34e-MWB\n");
	fprintf(file,"Pu ECP Stoll 12s11p10d8f 8s7p6d4f 34e-MWB\n");
	fprintf(file,"Pu ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 34e-MWB\n");
	fprintf(file,"Pu ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 34e-SOC\n");
	fprintf(file,"Atom  Ni\n");
	fprintf(file,"13\n");
	fprintf(file,"Ni ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Ni ano-s Pierloot 17s12p9d4f 7s7p7d4f UNK\n");
	fprintf(file,"Ni 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Ni ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Ni ECP Rakowitz 9s6p6d3f 5s4p4d1f 18e-NP-AIMP\n");
	fprintf(file,"Ni ECP Barandiaran 9s6p6d 1s2p2d 16e-CG-AIMP\n");
	fprintf(file,"Ni ECP Seijo 9s6p6d 1s2p2d 16e-NR-AIMP\n");
	fprintf(file,"Ni ECP HW 5s5p5d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Ni ECP Seijo 14s11p6d 1s1p1d 0e-AIMP-NiO\n");
	fprintf(file,"Ni ECP Dolg 8s7p6d1f 6s5p3d1f 18e-MDF\n");
	fprintf(file,"Ni ECP Seijo 0s 0s 0e-AIMP-NiO\n");
	fprintf(file,"Ni ECP Stoll 8s7p6d1f 6s5p3d1f 18e-MDF\n");
	fprintf(file,"Ni ECP Hay-Wadt 5s5p5d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Atom  Pd\n");
	fprintf(file,"9\n");
	fprintf(file,"Pd Raf-r Wahlgren 17s13p9d2f 7s6p4d2f UNK\n");
	fprintf(file,"Pd ANO-DK3 Tsuchiya 23s19p12d 4s3p2d UNK\n");
	fprintf(file,"Pd ECP Rakowitz 11s8p7d3f 5s4p4d1f 18e-NP-AIMP\n");
	fprintf(file,"Pd ECP Barandiaran 11s8p7d 1s2p2d 16e-CG-AIMP\n");
	fprintf(file,"Pd ECP HW 5s6p4d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Pd ECP Dolg 8s7p6d 6s5p3d 18e-MWB\n");
	fprintf(file,"Pd ECP Barandiaran 11s8p7d 1s2p2d 16e-NR-AIMP\n");
	fprintf(file,"Pd ECP Stoll 8s7p6d 6s5p3d 18e-MWB\n");
	fprintf(file,"Pd ECP Hay-Wadt 5s6p4d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Atom  Pt\n");
	fprintf(file,"11\n");
	fprintf(file,"Pt Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Pt ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Pt ECP Casarrubios 13s10p9d5f 1s2p2d1f 16e-NR-AIMP\n");
	fprintf(file,"Pt ECP Rakowitz 13s10p9d6f 5s4p4d2f 18e-NP-AIMP\n");
	fprintf(file,"Pt ECP Rakowitz 13s10p9d1f 5s4p4d1f 18e-NP-AIMP\n");
	fprintf(file,"Pt ECP Casarrubios 13s10p9d5f 1s2p2d1f 16e-CG-AIMP\n");
	fprintf(file,"Pt ECP HW 5s6p3d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Pt ECP Dolg 8s7p6d 6s5p3d 18e-MWB\n");
	fprintf(file,"Pt ECP Casarrubios 13s10p9d5f 1s2p2d1f 16e-CG-AIMP-ave\n");
	fprintf(file,"Pt ECP Stoll 8s7p6d 6s5p3d 18e-MWB\n");
	fprintf(file,"Pt ECP Hay-Wadt 5s6p3d 3s3p2d 18e-LANL2DZ\n");
	fprintf(file,"Atom  Eu\n");
	fprintf(file,"7\n");
	fprintf(file,"Eu ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Eu ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Eu ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Eu ECP Seijo 14s10p9d8f 2s1p1d1f 17e-CG-AIMP\n");
	fprintf(file,"Eu ECP Tsuchiya 14s10p9d8f 2s1p1d1f 17e-DK3-AIMP\n");
	fprintf(file,"Eu ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Eu ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Am\n");
	fprintf(file,"10\n");
	fprintf(file,"Am ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Am ECP Dolg 12s11p10d8f 8s7p6d4f 35e-MWB\n");
	fprintf(file,"Am ECP Dolg 12s11p10d8f2g 8s7p6d4f2g 35e-MWB\n");
	fprintf(file,"Am ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 35e-MWB\n");
	fprintf(file,"Am ECP Paulovic 14s10p11d9f 2s1p1d1f 17e-DK3-AIMP\n");
	fprintf(file,"Am ECP Paulovic 14s10p12d9f 2s1p2d1f 27e-DK3-AIMP\n");
	fprintf(file,"Am ECP Seijo 14s10p11d9f 2s1p1d1f 17e-CG-AIMP\n");
	fprintf(file,"Am ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 35e-MWB\n");
	fprintf(file,"Am ECP Stoll 12s11p10d8f 8s7p6d4f 35e-MWB\n");
	fprintf(file,"Am ECP Stoll 12s11p10d8f2g 8s7p6d4f2g 35e-MWB\n");
	fprintf(file,"Atom  Cu\n");
	fprintf(file,"11\n");
	fprintf(file,"Cu ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Cu ano-s Pierloot 17s12p9d4f 8s8p8d4f UNK\n");
	fprintf(file,"Cu 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Cu ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Cu ECP Seijo 9s6p6d 1s2p2d 17e-NR-AIMP\n");
	fprintf(file,"Cu ECP HW 5s5p5d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Cu ECP Rakowitz 9s6p6d3f 5s4p4d1f 19e-NP-AIMP\n");
	fprintf(file,"Cu ECP Dolg 8s7p6d 6s5p3d 19e-MDF\n");
	fprintf(file,"Cu ECP Barandiaran 9s6p6d 1s2p2d 17e-CG-AIMP\n");
	fprintf(file,"Cu ECP Stoll 8s7p6d 6s5p3d 19e-MDF\n");
	fprintf(file,"Cu ECP Hay-Wadt 5s5p5d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Atom  Ag\n");
	fprintf(file,"8\n");
	fprintf(file,"Ag ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Ag ECP Barandiaran 11s8p7d 1s2p2d 17e-NR-AIMP\n");
	fprintf(file,"Ag ECP Rakowitz 11s8p7d3f 5s4p4d1f 19e-NP-AIMP\n");
	fprintf(file,"Ag ECP HW 5s6p4d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Ag ECP Dolg 8s7p6d 6s5p3d 19e-MWB\n");
	fprintf(file,"Ag ECP Barandiaran 11s8p7d 1s2p2d 17e-CG-AIMP\n");
	fprintf(file,"Ag ECP Stoll 8s7p6d 6s5p3d 19e-MWB\n");
	fprintf(file,"Ag ECP Hay-Wadt 5s6p4d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Atom  Au\n");
	fprintf(file,"11\n");
	fprintf(file,"Au Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Au ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Au ano-rcc Roos 24s21p15d11f4g 10s9p8d6f4g UNK\n");
	fprintf(file,"Au ECP Rakowitz 13s10p9d1f 5s4p4d1f 19e-NP-AIMP\n");
	fprintf(file,"Au ECP Casarrubios 13s10p9d5f 1s2p2d1f 17e-CG-AIMP\n");
	fprintf(file,"Au ECP HW 5s6p3d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Au ECP Dolg 8s7p6d 6s5p3d 19e-MWB\n");
	fprintf(file,"Au ECP Casarrubios 13s10p9d5f 1s2p2d1f 17e-NR-AIMP\n");
	fprintf(file,"Au ECP Rakowitz 13s10p9d6f 5s4p4d2f 19e-NP-AIMP\n");
	fprintf(file,"Au ECP Stoll 8s7p6d 6s5p3d 19e-MWB\n");
	fprintf(file,"Au ECP Hay-Wadt 5s6p3d 3s3p2d 19e-LANL2DZ\n");
	fprintf(file,"Atom  Gd\n");
	fprintf(file,"8\n");
	fprintf(file,"Gd ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Gd ano-rcc Roos 25s22p15d11f4g 12s11p8d7f4g UNK\n");
	fprintf(file,"Gd ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Gd ECP Seijo 14s10p9d8f 2s1p1d1f 18e-CG-AIMP\n");
	fprintf(file,"Gd ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Gd ECP Tsuchiya 14s10p9d8f 2s1p1d1f 18e-DK3-AIMP\n");
	fprintf(file,"Gd ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Gd ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Cm\n");
	fprintf(file,"8\n");
	fprintf(file,"Cm ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"Cm ECP Dolg 12s11p10d8f 8s7p6d4f 36e-MWB\n");
	fprintf(file,"Cm ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 36e-MWB\n");
	fprintf(file,"Cm ECP Paulovic 14s10p11d9f 2s1p1d1f 18e-DK3-AIMP\n");
	fprintf(file,"Cm ECP Paulovic 14s10p12d9f 2s1p2d1f 28e-DK3-AIMP\n");
	fprintf(file,"Cm ECP Seijo 14s10p11d9f 2s1p1d1f 18e-CG-AIMP\n");
	fprintf(file,"Cm ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 36e-MWB\n");
	fprintf(file,"Cm ECP Stoll 12s11p10d8f 8s7p6d4f 36e-MWB\n");
	fprintf(file,"Atom  Zn\n");
	fprintf(file,"16\n");
	fprintf(file,"Zn ano-l Pou 21s15p10d6f4g 8s7p6d5f4g UNK\n");
	fprintf(file,"Zn ano-s Pierloot 17s12p9d4f 8s8p8d4f UNK\n");
	fprintf(file,"Zn 6-31G UNK 22s16p4d 5s4p2d UNK\n");
	fprintf(file,"Zn ANO-DK3 Tsuchiya 20s15p9d 4s2p1d UNK\n");
	fprintf(file,"Zn ECP Lopez-Moraza 0s 0s 0e-AIMP-KZnF3\n");
	fprintf(file,"Zn ECP Rakowitz 9s6p6d3f 5s4p4d1f 20e-NP-AIMP\n");
	fprintf(file,"Zn ECP Barandiaran 9s6p5d 1s2p1d 18e-CG-AIMP\n");
	fprintf(file,"Zn ECP Seijo 9s6p5d 1s2p1d 18e-NR-AIMP\n");
	fprintf(file,"Zn ECP HW 3s2p5d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Zn ECP Lopez-Moraza 11s8p5d 1s1p1d 0e-AIMP-KZnF3\n");
	fprintf(file,"Zn ECP Dolg 8s7p6d 6s5p3d 20e-MDF\n");
	fprintf(file,"Zn ECP Dolg 4s2p 3s2p 2e-MWB\n");
	fprintf(file,"Zn ECP Lopez-Moraza 11s8p 1s1p 0e-AIMP-KZnF3\n");
	fprintf(file,"Zn ECP Stoll 8s7p6d 6s5p3d 20e-MDF\n");
	fprintf(file,"Zn ECP Stoll 4s2p 3s2p 2e-MWB\n");
	fprintf(file,"Zn ECP Hay-Wadt 3s2p5d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  Cd\n");
	fprintf(file,"12\n");
	fprintf(file,"Cd ANO-DK3 Tsuchiya 23s19p12d 5s3p2d UNK\n");
	fprintf(file,"Cd ECP Barandiaran 11s8p6d 1s2p1d 18e-NR-AIMP\n");
	fprintf(file,"Cd ECP Lopez-Moraza 11s7p6d 1s1p1d 0e-AIMP-KCdF3\n");
	fprintf(file,"Cd ECP Lopez-Moraza 11s7p 1s1p 0e-AIMP-KCdF3\n");
	fprintf(file,"Cd ECP Lopez-Moraza 0s 0s 0e-AIMP-KCdF3\n");
	fprintf(file,"Cd ECP Pascual 0s 0s 0e-AIMP-CdF2\n");
	fprintf(file,"Cd ECP Rakowitz 11s8p7d3f 5s4p4d1f 20e-NP-AIMP\n");
	fprintf(file,"Cd ECP HW 3s3p4d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Cd ECP Dolg 8s7p6d 6s5p3d 20e-MWB\n");
	fprintf(file,"Cd ECP Barandiaran 11s8p6d 1s2p1d 18e-CG-AIMP\n");
	fprintf(file,"Cd ECP Stoll 8s7p6d 6s5p3d 20e-MWB\n");
	fprintf(file,"Cd ECP Hay-Wadt 3s3p4d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  Hg\n");
	fprintf(file,"12\n");
	fprintf(file,"Hg Raf-r Wahlgren 22s18p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Hg ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Hg ECP Rakowitz 13s10p9d6f 5s4p4d2f 20e-NP-AIMP\n");
	fprintf(file,"Hg ECP Rakowitz 13s10p9d1f 5s4p4d1f 20e-NP-AIMP\n");
	fprintf(file,"Hg ECP Casarrubios 13s10p9d5f 1s2p2d1f 18e-CG-AIMP\n");
	fprintf(file,"Hg ECP HW 3s3p3d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Hg ECP Dolg 8s7p6d 6s5p3d 20e-MWB\n");
	fprintf(file,"Hg ECP Dolg 4s4p1d 2s2p1d 2e-MWB\n");
	fprintf(file,"Hg ECP Casarrubios 13s10p9d5f 1s2p2d1f 18e-NR-AIMP\n");
	fprintf(file,"Hg ECP Stoll 8s7p6d 6s5p3d 20e-MWB\n");
	fprintf(file,"Hg ECP Stoll 4s4p1d 2s2p1d 2e-MWB\n");
	fprintf(file,"Hg ECP Hay-Wadt 3s3p3d 2s2p2d 12e-LANL2DZ\n");
	fprintf(file,"Atom  Tb\n");
	fprintf(file,"7\n");
	fprintf(file,"Tb ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Tb ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Tb ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Tb ECP Seijo 14s10p9d8f 2s1p1d1f 19e-CG-AIMP\n");
	fprintf(file,"Tb ECP Tsuchiya 14s10p9d8f 2s1p1d1f 19e-DK3-AIMP\n");
	fprintf(file,"Tb ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Tb ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Bk\n");
	fprintf(file,"8\n");
	fprintf(file,"Bk ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"Bk ECP Dolg 12s11p10d8f 8s7p6d4f 37e-MWB\n");
	fprintf(file,"Bk ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 37e-MWB\n");
	fprintf(file,"Bk ECP Paulovic 14s10p11d9f 2s1p1d1f 19e-DK3-AIMP\n");
	fprintf(file,"Bk ECP Paulovic 14s10p12d9f 2s1p2d1f 29e-DK3-AIMP\n");
	fprintf(file,"Bk ECP Seijo 14s10p11d9f 2s1p1d1f 19e-CG-AIMP\n");
	fprintf(file,"Bk ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 37e-MWB\n");
	fprintf(file,"Bk ECP Stoll 12s11p10d8f 8s7p6d4f 37e-MWB\n");
	fprintf(file,"Atom  B\n");
	fprintf(file,"19\n");
	fprintf(file,"B ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"B ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"B 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"B 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"B STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"B 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"B 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"B cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"B cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"B cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"B ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"B 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"B ano-rcc Roos 14s9p5d3f2g 9s8p5d3f2g UNK\n");
	fprintf(file,"B aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"B aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"B ECP Dolg 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"B ECP Barandiaran 5s5p1d 1s1p1d 3e-CG-AIMP\n");
	fprintf(file,"B ECP Huzinaga 5s5p1d 1s1p1d 3e-NR-AIMP\n");
	fprintf(file,"B ECP Stoll 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"Atom  Al\n");
	fprintf(file,"20\n");
	fprintf(file,"Al ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Al ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"Al 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Al 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Al STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Al 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Al 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Al cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"Al cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Al cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Al ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"Al ano-rcc Roos 17s12p5d3f 9s9p5d3f UNK\n");
	fprintf(file,"Al aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"Al aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"Al ECP Barandiaran 7s6p1d 1s1p1d 3e-CG-AIMP\n");
	fprintf(file,"Al ECP Huzinaga 7s6p1d 1s1p1d 3e-NR-AIMP\n");
	fprintf(file,"Al ECP HW 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"Al ECP Dolg 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"Al ECP Stoll 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"Al ECP Hay-Wadt 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"Atom  Ga\n");
	fprintf(file,"13\n");
	fprintf(file,"Ga ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"Ga ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"Ga ano-rcc Roos 20s17p11d5f2g 10s9p7d5f2g UNK\n");
	fprintf(file,"Ga aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"Ga aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"Ga ECP HW 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"Ga ECP Dolg 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"Ga ECP Huzinaga 9s8p4d 1s1p2d 3e-NR-AIMP\n");
	fprintf(file,"Ga ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6\n");
	fprintf(file,"Ga ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6-60Kbar\n");
	fprintf(file,"Ga ECP Barandiaran 9s8p4d 1s1p2d 3e-CG-AIMP\n");
	fprintf(file,"Ga ECP Stoll 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"Ga ECP Hay-Wadt 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"Atom  In\n");
	fprintf(file,"8\n");
	fprintf(file,"In ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"In ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"In ECP HW 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"In ECP Dolg 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"In ECP Barandiaran 11s10p7d 1s1p2d 13e-CG-AIMP\n");
	fprintf(file,"In ECP Barandiaran 11s10p7d 1s1p2d 13e-NR-AIMP\n");
	fprintf(file,"In ECP Stoll 4s4p 2s2p 3e-MWB\n");
	fprintf(file,"In ECP Hay-Wadt 3s3p 2s2p 3e-LANL2DZ\n");
	fprintf(file,"Atom  Tl\n");
	fprintf(file,"9\n");
	fprintf(file,"Tl Raf-r Wahlgren 22s17p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Tl ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"Tl ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"Tl ECP HW 3s3p3d 2s2p2d 13e-LANL2DZ\n");
	fprintf(file,"Tl ECP Dolg 4s4p1d 2s2p1d 3e-MWB\n");
	fprintf(file,"Tl ECP Barandiaran 13s12p8d5f 1s1p2d1f 13e-NR-AIMP\n");
	fprintf(file,"Tl ECP Barandiaran 13s12p8d5f 1s1p2d1f 13e-CG-AIMP\n");
	fprintf(file,"Tl ECP Stoll 4s4p1d 2s2p1d 3e-MWB\n");
	fprintf(file,"Tl ECP Hay-Wadt 3s3p3d 2s2p2d 13e-LANL2DZ\n");
	fprintf(file,"Atom  Dy\n");
	fprintf(file,"7\n");
	fprintf(file,"Dy ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Dy ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Dy ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Dy ECP Seijo 14s10p9d8f 2s1p1d1f 20e-CG-AIMP\n");
	fprintf(file,"Dy ECP Tsuchiya 14s10p9d8f 2s1p1d1f 20e-DK3-AIMP\n");
	fprintf(file,"Dy ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Dy ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Cf\n");
	fprintf(file,"8\n");
	fprintf(file,"Cf ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Cf ECP Dolg 12s11p10d8f 8s7p6d4f 38e-MWB\n");
	fprintf(file,"Cf ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 38e-MWB\n");
	fprintf(file,"Cf ECP Paulovic 14s10p11d9f 2s1p1d1f 20e-DK3-AIMP\n");
	fprintf(file,"Cf ECP Paulovic 14s10p12d9f 2s1p2d1f 30e-DK3-AIMP\n");
	fprintf(file,"Cf ECP Seijo 14s10p11d9f 2s1p1d1f 20e-CG-AIMP\n");
	fprintf(file,"Cf ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 38e-MWB\n");
	fprintf(file,"Cf ECP Stoll 12s11p10d8f 8s7p6d4f 38e-MWB\n");
	fprintf(file,"Atom  C\n");
	fprintf(file,"22\n");
	fprintf(file,"C Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"C ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"C ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"C 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"C 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"C STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"C 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"C 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"C cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"C cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"C cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"C ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"C 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"C ano-rcc Roos 14s9p4d3f2g 8s7p4d3f2g UNK\n");
	fprintf(file,"C aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"C aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"C ECP Barandiaran 5s5p1d 1s1p1d 4e-CG-AIMP\n");
	fprintf(file,"C ECP Dolg 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"C ECP Dolg 4s4p1d 2s2p1d 4e-MWB\n");
	fprintf(file,"C ECP Huzinaga 5s5p1d 1s1p1d 4e-NR-AIMP\n");
	fprintf(file,"C ECP Stoll 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"C ECP Stoll 4s4p1d 2s2p1d 4e-MWB\n");
	fprintf(file,"Atom  Si\n");
	fprintf(file,"21\n");
	fprintf(file,"Si Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"Si ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Si ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"Si 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Si 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Si STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Si 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Si 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Si cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"Si cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Si cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Si ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"Si ano-rcc Roos 17s12p5d4f2g 8s7p5d4f2g UNK\n");
	fprintf(file,"Si aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"Si aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"Si ECP Huzinaga 7s6p1d 1s1p1d 4e-NR-AIMP\n");
	fprintf(file,"Si ECP Barandiaran 7s6p1d 1s1p1d 4e-CG-AIMP\n");
	fprintf(file,"Si ECP HW 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Si ECP Dolg 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Si ECP Stoll 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Si ECP Hay-Wadt 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Atom  Ge\n");
	fprintf(file,"13\n");
	fprintf(file,"Ge Pol Sadlej 15s12p9d 9s7p4d UNK\n");
	fprintf(file,"Ge ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"Ge ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"Ge ano-rcc Roos 20s17p11d5f2g 10s9p8d5f2g UNK\n");
	fprintf(file,"Ge aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"Ge aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"Ge ECP Dolg 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Ge ECP Casarrubios 0s 0s 0e-AIMP-Cs2GeF6\n");
	fprintf(file,"Ge ECP Barandiaran 9s8p4d 1s1p2d 4e-CG-AIMP\n");
	fprintf(file,"Ge ECP Huzinaga 9s8p4d 1s1p2d 4e-NR-AIMP\n");
	fprintf(file,"Ge ECP HW 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Ge ECP Stoll 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Ge ECP Hay-Wadt 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Atom  Sn\n");
	fprintf(file,"9\n");
	fprintf(file,"Sn Pol Sadlej 19s15p12d4f 11s9p6d2f UNK\n");
	fprintf(file,"Sn ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"Sn ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"Sn ECP HW 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Sn ECP Dolg 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Sn ECP Barandiaran 11s10p7d 1s1p2d 14e-NR-AIMP\n");
	fprintf(file,"Sn ECP Barandiaran 11s10p7d 1s1p2d 14e-CG-AIMP\n");
	fprintf(file,"Sn ECP Stoll 4s4p 2s2p 4e-MWB\n");
	fprintf(file,"Sn ECP Hay-Wadt 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Atom  Pb\n");
	fprintf(file,"8\n");
	fprintf(file,"Pb ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"Pb ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"Pb ECP HW 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Pb ECP Dolg 4s4p1d 2s2p1d 4e-MWB\n");
	fprintf(file,"Pb ECP Barandiaran 13s12p8d5f 1s1p2d1f 14e-CG-AIMP\n");
	fprintf(file,"Pb ECP Barandiaran 13s12p8d5f 1s1p2d1f 14e-NR-AIMP\n");
	fprintf(file,"Pb ECP Stoll 4s4p1d 2s2p1d 4e-MWB\n");
	fprintf(file,"Pb ECP Hay-Wadt 3s3p 2s2p 4e-LANL2DZ\n");
	fprintf(file,"Atom  Ho\n");
	fprintf(file,"7\n");
	fprintf(file,"Ho ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Ho ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Ho ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Ho ECP Seijo 14s10p9d8f 2s1p1d1f 21e-CG-AIMP\n");
	fprintf(file,"Ho ECP Tsuchiya 14s10p9d8f 2s1p1d1f 21e-DK3-AIMP\n");
	fprintf(file,"Ho ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Ho ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Es\n");
	fprintf(file,"8\n");
	fprintf(file,"Es ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Es ECP Dolg 12s11p10d8f 8s7p6d4f 39e-MWB\n");
	fprintf(file,"Es ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 39e-MWB\n");
	fprintf(file,"Es ECP Paulovic 14s10p11d9f 2s1p1d1f 21e-DK3-AIMP\n");
	fprintf(file,"Es ECP Paulovic 14s10p12d9f 2s1p2d1f 31e-DK3-AIMP\n");
	fprintf(file,"Es ECP Seijo 14s10p11d9f 2s1p1d1f 21e-CG-AIMP\n");
	fprintf(file,"Es ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 39e-MWB\n");
	fprintf(file,"Es ECP Stoll 12s11p10d8f 8s7p6d4f 39e-MWB\n");
	fprintf(file,"Atom  N\n");
	fprintf(file,"23\n");
	fprintf(file,"N Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"N ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"N ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"N 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"N 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"N STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"N TOULBAS TOUL 1s2p 1s2p UNK\n");
	fprintf(file,"N 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"N 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"N cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"N cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"N cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"N ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"N 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"N ano-rcc Roos 14s9p4d3f2g 8s7p4d3f2g UNK\n");
	fprintf(file,"N aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"N aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"N ECP Huzinaga 5s5p1d 1s1p1d 5e-NR-AIMP\n");
	fprintf(file,"N ECP Dolg 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"N ECP Dolg 4s4p1d 2s2p1d 5e-MWB\n");
	fprintf(file,"N ECP Barandiaran 5s5p1d 1s1p1d 5e-CG-AIMP\n");
	fprintf(file,"N ECP Stoll 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"N ECP Stoll 4s4p1d 2s2p1d 5e-MWB\n");
	fprintf(file,"Atom  P\n");
	fprintf(file,"21\n");
	fprintf(file,"P Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"P ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"P ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"P 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"P 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"P 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"P 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"P cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"P cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"P cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"P ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"P 4-31G Ditchfield 12s8p 4s3p UNK\n");
	fprintf(file,"P ano-rcc Roos 17s12p5d4f2g 8s7p5d4f2g UNK\n");
	fprintf(file,"P aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"P aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"P ECP Huzinaga 7s6p1d 1s1p1d 5e-NR-AIMP\n");
	fprintf(file,"P ECP Barandiaran 7s6p1d 1s1p1d 5e-CG-AIMP\n");
	fprintf(file,"P ECP Dolg 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"P ECP HW 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"P ECP Stoll 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"P ECP Hay-Wadt 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Atom  As\n");
	fprintf(file,"12\n");
	fprintf(file,"As Pol Sadlej 15s12p9d 9s7p4d UNK\n");
	fprintf(file,"As ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"As ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"As ano-rcc Roos 20s17p11d4f2g 9s8p6d4f2g UNK\n");
	fprintf(file,"As aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"As aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"As ECP Barandiaran 9s8p4d 1s1p2d 5e-CG-AIMP\n");
	fprintf(file,"As ECP Huzinaga 9s8p4d 1s1p2d 5e-NR-AIMP\n");
	fprintf(file,"As ECP HW 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"As ECP Dolg 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"As ECP Stoll 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"As ECP Hay-Wadt 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Atom  Sb\n");
	fprintf(file,"9\n");
	fprintf(file,"Sb Pol Sadlej 19s15p12d4f 11s9p6d2f UNK\n");
	fprintf(file,"Sb ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"Sb ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"Sb ECP HW 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Sb ECP Dolg 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"Sb ECP Barandiaran 11s10p7d 1s1p2d 15e-NR-AIMP\n");
	fprintf(file,"Sb ECP Barandiaran 11s10p7d 1s1p2d 15e-CG-AIMP\n");
	fprintf(file,"Sb ECP Stoll 4s4p 2s2p 5e-MWB\n");
	fprintf(file,"Sb ECP Hay-Wadt 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Atom  Bi\n");
	fprintf(file,"8\n");
	fprintf(file,"Bi ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"Bi ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"Bi ECP HW 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Bi ECP Dolg 4s4p1d 2s2p1d 5e-MWB\n");
	fprintf(file,"Bi ECP Barandiaran 13s12p8d5f 1s1p2d1f 15e-CG-AIMP\n");
	fprintf(file,"Bi ECP Barandiaran 13s12p8d5f 1s1p2d1f 15e-NR-AIMP\n");
	fprintf(file,"Bi ECP Stoll 4s4p1d 2s2p1d 5e-MWB\n");
	fprintf(file,"Bi ECP Hay-Wadt 3s3p 2s2p 5e-LANL2DZ\n");
	fprintf(file,"Atom  Er\n");
	fprintf(file,"7\n");
	fprintf(file,"Er ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Er ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Er ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Er ECP Seijo 14s10p9d8f 2s1p1d1f 22e-CG-AIMP\n");
	fprintf(file,"Er ECP Tsuchiya 14s10p9d8f 2s1p1d1f 22e-DK3-AIMP\n");
	fprintf(file,"Er ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Er ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Fm\n");
	fprintf(file,"8\n");
	fprintf(file,"Fm ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Fm ECP Dolg 12s11p10d8f 8s7p6d4f 40e-MWB\n");
	fprintf(file,"Fm ECP Dolg 14s13p10d8f6g 6s6p5d4f3g 40e-MWB\n");
	fprintf(file,"Fm ECP Paulovic 14s10p11d9f 2s1p1d1f 22e-DK3-AIMP\n");
	fprintf(file,"Fm ECP Paulovic 14s10p12d9f 2s1p2d1f 32e-DK3-AIMP\n");
	fprintf(file,"Fm ECP Seijo 14s10p11d9f 2s1p1d1f 22e-CG-AIMP\n");
	fprintf(file,"Fm ECP Stoll 14s13p10d8f6g 6s6p5d4f3g 40e-MWB\n");
	fprintf(file,"Fm ECP Stoll 12s11p10d8f 8s7p6d4f 40e-MWB\n");
	fprintf(file,"Atom  O\n");
	fprintf(file,"36\n");
	fprintf(file,"O Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"O ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"O ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"O Raf-r Wahlgren 9s6p1d 3s4p1d UNK\n");
	fprintf(file,"O 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"O 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"O STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"O 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"O 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"O cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"O cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"O cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"O ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"O 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"O ano-rcc Roos 14s9p4d3f2g 8s7p4d3f2g UNK\n");
	fprintf(file,"O aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"O aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"O ECP Seijo 0s 0s 0e-AIMP-NiO\n");
	fprintf(file,"O ECP Barandiaran 5s6p1d 1s2p1d 6e-CG-AIMP\n");
	fprintf(file,"O ECP Huzinaga 5s6p1d 1s2p1d 6e-NR-AIMP\n");
	fprintf(file,"O ECP Pascual 8s6p 1s1p 0e-AIMP-MgO\n");
	fprintf(file,"O ECP Dolg 4s5p 2s3p 6e-MWB\n");
	fprintf(file,"O ECP Dolg 4s5p1d 2s3p1d 6e-MWB\n");
	fprintf(file,"O ECP Dolg 4s5p3d 2s3p2d 6e-MWB\n");
	fprintf(file,"O ECP Dolg 4s5p1d 2s3p1d 6e-SOC\n");
	fprintf(file,"O ECP Dolg 4s5p 2s3p 6e-SOC\n");
	fprintf(file,"O ECP Pascual 0s 0s 0e-AIMP-MgO\n");
	fprintf(file,"O ECP Pascual 0s 0s 0e-AIMP-MgO-0\n");
	fprintf(file,"O ECP Pascual 0s 0s 0e-AIMP-CaO\n");
	fprintf(file,"O ECP Pascual 0s 0s 0e-AIMP-SrO\n");
	fprintf(file,"O ECP Pascual 0s 0s 0e-AIMP-SrO-QR\n");
	fprintf(file,"O ECP Stoll 4s5p 2s3p 6e-MWB\n");
	fprintf(file,"O ECP Stoll 4s5p1d 2s3p1d 6e-MWB\n");
	fprintf(file,"O ECP Stoll 4s5p3d 2s3p2d 6e-MWB\n");
	fprintf(file,"O ECP Stoll 4s5p1d 2s3p1d 6e-SOC\n");
	fprintf(file,"O ECP Stoll 4s5p 2s3p 6e-SOC\n");
	fprintf(file,"Atom  S\n");
	fprintf(file,"23\n");
	fprintf(file,"S Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"S ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"S ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"S 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"S 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"S STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"S 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"S 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"S cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"S cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"S cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"S ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"S 4-31G Ditchfield 12s8p 4s3p UNK\n");
	fprintf(file,"S ano-rcc Roos 17s12p5d4f2g 8s7p5d4f2g UNK\n");
	fprintf(file,"S aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"S aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"S ECP Barandiaran 7s6p1d 1s1p1d 6e-CG-AIMP\n");
	fprintf(file,"S ECP HW 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"S ECP Dolg 4s5p2d 2s3p2d 6e\n");
	fprintf(file,"S ECP Huzinaga 7s6p1d 1s1p1d 6e-NR-AIMP\n");
	fprintf(file,"S ECP Stoll 4s5p 2s3p 6e\n");
	fprintf(file,"S ECP Stoll 4s5p2d 2s3p2d 6e\n");
	fprintf(file,"S ECP Hay-Wadt 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"Atom  Se\n");
	fprintf(file,"12\n");
	fprintf(file,"Se Pol Sadlej 15s12p9d 9s7p4d UNK\n");
	fprintf(file,"Se ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"Se ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"Se ano-rcc Roos 20s17p11d4f2g 9s8p6d4f2g UNK\n");
	fprintf(file,"Se aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"Se aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"Se ECP Barandiaran 9s8p4d 1s1p2d 6e-CG-AIMP\n");
	fprintf(file,"Se ECP Huzinaga 9s8p4d 1s1p2d 6e-NR-AIMP\n");
	fprintf(file,"Se ECP HW 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"Se ECP Dolg 4s5p 2s3p 6e-MWB\n");
	fprintf(file,"Se ECP Stoll 4s5p 2s3p 6e-MWB\n");
	fprintf(file,"Se ECP Hay-Wadt 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"Atom  Te\n");
	fprintf(file,"10\n");
	fprintf(file,"Te Pol Sadlej 19s15p12d4f 11s9p6d2f UNK\n");
	fprintf(file,"Te ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"Te ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"Te ECP HW 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"Te ECP Dolg 4s5p1d 2s3p1d 6e-MWB\n");
	fprintf(file,"Te ECP Barandiaran 11s10p7d 1s1p2d 16e-NR-AIMP\n");
	fprintf(file,"Te ECP Barandiaran 11s10p7d 1s1p2d 16e-CG-AIMP\n");
	fprintf(file,"Te ECP Stoll 4s5p 2s3p 6e-MWB\n");
	fprintf(file,"Te ECP Stoll 4s5p1d 2s3p1d 6e-MWB\n");
	fprintf(file,"Te ECP Hay-Wadt 3s3p 2s2p 6e-LANL2DZ\n");
	fprintf(file,"Atom  Po\n");
	fprintf(file,"7\n");
	fprintf(file,"Po Raf-r Wahlgren 22s17p14d9f 8s7p5d3f UNK\n");
	fprintf(file,"Po ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"Po ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"Po ECP Dolg 4s4p1d 2s2p1d 6e-MWB\n");
	fprintf(file,"Po ECP Barandiaran 13s12p8d5f 1s1p2d1f 16e-NR-AIMP\n");
	fprintf(file,"Po ECP Barandiaran 13s12p8d5f 1s1p2d1f 16e-CG-AIMP\n");
	fprintf(file,"Po ECP Stoll 4s4p1d 2s2p1d 6e-MWB\n");
	fprintf(file,"Atom  Tm\n");
	fprintf(file,"7\n");
	fprintf(file,"Tm ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Tm ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Tm ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Tm ECP Seijo 14s10p9d8f 2s1p1d1f 23e-CG-AIMP\n");
	fprintf(file,"Tm ECP Tsuchiya 14s10p9d8f 2s1p1d1f 23e-DK3-AIMP\n");
	fprintf(file,"Tm ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Tm ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  Md\n");
	fprintf(file,"4\n");
	fprintf(file,"Md ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"Md ECP Paulovic 14s10p11d9f 2s1p1d1f 23e-DK3-AIMP\n");
	fprintf(file,"Md ECP Paulovic 14s10p12d9f 2s1p2d1f 33e-DK3-AIMP\n");
	fprintf(file,"Md ECP Seijo 14s10p11d9f 2s1p1d1f 23e-CG-AIMP\n");
	fprintf(file,"Atom  F\n");
	fprintf(file,"40\n");
	fprintf(file,"F UNK Seijo 0s 0s 0e-AIMP-co-NaF\n");
	fprintf(file,"F Pol Sadlej 10s6p4d 5s3p2d UNK\n");
	fprintf(file,"F ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"F ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"F 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"F 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"F STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"F 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"F 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"F cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"F cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"F cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"F ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"F 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"F ano-rcc Roos 14s9p4d3f2g 8s7p4d3f2g UNK\n");
	fprintf(file,"F aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"F aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"F ECP Casarrubios 0s 0s 0e-AIMP-Cs2GeF6\n");
	fprintf(file,"F ECP Huzinaga 5s6p1d 1s2p1d 7e-NR-AIMP\n");
	fprintf(file,"F ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6\n");
	fprintf(file,"F ECP Barandiaran 0s 0s 0e-AIMP-K2NaGaF6-60Kbar\n");
	fprintf(file,"F ECP Lopez-Moraza 0s 0s 0e-AIMP-KMgF3\n");
	fprintf(file,"F ECP Lopez-Moraza 0s 0s 0e-AIMP-KZnF3\n");
	fprintf(file,"F ECP Lopez-Moraza 0s 0s 0e-AIMP-KCdF3\n");
	fprintf(file,"F ECP Lopez-Moraza 0s 0s 0e-AIMP-CsCaF3\n");
	fprintf(file,"F ECP Seijo 0s 0s 0e-AIMP-LiF\n");
	fprintf(file,"F ECP Seijo 0s 0s 0e-AIMP-NaF\n");
	fprintf(file,"F ECP Barandiaran 5s6p1d 1s2p1d 7e-CG-AIMP\n");
	fprintf(file,"F ECP Seijo 0s 0s 0e-AIMP-sh-NaF\n");
	fprintf(file,"F ECP Dolg 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"F ECP Dolg 4s5p1d 2s3p1d 7e-MWB\n");
	fprintf(file,"F ECP Dolg 4s5p1d 2s3p1d 7e-SOC\n");
	fprintf(file,"F ECP Seijo 0s 0s 0e-AIMP-KF\n");
	fprintf(file,"F ECP Pascual 0s 0s 0e-AIMP-CaF2\n");
	fprintf(file,"F ECP Pascual 0s 0s 0e-AIMP-SrF2\n");
	fprintf(file,"F ECP Pascual 0s 0s 0e-AIMP-BaF2\n");
	fprintf(file,"F ECP Pascual 0s 0s 0e-AIMP-CdF2\n");
	fprintf(file,"F ECP Stoll 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"F ECP Stoll 4s5p1d 2s3p1d 7e-MWB\n");
	fprintf(file,"F ECP Stoll 4s5p1d 2s3p1d 7e-SOC\n");
	fprintf(file,"Atom  Cl\n");
	fprintf(file,"24\n");
	fprintf(file,"Cl Pol Sadlej 14s10p4d 7s5p2d UNK\n");
	fprintf(file,"Cl ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Cl ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"Cl 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Cl 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Cl STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Cl 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Cl 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Cl cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"Cl cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Cl cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Cl ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"Cl 4-31G Ditchfield 12s8p 4s3p UNK\n");
	fprintf(file,"Cl ano-rcc Roos 17s12p5d4f2g 8s7p5d4f2g UNK\n");
	fprintf(file,"Cl aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"Cl aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"Cl ECP Dolg 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"Cl ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYCl6\n");
	fprintf(file,"Cl ECP Seijo 0s 0s 0e-AIMP-NaCl\n");
	fprintf(file,"Cl ECP Barandiaran 7s7p1d 1s2p1d 7e-CG-AIMP\n");
	fprintf(file,"Cl ECP HW 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"Cl ECP Huzinaga 7s7p1d 1s2p1d 7e-NR-AIMP\n");
	fprintf(file,"Cl ECP Stoll 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"Cl ECP Hay-Wadt 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"Atom  Br\n");
	fprintf(file,"13\n");
	fprintf(file,"Br Pol Sadlej 15s12p9d 9s7p4d UNK\n");
	fprintf(file,"Br ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"Br ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"Br ano-rcc Roos 20s17p11d4f2g 9s8p6d4f2g UNK\n");
	fprintf(file,"Br aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"Br aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"Br ECP Dolg 6s6p1d 5s5p1d 7e-MWB\n");
	fprintf(file,"Br ECP Abdalla 0s 0s 0e-AIMP-Cs2NaYBr6\n");
	fprintf(file,"Br ECP Barandiaran 9s8p4d 1s1p2d 7e-CG-AIMP\n");
	fprintf(file,"Br ECP Huzinaga 9s8p4d 1s1p2d 7e-NR-AIMP\n");
	fprintf(file,"Br ECP HW 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"Br ECP Stoll 6s6p1d 5s5p1d 7e-MWB\n");
	fprintf(file,"Br ECP Hay-Wadt 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"Atom  I\n");
	fprintf(file,"9\n");
	fprintf(file,"I Pol Sadlej 19s15p12d4f 11s9p6d2f UNK\n");
	fprintf(file,"I ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"I ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"I ECP HW 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"I ECP Dolg 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"I ECP Barandiaran 11s10p7d 1s1p2d 17e-NR-AIMP\n");
	fprintf(file,"I ECP Barandiaran 11s10p7d 1s1p2d 17e-CG-AIMP\n");
	fprintf(file,"I ECP Stoll 4s5p 2s3p 7e-MWB\n");
	fprintf(file,"I ECP Hay-Wadt 3s3p 2s2p 7e-LANL2DZ\n");
	fprintf(file,"Atom  At\n");
	fprintf(file,"6\n");
	fprintf(file,"At ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"At ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"At ECP Dolg 4s4p1d 2s2p1d 7e-MWB\n");
	fprintf(file,"At ECP Barandiaran 13s12p8d5f 1s1p2d1f 17e-CG-AIMP\n");
	fprintf(file,"At ECP Barandiaran 13s12p8d5f 1s1p2d1f 17e-NR-AIMP\n");
	fprintf(file,"At ECP Stoll 4s4p1d 2s2p1d 7e-MWB\n");
	fprintf(file,"Atom  Yb\n");
	fprintf(file,"8\n");
	fprintf(file,"Yb ANO-DK3 Tsuchiya 27s23p15d10f 6s4p2d1f UNK\n");
	fprintf(file,"Yb ano-rcc Roos 25s22p15d11f4g 11s10p8d7f4g UNK\n");
	fprintf(file,"Yb ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Yb ECP Seijo 14s10p9d8f 2s1p1d1f 24e-CG-AIMP\n");
	fprintf(file,"Yb ECP Dolg 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Yb ECP Tsuchiya 14s10p9d8f 2s1p1d1f 24e-DK3-AIMP\n");
	fprintf(file,"Yb ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Yb ECP Stoll 7s6p5d 5s4p3d 10e-MWB\n");
	fprintf(file,"Atom  No\n");
	fprintf(file,"4\n");
	fprintf(file,"No ANO-DK3 Tsuchiya 35s26p18d13f 7s5p3d2f UNK\n");
	fprintf(file,"No ECP Paulovic 14s10p11d9f 2s1p1d1f 24e-DK3-AIMP\n");
	fprintf(file,"No ECP Paulovic 14s10p12d9f 2s1p2d1f 34e-DK3-AIMP\n");
	fprintf(file,"No ECP Seijo 14s10p11d9f 2s1p1d1f 24e-CG-AIMP\n");
	fprintf(file,"Atom  He\n");
	fprintf(file,"15\n");
	fprintf(file,"He ano-l Widmark 9s4p3d 7s4p3d UNK\n");
	fprintf(file,"He ano-s Pierloot 7s3p 4s3p UNK\n");
	fprintf(file,"He 3-21G Binkley 3s 2s UNK\n");
	fprintf(file,"He 6-31G** UNK 4s1p 2s1p UNK\n");
	fprintf(file,"He STO-3G Hehre 3s 1s UNK\n");
	fprintf(file,"He 6-31G UNK 4s 2s UNK\n");
	fprintf(file,"He 6-31G* UNK 4s 2s UNK\n");
	fprintf(file,"He cc-pVTZ Dunning 6s2p1d 3s2p1d UNK\n");
	fprintf(file,"He cc-pVQZ Dunning 7s3p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"He cc-pVDZ Dunning 4s1p 2s1p UNK\n");
	fprintf(file,"He ANO-DK3 Tsuchiya 6s 1s UNK\n");
	fprintf(file,"He 4-31G Ditchfield 4s 2s UNK\n");
	fprintf(file,"He ano-rcc Widmark 9s4p3d2f 7s4p3d2f UNK\n");
	fprintf(file,"He aug-cc-pVDZ Woon 5s2p 3s2p UNK\n");
	fprintf(file,"He aug-cc-pVTZ Woon 7s3p2d 4s3p2d UNK\n");
	fprintf(file,"Atom  Ne\n");
	fprintf(file,"19\n");
	fprintf(file,"Ne ano-l Widmark 14s9p4d3f 7s7p4d3f UNK\n");
	fprintf(file,"Ne ano-s Pierloot 10s6p3d 7s6p3d UNK\n");
	fprintf(file,"Ne 3-21G Binkley 6s3p 3s2p UNK\n");
	fprintf(file,"Ne 6-31G** UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Ne STO-3G Hehre 6s3p 2s1p UNK\n");
	fprintf(file,"Ne 6-31G UNK 10s4p 3s2p UNK\n");
	fprintf(file,"Ne 6-31G* UNK 10s4p1d 3s2p1d UNK\n");
	fprintf(file,"Ne cc-pVTZ Dunning 10s5p2d1f 4s3p2d1f UNK\n");
	fprintf(file,"Ne cc-pVQZ Dunning 12s6p3d2f1g 5s4p3d2f1g UNK\n");
	fprintf(file,"Ne cc-pVDZ Dunning 9s4p1d 3s2p1d UNK\n");
	fprintf(file,"Ne ANO-DK3 Tsuchiya 12s8p 2s1p UNK\n");
	fprintf(file,"Ne 4-31G Ditchfield 8s4p 3s2p UNK\n");
	fprintf(file,"Ne ano-rcc Roos 14s9p4d3f2g 8s7p4d3f2g UNK\n");
	fprintf(file,"Ne aug-cc-pVDZ Dunning 10s5p2d 4s3p2d UNK\n");
	fprintf(file,"Ne aug-cc-pVTZ Kendall 11s6p3d2f 5s4p3d2f UNK\n");
	fprintf(file,"Ne ECP Dolg 7s7p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Ne ECP Barandiaran 5s5p1d 1s1p1d 8e-CG-AIMP\n");
	fprintf(file,"Ne ECP Huzinaga 5s5p1d 1s1p1d 8e-NR-AIMP\n");
	fprintf(file,"Ne ECP Stoll 7s7p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Atom  Ar\n");
	fprintf(file,"20\n");
	fprintf(file,"Ar ano-l Widmark 17s12p5d4f 7s7p5d4f UNK\n");
	fprintf(file,"Ar ano-s Pierloot 13s10p4d 7s7p4d UNK\n");
	fprintf(file,"Ar 3-21G Gordon 9s6p 4s3p UNK\n");
	fprintf(file,"Ar 6-31G** UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Ar STO-3G Hehre 9s6p 3s2p UNK\n");
	fprintf(file,"Ar 6-31G UNK 16s10p 4s3p UNK\n");
	fprintf(file,"Ar 6-31G* UNK 16s10p1d 4s3p1d UNK\n");
	fprintf(file,"Ar cc-pVTZ Dunning 15s9p2d1f 5s4p2d1f UNK\n");
	fprintf(file,"Ar cc-pVQZ Dunning 16s11p3d2f1g 6s5p3d2f1g UNK\n");
	fprintf(file,"Ar cc-pVDZ Dunning 12s8p1d 4s3p1d UNK\n");
	fprintf(file,"Ar ANO-DK3 Tsuchiya 16s11p 3s2p UNK\n");
	fprintf(file,"Ar ano-rcc Roos 17s12p5d4f2g 8s7p5d4f2g UNK\n");
	fprintf(file,"Ar aug-cc-pVDZ Woon 13s9p2d 5s4p2d UNK\n");
	fprintf(file,"Ar aug-cc-pVTZ Woon 16s10p3d2f 6s5p3d2f UNK\n");
	fprintf(file,"Ar ECP Barandiaran 7s6p1d 1s1p1d 8e-CG-AIMP\n");
	fprintf(file,"Ar ECP Huzinaga 7s6p1d 1s1p1d 8e-NR-AIMP\n");
	fprintf(file,"Ar ECP HW 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Ar ECP Dolg 6s6p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Ar ECP Stoll 6s6p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Ar ECP Hay-Wadt 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Atom  Kr\n");
	fprintf(file,"11\n");
	fprintf(file,"Kr ano-s Pierloot 17s15p9d 9s9p5d UNK\n");
	fprintf(file,"Kr ANO-DK3 Tsuchiya 20s15p9d 4s3p1d UNK\n");
	fprintf(file,"Kr ano-rcc Roos 20s17p11d4f2g 9s8p6d4f2g UNK\n");
	fprintf(file,"Kr aug-cc-pVDZ UNK 15s12p7d 6s5p3d UNK\n");
	fprintf(file,"Kr aug-cc-pVTZ Woon 21s14p10d2f 7s6p4d2f UNK\n");
	fprintf(file,"Kr ECP Huzinaga 9s8p4d 1s1p2d 8e-NR-AIMP\n");
	fprintf(file,"Kr ECP Barandiaran 9s8p4d 1s1p2d 8e-CG-AIMP\n");
	fprintf(file,"Kr ECP HW 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Kr ECP Dolg 6s6p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Kr ECP Stoll 6s6p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Kr ECP Hay-Wadt 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Atom  Xe\n");
	fprintf(file,"8\n");
	fprintf(file,"Xe ANO-DK3 Tsuchiya 23s19p12d 5s4p2d UNK\n");
	fprintf(file,"Xe ano-rcc Roos 22s19p13d5f3g 10s9p8d5f3g UNK\n");
	fprintf(file,"Xe ECP HW 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Xe ECP Dolg 6s6p3d1f 4s4p3d1f 8e-MWB\n");
	fprintf(file,"Xe ECP Barandiaran 11s10p7d 1s1p2d 18e-CG-AIMP\n");
	fprintf(file,"Xe ECP Barandiaran 11s10p7d 1s1p2d 18e-NR-AIMP\n");
	fprintf(file,"Xe ECP Stoll 6s6p3d1f 4s4p3d1f 8e-M\n");
	fprintf(file,"Xe ECP Hay-Wadt 3s3p 2s2p 8e-LANL2DZ\n");
	fprintf(file,"Atom  Rn\n");
	fprintf(file,"6\n");
	fprintf(file,"Rn ANO-DK3 Tsuchiya 27s23p15d10f 6s5p3d1f UNK\n");
	fprintf(file,"Rn ano-rcc Roos 25s22p16d12f4g 11s10p9d6f4g UNK\n");
	fprintf(file,"Rn ECP Dolg 4s4p1d 2s2p1d 8e-MWB\n");
	fprintf(file,"Rn ECP Barandiaran 13s12p8d5f 1s1p2d1f 18e-CG-AIMP\n");
	fprintf(file,"Rn ECP Barandiaran 13s12p8d5f 1s1p2d1f 18e-NR-AIMP\n");
	fprintf(file,"Rn ECP Stoll 4s4p1d 2s2p1d 8e-MWB\n");
	fprintf(file,"Atom  Lu\n");
	fprintf(file,"5\n");
	fprintf(file,"Lu ANO-DK3 Tsuchiya 27s23p15d10f 6s4p3d1f UNK\n");
	fprintf(file,"Lu ECP Dolg 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Lu ECP Seijo 14s10p9d8f 2s1p1d1f 25e-CG-AIMP\n");
	fprintf(file,"Lu ECP Tsuchiya 14s10p9d8f 2s1p1d1f 25e-DK3-AIMP\n");
	fprintf(file,"Lu ECP Stoll 7s6p5d 5s4p3d 11e-MWB\n");
	fprintf(file,"Atom  Lr\n");
	fprintf(file,"4\n");
	fprintf(file,"Lr ANO-DK3 Tsuchiya 35s26p18d13f 7s5p4d2f UNK\n");
	fprintf(file,"Lr ECP Paulovic 14s10p11d9f 2s1p1d1f 25e-DK3-AIMP\n");
	fprintf(file,"Lr ECP Paulovic 14s10p12d9f 2s1p2d1f 35e-DK3-AIMP\n");
	fprintf(file,"Lr ECP Seijo 14s10p11d9f 2s1p1d1f 25e-CG-AIMP\n");
	fclose(file);
	return TRUE;
}
