#include <stdio.h>

#include "guiinterface.h"

GtkWidget *status_bar;

gpointer about_dialog[2] = {gui_about_dialog_create, NULL};
gpointer options_dialog[2] = {gui_options_dialog_create, NULL};
gpointer newgame_dialog[2] = {gui_newgame_dialog_create, NULL};
gpointer loadgame_dialog[2] = {gui_loadgame_dialog_create, NULL};
gpointer savegame_dialog[2] = {gui_savegame_dialog_create, NULL};

GuiMenuTree *gui_menu_tree;

extern Square game_winner;
extern PlayerOptions player_options[2];

void gui_show_win(Coordinate *move)
{
	char str[160];

	if(move == NULL) /* TIE */ {
		gui_board_show_tie();
		gui_dialog_new("Game ended", "Tie!");
	} else {
		gui_board_show_win(move);
		gui_score_update();
		sprintf(str, "%s won!", player_options[game_winner-1].name);
		gui_dialog_new("Game ended", str);
	}
}

int gui_init(int *argc, char ***argv)
{
	GtkWidget *box, *handle_box, *window;

	gtk_init(argc, argv);
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_main_quit), NULL);
	gtk_window_set_title(GTK_WINDOW(window), WINDOW_TITLE);
	gtk_container_border_width(GTK_CONTAINER(window), WINDOW_BORDER);
	gui_menu_tree =
		gui_menu_tree_new(NULL, FALSE,
			gui_menu_tree_new(gui_menu_item_new_with_label("_Game", NULL, NULL), FALSE,
				gui_menu_tree_new(gui_menu_item_new_with_label("_New", GTK_SIGNAL_FUNC(cb_dialog_create), newgame_dialog), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Options", GTK_SIGNAL_FUNC(cb_dialog_create), options_dialog), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_hseparator_new(), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Load", GTK_SIGNAL_FUNC(cb_dialog_create), loadgame_dialog), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Save", GTK_SIGNAL_FUNC(cb_dialog_create), savegame_dialog), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_hseparator_new(), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Quit", GTK_SIGNAL_FUNC(gtk_main_quit), NULL), FALSE, NULL),
			NULL),
			gui_menu_tree_new(gui_menu_item_new_with_label("_Operation", NULL, NULL), FALSE,
				gui_menu_tree_new(gui_menu_item_new_with_label("_Undo", GTK_SIGNAL_FUNC(cb_undo), NULL), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Redo", GTK_SIGNAL_FUNC(cb_redo), NULL), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_hseparator_new(), FALSE, NULL),
				gui_menu_tree_new(gui_menu_item_new_with_label("_Clear board", GTK_SIGNAL_FUNC(cb_board_clear), NULL), FALSE, NULL),
			NULL),
			gui_menu_tree_new(gui_menu_item_new_with_label("_Help", NULL, NULL), TRUE,
				gui_menu_tree_new(gui_menu_item_new_with_label("_About", GTK_SIGNAL_FUNC(cb_dialog_create), about_dialog), FALSE, NULL),
			NULL),
		NULL);
	box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(window), box);

	handle_box = gtk_handle_box_new();
	gtk_box_pack_start(GTK_BOX(box), handle_box, FALSE, FALSE, 0);
	gtk_container_add(GTK_CONTAINER(handle_box), gui_menu_create(window, gui_menu_tree));

	gtk_box_pack_start(GTK_BOX(box), gui_board_new(), TRUE, TRUE, 0);

	status_bar = gtk_statusbar_new();
	gtk_box_pack_end(GTK_BOX(box), status_bar, FALSE, FALSE, 0);

	gui_score_init();

	gtk_widget_show_all(window);
	gui_board_init(window);

	return 0;
}

int gui_main(void)
{
	gtk_main();
	gui_menu_tree_destroy(gui_menu_tree, FALSE);

	return 0;
}
